<?php

class Pages extends Public_Controller {

  public function __construct() {

    parent::__construct();
    $this->load->helper(array('file'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }

  public function aboutus() {
     $friendly_url = $this->uri->uri_string;
     $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['page_name'] = $content['page_name'];
      
    $data['heading_title'] = "Winner of Global Excellence Award 2019 as best laser centre in North India";
    //$data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_page='about' and status='1' and CURDATE() between banner_start_date and banner_end_date")->row_array();
    $this->load->view('pages/about', $data);
  }


  public function whatsappenq(){ 
      $adminRes = get_site_email();
      $data['adminRes'] = $adminRes;
      $this->form_validation->set_rules('wname', 'Name', 'trim|required');
      $this->form_validation->set_rules('wmobile', 'Mobile Number', 'trim|required|max_length[12]|min_length[10]|numeric');
      $url=$_SERVER['HTTP_REFERER'];
        if ($this->form_validation->run() == TRUE) {  
        $posted_data = array (
          'type' => '3',
          'first_name' => $this->input->post('wname'),
          'mobile_number' => $this->input->post('wmobile'),
          'message' => 'Whatsapp Enquiry',
          'post_url' => $url,
          'receive_date' => $this->config->item('config.date.time')
        );
        $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, false);

          $name=$this->input->post('wname');
          $subject = "WebpulseIndia.com - Whatsapp Enquiry from ".$this->config->item('site_name_www');
          $content = get_content('wps_auto_respond_mails', '3');
          $body = $content->email_content;
          $body = str_replace('{mem_name}', 'Admin', $body);
          $body = str_replace('{name}', $this->input->post('wname'), $body);
          $body = str_replace('{phone}', $this->input->post('wmobile'), $body);
          $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
          $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
          $body = str_replace('{post_url}', $url, $body);

          if($this->admin_info->mode=='Live'){
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Whatsapp Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => $adminRes->admin_email,
                'from_email' => $adminRes->admin_email,
                'from_name' => $name,
                //'reply_to' => 'webpulseindia@gmail.com',
                //'reply_name' => $this->input->post('wname'),
                  'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Whatsapp Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => 'webpulseindia@gmail.com',
                'from_email' => $adminRes->admin_email,
                'from_name' => $name,
                //'reply_to' => 'webpulseindia@gmail.com',
                //'reply_name' => $this->input->post('wname'),
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }else{
            $mail_conf = array(
              'subject' => "Webpulseindia.com - Whatsapp Enquiry from ".$this->config->item('site_name_www'),
              'to_email' => $this->admin_info->admin_email,
              'from_email' => $adminRes->admin_email,
              'from_name' => $name,
              'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }
            
       $res = 'success';     
      }else {
          $res = '<div class="alert alert-danger">
                          <strong>'.validation_errors().'
                      </div>';
      }
      echo $res;
      exit;
 
  }

 
  public function bookappointmodal() {
 

     $url=$_SERVER['HTTP_REFERER']; 
   $this->form_validation->set_rules('book_name', 'Name', 'trim|required');
    $this->form_validation->set_rules('book_email', 'Email', 'trim|valid_email');
    $this->form_validation->set_rules('book_mobile', 'Mobile Number', 'trim|required|max_length[10]|min_length[10]|numeric');
        $this->form_validation->set_rules('book_date', 'Booking Date', 'required');
    $this->form_validation->set_rules('book_message', 'Message','trim|regex_match[/^[][a-zA-Z0-9@# ,().]+$/]');

    


    if ($this->form_validation->run() == TRUE) {
   
        $posted_data = array(
            'type' => '6',
            'first_name' => $this->input->post('book_name'),
            'email' => $this->input->post('book_email'),
            'mobile_number' => $this->input->post('book_mobile'),
            'post_url' => $url,           
            'booking_date' => $this->input->post('book_date'),
            'message' => $this->input->post('book_message'),
            'receive_date' => $this->config->item('config.date.time'),
        );
        $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, false);

        $content = get_content('wps_auto_respond_mails', '6');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{name}', $this->input->post('book_name'), $body);
        $body = str_replace('{email}', $this->input->post('book_email'), $body);
        $body = str_replace('{phone}', $this->input->post('book_mobile'), $body);
        $body = str_replace('{book_date}', $this->input->post('book_date'), $body);
        $body = str_replace('{address}', $this->input->post('slocation'), $body);
        $body = str_replace('{message}', $this->input->post('book_message'), $body);
        $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
         $body = str_replace('{post_url}', $url, $body);
        $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
       
            $mail_conf = array(
                'subject' => 'Webpulseindia.com : Enquiry from www.woxmen.in',
                'to_email' => $this->admin_info->admin_email, //$this->admin_info->admin_email
                'reply_to' => $this->input->post('book_name'),
                'reply_name' => $this->input->post('book_name'),
                'from_email' => $this->input->post('book_email'),
                'from_name' => $this->input->post('book_name'),
                'body_part' => $body
            );
        //print_r($mail_conf);
        $this->dmailer->mail_notify($mail_conf);
        $mail_conf1 = array(
                'subject' => 'Webpulseindia.com : Enquiry from www.woxmen.in',
                'to_email' => $this->admin_info->admin_email, //$this->admin_info->admin_email
                'reply_to' => $this->input->post('book_name'),
                'reply_name' => $this->input->post('book_name'),
                'from_email' => $this->input->post('book_email'),
                'from_name' => $this->input->post('book_name'),
                'body_part' => $body
            );
        //print_r($mail_conf);
        $this->dmailer->mail_notify($mail_conf1);
        $res = 'success';
    } 
       else {
      $res = '<div class="alert alert-danger">
                      <strong>'.validation_errors().'
                  </div>';
    }
    echo $res;
    exit;
  }
  
  public function contactus() {
       $url=$_SERVER['HTTP_REFERER']; 
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    //trace($_SERVER['HTTP_REFERER']);

    $this->form_validation->set_rules('first_name', 'Name', 'trim|required|alpha|max_length[30]');
    $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|max_length[80]');
    //$this->form_validation->set_rules('subject', 'Subject', 'trim|required|max_length[255]');
    //$this->form_validation->set_rules('country', 'Country', 'trim|required|max_length[200]');
    $this->form_validation->set_rules('location', 'Location', 'trim|required|max_length[220]');
    $this->form_validation->set_rules('phone', 'Contact Number', 'trim|required|numeric|min_length[10]|max_length[10]');
    $this->form_validation->set_rules('message', 'Comment', 'trim|max_length[5000]');
     $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');


    if ($this->form_validation->run() == TRUE) {
      $post_data = http_build_query(
            array(
                'secret' => CAPTCHA_SECRET,
                'response' => $_POST['g-recaptcha-response'],
                'remoteip' => $_SERVER['REMOTE_ADDR'],
            )
      );
      $opts = array('http' => array(
              'method' => 'POST',
              'header' => 'Content-type: application/x-www-form-urlencoded',
              'content' => $post_data,
          ),
      );
      $context = stream_context_create($opts);
      $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
      $capcha_result = json_decode($response);
      if (!$capcha_result->success) {
        //throw new Exception('Gah! CAPTCHA verification failed. Please try again', 1);
        $msg = "CAPTCHA verification failed!";
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', $msg);
        $friendly_url = $this->uri->uri_string;
        $condition = array('friendly_url' => $friendly_url, 'status' => '1');
        $content = $this->pages_model->get_cms_page($condition);
        $data['content'] = $content;
        $data['title'] = "Contact Us";
        $this->load->view('contactus', $data);
      } else {

        $posted_data = array(
            'type' => '1',
            'first_name' => $this->input->post('first_name'),
            'email' => $this->input->post('email'),
            'mobile_number' => $this->input->post('phone'),
            //'country' => $this->input->post('location'),
            'location' => $this->input->post('location'),
            'message' => $this->input->post('message'),
            'post_url' => $url,
            //'subject' => $this->input->post('subject'),
            'receive_date' => $this->config->item('config.date.time')
        );
        $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

        //Mail
        $content = get_content('wps_auto_respond_mails', '5');
        $name = $this->input->post('first_name');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{user_name}', $name, $body);
        //$body = str_replace('{subject}', $this->input->post('subject'), $body);
        $body = str_replace('{email}', $this->input->post('email'), $body);
        $body = str_replace('{phone}', $this->input->post('phone'), $body);
        //$body = str_replace('{country}', $this->input->post('country'), $body);
        $body = str_replace('{location}', $this->input->post('location'), $body);
        $body = str_replace('{comments}', $this->input->post('message'), $body);
        $body = str_replace('{site_name}', SITENAME, $body);
        $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
        if($this->admin_info->mode=='Live'){
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => $adminRes->admin_email,
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => 'webpulseindia@gmail.com',
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }else{
            $mail_conf = array(
              'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
              'to_email' => $this->admin_info->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }

        $msg = "Your message has been sent successfully to ".$this->config->item('site_name_').". We will endeavour to reply within 24hrs. Thank You";
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', $msg);
        redirect(base_url('contact-us'));
      }
    }

    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '14');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['title'] = "Contact Us";
    $data['banner']=$this->db->query("select * from wps_banners where banner_position='Contact Us Banner' and status='1'")->row_array();
    $this->load->view('contactus', $data);
  }
  public function enquiry() {
       $url=$_SERVER['HTTP_REFERER']; 
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    //trace($_SERVER['HTTP_REFERER']);
    //qname,qemail,qmobile_number,qlocation,qmessage
    $this->form_validation->set_rules('qname', 'Name', 'trim|required|alpha|max_length[30]');
    $this->form_validation->set_rules('qemail', 'Email', 'trim|valid_email|max_length[80]');
    $this->form_validation->set_rules('qlocation', 'Location', 'trim|required|max_length[220]');
    $this->form_validation->set_rules('qmobile_number', 'Contact Number', 'trim|required|numeric|min_length[10]|max_length[12]');
    $this->form_validation->set_rules('qmessage', 'Message', 'trim|max_length[5000]');
    //$this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');
    
    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
            'type' => '1',
            'first_name' => $this->input->post('qname'),
            'email' => $this->input->post('qemail'),
            'mobile_number' => $this->input->post('qmobile_number'),
            'location' => $this->input->post('qlocation'),
            'message' => $this->input->post('qmessage'),
            'post_url' => $url,
            'receive_date' => $this->config->item('config.date.time')
        );
        $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

        //Mail
        $content = get_content('wps_auto_respond_mails', '5');
        $name = $this->input->post('qname');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{user_name}', $name, $body);
        //$body = str_replace('{subject}', $this->input->post('subject'), $body);
        $body = str_replace('{email}', $this->input->post('qemail'), $body);
        $body = str_replace('{phone}', $this->input->post('qmobile_number'), $body);
        //$body = str_replace('{country}', $this->input->post('country'), $body);
        $body = str_replace('{location}', $this->input->post('qlocation'), $body);
        $body = str_replace('{comments}', $this->input->post('qmessage'), $body);
        $body = str_replace('{site_name}', SITENAME, $body);
        $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
        if($this->admin_info->mode=='Live'){
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => $adminRes->admin_email,
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => 'webpulseindia@gmail.com',
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }else{
            $mail_conf = array(
              'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
              'to_email' => $this->admin_info->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }
      
        $res = 'success';
    } else {
        $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>';
    }
      echo $res;
      exit;


  }
   public function quick_contact() {
        $url=$_SERVER['HTTP_REFERER']; 
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    //trace($_SERVER['HTTP_REFERER']);
    //qname,qemail,qmobile_number,qlocation,qmessage
    $this->form_validation->set_rules('quick_name', 'Name', 'trim|required|alpha|max_length[30]');
    $this->form_validation->set_rules('quick_email', 'Email', 'trim|valid_email|max_length[80]');
    $this->form_validation->set_rules('quick_location', 'Location', 'trim|required|max_length[220]');
    $this->form_validation->set_rules('quick_mobile_number', 'Contact Number', 'trim|required|numeric|min_length[10]|max_length[12]');
    $this->form_validation->set_rules('quick_message', 'Message', 'trim|max_length[5000]');
    //$this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');
    
    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
            'type' => '1',
            'first_name' => $this->input->post('quick_name'),
            'email' => $this->input->post('quick_email'),
            'mobile_number' => $this->input->post('quick_mobile_number'),
            'location' => $this->input->post('quick_location'),
            'message' => $this->input->post('quick_message'),
            'post_url' => $url,
            'receive_date' => $this->config->item('config.date.time')
        );
        $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

        //Mail
        $content = get_content('wps_auto_respond_mails', '5');
        $name = $this->input->post('quick_name');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{user_name}', $name, $body);
        //$body = str_replace('{subject}', $this->input->post('subject'), $body);
        $body = str_replace('{email}', $this->input->post('quick_email'), $body);
        $body = str_replace('{phone}', $this->input->post('quick_mobile_number'), $body);
        //$body = str_replace('{country}', $this->input->post('country'), $body);
        $body = str_replace('{location}', $this->input->post('quick_location'), $body);
        $body = str_replace('{comments}', $this->input->post('quick_message'), $body);
        $body = str_replace('{site_name}', SITENAME, $body);
        $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
        if($this->admin_info->mode=='Live'){
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => $adminRes->admin_email,
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
            $mail_conf = array(
                'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
                'to_email' => 'webpulseindia@gmail.com',
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }else{
            $mail_conf = array(
              'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
              'to_email' => $this->admin_info->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }
      
        $res = 'success';
    } else {
        $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>';
    }
      echo $res;
      exit;


  }
  public function sitemap() {
    $this->load->view('sitemap');
  }


  public function marketarea() {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list WHERE status ='1'")->result_array();

    $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();
    $data['banner']=$this->db->query("select * from wps_banners where banner_position='Market Area Banner' and status='1'")->row_array();
    $this->load->view('marketarea', $data);
  }

}

/* End of file pages.php */