<?php

class Orders extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('order/order_model', 'products/product_model'));
    $this->load->helper(array('cart/cart', 'file', 'category/category'));
    $this->load->library(array('Dmailer'));
  }

  public function index($page = NULL) {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->order_model->get_orders($offset, $config['limit']);
    $config['total_rows'] = $this->order_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    /* Order oprations  */
    if ($this->input->post('unset_as') != '') {
      $this->set_as('wps_order', 'order_id', array('payment_status' => 'Unpaid'));
    }
    // if ($this->input->post('ord_status') != '') {
    //  $posted_order_status = $this->input->post('ord_status');
    //  $this->set_as('wps_order', 'order_id', array('order_status' => $posted_order_status));
    //  } 

    if ($this->input->post('ord_status') != '') {
      $posted_order_status = $this->input->post('ord_status');
      switch ($posted_order_status) {
        case '8': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '8', 'order_delivery_date' => date("Y-m-d H:i:s")));
            break;
          }
        case '7': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '6', 'order_returned_date' => date("Y-m-d H:i:s")));
            break;
          }
        case '1': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '1', 'order_confirmed_date' => date("Y-m-d H:i:s")));
            break;
          }
        case '2': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '2', 'order_dispatched_date' => date("Y-m-d H:i:s")));
            break;
          }
        case '3': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '3', 'order_in_transit_date' => date("Y-m-d H:i:s")));
            break;
          }
        case '4': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '4', 'order_out_for_delivery_date' => date("Y-m-d H:i:s")));
            break;
          }

        case '5': {
            $this->set_as('wps_order', 'order_id', array('order_status' => '5', 'order_cancelled_date' => date("Y-m-d H:i:s")));
            break;
          } default: break;
      }
    }

    $status_array = [
        '1' => ['status_title' => 'Confirmed', 'status_date' => 'order_confirmed_date', 'date_title' => 'Order Confirmed On'],
        '0' => ['status_title' => 'Placed', 'status_date' => 'order_received_date', 'date_title' => 'Order Received On'],
        '2' => ['status_title' => 'Dispatched', 'status_date' => 'order_dispatched_date', 'date_title' => 'Order Dispatched On'],
        '3' => ['status_title' => 'In Transit', 'status_date' => 'order_in_transit_date', 'date_title' => 'In Transit Date'],
        '4' => ['status_title' => 'Out for delivery', 'status_date' => 'order_out_for_delivery_date', 'date_title' => 'Order Out For Delivery On'],
        '5' => ['status_title' => 'Cancelled', 'status_date' => 'order_cancelled_date', 'date_title' => 'Order Cancelled On'],
        '6' => ['status_title' => 'Returned', 'status_date' => 'order_returned_date', 'date_title' => 'Order Returned On'],
        '7' => ['status_title' => 'Requested For Return', 'status_date' => 'order_request_for_return_date', 'date_title' => 'Order Requested For Return On'],
        '8' => ['status_title' => 'Delivered', 'status_date' => 'order_delivery_date', 'date_title' => 'Order Delivered On'],
    ];

    $data['status_array'] = $status_array;

    if ($this->input->post('Delete') != '') {
      $posted_order_status = $this->input->post('ord_status');
      $this->set_as('wps_order', 'order_id', array('order_status' => '9'));
      //$this->set_as('wps_order', 'order_id', array('order_status' => 'Deleted'));
    }
    /* End order oprations */
    $data['headingTitle'] = 'Order Lists';
    $data['res'] = $res_array;
    $this->load->view('order/view_order_list', $data);
  }

  public function vieworder() {
    $id = (int) $this->uri->segment(4);
    $ordmaster = $this->db->query("SELECT * FROM wps_order WHERE order_id = '" . $id . "'")->row_array();
    $ordDetails = $this->db->query("SELECT * FROM wps_orders_products WHERE order_id = '" . $id . "'")->result_array();

    $data['ordmaster'] = $ordmaster;
    $data['ordDetails'] = $ordDetails;

    $data['headingTitle'] = 'Order Details - Order# ' . $ordmaster['invoice_number'];
    $this->load->view('order/view_order_details', $data);
  }

  public function make_paid($order_id) {

    $order_id = (int) $order_id;
    $where = "order_id = '" . $order_id . "'";
    $this->order_model->safe_update('wps_order', array('payment_status' => 'Paid'), $where, FALSE);
    $this->update_stocks($order_id);

    $ordmaster = $this->order_model->get_order_master($order_id);
    $orddetail = $this->order_model->get_order_detail($order_id);

    /* Start  send mail */

    ob_start();
    $mail_subject = $this->config->item('site_name') . " Order overview";
    $from_email = $this->admin_info->admin_email;
    $from_name = $this->config->item('site_name');
    $mail_to = $ordmaster['email'];

    $body = invoice_content_print($ordmaster, $orddetail);
    $msg = ob_get_contents();

    $mail_conf = array(
        'subject' => $this->config->item('site_name') . " Order overview",
        'to_email' => $mail_to,
        'from_email' => $from_email,
        'from_name' => $this->config->item('site_name'),
        'body_part' => $msg);				
    //$this->dmailer->mail_notify($mail_conf);
    /* End  send mail */

    $this->session->set_userdata(array('msg_type' => 'success'));
    $this->session->set_flashdata('success', $this->config->item('payment_success'));
    redirect('wps-admin/orders', '');
  }



}

// End of controller