<?php

class Treatment extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('treatment/treatment_model'));
    $this->load->helper('treatment/treatment');
    $this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
    $this->default_view = 'treatment';
    $this->deletePrvg = TRUE;
  }

  public function index() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $condtion='';
    $condtion_array = array(
        'field' => "*",
        'condition' => $condtion,
        'debug' => FALSE
    );
    $res_array = $this->treatment_model->gettreatment($condtion_array);
    $config['total_rows'] = $this->treatment_model->total_rec_found;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['headingTitle'] = 'Manage Treatment';
    $data['res'] = $res_array;



    if ($this->input->post('action') != '') {
      if ($this->input->post('action') == 'Delete') {
        $prod_id = $this->input->post('arr_ids');
        $this->session->set_userdata('success', 'Treatment Has been deleted Successfully!');
        foreach ($prod_id as $v) {
          $where = array('entity_type' => 'treatment/details', 'entity_id' => $v);
          safe_delete('wps_meta_tags', $where, TRUE);
        }
      }
      $this->update_status('wps_treatment', 'treatment_id');
    }
    if ($this->input->post('update_order') != '') {
      $this->update_displayOrder('wps_treatment', 'sort_order', 'treatment_id');
    }
    $this->load->view($this->default_view . '/view_treatment_list', $data);
  }

  public function add() {

  $data['ckeditor1'] = set_ck_config(array('textarea_id' => 'treatment_description'));
  $treatment_name = $this->db->escape_str($this->input->post('treatment_name'));
  $posted_friendly_url = $this->input->post('friendlyUrl');
  $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
  $data['headingTitle'] = 'Add Treatment';


  $this->form_validation->set_rules('treatment_name', 'Title', "trim|required|max_length[100]|unique[wps_treatment.treatment_name ='" . $treatment_name . "' AND status!='2']");
  $this->form_validation->set_rules('friendlyUrl', 'Page URL', "trim|required|unique[wps_meta_tags.page_url ='" . $this->cbk_friendly_url . "'] ");
  //$this->form_validation->set_rules('treatment_image', 'Treatment Image', "callback_validateFile[treatment_image,image,false]");
  //$this->form_validation->set_rules('banner_tagline', 'Banner Tagline', "max_length[200]|trim|required");
  $this->form_validation->set_rules('treatment_description', 'Description', "max_length[6000]");

    if ($this->form_validation->run() === TRUE) {

      $uploaded_icon = $uploaded_file = $uploaded_banner="";

      if (!empty($_FILES) && $_FILES['treatment_image']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/treatment/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('treatment_image');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

       if (!empty($_FILES) && $_FILES['treatment_banner']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/treatment/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('treatment_banner');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_banner = $uploaded_data['upload_data']['file_name'];
        }
      }
      

      $posted_data = array(
          'treatment_name' => $this->input->post('treatment_name'),
          'treatment_alt' => $this->input->post('treatment_alt'),
          'treatment_description' =>$this->input->post('treatment_description'),
          'friendly_url' => $this->cbk_friendly_url,
          'treatment_image' => $uploaded_file,
          'treatment_banner' => $uploaded_banner,
          'banner_tagline' => $this->input->post('banner_tagline'),
          'date_added' => $this->config->item('config.date.time')
      );
      $this->db->insert('wps_treatment', $posted_data);
      $insertId = $this->db->insert_id();
      if ($insertId > 0) {
        if ($this->input->get_post('metaTitle') != '' && $this->input->get_post('metaDescription') != '') {
          $title = get_text($this->input->get_post('metaTitle'));
          $description = get_text($this->input->get_post('metaDescription'));
          $keywords = get_keywords($this->input->get_post('metaKeyword'));
        } else {
          $title = '';
          $description = '';
          $keywords = '';
        }
        $redirect_url = "treatment/details";
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $insertId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => $title,
            'meta_description' => $description,
            'meta_keyword' => $keywords
        );
        $this->db->insert('wps_meta_tags', $meta_array);
      }

      $this->session->set_userdata('success', 'Record has been added successfully!');
      $redirect_path = 'treatment';
      $this->load->helper('url');
      redirect(base_url() . 'wps-admin/' . $redirect_path, '');
      exit;
    }
    $this->load->view($this->default_view . '/view_treatment_add', $data);
  }

  public function edit() {
    $data['ckeditor1'] = set_ck_config(array('textarea_id' => 'treatment_description'));
    $baseURL = base_url();

    $catId = (int) $this->uri->segment(4);
    $rowdata = $this->treatment_model->get_treatment_by_id($catId);
    $data['headingTitle'] = 'Edit Treatment';

    if (!is_array($rowdata)) {
      $this->session->set_flashdata('message', lang('idmissing'));
      redirect('wps-admin/treatment', '');
    }

    $posted_friendly_url = $this->input->post('friendlyUrl');
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
    $treatment_name = $this->db->escape_str($this->input->post('treatment_name'));
    $categoryId = $rowdata['treatment_id'];
    //Meta Details - Main
    $metaDets = get_db_single_row("wps_meta_tags", "meta_title, meta_description, meta_keyword", "entity_type = 'treatment/details' AND entity_id = '" . $categoryId . "'");


    $this->form_validation->set_rules('treatment_name', 'Title', "trim|required|max_length[100]|unique[wps_treatment.treatment_name ='" . $treatment_name . "' AND status!='2' AND treatment_id!='" . $categoryId . "']");
    //$this->form_validation->set_rules('friendlyUrl', 'Page URL', "trim|required|unique[wps_meta_tags.page_url ='" . $this->cbk_friendly_url . "' AND entity_id!='" . $catId . "'] ");
    $this->form_validation->set_rules('treatment_image', 'Treatment Image', "callback_validateFile[categoryImage,image,false]");
    //$this->form_validation->set_rules('banner_tagline', 'Banner tagline', "max_length[200]|required|trim");

    $this->form_validation->set_rules('treatment_description', 'Description', "max_length[6000]");

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = $rowdata['treatment_image'];
      $unlink_image = array('source_dir' => "treatment", 'source_file' => $rowdata['treatment_image']);
      if ($this->input->post('cat_img_delete') === 'Y') {
        removeImage($unlink_image);
        $uploaded_file = NULL;
      }

      if (!empty($_FILES) && $_FILES['treatment_image']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/treatment/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('treatment_image');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $uploaded_banner = $rowdata['treatment_banner'];
      $unlink_banner = array('source_dir' => "treatment", 'source_file' => $rowdata['treatment_banner']);
      if (!empty($_FILES) && $_FILES['treatment_banner']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/treatment/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('treatment_banner');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_banner = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_banner);
        }
      }

      $category_alt = $this->input->post('treatment_name');
      $category_alt = $category_alt != '' ? $category_alt : null;
      $banner_tagline = $this->input->post('banner_tagline');
      
      $treatment_description = $this->input->post('treatment_description');
      $treatment_description = $treatment_description != '' ? $treatment_description : null;
      $category_shortdescription = $this->input->post('short_desc');

      $posted_data = array(
          'treatment_name' => $this->input->post('treatment_name'),
          'friendly_url' => $this->cbk_friendly_url,
          'category_alt' => $category_alt,
          'treatment_description' => $treatment_description,
          'category_image' => $uploaded_file,
          'category_banner' => $uploaded_banner,
         'banner_tagline' => $banner_tagline,
         'date_modified' => $this->config->item('config.date.time')
      );
      //trace($posted_data);

      $this->db->where('treatment_id', $categoryId);
      $this->db->update('wps_treatment', $posted_data);


      //Update Meta
      if ($categoryId > 0) {
        if ($this->input->get_post('metaTitle') != '' && $this->input->get_post('metaDescription') != '') {
          $title = get_text($this->input->get_post('metaTitle'));
          $description = get_text($this->input->get_post('metaDescription'));
          $keywords = $this->input->get_post('metaKeyword');
        } else {
          $title = '';
          $description = '';
          $keywords = '';
        }
        $posted_data_meta = array(
            'meta_title' => $title,
            'meta_description' => $description,
            'meta_keyword' => $keywords,
        );
        $this->db->where('entity_id', $categoryId);
        $this->db->where('entity_type', 'treatment/details');
        $this->db->update('wps_meta_tags', $posted_data_meta);
      }
      //End here

      $this->session->set_userdata('success', 'Record has been updated successfully!');
      $redirect_path = 'treatment';
      //header("Location:".$baseURL.'wps-admin/' . $redirect_path);
      redirect(base_url('wps-admin/' . $redirect_path), '');
    }

    $data['metaDets'] = $metaDets;
    $data['catresult'] = $rowdata;
    $this->load->view($this->default_view . '/view_treatment_edit', $data);
  }

  public function delete() {
    $catId = (int) $this->uri->segment(4, 0);
    $rowdata = $this->treatment_model->get_treatment_by_id($catId);

    if (!is_array($rowdata)) {
      $this->session->set_flashdata('message', lang('idmissing'));
      redirect('sitepanel/treatment', '');
    } else {
      $total_product = count_products("AND treatment_id='$catId' ");

      if ($total_product > 0) {
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', lang('child_to_delete'));
      } else {
        $where = array('treatment_id' => $catId);
        $this->treatment_model->safe_delete('wps_treatment', $where, TRUE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('deleted'));
      }
      redirect($_SERVER['HTTP_REFERER'], '');
    }
  }

  function validateFile($flName, $ext) {
    $parameter = explode(',', $ext);
    $fileName = $parameter[0];
    $allowedExt = $parameter[1];
    $isRequired = $parameter[2];
    if ($isRequired == 'false') {
      if (empty($_FILES[$fileName]['name'])) {
        return TRUE;
      } else {
        $file = $_FILES[$fileName];
        $ext_groups = array();
        $ext_groups['image'] = array('jpg', 'jpeg', 'gif', 'png', 'JPG', 'JPEG', 'GIF', 'PNG');
        $ext_groups['document'] = array('rtf', 'doc', 'docx', 'pdf', 'txt', 'ppt', 'zip');
        $ext_groups['media'] = array('mp4', 'mpeg4');
        $ext_groups['compressed'] = array('zip', 'gzip', 'tar', 'gz');
        $exts = $ext_groups[$allowedExt];
        //get file ext
        $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array($file_ext, $exts)) {
          $exts_allowed = implode(" | ", $exts);
          $this->form_validation->set_message('validateFile', "File should be " . $exts_allowed);
          return FALSE;
        } else {
          return TRUE;
        }
      }
    } else {
      if (empty($_FILES[$fileName]['name'])) {
        $this->form_validation->set_message('validateFile', 'Please select file.');
        return false;
      } else {
        $file = $_FILES[$fileName];
        $ext_groups = array();
        $ext_groups['image'] = array('jpg', 'jpeg', 'gif', 'png', 'JPG', 'JPEG', 'GIF', 'PNG');
        $ext_groups['document'] = array('rtf', 'doc', 'docx', 'pdf', 'txt', 'ppt', 'zip');
        $ext_groups['media'] = array('mp4', 'mpeg4');
        $ext_groups['compressed'] = array('zip', 'gzip', 'tar', 'gz');
        $exts = $ext_groups[$allowedExt];
        //get file ext
        $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array($file_ext, $exts)) {
          $exts_allowed = implode(" | ", $exts);
          $this->form_validation->set_message('validateFile', "File should be " . $exts_allowed);
          return FALSE;
        } else {
          return TRUE;
        }
      }
    }
  }

  public function updateuserstatus() {
    $userId = $this->input->post('userId');
    $status = $this->input->post('status');
    if ($userId > 0) {
      $this->db->query("UPDATE wps_treatment SET status = '" . $status . "' WHERE treatment_id = '" . $userId . "'");
      if ($status == 0) {
        echo 'Record has been Deactived successfully!';
      } else {
        echo 'Record has been Actived successfully!';
      }
    } else {
      echo 'Something went wrong, please try again later!';
    }
  }

  public function check_upload_excel() {
    $filearrext = array('xls', 'xlsx');
    if ($_FILES['excel_file']['name'] == '') {
      $this->form_validation->set_message('check_upload_excel', 'Please upload excel file.');
      return FALSE;
    }
    if ($_FILES['excel_file']['name'] != '') {
      $extension = substr(strrchr($_FILES['excel_file']['name'], '.'), 1);
      if (!in_array($extension, $filearrext)) {
        $this->form_validation->set_message('check_upload_excel', 'Please upload (xls) file only.');
        return FALSE;
      } else {
        return TRUE;
      }
    }
  }

}

// End of controller
