<style amp-boilerplate>
    body {
        -webkit-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        -moz-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        -ms-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        animation: -amp-start 8s steps(1, end) 0s 1 normal both
    }

    @-webkit-keyframes -amp-start {
        from {
            visibility: hidden
        }

        to {
            visibility: visible
        }
    }

    @-moz-keyframes -amp-start {
        from {
            visibility: hidden
        }

        to {
            visibility: visible
        }
    }

    @-ms-keyframes -amp-start {
        from {
            visibility: hidden
        }

        to {
            visibility: visible
        }
    }

    @-o-keyframes -amp-start {
        from {
            visibility: hidden
        }

        to {
            visibility: visible
        }
    }

    @keyframes -amp-start {
        from {
            visibility: hidden
        }

        to {
            visibility: visible
        }
    }
</style>
<noscript>
    <style amp-boilerplate>
        body {
            -webkit-animation: none;
            -moz-animation: none;
            -ms-animation: none;
            animation: none
        }
    </style>
</noscript>
<style amp-custom>
    *,
    *::after,
    *::before {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
    }

    :root {
        --liner: linear-gradient(180deg, rgba(0, 0, 0, 0.12), rgba(0, 0, 0, 0));
        --liner2: linear-gradient(0deg, rgba(253, 229, 210, 1) 0%, rgba(255, 246, 238, 1) 100%);
        --pri: #1c6288;
        --dark: #103c54;
        --text-color: #0A0A0B;
        --text-light: #8C8C8C;
        --para-color: #666;
    }

    button,
    input,
    select,
    textarea {
        font-family: "Roboto", serif;
        font-size: 15px;
    }

    body {
        font-family: "Roboto", serif;
        font-size: 14px;
        box-sizing: border-box;
        font-weight: 400;
        color: var(--text-color);
        background-color: #fff;
        -webkit-tap-highlight-color: transparent;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        line-height: 1.4;
    }

    .container {
        padding-left: 13px;
        padding-right: 13px;
    }

    img {
        max-width: 100%;
        width: auto;
        height: auto;
    }

    p {
        color: var(--text-color);
        font-size: 15px;
        font-weight: 400;
        margin: 0;
        margin-bottom: 10px;
    }

    a {
        display: block;
        text-decoration: none;
    }

    p a {
        display: inline;
    }

    header {
        position: fixed;
        top: 0;
        overflow: hidden;
        background: #fff;
        width: 100%;
        z-index: 999;
        box-shadow: 0 3px 2px rgba(0, 0, 0, .05);
    }

    .top-bar .container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background: white;
        padding-block: 1px;
        background: #d8e6ee;
    }

    .top-bar .container a {
        color: var(--dark);
        font-size: 16px;
        letter-spacing: -0.4px;
        font-weight: 700;
        line-height: normal;
    }

    .top-bar .container a i {
        font-size: 17px;
    }

    .top-bar .container .main-btn {
        padding: 7px 12px;
        box-shadow: rgba(0, 0, 0, 0.1) 0px 1px 2px 0px;
        font-size: 14px;
    }

    .menubar .container {
        display: flex;
        align-items: center;
        /* justify-content: space-between; */
        background: white;
        padding-block: 2px;
    }

    .menubar .logo {
        width: 100px;
        margin: 1px 0;
    }

    .menubar .menuToggle-btn {
        color: #171717;
        line-height: normal;
        text-align: center;
        display: inline-block;
        padding: 2px;
        font-size: 23px;
        cursor: pointer;
        background-color: transparent;
        border: 0;
        margin-right: 15px;
    }

    #custom-button .amp-carousel-button-prev,
    .amp-carousel-button-prev {
        left: 3%;
        background-image: url('https://amp.dev/static/samples/img/carousel-arrow-left.png');
    }

    #custom-button .amp-carousel-button-next,
    .amp-carousel-button-next {
        right: 3%;
        background-image: url('https://amp.dev/static/samples/img/carousel-arrow-right.png');
    }

    .header-clear {
        height: 100px;
    }

    #custom-button .amp-carousel-button,
    .amp-carousel-button {
        height: 25px;
        width: 25px;
        background-color: rgba(0, 0, 0, 0.3);
        border: 0;
        outline: 0;
        border-radius: 100%;
    }

    #sidebar1 {
        width: 280px;
        background: #fff;
    }

    .sidebar-header {
        background: #f9f9f9;
        padding: 10px 0;
        border-bottom: 1px solid #eee;
    }

    .sidebar-logo {
        /* height: 61px; */
        width: 100px;
        display: block;
        margin: 0 13px;
    }

    .sidebar-menu {
        margin-bottom: 0;
        background: #fff;
        padding-left: 15px
    }

    .sidebar-menu svg {
        font-size: 14px;
        line-height: 35px;
        text-align: center;
        padding: 7px;
        border-radius: 35px;
        margin-right: 10px;
        position: absolute;
        right: 7px;
        height: 30px;
        width: 30px;
        top: 6px
    }

    .sidebar-menu ul li a .fa-circle {
        font-size: 4px;
        margin-left: 1px;
        margin-top: -1px
    }

    .sidebar-menu .fa-angle-down,
    .sidebar-menu .fa-circle {
        width: 35px;
        height: 35px;
        position: absolute;
        right: 0;
        top: 3px;
        font-size: 4px;
        color: #acacac
    }

    .sidebar-menu .cs_dropdown {
        width: 30px;
        height: 30px;
    }

    .sidebar-menu section[expanded] .cs_dropdown {
        transform: rotate(180deg)
    }

    .sidebar-menu section[expanded] .sidebar_submenu section[expanded] .cs_subdropdown {
        transform: rotate(180deg)
    }

    .sidebar-menu h4 {
        background: 0;
        border: 0;
        color: #3a3a3a;
        line-height: 40px;
        font-size: 15px;
        font-weight: 400;
        border-bottom: 1px solid #eee
    }

    .sidebar-menu h4 a {
        color: #333
    }

    .sidebar-menu h4 a:hover {
        color: var(--pri)
    }

    .sidebar-menu ul {
        padding: 0
    }

    .sidebar-menu ul li {
        border-bottom: 1px solid #eee
    }

    .sidebar-menu ul li a {
        color: #333;
        font-size: 14px;
        line-height: 35px
    }

    .sidebar-menu ul li a:hover {
        color: var(--pri)
    }

    .sidebar-menu i:first-child {
        font-size: 14px
    }

    .sidebar-menu li a .fa-circle {
        margin-top: -5px
    }

    .sidebar-divider {
        margin-bottom: 20px;
        font-size: 14px;
        padding: 10px 0;
        padding-left: 15px;
        font-weight: 400;
        text-transform: capitalize;
        color: #1f1f1f;
        border-bottom: solid 1px rgba(0, 0, 0, .1);
        border-top: solid 1px rgba(0, 0, 0, .1);
        line-height: normal;
        margin-bottom: 0;
        background: #fff
    }

    .sidebar-divider a {
        display: inline;
        color: var(--pri);
        line-height: normal;
        text-transform: capitalize
    }

    .sidebar-divider i,
    .sidebar-divider svg {
        color: var(--pri);
        margin-top: 3px;
    }

    .sidebar-divider a:hover {
        color: var(--pri)
    }

    .sidebar-menu .sidebar-item {
        color: #1f1f1f;
        font-size: 14px;
        line-height: 35px;
        border-bottom: 1px solid #eee
    }

    .sidebar-menu .sidebar-item.border-0 {
        border-bottom: none;
    }

    .sidebar-menu .sidebar-item:hover {
        color: var(--pri);
    }

    .sidebar-menu .sidebar-item.border-0 {
        border-bottom: 0;
    }

    .active-item .sidebar-item,
    .active-menu {
        color: var(--pri)
    }

    .active-item a,
    .active-menu a {
        color: var(--dark)
    }

    .active-item .fa-circle,
    .active-menu .fa-circle {
        color: var(--pri)
    }

    .footer-clear {
        height: 59px;
        background-color: var(--dark);
    }

    .mobile_stickybar {
        position: fixed;
        bottom: 0;
        -webkit-transition: all .3s ease-in-out;
        -moz-transition: all .3s ease-in-out;
        -o-transition: all .3s ease-in-out;
        transition: all .3s ease-in-out;
        z-index: 66;
        overflow: hidden;
        left: 0;
        right: 0;
    }

    .mobile_warpper {
        box-shadow: 0 -4px 4px -1px rgba(0, 0, 0, 0.04), 0 2px 4px -1px rgba(0, 0, 0, 0.02);
        background-color: #fff;
        z-index: 3;
        position: relative;
        overflow: hidden;
        border-top-left-radius: 1.5rem;
        border-top-right-radius: 1.5rem;
        border: 1px solid #eee;
    }

    .mobile_warpper ul {
        display: flex;
        justify-content: space-between;
        margin: 0;
        padding: 0
    }

    .mobile_warpper ul li {
        list-style: none;
        width: 20%;
        display: flex;
        flex-direction: column;
        text-align: center;
        padding: 13px 0 10px;
    }

    .mobile_stickybar ul li>span,
    .mobile_warpper ul li a {
        font-size: 12px;
        color: var(--pri);
        text-decoration: none;
        font-weight: 600;
        letter-spacing: -0.5px;
    }

    .mobile_stickybar ul li.active-menu span,
    .mobile_warpper ul li.active-menu a {
        color: var(--pri);
    }

    .mobile_stickybar ul li.whatsapp span,
    .mobile_warpper ul li.whatsapp a {
        color: #00c966;
    }


    .mobile_warpper ul li svg {
        height: 22px;
        width: 22px;
    }

    .mobile_warpper ul li a span {
        display: block;
        line-height: 10px;
        color: #222;
    }

    .webpulse-faqSec {
        padding-block: 40px;
    }

    .faq-item {
        padding: 10px 15px;
        border-radius: 10px;
        box-shadow: rgba(0, 0, 0, 0.08) 0px 1px 3px;
        margin-bottom: 12px;
        background-color: #f7f7f7;
    }

    .faq-item h4 {
        padding: 0;
        margin: 0;
        background-color: transparent;
        border: 0;
        font-weight: 500;
        color: var(--text-color);
        font-size: 15px;
        padding-right: 20px;
    }

    .faq-item[expanded] h4 {
        color: var(--pri);
    }

    .faq-item svg {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        right: 0;
    }

    .faq-item p {
        color: var(--para-color);
        margin-top: 5px;
        font-size: 14px;
    }

    section[expanded].faq-item .cs_subdropdown {
        transform: translateY(-50%) rotate(180deg);
    }

    amp-lightbox {
        z-index: 999
    }

    .lightbox {
        background: rgba(0, 0, 0, .8);
        width: 100%;
        height: 100%;
        position: absolute;
        text-align: center
    }

    .cancel_btn {
        font-size: 16px;
        right: 6px;
        margin: 8px auto;
        cursor: pointer;
        color:#fff;
        position: absolute;
        width: 30px;
        height: 30px;
        text-align: center;
        line-height: 30px
    }

    .cancel_btn:hover,
    .cancel_btn:focus,
    .cancel_btn:focus-within {
        background: var(--text-red)
    }

    .cancel_btn svg {
        width: 28px;
        height: 28px;
    }

    .popup_form {
        max-width: 300px;
        padding: 0;
        margin: 30% auto;
        background: #fff;
        border-radius: 4px;
        overflow: hidden;
        position: relative;
    }

    .popup_form h5 {
        background: linear-gradient(335deg, #103c54, #276587 0%, #2d78a1);
        color:#fff;
        font-weight: 500;
        font-size: 18px;
        padding: 10px 10px;
        text-align: left
    }

    form label {
        text-align: left
    }

    form {
        /* background: #fff; */
        padding: 15px 10px
    }

    form .amp_input {
        margin-bottom: 10px
    }

    form .amp_input label {
        margin-bottom: 5px
    }

    form .amp_input input {
        height: 45px;
        width: 100%;
        padding: 0 0 0 5%;
        border: 1px solid #eee;
        font-size: 15px;
        background: #fff;
        border-radius: 3px
    }

    form .amp_input select {
        height: 45px;
        width: 100%;
        padding: 0 0 0 2%;
        border: 1px solid #eee;
        background: #fff;
        font-size: 15px
    }

    form .amp_input .code01 {
        height: 45px;
        width: 21%;
        padding: 0 0 0 2%
    }

    form .amp_input .code02 {
        height: 33px;
        width: 76%;
        padding: 0 0 0 2%
    }

    form .amp_input textarea {
        width: 100%;
        height: 90px;
        width: 100%;
        padding: 10px 0 0 3%;
        border: 1px solid #eee;
        border-radius: 4px;
        font-size: 14px;

    }

    .main-btn {
        margin-block: 5px;
        padding: 10px 15px;
        color: white;
        display: inline-flex;
        gap: 5px;
        align-items: center;
        font-size: 16px;
        font-weight: 400;
        white-space: nowrap;
        background-color: var(--dark);
        outline: none;
        transition: 0.2s ease-in-out;
        box-shadow: rgba(0, 0, 0, 0.1) 0px 1px 2px 0px;
        border-radius: 6px;
        border: 0;
    }

    .contact_btn {
        display: inline-block;
        cursor: pointer;
        padding: 13px 0;
        font-size: 15px;
        width: 100%;
        text-transform: uppercase;
        font-weight: 500;
        letter-spacing: 0.5px;
        line-height: normal;
        text-align: center;
        background: var(--liner);
        background-color: var(--pri);
        color: #fff;
        outline: 0;
        border: 0;
        border-radius: 6px;
        margin-top: 10px;
    }

    .social {
        display: flex;
        align-items: center;
        gap: 5px;
        padding: 0;
        list-style: none;
        margin: 0;
        margin-left: auto;
    }

    .social li a {
        width: 30px;
        height: 30px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        color: white;
        border-radius: 2px;
    }

    .social li a i {
        font-size: 14px;
    }

    .social li a svg {
        width: 12px;
        height: 12px;
    }

    ul.social li.facebook a {
        background: #3C5B9B;
    }

    ul.social li.twitter a {
        background: var(--liner);
        background-color: #0e1419;
    }

    ul.social li.linkedin a {
        background: #027ba5;
    }

    ul.social li.youtube a {
        background: #f70000;
    }

    ul.social li.instagram a {
        background: radial-gradient(circle at 30% 107%, #fdf497 0%, #fdf497 5%, #fd5949 45%, #d6249f 60%, #285AEB 90%);
    }

    #product_lightbox .popup_form .image_2 {
        background: #fff;
        padding: 12px 10px;
        position: relative;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        gap: 10px;
        align-items: center;
        border-bottom: 1px solid #eee;
        margin: 0;
    }

    #product_lightbox .popup_form .image_2 amp-img {
        width: 100%;
        /* margin-right: 10px; */
        min-width: 80px;
        border-radius: 10px;
        overflow: hidden;
    }

    .popup_form .full_box {
        max-height: 80vh;
        overflow-y: auto;
    }

    #product_lightbox .popup_form h6 {
        text-align: left;
        text-transform: capitalize;
        color: var(--text-color);
        font-size: 18px;
        font-weight: 500;
        padding: 0;
        line-height: 24px;
    }

    .head-sec {
        margin-bottom: 17px;
        text-align: center;
    }

    .head-sec .tt {
        font-weight: 500;
        font-size: 22px;
        margin-bottom: 5px;
        color: var(--text-color);
    }

    .head-sec .tt span {
        color: var(--pri);
        font-weight: 600;
        line-height: 1.2;
    }

    .head-sec .fs-lg {
        font-size: 25px;
    }

    .head-sec p {
        font-size: 14px;
        line-height: 1.3;
        color: var(--para-color);
    }

    main {
        background-image: url(designer/image/bg/hero-bg.webp);
        background-color: var(--dark);
        background-size: cover;
        background-position: top left;
        min-height: 70vh;
        position: relative;
        /* background-color: rgb(14, 7, 49); */
        text-align: center;
        color: white;
        padding-top: 50px;
        padding-bottom: 100px;
    }

    main .main-btn.main-btn2 {
        background-color: white;
        color: var(--pri);
    }

    main .text-bx {
        padding-inline: 10px;
    }

    main .text-bx .main-tt {
        margin-bottom: 10px;
        font-size: 30px;
    }

    main .text-bx p {
        font-size: 18px;
        color: rgba(255, 255, 255, 0.85);
        margin-bottom: 15px;
    }

    main .img-bx {
        position: relative;
        padding-top: 25px;
        padding-inline: 15px;
    }

    main .img-bx::before {
        background: linear-gradient(0deg, var(--dark) 0%, var(--dark) 10.75%, rgba(5, 62, 143, 0) 95.83%);
        height: 48px;
        content: "";
        position: absolute;
        bottom: -2px;
        width: 100%;
        left: 0;
        z-index: 2;
    }

    .equ-sec {
        padding-bottom: 40px;
    }

    .equ_box {
        max-width: 320px;
        margin: 30px auto 0;
        padding: 25px;
        background-color: #fff;
        position: relative;
        border-radius: 18px;
        box-shadow: rgba(0, 0, 0, 0.1) 0px 1px 6px;
    }

    .equ_box form {
        padding: 0;
    }

    .equ_box .head-sec .tt {
        font-size: 18px;
        margin-bottom: 12px;
    }

    .equ_box:before,
    .equ_box:after {
        content: '';
        position: absolute;
        display: block;
        opacity: 0.2;
        background-image: linear-gradient(-60deg, #6aafd5 0%, #17a1ec 100%);
        border-radius: 0 0 10px 10px;
        transition: 0.4s ease;
    }

    .equ_box:before {
        z-index: 2;
        left: 20px;
        right: 20px;
        height: 10px;
        bottom: -10px;
    }

    .equ_box:after {
        z-index: 1;
        left: 30px;
        right: 30px;
        height: 20px;
        bottom: -20px;
    }

    .ondebox {
        position: absolute;
        bottom: -2px;
        background: white;
        width: 100%;
        transform: rotate(180deg);
    }

    .onde {
        position: relative;
        width: 100%;
        height: 15vh;
        margin-bottom: -7px;
        min-height: 100px;
        max-height: 150px;
    }

    /* Animation */

    .parallaxonde>use {
        animation: move-forever 25s cubic-bezier(.55, .5, .45, .5) infinite;
    }

    .parallaxonde>use:nth-child(1) {
        animation-delay: -2s;
        animation-duration: 7s;
    }

    .parallaxonde>use:nth-child(2) {
        animation-delay: -3s;
        animation-duration: 10s;
    }

    .parallaxonde>use:nth-child(3) {
        animation-delay: -4s;
        animation-duration: 13s;
    }

    .parallaxonde>use:nth-child(4) {
        animation-delay: -5s;
        animation-duration: 20s;
    }

    @keyframes move-forever {
        0% {
            transform: translate3d(-90px, 0, 0);
        }

        100% {
            transform: translate3d(85px, 0, 0);
        }
    }

    /*Shrinking for mobile*/
    @media (max-width: 768px) {
        .onde {
            height: 40px;
            min-height: 40px;
        }
    }

    @keyframes wave {
        0% {
            margin-left: 0;
        }

        100% {
            margin-left: -1600px;
        }
    }

    @keyframes swell {

        0%,
        100% {
            transform: translate3d(0, -25px, 0);
        }

        50% {
            transform: translate3d(0, 5px, 0);
        }
    }

    .featured-sec {
        padding-top: 30px;
        padding-bottom: 40px;
    }

    .featured-bx {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 5px;
    }

    .featured-item {
        aspect-ratio: 16 / 10;
        box-shadow: rgba(0, 0, 0, 0.08) 0px 1px 4px;
        overflow: hidden;
        border-radius: 10px;
        width: calc(100% / 4 - 5px);
        /* border: 1px solid #f5f5f5; */
        background-color: #f9f9f9;
    }

    .featured-sec .head-sec .tt {
        margin-bottom: 0;
        font-size: 24px;
    }

    .gallery-sec {
        padding-block: 40px;
        background: #fff;
    }

    .gallery-bx {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 8px;
    }

    .gallery-item {
        width: calc(50% - 5px);
        overflow: hidden;
        box-shadow: rgba(0, 0, 0, 0.08) 0px 1px 4px;
    }

    .video-sec {
        padding-block: 40px;
    }

    .video-bx {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 10px;
    }

    .video-bx .video-item {
        width: calc(50% - 7px);
        overflow: hidden;
        border-radius: 10px;
        margin-bottom: 5px;
    }

    .video-bx .video-item.w-100 {
        width: 100%;
    }

    .video-bx .videoBg {
        width: 100%;
        margin-bottom: 15px;
    }

    .videoTitle {
        font-size: 16px;
        text-align: center;
        font-weight: 600;
        color: #333;
        line-height: normal;
    }

    .service-sec {
        padding-block: 40px;
        background-color: #f8f8f8;
    }

    .service-bx {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
    }

    .service-bx .service-item {
        width: calc(50% - 4px);
        margin-bottom: 5px;
        border-radius: 10px;
        overflow: hidden;
        background: white;
        box-shadow: rgba(0, 0, 0, 0.05) 0px 1px 8px;
    }

    .service-bx .service-item .des {
        padding: 8px;
        text-align: center;
    }

    .service-bx .service-item .des .main-btn {
        padding: 6px 12px;
        box-shadow: rgba(0, 0, 0, 0.1) 0px 1px 2px 0px;
        font-size: 13px;
    }

    .service-bx .service-item .tt {
        font-size: 14px;
        font-weight: 600;
        line-height: 1.5;
        color: var(--text-color);
        /* overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        display: block; */
        min-height: 45px;
        display: flex;
        align-items: center;
        justify-content: center;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;

    }

    .testimonial-sec {
        padding-block: 40px;
        background-image: url(designer/image/bg/hero-bg.webp);
        background-color: var(--dark);
        background-size: cover;
        background-position: center;
    }

    .testimonial-sec .head-sec .tt {
        color: white;
    }
    .testimonial-sec .head-sec p{
        color: #fff;
    }
    .testimonial-sec .amp-carousel-button {
        background-color: rgba(245, 131, 30, .6);
        /* height: 24px;
        width: 24px; */
        border-radius: 100%;
    }

    .testimonial-sec .amp-carousel-button-next {
        right: 0;
        /* background-size: 14px 14px; */
    }

    .testimonial-sec .amp-carousel-button-prev {
        left: 0;
        /* background-size: 14px 14px; */
    }

    .tm-testi-slide-1 {
        background: #fff;
        padding: 24px 21px 15px 21px;
        border: 1px solid #dfdfdf;
        border-radius: 18px;
        transition: all .3s ease-in-out;
        margin-inline: 10px;
    }

    .tm-testi-logo {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 50px;
    }

    .tm-trustpilot-logo {
        width: 100%;
        max-width: 100px;
    }

    .tm-star-ratings {
        width: 100%;
        max-width: 90px;
    }

    .tm-slide-p {
        font-weight: 400;
        font-size: 15px;
        padding: 10px 0 15px 0;
        line-height: 23px;
        border-bottom: 1px solid #ebeaea;
        color: #707070;
        text-align: left;
        margin: 0;
    }

    .tm-slide-h5 {
        color: #154fc1;
        padding-top: 10px;
        font-size: 16px;
        font-weight: 600;
    }

    .costing-sec {
        padding-block: 40px;
        background: #fff;
    }


    .head-sec2 {
        margin-bottom: 17px;
        text-align: left;
    }

    .head-sec2 .tt {
        font-weight: 500;
        font-size: 22px;
        margin-bottom: 5px;
        color: var(--text-color);
    }

    .head-sec2 .tt span {
        color: var(--pri);
        font-weight: 600;
        line-height: 1.2;
    }

    .head-sec2 p {
        font-size: 14px;
        text-align: left;
    }


    .serv-bx {
        display: flex;
        align-items: center;
        gap: 30px;
        margin-bottom: 20px;
    }

    .serv-bx .des {
        width: calc(100% - 100px);
    }

    .serv-bx .ic-bx {
        width: 70px;
    }

    .serv-bx .des .tt {
        color: var(--black);
        font-size: 17px;
        font-weight: 600;
    }

    .serv-bx .des p {
        margin-bottom: 0;
    }


    .costing-sec table {
        background: white;
    }


    .costing-sec table {
        width: 100%;
        text-align: left;
        border-collapse: collapse;
        border-radius: 6px;
        overflow: hidden;
        max-width: 100%;
    }

    .costing-sec table thead tr {
        border-bottom: 1px solid #eee;
    }

    .costing-sec table thead tr th {
        height: 35px;
        font-weight: 600;
        background: #292350;
        color: #fff;
        padding: 5px 10px;
        line-height: normal;
        border-right: 1px solid #eee;
        font-size: 16px;
        text-align: center;
        border-bottom: 1px solid #eee;

    }

    .costing-sec table thead tr th:last-child {
        border-right: 0;
    }

    .costing-sec table td {
        border: 1px solid #eee;
        padding: 5px 10px;
        color: #333;
        vertical-align: middle;
        font-size: 16px;
        text-align: center;
        line-height: normal;
    }


    .costing-sec table td .main-btn {
        font-size: 13px;
        padding: 5px 10px;
    }

    .costing-sec table tr td a {
        color: #333
    }

/* */
.why_us_bx{box-shadow:0 .3rem 1rem 1px rgba(0,0,0,.15);padding:20px 25px; margin-bottom: 15px; border-radius:10px;overflow:hidden;border-bottom:5px solid var(--sec);transition:.4s;background:#fff;height:100%}
.why_us_bx:hover{transform:translateY(-10px)}
.why_us_bx p{margin-bottom:0}
.why_us_bx .why_ic{max-width:60px;transition:.7s}
.why_us_bx:hover .why_ic{transform:rotateY(360deg)}
.why_us_bx .why-tt{padding:8px 0;font-size:20px;font-weight:700;line-height:1.3}
.why_us_bx .why-tt-bx{position:relative;z-index:1}
.why_us_bx .whycount{position:absolute;top:49%;left:0;font-size:70px;color:var(--pri);font-weight:800;z-index:-1;opacity:.1;transform:translateY(-50%)}
.why_us_bx p{color:#666;text-align:left;margin-bottom:0;font-size:16px;line-height:22px}
._why_us{float:left;width:100%;margin:0;padding:60px 0;background:#fff;position:relative;background:url(../images/bg/bg21.jpg);background-position:center;background-repeat:no-repeat;background-size:cover;z-index:1}
._why_us::before{content:"";position:absolute;top:0;left:0;height:100%;width:100%;background:#fff;z-index:-1;opacity:.8}


    .footer {
        width: 100%;
        padding-top: 60px;
        background-color: var(--dark);
        background-size: cover;
        background-position: center;
        position: relative;
    }

    .footer .ondebox {
        position: absolute;
        top: -2px;
        bottom: auto;
        background: white;
        width: 100%;
        transform: none;
    }

    .footer_quote {
        margin: 10px 0 15px 0;
        padding: 20px;
        background: rgb(255 255 255 / 10%);
        border-radius: 15px;
        backdrop-filter: blur(15px);
    }

    .footer_quote h6 {
        font-size: 17px;
        margin-bottom: 3px;
        color:#fff;
        line-height: 24px;
    }

    .footer_quote p {
        color: #fff;
        font-size: 15px;
        line-height: 22px;
        margin-bottom: 0
    }

    .footer_quote p a {
        color: #fff
    }

    .footer_quote p a:hover {
        color: var(--pri)
    }

    .social_media .social {
        justify-content: center;
        margin-bottom: 15px;
    }

    .social_media .social li a {
        width: 35px;
        height: 35px;
    }

    .copyrights {
        width: 100%;
        color: #fff;
        line-height: 22px;
        font-size: 14px;
        padding-bottom: 30px;
        text-align: center;
        margin-bottom: 0;
    }

    .copyrights a {
        color: #4098c6;
    }

    .py-0,
    .pt-0 {
        padding-top: 0;
    }

    .py-0,
    .pb-0 {
        padding-bottom: 0;
    }

    .py-40,
    .pt-40 {
        padding-top: 40px;
    }

    .py-40,
    .pb-40 {
        padding-bottom: 40px;
    }

    .my-0,
    .mt-0 {
        margin-top: 0;
    }

    .my-0,
    .mb-0 {
        margin-bottom: 0;
    }

    .my-40,
    .mt-40 {
        margin-top: 40px;
    }

    .my-40,
    .mb-40 {
        margin-bottom: 40px;
    }

    .aboutSection {
        padding: 30px 0;
        background-color: #ebf2f7;
    }

    .aboutSection h3 {
        font-size: 18px;
        color:var(--pri);
        font-weight: 600;
        margin-bottom: 15px;
        text-align: center;
    }

    .aboutSection h2 {
        font-weight: 600;
        font-size: 22px;
        margin-bottom: 5px;
        color: var(--pri);
        text-align: center;
    }

    .aboutSection p {
        text-align: center;
    }

    .videoBox {
        overflow: hidden;
        position: relative;
        z-index: 1;
        background: #fff;
        padding: 0;
        box-shadow: 0 0 8px rgba(0, 0, 0, .2);
        margin: 0 0 10px;
        border-radius: 16px;
    }

    .videoBox amp-video {
        border-radius: 16px;
    }

    .aboutSection ul {
        margin: 0 0 25px;
        padding: 0;
    }

    .aboutSection ul li {
        list-style: none;
        line-height: 1.4;
        color: #333;
        font-size: 15px;
        font-weight: normal;
        margin-bottom: 5px;
    }

    .aboutSection ul li::before {
        margin-right: 5px;
        content: url("data:image/svg+xml;charset=utf-8,<svg xmlns='http://www.w3.org/2000/svg' width='14' height='14' fill='gray' viewBox='0 0 16 16'><path d='m12.14 8.753-5.482 4.796c-.646.566-1.658.106-1.658-.753V3.204a1 1 0 0 1 1.659-.753l5.48 4.796a1 1 0 0 1 0 1.506z'/></svg>");
    }
</style>