<?php
include_once('../../include/main.inc.php');

function is_mobile()
{
    return preg_match("/(android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini)/i", $_SERVER["HTTP_USER_AGENT"]);
}

// If it's a desktop device, redirect to the desktop version
if (!is_mobile()) {
    header("Location: https://www.winntus.com/lp/");
    exit();
}

?>
<!DOCTYPE html>
<html amp lang="en">

<head>
    <meta charset="utf-8">
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <title>Scaffolding on Rent in India,Aluminium Formwork System Manufacturers in India</title>
    <meta name="description" content="Winntus Formwork System Pvt. Ltd. leading Scaffolding on Rent in India. Best Quality Aluminium Formwork System Manufacturers in India at Factory Price. Call +91-8447755028">
    <meta name="keywords" content="Scaffolding on Rent, Aluminium Formwork System Manufacturers, Scaffolding on Rent, Aluminium Formwork System">
    <link rel="canonical" href="https://amp.dev/documentation/guides-and-tutorials/start/create/basic_markup/">
    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1">
    <link rel="icon" href="designer/image/favicon.ico">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    <script async custom-element="amp-fx-collection" src="https://cdn.ampproject.org/v0/amp-fx-collection-0.1.js"></script>
    <script async custom-element="amp-carousel" src="https://cdn.ampproject.org/v0/amp-carousel-0.1.js"></script>
    <script async custom-element="amp-sidebar" src="https://cdn.ampproject.org/v0/amp-sidebar-0.1.js"></script>
    <script async custom-element="amp-image-lightbox" src="https://cdn.ampproject.org/v0/amp-image-lightbox-0.1.js"></script>
    <script async custom-element="amp-lightbox" src="https://cdn.ampproject.org/v0/amp-lightbox-0.1.js"></script>
    <script async custom-element="amp-lightbox-gallery" src="https://cdn.ampproject.org/v0/amp-lightbox-gallery-0.1.js"></script>
    <script async custom-element="amp-accordion" src="https://cdn.ampproject.org/v0/amp-accordion-0.1.js"></script>
    <script async custom-element="amp-youtube" src="https://cdn.ampproject.org/v0/amp-youtube-0.1.js"></script>
    <?php include "top.php"; ?>
</head>

<body>
    <?php include "header.php"; ?>
    <main id="home">
        <div class="container">
            <div class="text-bx">
                <h1 class="main-tt">Top Quality Scaffolding on Rent in India</h1>
                <p>At Winntus, we believe in more than just building structures; we're dedicated to building a sustainable future for our country, driven by integrity, innovation, and collaboration.</p>
            </div>
            <!-- <div class="img-bx">
                <amp-img src="designer/image/main-img.webp" width="700" height="588" layout="responsive" alt="" title=""></amp-img>
            </div> -->
            <div class="equ_box">
                <div class="head-sec text-center mb-0">
                    <div class="tt">Request your customized quote,<br> <span>tailored to your needs today!</span> </div>
                </div>
                <form method="POST" action="submit_enquiry_amp.php" target="_top" onsubmit="disableButton()" autocomplete="off">

                    <div class="amp_input">
                        <input type="text" name="en_name" id="name" placeholder="Full Name*" required>
                    </div>
                    <div class="amp_input">
                        <input type="text" name="en_mobile" id="mobile" placeholder="Mobile Number*" required="" inputmode="numeric" pattern="^[0-9]{4,15}$" maxlength="15" minlength="4" title="Please enter a valid mobile number (only digits allowed 4 - 15)">
                    </div>
                    <div class="amp_input">
                        <input type="email" name="en_email" id="email" placeholder="Email ID*" required="">
                    </div>
                    <div class="amp_input">
                        <input type="text" name="en_city" id="city" placeholder="City Name*" required="">
                    </div>
                    <div class="amp_input">
                        <textarea class="form-control" name="en_message" id="message" placeholder="Your Message*" required=""></textarea>
                    </div>

                    <button class="contact_btn" type="submit" name="submit" id="submitBtn">Enquire Now</button>
                </form>
            </div>
        </div>
        <div class="ondebox">
            <svg class="onde" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                viewBox="0 24 150 28" preserveAspectRatio="none" shape-rendering="auto">
                <defs>
                    <path id="onda" d="M-160 44c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352Z" />
                </defs>
                <g class="parallaxonde">
                    <use xlink:href="#onda" x="48" y="0" fill="rgba(16, 60, 84" />
                    <use xlink:href="#onda" x="48" y="3" fill="rgba(6, 60, 84,0.8)" />
                    <use xlink:href="#onda" x="48" y="5" fill="rgba(6, 60, 84,0.6)" />
                    <!-- <use xlink:href="#onda" x="48" y="7" fill="#f9f6ef" /> -->
                </g>
            </svg>
        </div>
    </main>
    <div class="featured-sec" id="feature">
        <div class="container">
            <div class="head-sec text-center">
                <div class="tt">Clients who made us india's <span> most trusted formwork partner</span> </div>
            </div>
            <div class="featured-bx">
                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-Gail.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>
                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-Aditya-Birla.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>
                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-BHEL.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>
                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-HP.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>
                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-IndianOil.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>

                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-Adani-Power-Limited.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>

                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-NTPC.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>
                <div class="featured-item">
                    <amp-img src="designer/image/clients/clients-Tata-Power.jpg" width="160" height="100" layout="responsive" alt="" title=""></amp-img>
                </div>



            </div>
        </div>
    </div>

    <div class="aboutSection" id="about">
        <div class="container">
            <h2>Revolutionizing Construction with Innovative Solutions</h2>
            <p>At Winntus Formwork Pvt. Ltd, we are dedicated to providing top-notch solutions for your construction needs. Our expertise lies in offering <strong>Scaffolding on Rent in India</strong>, tailored to meet the demands of your project. Whether you're working on a large-scale commercial development or a residential renovation, our scaffolding solutions ensure safety and efficiency at every step. We understand the importance of reliable equipment in the construction industry, which is why we offer a wide range of scaffolding options that adhere to stringent safety standards.</p>

            <div class="videoBox">
                <amp-youtube data-videoid="E6t1npsEXw0" layout="responsive" width="400" height="220"></amp-youtube>
            </div>
            <h3>"At Winntus, we believe in more than just building structures; we're dedicated to building a sustainable future for our country, driven by integrity, innovation, and collaboration."</h3>

        </div>
    </div>


    <div class="gallery-sec" id="result">
        <div class="container">
            <div class="head-sec text-center">
                <div class="tt">Your New Look Awaits <br> <span class="fs-lg"> Our Esteemed Projects</span> </div>
            </div>
            <div class="gallery-bx">
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project1.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project2.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project3.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project4.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project5.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project6.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project7.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project8.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project9.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
                <figure class="gallery-item">
                    <div class="img-bx">
                        <amp-img lightbox="caption" src="designer/image/projects/zone-project10.jpg" alt="" title="" layout="responsive" width="300" height="300"></amp-img>
                    </div>
                </figure>
            </div>
        </div>
    </div>
    <div class="service-sec" id="products">
        <div class="container">
            <div class="head-sec">
                <div class="tt">Our <span>Products</span> </div>
                <p>Elevate your construction game with Winntus Formwork Pvt. Ltd. Browse through our premium range of innovative products designed for unparalleled performance and durability.</p>
            </div>
            <div class="service-bx">
                <div class="service-item">
                    <amp-img src="designer/image/products/Aluminium-Formwork-Rental.jpg" width="255" height="255" layout="responsive" alt="" title=""></amp-img>
                    <div class="des">
                        <div class="tt">Aluminium Formwork Rental</div>
                        <button class="main-btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i>
                        </button>
                    </div>
                </div>
                <div class="service-item">
                    <amp-img src="designer/image/products/Aluminium-Formwork-Refurbishment.jpg" width="255" height="255" layout="responsive" alt="" title=""></amp-img>
                    <div class="des">
                        <div class="tt">Aluminium Formwork Refurbishment</div>
                        <button class="main-btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i>
                        </button>
                    </div>
                </div>
                <div class="service-item">
                    <amp-img src="designer/image/products/MS-Formwork.jpg" width="255" height="255" layout="responsive" alt="" title=""></amp-img>
                    <div class="des">
                        <div class="tt">MS Formwork</div>
                        <button class="main-btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i>
                        </button>
                    </div>
                </div>
                <div class="service-item">
                    <amp-img src="designer/image/products/Aluminum-Vertical-Formwork.jpg" width="255" height="255" layout="responsive" alt="" title=""></amp-img>
                    <div class="des">
                        <div class="tt">Aluminum Vertical Formwork</div>
                        <button class="main-btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i>
                        </button>
                    </div>
                </div>

                <div class="service-item">
                    <amp-img src="designer/image/products/Aluminium-Formwork-Accessories-on-Rent.jpg" width="255" height="255" layout="responsive" alt="" title=""></amp-img>
                    <div class="des">
                        <div class="tt">Aluminium Formwork Accessories on Rent</div>
                        <button class="main-btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i>
                        </button>
                    </div>
                </div>

                <div class="service-item">
                    <amp-img src="designer/image/products/Aluminium-Deck-Panel-Formwork.jpg" width="255" height="255" layout="responsive" alt="" title=""></amp-img>
                    <div class="des">
                        <div class="tt">Aluminium Deck Panel Formwork</div>
                        <button class="main-btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i>
                        </button>
                    </div>
                </div>



            </div>
        </div>
    </div>
    <div class="video-sec" id="testimonials">
        <div class="container">
            <div class="head-sec">
                <div class="tt">Trusted by Thousands of <span>Clients like You</span> </div>
                <p>Join the ranks of satisfied clients at Winntus Formwork Pvt. Ltd. Trusted by thousands, we deliver reliability, quality, and innovation for your construction needs.</p>
            </div>
            <div class="video-bx">
                <div class="videoBg">
                    <div class="video-item w-100">
                        <amp-youtube data-videoid="rsR8YQAiBuc" layout="responsive" width="400" height="220"></amp-youtube>
                    </div>
                    <div class="videoTitle">Shapoorji & Pallonji</div>
                </div>

                <div class="videoBg">
                    <div class="video-item w-100">
                        <amp-youtube data-videoid="DAXJSWEZeUE" layout="responsive" width="400" height="220"></amp-youtube>
                    </div>
                    <div class="videoTitle">Nyati Group</div>
                </div>
                <div class="videoBg">
                    <div class="video-item w-100">
                        <amp-youtube data-videoid="eMBWxYMUlRs" layout="responsive" width="400" height="220"></amp-youtube>
                    </div>
                    <div class="videoTitle">Godrej Properties</div>
                </div>

            </div>
        </div>
    </div>
    <div class="costing-sec" id="service">
        <div class="container">
            <div class="head-sec2">
                <div class="tt">Our <span>Services</span></div>
                <p>We provide reliable, high-quality scaffolding solutions for safe and efficient construction, ensuring stability, durability, and compliance with industry standards for projects of all sizes. </p>
            </div>
            <div class="bd_bx">
                <div class="serv-bx">
                    <div class="ic-bx">
                        <img src="designer/image/services/rent.png" alt="rent" title="rent" width="128" height="128">
                    </div>
                    <div class="des">
                        <div class="tt">Rentals</div>
                        <p>Shuttering, scaffolding products, Aluminium Formwork and accessories are available
                            for rent.</p>
                    </div>
                </div>
                <div class="serv-bx">
                    <div class="ic-bx">
                        <img src="designer/image/services/manufacturing.png" alt="Manufacturing" title="Manufacturing" width="128" height="128">
                    </div>
                    <div class="des">
                        <div class="tt">Manufacturing</div>
                        <p>Winntus manufactures MS Shuttering, Aluminium Formwork and Scaffolding with in-house
                            warehousing and Inventory.</p>
                    </div>
                </div>
                <div class="serv-bx">
                    <div class="ic-bx">
                        <img src="designer/image/services/repair.png" alt="Repair &amp; Modification" title="Repair &amp; Modification" width="128" height="128">
                    </div>
                    <div class="des">
                        <div class="tt">Repair &amp; Modification</div>
                        <p>We undertake rapair, Aluminium Formwork and reconditioning work for scaffolding.</p>
                    </div>
                </div>
                <div class="serv-bx">
                    <div class="ic-bx">
                        <img src="designer/image/services/exchange.png" alt="Exchange" title="Exchange" width="128" height="128">
                    </div>
                    <div class="des">
                        <div class="tt">Exchange</div>
                        <p>In exchange of your non workable scrap we provide you with new and customized
                            scaffolding and shuttering materials.</p>
                    </div>
                </div>
                <div class="serv-bx">
                    <div class="ic-bx">
                        <img src="designer/image/services/export.png" alt="Exporter" title="Exporter" width="128" height="128">
                    </div>
                    <div class="des">
                        <div class="tt">Exporter</div>
                        <p>Winntus is exporting it's facilities internationally also.</p>
                    </div>
                </div>

                <button class="contact_btn" on="tap:whatsapp_lightbox">Enquire Now <i class="fa fa-envelope-o"></i></button>

            </div>


        </div>
    </div>
    <div class="testimonial-sec">
        <div class="container">
            <div class="head-sec">
                <div class="tt">
                    Reasons to Choose Us</div>
                <p>Choose us for safe, durable, and customized scaffolding solutions. We offer expert installation, reliable materials, competitive pricing, timely delivery, and 24/7 support for all projects.</p>
            </div>

            <div class="why_us_bx">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="why_ic">
                        <img src="designer/image/icons/High-Quality-&amp;-Reliable-Products.png" alt="High Quality &amp; Reliable Products" title="High Quality &amp; Reliable Products" width="128" height="128">
                    </div>
                    <div class="why-tt-bx">
                        <div class="why-tt">High Quality &amp; Reliable Products</div>
                        <span class="whycount">01</span>
                    </div>
                </div>
                <p>Winntus emphasizes the use of premium quality raw materials meeting industry standards in
                    manufacturing its products, ensuring durability, reliability, and safety in construction
                    projects.</p>
            </div>

            <div class="why_us_bx">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="why_ic">
                        <img src="designer/image/icons/Best-Talent.png" alt="Best Talent" title="Best Talent" width="128" height="128">
                    </div>
                    <div class="why-tt-bx">
                        <div class="why-tt">Best Talent</div>
                        <span class="whycount">02</span>
                    </div>
                </div>
                <p>At Winntus, our 500+ member strong team operates as a cohesive unit, dedicated to swiftly
                    addressing any query or issue, whether before or after the sale. With a collective
                    commitment to excellence, we ensure that our clients receive optimal solutions with
                    promptness and efficiency.</p>
            </div>

            <div class="why_us_bx">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="why_ic">
                        <img src="designer/image/icons/State-of-Art-Production-Facility.png" alt="State of Art Production Facility" title="State of Art Production Facility" width="128" height="128">
                    </div>
                    <div class="why-tt-bx">
                        <div class="why-tt">State of Art Production Facility</div>
                        <span class="whycount">03</span>
                    </div>
                </div>
                <p>In Winntus we have Aluminium Formwork 30K SQM Production Capacity Monthly and 10K Dispatch
                    Capacity Monthly, 80K Ton of MS Scaffolding &amp; Shuttering in Stock, 20K Ton of MS Scaffolding
                    Production Capacity.</p>
            </div>

            <div class="why_us_bx">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="why_ic">
                        <img src="designer/image/icons/Innovative-Solutions.png" alt="Innovative Solutions" title="Innovative Solutions" width="128" height="128">
                    </div>
                    <div class="why-tt-bx">
                        <div class="why-tt">Innovative Solutions</div>
                        <span class="whycount">04</span>
                    </div>
                </div>
                <p>The Company prides itself on offering innovative and customised solutions to meet clients'
                    specific requirements. This flexibility suggests a commitment to finding unique answers to
                    complex construction needs.</p>
            </div>

            <div class="why_us_bx">
                <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="why_ic">
                        <img src="designer/image/icons/Client-Centric-Approach.png" alt="Client Centric Approach" title="Client Centric Approach" width="128" height="128">
                    </div>
                    <div class="why-tt-bx">
                        <div class="why-tt">Client Centric Approach</div>
                        <span class="whycount">05</span>
                    </div>
                </div>
                <p>Winntus aims to priorities client satisfaction, aiming to exceed expectations through
                    excellent service and support throughout the project lifecycle.</p>
            </div>
        </div>
    </div>
    <?php include "app_faq.php"; ?>
    <?php include "footer.php"; ?>
    <?php include "app_modal.php"; ?>

    <script>
        function disableButton() {
            document.getElementById("submitBtn").disabled = true;
        }
    </script>
</body>

</html>