<?php include "app_modal.php"; ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.min.js"></script> 

<script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.0.2/wow.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.js"></script> 

<!-- <script src="<?=site_url;?>/designer/js/intlTelInput-jquery.js"></script> -->

 <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.9.0/jquery.validate.min.js"></script>  

 <script src="<?=site_url;?>/designer/js/themes.js"></script>
<script>
    $(document).ready(function() {

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#contact_form").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required"
                // ❗ mobile rules removed (handled dynamically)
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location",
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                }

            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/contact.php",
                    type: "POST",
                    data: $("#contact_form").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#pop_up").text(res.message_response).css("color", "green");
                            $("#contact_form")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#pop_up").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#contact_form");

    });


    // whatsapp form start

    $(document).ready(function() {
        // ------------------------------
        // FORM VALIDATION
        // ------------------------------
        $("#whatsapp_form").validate({
            rules: {
                name: "required"
                // mobile rules dynamically added
            },
            messages: {
                name: "Please enter your name",
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                }

            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $(':input[type="submit"]').prop("disabled", true);

                $.ajax({
                    
                    url: "<?= site_url; ?>/whatsapp_enq.php",
                    type: "POST",
                    data: $("#whatsapp_form").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $(".wht_error_message").text("");
                            $(".wht_success_message").text("Submitted Successfully.");
                            $("#whatsapp_form")[0].reset();
                            window.open(res.message_response, "_blank");
                        } else {
                            $(".wht_success_message").text("");
                            $(".wht_error_message").text(res.message_response);
                        }
                        $(':input[type="submit"]').prop("disabled", false);
                    }
                });
            }
        });

        // ------------------------------
        // INIT PHONE FIELD
        // ------------------------------
        setupPhoneValidation("#whatsapp_form");

    });


    // whatsapp form end

    // Quick Enquiry Form Start

    $(document).ready(function() {

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#enq_pop_form1").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required"

                // ❗ mobile rules removed (handled dynamically)
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location",
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                }

            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/enquiry_popup.php",
                    type: "POST",
                    data: $("#enq_pop_form1").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#enq_pop_up").text(res.message_response).css("color", "green");
                            $("#enq_pop_form1")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#enq_pop_up").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#enq_pop_form");

    });

    // Quick Enquiry Form End

    // Send (Category) Enquiry Form Start

    $(document).ready(function() {

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#product_pop_form").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required",
                quantity: {
            required: true,
            number: true,
            min: 500   // ✅ ADD THIS
        }
    },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location",
                quantity: "Please enter your order quantity (Minimum Order Value Must Be 500 Pcs)",
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                }

            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/enquirycat_popup.php",
                    type: "POST",
                    data: $("#product_pop_form").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#cat_pop_up").text(res.message_response).css("color", "green");
                            $("#product_pop_form")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#cat_pop_up").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#product_pop_form");

    });

    // Send (Category) Enquiry Form End


    // Request call back start

   $(document).ready(function() {

   $("#callback_form").validate({
            rules: {
                name: "required"
                // mobile rules dynamically added
            },
            messages: {
                name: "Please enter your name",
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                }

            },

            errorPlacement: function(error, element) {
                // element is jQuery object
                const group = element.closest(".phone-group");

                if (group && group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                // ensure hidden code is present before sending
                const formEl = $("#callback_form");
                const codeVal = formEl.find("input.country_code").val() || "";
                const nameVal = formEl.find("input.countryName").val() || "";
                // if code missing, show message and stop
                if ($.trim(codeVal) === "") {
                    $("#cpop_up").text("").css("color", "red");
                    return false;
                }

                // disable button to prevent double submits
                const $submitBtn = $(':input[type="submit"]', formEl);
                $submitBtn.prop("disabled", true);

                // send submit_callback so PHP recognizes AJAX submit
                const payload = formEl.serialize() + "&submit_callback=1";

                $.ajax({
                    url: "<?= site_url; ?>/ajax_enq_action.php",
                    type: "POST",
                    data: payload,
                    dataType: "json",
                    success: function(res) {
                        if (res && res.status === true) {
                            $("#cpop_up").text(res.message_response).css("color", "green");
                            $("#callback_form")[0].reset();
                            // reset intlTelInput UI values too (if grecaptcha not used remove next line)
                            if (typeof grecaptcha !== "undefined" && grecaptcha.reset) {
                                grecaptcha.reset();
                            }
                        } else {
                            const msg = (res && res.message_response) ? res.message_response : "Something went wrong";
                            $("#cpop_up").text(msg).css("color", "red");
                        }
                    },
                    error: function(xhr, status, err) {
                        $("#cpop_up").text("Server error. Please try again.").css("color", "red");
                    },
                    complete: function() {
                        // always re-enable submit button
                        $submitBtn.prop("disabled", false);
                    }
                });
            },
        });

        // ------------------------------
        // INIT PHONE FIELD
        // ------------------------------
        setupPhoneValidation("#callback_form");

        // additionally: if user manually changes hidden code (edge cases), clear popup
        $(document).on("change", "#callback_form input.code, #callback_form input.countryName", function() {
            $("#cpop_up").text("");
        });
    });







    // Request Call back end



    // Home Page Enquiry Form Start

    $(document).ready(function() {

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#enq_pop_form2").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required"

                // ❗ mobile rules removed (handled dynamically)
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location",
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                }

            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/enquiry_home.php",
                    type: "POST",
                    data: $("#enq_pop_form2").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#enq_pop_up_home").text(res.message_response).css("color", "green");
                            $("#enq_pop_form2")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#enq_pop_up_home").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#enq_pop_form");

    });

    // Home Page Enquiry Form End

    function ValidateAlpha(evt) {
        var keyCode = (evt.which) ? evt.which : evt.keyCode
        if ((keyCode < 65 || keyCode > 90) && (keyCode < 97 || keyCode > 123) && keyCode != 32)
            return false;
        return true;
    }

    function isNumberKey(evt) {
        //var e = evt || window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode != 46 && charCode > 31 &&
            (charCode < 48 || charCode > 57))
            return false;
        return true;
    }

    function validateOnlyTextField(element) {
        var str = element.value;
        if (str == ' ') {
            element.value = "";
        }
        if (!(/^[a-zA-Z\s]+$/.test(str))) {
            // console.log('String contain number characters');
            str = str.substr(0, str.length - 1);
            element.value = "";
        }
    }

  
</script>


<script>
/* =====================================================
   SETUP PHONE VALIDATION (PER PHONE GROUP)
===================================================== */
function setupPhoneValidation(group, options = {}) {

    const input     = group.querySelector(".phone-input");
    const codeInput = group.querySelector(".country_code");
    const nameInput = group.querySelector(".country_name");
    const isoInput  = group.querySelector(".country_iso");
    const errorEl   = group.querySelector(".error-message");

    if (!input) return;

    const iti = window.intlTelInput(input, {
        initialCountry: "",
        separateDialCode: true,
        allowDropdown: true,
        dropdownContainer: options.dropdownContainer || document.body,
        utilsScript:
          "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/utils.min.js"
    });

    /* clear hidden fields initially */
    codeInput.value = "";
    nameInput.value = "";
    isoInput.value  = "";

    /* country change */
    input.addEventListener("countrychange", () => {
        const c = iti.getSelectedCountryData();

        codeInput.value = c.dialCode || "";
        nameInput.value = c.name || "";
        isoInput.value  = c.iso2 || "";

        errorEl.textContent = "";
        updatePhoneRules(input.closest("form"), input, c);
    });

    /* sanitize input */
    input.addEventListener("input", () => {
        input.value = input.value.replace(/\D/g, "").replace(/^0+/, "");
        errorEl.textContent = "";
    });

    /* validation function */
    group.validatePhone = function () {

        if (!isoInput.value) {
            errorEl.textContent = "Please select country code";
            iti.openCountryDropdown();
            return false;
        }

        // if (!iti.isValidNumber()) {
        //     errorEl.textContent = "Please enter a valid mobile number";
        //     return false;
        // }

        return true;
    };
}

/* =====================================================
   UPDATE RULES (jQuery Validate Sync)
===================================================== */
function updatePhoneRules(form, input, country) {
    let validator = $(form).data("validator");
    if (!validator) return;

    let field = input.name;

    if (country.iso2 === "in") {
        $(input).attr({ minlength: 10, maxlength: 10 });

        validator.settings.rules[field] = {
            required: true,
            minlength: 10,
            maxlength: 10,
            digits: true
        };

        validator.settings.messages[field] = {
            required: "Please enter your mobile no.",
            minlength: "Your Mobile No. must be 10 digits",
            maxlength: "Your Mobile No. must be 10 digits"
        };
    } else {
        $(input).attr({ minlength: 4, maxlength: 17 });

        validator.settings.rules[field] = {
            required: true,
            minlength: 4,
            maxlength: 17,
            digits: true
        };

        validator.settings.messages[field] = {
            required: "Please enter your mobile no.",
            minlength: "Your Mobile No. must be 4–17 digits long",
            maxlength: "Your Mobile No. must be 4–17 digits long"
        };
    }
}

/* =====================================================
   INIT ALL PHONE GROUPS
===================================================== */
function initAllPhoneGroups(root = document) {
    root.querySelectorAll(".phone-group").forEach(group => {
        if (!group._itiInitialized) {
            setupPhoneValidation(group, {
                dropdownContainer: group.closest(".modal") || document.body
            });
            group._itiInitialized = true;
        }
    });
}

/* =====================================================
   PAGE LOAD
===================================================== */
document.addEventListener("DOMContentLoaded", () => {
    initAllPhoneGroups(document);
});

/* =====================================================
   MODAL SUPPORT
===================================================== */
document.addEventListener("shown.bs.modal", e => {
    initAllPhoneGroups(e.target);
});

/* =====================================================
   FORM SUBMIT (🔥 MAIN FIX HERE)
===================================================== */
document.querySelectorAll("form").forEach(form => {
    form.addEventListener("submit", function (e) {

        e.preventDefault(); // ❗ ALWAYS stop first

        let allValid = true;

        form.querySelectorAll(".phone-group").forEach(group => {
            if (!group.validatePhone()) {
                allValid = false;
            }
        });

        if (!allValid) {
            return false; // ❌ STOP – no popup, no ajax
        }

        /* ✅ ONLY VALID FORM REACHES HERE */

        // If normal submit required
        // form.submit();

        // OR if AJAX submit
        if (typeof $ !== "undefined") {
            $.ajax({
                url: form.action,
                type: "POST",
                data: $(form).serialize(),
                success: function () {
                    $(".success-msg")
                        .text("Submitted Successfully.")
                        .show();
                }
            });
        }
    });
});
</script>
