<?php

include_once("include/main.inc.php");

$hover = 'blogs';

$blog_query = mysqli_query($GLOBALS['dbconn'], "select catImage,catName,blogDname,catDesc,blog_written from blog_tbl");

$page_metatitle = "Insights and Trends in T-Shirt Manufacturing | " . COMPANY_NAME;

$page_metakey = "Blog, T-shirt Blog, Custom Apparel Trends, T-shirt Tips, Wali Exports Blog";

$page_metadesc = "Dive into our blog for updates, insights, and trends in T-shirt manufacturing and custom apparel. Stay informed with " . COMPANY_NAME;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>

</head>
<body>
    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/about-banner.jpg)">

        <div class="container">

            <div class="row">

                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">

                    <h1 class="cat_title">Our Blogs</h1>

                </div>

            </div>

        </div>

    </section>
    <div class="inner_breadcrumb hidden_xs">

        <div class="container">

            <div class="row">

                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                    <ul class="breadcrumb">

                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>

                        <li class="active">Our Blog</li>

                    </ul>

                </div>

            </div>

        </div>

    </div>
    <div class="homeBlog">

        <div class="container">

            <div class="tt-bx">

                <div class="tt">Latest <span>Blogs</span></div>

                <p>Stay updated with our latest blogs, where we share insights on fashion trends, styling tips, and product care. Dive into expert advice and discover how to make the most of your wardrobe with practical ideas and fresh perspectives. Our blogs are your go-to source for inspiration and knowledge in every season.
                </p>

            </div>

            <div class="clearfix"></div>
            <div class="row align-items-stretch">
            <?php while ($blog_res = mysqli_fetch_assoc($blog_query)) {

if ($blog_res['catImage'] != '') {

    $blog_img =  getImage($blog_res['catImage'], 376, 235, $blog_res['catName'], "/uploaded-files/blog/images/");
} else {

    $blog_img = NO_IMG_URL;
}

?>
                <div class="col-lg-4 col-md-6 col-12 wow fadeInUp">

                    <div class="blogBox">

                        <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>">

                            <div class="image">

                                <img src="<?= $blog_img; ?>" alt="<?= $blog_res['blogDname']; ?>" title="<?= $blog_res['blogDname']; ?>">

                            </div>

                        </a>

                        <div class="blogDescribe">

                            <!-- <abbr class="blogDate">01 Sept, 2022</abbr> -->

                            <h2 class="tt"><a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>"><?= $blog_res['blogDname']; ?></a></h2>

                            <p><?= html_entity_decode(substr($blog_res['catDesc'], 0, 200)); ?>...</p>

                            <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="Read More" class="readMore">Read More

                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"

                                    viewBox="0 0 16 16">

                                    <path fill-rule="evenodd"

                                        d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">

                                    </path>

                                </svg>

                            </a>

                        </div>

                    </div>

                </div>
                <?php } ?>
            </div>

        </div>

    </div>
    <?php include "app_footer.php"; ?>

    <?php include "app_bottom.php"; ?>

</body>
</html>