<?php
include('include/main.inc.php');
$web_det_query = "Select * from admin_details where slno = '1'";
$res_web = $dbconn->query($web_det_query);
$web_details = $res_web->fetch_assoc();
$page_metatitle = "Explore Expert Insights and Updates from Leading Shuttering Material Formwork Manufacturers ";
$page_metadesc = "Stay informed with Kayson Steelcast LLP' blog on shuttering material and formwork innovations. Discover expert advice, trends, and updates in the construction industry.";
$page_metakey = "Shuttering Material, Formwork Manufacturers, Construction Innovations, Kayson Steelcast LLP Blog, Shuttering Solutions, Formwork Trends.";

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?= $page_metatitle; ?></title>
    <meta name="description" content="<?= $page_metadesc; ?>">
    <meta name="keywords" content="<?= $page_metakey; ?>">
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/blog-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Our Blogs</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Our Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <section class="blog_page">
        <div class="container">
            <div class="title_2">Our Blogs</div>
            <div class="clearfix"></div>
            <div class="row">
                <?php
                $sel_blog_query = "select * from blog_tbl order by catID asc";
                $res_blog = $dbconn->query($sel_blog_query);
                if ($res_blog->num_rows > 0) {
                    $sno = 1;
                    while ($blogs = $res_blog->fetch_assoc()) {
                        $blog_href = str_ireplace(" ", "-", $blogs['catName']);
                        $sno++;
                ?>
                        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            <div class="btc_blog_indx_box_wrapper">
                                <a href="<?= site_url; ?>/blog/<?= strtolower($blog_href); ?>.htm" title="<?= $blogs['blogDname']; ?>">
                                    <div class="btc_blog_indx_img_wrapper">
                                        <img src="<?= site_url; ?>/uploaded-files/blog/images/<?= $blogs['catImage']; ?>" alt="<?= $blogs['blogDname']; ?>" title="<?= $blogs['blogDname']; ?>">
                                        <div class="btc_blog_indx_date_wrapper">
                                            <span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                                    <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z" />
                                                </svg></span>
                                        </div>
                                    </div>
                                    <div class="btc_blog_indx_cont_wrapper">
                                        <p><?= date('M d, Y', strtotime($blogs['blogDate'])); ?></p>
                                        <h2 class="blogTitle"><?= $blogs['blogDname']; ?></h2>
                                    </div>
                                </a>
                            </div>
                        </div>
                <?php }
                } ?>

            </div>
        </div>
    </section>

    <?php include "app_testimonials.php"; ?>
    <?php // include "app_clients.php"; 
    ?>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>