<?php
include_once("include/main.inc.php");
$hover = 'blog';
$blog_query = mysqli_query($GLOBALS['dbconn'], "select catImage,catName,blogDname,catDesc,blog_written,blogDate from blog_tbl");
$page_metatitle = 'Top Embroidered Patches Manufacturers in Houston, USA | Vision Digitizers';
$page_metakey = 'Embroidered Patches Manufacturers in Houston, Custom Embroidered Patches Houston, Vision Digitizers, Embroidery Patch Makers USA, Best Patch Manufacturers Houston, Custom Patches USA, Houston Patch Suppliers, Embroidered Badge Manufacturers, High-Quality Patches USA, Custom Logo Patches Houston';
$page_metadesc = 'Discover the Top Embroidered Patches Manufacturers in Houston, USA with Vision Digitizers. Explore expert tips, quality standards, and why Vision Digitizers is a trusted name for custom embroidery patches.';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <div class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/about/about-banner.webp)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Blogs - <?= $admin_res['companyName']; ?></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="breadcrumbSection hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Our Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <div class="blog_page">
        <div class="container">
            <div class="blog_left">
                <div class="title_2">Our Blogs</div>
                <div class="maxWidth">
                    <p>Stay inspired with the latest trends, tips, and insights in embroidery, patches, and custom digitizing. Our blogs cover everything from design techniques to industry innovations, helping you bring your creative vision to life. Whether you're a business or an artist, find expert advice and fresh ideas to elevate your branding and style!</p>
                </div>
                <div class="clearfix"></div>
                <div class="row g-4">
                    <?php
                    while ($blog_res = mysqli_fetch_assoc($blog_query)) {
                        if ($blog_res['catImage'] != '') {
                            $blog_img =  getImage($blog_res['catImage'], 500, 312, $blog_res['catName'], "/uploaded-files/blog/images/");
                        } else {
                            $blog_img = NO_IMG_URL;
                        }
                        $blog_shortdesc = str_ireplace('{companyName}', $admin_res['companyName'], $blog_res['catDesc']);
                    ?>
                        <div class="col-lg-4 col-md-6 col-12">
                            <div class="singleBlog">
                                <div class="image-box">
                                    <figure class="image">
                                        <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>">
                                            <img src="<?= $blog_img; ?>" alt="<?= $blog_res['blogDname']; ?>" title="<?= $blog_res['blogDname']; ?>">
                                        </a>
                                    </figure>
                                </div>
                                <div class="blogInfo">
                                    <h2 class="blogTitle">
                                        <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>"><?= $blog_res['blogDname']; ?> </a>
                                    </h2>
                                    <a class="readBtn_1" href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="Full Article">Full Article <i class="icon fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>