<?php
include_once("include/main.inc.php");
$hover = 'gallery';
$page_metatitle = "Photo Gallery - " . $admin_res['companyName'];
$page_metakey = "Photo Gallery - " . $admin_res['companyName'];
$page_metadesc = "Photo Gallery - " . $admin_res['companyName'];
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>


    <div class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/about/about-banner.webp)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Photo Gallery - <?= $admin_res['companyName']; ?> </h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="breadcrumbSection hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Photo Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="category_page">
        <div class="container">
            <h2 class="title_2">Photo Gallery</h2>
            <div class="maxWidth">
                <p>Experience craftsmanship at its finest! Our photo gallery showcases stunning custom patches, premium headwear, and intricate embroidery designs. See the precision, vibrant colors, and exceptional detail that set our work apart. Get inspired by our creations and envision how we can bring your designs to life with unmatched quality and expertise!</p>
            </div>
            <div class="row g-2 g-lg-3 row-cols-2 row-cols-md-3 row-cols-lg-4">
                <?php $gallery_tbl = mysqli_query($GLOBALS['dbconn'], "select * from gallery_tbl");
                while ($gallery_res = mysqli_fetch_assoc($gallery_tbl)) {
                    $galleryImg = getImage($gallery_res["gallery_image"], 500, 500, $gallery_res["gallery_title"] . $gallery_res["id"], "/uploaded-files/gallery/");
                    $galleryImg1 = getImage($gallery_res["gallery_image"], 1000, 1000, $gallery_res["gallery_title"] . $gallery_res["id"], "/uploaded-files/gallery/"); ?>
                    <div class="col">
                        <div class="gallery-bx wow fadeInUp">
                            <a href="<?= $galleryImg1; ?>" title="<?= $gallery_res['gallery_title']; ?>" data-fancybox="Gallery" class="img-bx">
                                <img loading="lazy" src="<?= $galleryImg; ?>" alt="<?= $gallery_res['gallery_title']; ?>" title="<?= $gallery_res['gallery_title']; ?>">
                            </a>
                            <span class="link-wrap">
                                <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-width="2" d="m21 21-3.5-3.5M17 10a7 7 0 1 1-14 0 7 7 0 0 1 14 0Z"></path>
                                </svg>
                            </span>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>