<?php 
include_once("include/main.inc.php"); 
$hover='blog';
$blog_query = mysqli_query($GLOBALS['dbconn'], "select * from blog_tbl order by en_date desc");
$page_metatitle="Blogs-".COMPANY_NAME;
$page_metakey="Blogs-".COMPANY_NAME;
$page_metadesc="Blogs-".COMPANY_NAME;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/blog-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Our Blogs</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Our Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <section class="news_section blog_page mt-1">
        <div class="container">
        <div class="title3">
                <h2 class="title-inner3">Our Blogs</h2>
                <div class="line"></div>
            </div>
            <div class="clearfix"></div>
            
            <div class="row">
            <?php
             while($blog_res = mysqli_fetch_assoc($blog_query)){
              
                $date = new DateTime($blog_res['blogDate']);
                $day = $date->format('d');
                $month = $date->format('M');
                $year = $date->format('Y'); ?>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 events-full-box">
                    <div class="events-single-box">
                        <div class="row">
                            <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5 col-sm-12 col-12">
                                <a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="<?php echo $blog_res['blogDname'];?>"><img class="img-responsive" src="<?= getImage($blog_res['catImage'], 250, 250, $blog_res['catName'], "/uploaded-files/blog/images/"); ?>" alt="<?php echo $blog_res['blogDname'];?>" title="<?php echo $blog_res['blogDname'];?>"></a>
                            </div>

                            <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7 col-sm-12 col-12">
                                <div class="event-info">
                                    <h4 class="title_h4"><a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="<?php echo $blog_res['blogDname'];?>"><?php echo $blog_res['blogDname'];?></a></h4>                                   
                              
                                    <p><?=html_entity_decode(substr($blog_res['catDesc'],0,150));?>...</p>


                                    <a class="event-btn" href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="Read More">Read More<i class="fa fa-long-arrow-right events-btn-icon"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
             
            </div>

        </div>
    </section>
    <?php // include "app_faq.php"; ?>
    <?php include "app_testimonials.php"; ?> 
    <?php include "app_clients.php"; ?>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>