<?php 
include_once("include/main.inc.php"); 
$hover='blogs';
$blog_query = mysqli_query($GLOBALS['dbconn'], "select catID,blog_written,blogDate,catImage,catName,blogDname,catDesc from blog_tbl Where status !='D' ORDER BY catID DESC");
$page_metatitle="Explore School Furniture Tips & Trends – Blogs by Trusto Brothers Enterprises (Uttar Pradesh) ";
$page_metakey="School Furniture Blog Uttar Pradesh, Play School Furniture Ideas UP, Educational Furniture Tips, Classroom Desk Trends UP, Kindergarten Furniture Blog, School Bench Design Uttar Pradesh, Trusto Brothers Enterprises Blog";
$page_metadesc="Read blogs by Trusto Brothers Enterprises on school and play school furniture trends in Uttar Pradesh. Get expert insights on classroom design, child-safe furniture, and more.";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
  
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <div class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/about-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Our Blogs - <?=$admin_res['companyName'];?></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="breadcrumbSection hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Our Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <div class="blog_page">
        <div class="container">
            <div class="blog_left">
                <h2 class="title_2">Our Blogs</h2>
                <div class="maxWidth">
                    <p>Discover insights, tips, and trends in educational furniture through our blogs. From classroom design ideas to child-safe materials, explore how the right furniture can transform learning spaces and boost student engagement.</p>
                </div>
                <div class="clearfix"></div>
               <div class="row g-4">
                <?php
while ($blog_res = mysqli_fetch_assoc($blog_query)) {
    if ($blog_res['catImage'] != '') {
        $blog_img =  getImage($blog_res['catImage'], 415, 275, $blog_res['catName'], "/uploaded-files/blog/images/");
    } else {
        $blog_img = NO_IMG_URL;
    }
    $blog_shortdesc = str_ireplace('{companyName}', $admin_res['companyName'], $blog_res['catDesc']);
?>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="singleBlog">
                        <div class="image-box">
                            <figure class="image">
                                <a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="<?= $blog_res['blogDname'];?>">
                                    <img src="<?= $blog_img; ?>" alt="<?= $blog_res['blogDname']; ?>" title="<?= $blog_res['blogDname']; ?>">
                                </a>
                            </figure>
                            <!-- <span class="date">
                                <strong>03</strong>
                                <span>Feb 2025</span>
                            </span> -->
                        </div>
                        <div class="blogInfo">
                            <div class="blogTitle"><a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="<?= $blog_res['blogDname'];?>"><?= $blog_res['blogDname'];?></a></div>
                            <a class="readBtn_1" href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="Full Article">Full Article <i class="icon fa fa-long-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <?php } ?>
                
                
            </div>
            </div>
        </div>
    </div>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>