<?php
$this->load->view("top");
$QryStringArr = array();  // To store all Query Variables so to move to other view;
$QryStringArr = array_unique($QryStringArr);
if (isset($this->meta_info['entity_id']) && $this->meta_info['entity_id'] != '') {
    $QryStringArr['category_id'] = $this->meta_info['entity_id'];
}
if ($catid) {
    $QryStringArr['category_id'] = $catid;
}
if ($this->input->post('category_id')) {
    $QryStringArr['category_id'] = $this->input->post('category_id');
}

if ($this->input->get_post('keywordSearch') != '') {
    $QryStringArr['keywordSearch'] = $this->input->get_post('keywordSearch');
}

if ($this->input->get_post('sort') != '') {
    $QryStringArr['sort'] = $this->input->get_post('sort');
}
if ($this->input->get_post('color') != '') {
    $QryStringArr['color'] = implode(',', $this->input->get_post('color'));
}
if ($this->input->get_post('size') != '') {
    $QryStringArr['size'] = implode(',', $this->input->get_post('size'));
}
if ($this->input->get_post('brand') != '') {
    $QryStringArr['brand'] = implode(',', $this->input->get_post('brand'));
}
if ($this->input->get_post('price') != '') {
    $priceArr = explode('-', $this->input->get_post('price'));
    $minPrice = $priceArr[0];
    $maxPrice = $priceArr[1];
    $QryStringArr['price'] = $this->input->get_post('price');
    $range = 'Range: ₹' . $priceArr[0] . ' - ₹' . $priceArr[1];
} else {
    $range = 'Range: ₹1 - ₹10';
    $minPrice = 100;
    $maxPrice = 10000;
}

$type = $this->uri->segment(1);
if ($type > 0) {
    if ($type == 1) {
        $QryStringArr['type'] = $type;
    }
    if ($type == 2) {
        $QryStringArr['type'] = $type;
    }
    if ($type == 3) {
        $QryStringArr['type'] = $type;
    }
    if ($type == 4) {
        $QryStringArr['type'] = $type;
    }
}

$cat_res2 = $this->db->query("SELECT * FROM wps_categories WHERE status = '1' and parent_id = '0' order by sort_order asc ")->result_array();

if (@$cat_res['category_icon'] != '') {
    $dimage =  get_image('category', $cat_res['category_icon'], '', '', 'R');
} else {
    $dimage =  theme_url() . 'images/listing_banner.jpg';
}

?>
<section class="banner_category" style="background-image: url('<?php echo $dimage; ?>');">
    <div class="container">
        <h1 class="banner_title"><?php echo $heading_title; ?></h1>
    </div>
</section>
<div class="page_breadcrumbs">
    <div class="container">
        <ul>
            <li><a href="<?php echo site_url(); ?>" title="Home">Home</a></li>
            <?php if ($this->input->post('keyword_search') == '') {
                if ($catid) {
                    echo category_breadcrumbs($catid);
                } else {
                    echo '<li>' . $heading_title . '</li>';
                }
            } else {
                echo '<li>Search Result</li>';
            }
            ?>
        </ul>
    </div>
</div>


<section class="product_listing">
    <div class="container">
        <?php if (is_array($products) && !empty($products)) { ?>
            <form name="searchForm" id="searchForm" method="post">
                <div class="row">
                <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="product_right">
                            <div class="row">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <div class="page_show">

                                        <ul>
                                            <li class="hidden-xs">Showing <?= count($products); ?> results</li>
                                            <li>
                                                <select name="sort" onchange="this.form.submit();">
                                                    <option value="1" <?php echo ($this->input->get_post('sort') == '1') ? 'selected' : ''; ?>>Recommended</option>
                                                    <option value="2" <?php echo ($this->input->get_post('sort') == '2') ? 'selected' : ''; ?>>What's New</option>
                                                    <option value="3" <?php echo ($this->input->get_post('sort') == '3') ? 'selected' : ''; ?>>Price: High to Low</option>
                                                    <option value="4" <?php echo ($this->input->get_post('sort') == '4') ? 'selected' : ''; ?>>Price: Low to High</option>
                                                    <option value="5" <?php echo ($this->input->get_post('sort') == '5') ? 'selected' : ''; ?>>Popularity</option>
                                                </select>
                                            </li>
                                            <li><span>Sort:</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <?php foreach ($products as $key => $val) {
                                    $productImage = get_db_field_value("wps_products_media", "media", "WHERE products_id = '" . $val['products_id'] . "' and is_default='Y'");
                                    //echo $productImage;
                                ?>

                                    <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6 col-xs-6">
                                        <div class="box_item box_item_4">
<!--
                                            <?php if ($this->session->userdata('user_id') > 0) { ?>
                                                <a href="<?php echo site_url('cart/add_to_wishlist/' . $val['products_id']); ?>" class="wishlist_icon" title="Wishlist"><i class="fa fa-heart-o"></i></a>
                                            <?php } else { ?>
                                                <a href="javascript:void();" onclick="alert('Please login to add the product in your wishlist!');" class="wishlist_icon" title="Wishlist"><i class="fa fa-heart-o"></i></a>
                                            <?php } ?>
-->

                                            <div class="item_images">
                                                <a href="<?= base_url($val['friendly_url']); ?>" title="<?php echo imagealtTitle('', ucwords(strtolower($val['product_name'])), ''); ?>">
                                                    <img src="<?php echo get_image('products', $val['media'], 270, 270, 'AR'); ?>" alt="<?php echo imagealtTitle('', ucwords(strtolower($val['product_name'])), ''); ?>" title="<?php echo imagealtTitle('', ucwords(strtolower($val['product_name'])), ''); ?>">
                                                </a>
                                            </div>
                                            <!-- <div class="hover_box">
                                               
                                            </div> -->
                                            <div class="description02 description04">
                                                <h3><a href="<?= base_url($val['friendly_url']); ?>" title="<?php echo imagealtTitle('', ucwords(strtolower($val['product_name'])), ''); ?>">
                                                <?php echo char_limiter($val['product_name'], 24); ?></a></h3>
                                                <?php if ($val['product_discounted_price'] > 0) { ?>

                                                    <div class="price">
                                                        <span class="old_price"><?= display_price($val['product_price']); ?></span>
                                                        <?= display_price($val['product_discounted_price']); ?>
                                                    </div>


                                                <?php } else { ?>
                                                    <div class="price"><?= display_price($val['product_price']); ?></div>
                                                <?php } ?>
                 
                                                <a href="<?= base_url($val['friendly_url']); ?>" title="View Details" class="hmViewMore-btn default-btn">View Details</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    </div>


                </div>
            </form>

        <?php } else { ?>
            <div class="text-center mt10">
                <h2 class="contact-title">Sorry, No Result Found!</h2>
                <img src="<?php echo theme_url(); ?>images/noresult.gif" width="350" title="No Result Found" alt="No Result Found" />
                <br /><br />
                <button type="button" class="checkout_btn" onclick="window.location.href='<?php echo site_url('products'); ?>'">Browse Products</button>
            </div>
        <?php } ?>
        <div class="text_desc bottom_div">
            <?php if (isset($cat_res['category_description'])) {
                echo '<div class="col-md-12"><br/>' . $cat_res['category_description'] . '</div>';
            } ?>
        </div>


    </div>
</section>


<script>
    var page = 1;
    var triggeredPaging = 0;
    $(window).scroll(function() {
        $('#loadingdiv').hide();
        var scrollTop = $(window).scrollTop();
        var scrollBottom = (scrollTop + $(window).height());
        var containerTop = $('#prodListingContainer').offset().top;
        var containerHeight = $('#prodListingContainer').height();
        var containerBottom = Math.floor(containerTop + containerHeight);
        var scrollBuffer = 0;
        if ((containerBottom - scrollBuffer) <= scrollBottom) {
            page = $('.listpager').length;

            var queryString = '?stOffSet=' + page;
            <?php
            if (count($QryStringArr)) {
                foreach ($QryStringArr as $qrykey => $qryval) {
            ?>
                    queryString += "&<?php echo $qrykey; ?>=<?php echo $qryval; ?>";
            <?php
                }
            }
            ?>
            var actual_count = <?php echo $total_list_rows; ?>;

            if (!triggeredPaging && page < actual_count) {
                triggeredPaging = 1;
                //alert(queryString);exit();
                $.ajax({
                    type: "POST",
                    url: "<?php echo base_url(); ?>products/ajax_load_product_view" + queryString,
                    error: function(res) {
                        //alert('Error');
                        triggeredPaging = 0;
                        $('#loadingdiv').hide();
                        //console.log(arguments);
                    },
                    beforeSend: function(jqXHR, settings) {
                        $('#loadingdiv').show();

                    },
                    success: function(res) {
                        $('#loadingdiv').hide();
                        $("#prodListingContainer").append(res);
                        triggeredPaging = 0;
                        console.log(res);
                        // $('.listpager').fadeTo(1000, 0.5, function () {
                        //   $(this).fadeTo(1000, 1.0);
                        // });
                        $('.listpager11').fadeTo(1000, 0.5, function() {
                            $(this).fadeTo(1000, 1.0);
                        });
                    }
                });
            }
        }
    });
</script>
<?php $this->load->view("bottom"); ?>
</html>