<?php
$this->load->view('top');
$adminRes = get_site_email();
?>
<section class="banner_category" style="background-image: url('<?php echo theme_url(); ?>images/listing-banner.jpg');">
    <div class="container">

        <h1 class="banner_title">Need help</h1></h1>
    </div>
</section>
<div class="page_breadcrumbs">
    <div class="container">
        <ul>
            <li><a href="<?= site_url(); ?>" title="Home">Home</a>
            </li>
            <li>Need help</li>
        </ul>
    </div>
</div>

<div class="contact-page-section">
    <div class="container">
        <div class="rs-quick-contact">
            <div class="inner-part text-center mb-50">
                <h2 class="title mb-15">Need help Form</h2>

            </div>
            <div id="form-messages"></div>

            <?php if ($this->session->flashdata('success')) echo '
          <div class="alert alert-success success" style="padding: 8px 8px 8px 40px;">' . $this->session->flashdata('success') . '</div>
          <br/>'; ?>
            <?php if ($this->session->flashdata('error')) echo '
          <div class="alert alert-warning error" style="padding: 8px 8px 8px 40px;">' . $this->session->flashdata('error') . '</div>
          <br/>'; ?>
            <form action="" id="contact-form" name="contactform" method="post" class="contact-form row g-3 needs-validation md-mb-50" novalidate>

                <script src="https://www.google.com/recaptcha/api.js" async="" defer=""></script>
                <div class="col-md-6">
                    <label for="validationCustom01" class="form-label">Name</label>
                    <input type="text" name="first_name"  pattern="[a-z A-Z]+" value="<?php echo set_value('first_name'); ?>" class="form-control" id="validationCustom01" required>
                      <?php echo form_error('first_name'); ?>
                    <div class="valid-feedback">
                        Looks good!
                    </div>
                    <div class="invalid-feedback">
                        Please provide a valid Name
                    </div>
                </div>
                <div class="col-md-6">
                    <label for="validationCustom02" class="form-label">Mobile No.</label>
                    <input type="text" class="form-control" id="validationCustom02" name="phone"  value="<?php echo set_value('phone'); ?>" maxlength="10" minlength="10" onKeyPress="return isNumberKey(event)" required>
                    <?php echo form_error('phone'); ?>
                    <div class="valid-feedback">
                        Looks good!
                    </div>
                    <div class="invalid-feedback">
                        Please provide a valid Mobile No.
                    </div>
                </div>
                <div class="col-md-6">
                    <label for="validationCustomUsername" class="form-label">E-mail ID</label>
                    <div class="input-group has-validation">

                        <input type="text" name="email" class="form-control" id="validationCustomUsername" aria-describedby="inputGroupPrepend" value="<?php echo set_value('email'); ?>" required>
                        <?php echo form_error('email'); ?>
                        <div class="invalid-feedback">
                            Please provide a valid E-mail ID.
                        </div>
                        <div class="valid-feedback">
                            Looks good!
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <label for="validationCustom03" class="form-label">Location</label>
                    <input type="text" name="location" class="form-control" id="validationCustom03" value="<?php echo set_value('location'); ?>" required>
                   <?php echo form_error('location'); ?>
                    <div class="invalid-feedback">
                        Please provide a valid Location.
                    </div>
                    <div class="valid-feedback">
                        Looks good!
                    </div>
                </div>

                <div class="col-md-12">
                    <label for="validationCustom05" class="form-label">Message</label>
                    <textarea name="message" class="form-control" id="validationCustom05" onKeyPress="return isAlphaNumeric(event)" ondrop="return false;" onpaste="return false;" onkeyup="isURL(this);" required></textarea>
                    <div class="invalid-feedback">
                        Please provide a valid Message
                    </div>
                    <div class="valid-feedback">
                        Looks good!
                    </div>
                </div>
                <div class="g-recaptcha" data-sitekey="<?php echo CAPTCHA_SITEKEY; ?>" style="transform:scale(0.80);-webkit-transform:scale(0.70);transform-origin:0 0;-webkit-transform-origin:0 0;outline:0"></div>
                                <?php echo form_error('g-recaptcha-response'); ?>

                <div class="col-12">
                    <input class="btn-send btn btn-primary btn-lg" type="submit" value="Submit Now">

                </div>
            </form>

        </div> 

        <div class="row mb-90 md-mb-50">

            <div class="col-lg-7 col-md-12 md-mb-30">
                <div class="rs-contact-wrap">
                    <div class="inner-part">
                        <h2 class="title2">Enquiry</h2>                                   
                    </div>
                       <div class="address-item">
                        <div class="address-icon">
                            <i class="fa fa-map-marker"></i>
                        </div>
                        <div class="address-text">
                            <span class="label"> Address</span>
                            <span class="des"><?php echo $adminRes->address; ?></span>
                        </div>
                    </div>
                    <div class="address-item">
                        <div class="address-icon">
                            <i class="fa fa-envelope-o"></i>
                        </div>
                        <div class="address-text">
                            <span class="label">Email Address</span>
                            <span class="des">support@toyzoo.co.in</span>
                        </div>
                    </div> 
                    <?php if($adminRes->phone!=''){ ?>
                    <div class="address-item">
                        <div class="address-icon">
                            <i class="fa fa-headphones"></i>
                        </div>
                        <div class="address-text">
                            <span class="label">Phone Number</span>
                            <span class="des"><a href="tel:<?php echo $adminRes->phone;?>"><?php echo $adminRes->phone;?></a></span>
                        </div>
                    </div> 
                    <?php } ?>
                   
                </div> 
            </div> 
            <div class="col-lg-5 col-md-12">
               <!-- <div class="rs-contact-wrap">
                    <div class="inner-part ">
                        <h2 class="title2">Emergency</h2>                                   
                    </div>
                    <div class="address-item">
                        <div class="address-icon">
                            <i class="fa fa-envelope-o"></i>
                        </div>
                        <div class="address-text">
                            <span class="label">Email Address</span>
                            <span class="des">support@toyzoo.co.in</span>
                        </div>
                    </div> 
                    <div class="address-item">
                        <div class="address-icon">
                            <i class="fa fa-headphones"></i>
                        </div>
                        <div class="address-text">
                            <span class="label">Phone Number 1</span>
                            <span class="des"><a href="tel:9717813544">+91-9717813544</a></span>
                        </div>
                    </div> 
                    <div class="address-item">
                        <div class="address-icon">
                            <i class="fa fa-headphones"></i>
                        </div>
                        <div class="address-text">
                            <span class="label">Phone Number 2</span>
                            <span class="des"><a href="tel:9717813544">+91-9717813544</a></span>
                        </div>
                    </div>
                </div> -->
                
                <img src="<?php echo theme_url();?>images/contact-women.png" title="contact us" class="w100" />
            </div>
        </div>

    </div>
</div>



<!-- <iframe class="iframe_map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3501.0158162492457!2d77.14875131440786!3d28.659245089623695!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390d02f114c49e7f%3A0x11551dbc1a6316e9!2sWebpulse%20Solution%20Pvt%20Ltd%20-%20Rated%20%231%20Web%20Designing%2C%20SEO%20Company%20India!5e0!3m2!1sen!2sin!4v1574332011528!5m2!1sen!2sin" allowfullscreen=""></iframe> -->
<script>
  // Example starter JavaScript for disabling form submissions if there are invalid fields
(function () {
  'use strict'

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  var forms = document.querySelectorAll('.needs-validation')

  // Loop over them and prevent submission
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }

        form.classList.add('was-validated')
      }, false)
    })
})()
</script>
<?php $this->load->view('bottom'); ?>
  