<?php 

include_once("include/main.inc.php"); 

$hover='blog';

$blog_query = mysqli_query($GLOBALS['dbconn'], "select * from blog_tbl ORDER BY catID DESC");

$page_metatitle = "Blogs - ".COMPANY_NAME;

$page_metakey = "Blogs - ".COMPANY_NAME;

$page_metadesc = "Blogs - ".COMPANY_NAME;

?>

<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title><?=$page_metatitle;?></title>

    <meta name="description" content="<?=$page_metadesc;?>">

    <meta name="keywords" content="<?=$page_metakey;?>">

    <?php include "app_top.php"; ?>

</head>



<body>



    <?php include "app_header.php"; ?>



    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/blog-banner.jpg)">

        <div class="container">

            <div class="row">

                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">

                    <h1 class="cat_title">Our Blogs - <?=COMPANY_NAME;?></h1>

                    <div class="clearfix"></div>

                </div>

            </div>

        </div>

    </section>



    <div class="inner_breadcrumb hidden_xs">

        <div class="container">

            <div class="row">

                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                    <ul class="breadcrumb">

                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>

                        <li class="active">Our Blogs</li>

                    </ul>

                </div>

            </div>

        </div>

    </div>





    <section class="blog_page">

        <div class="container">

            <h2 class="title_1">Our Blogs</h2> 
            <div class="clearfix"></div>

            <div class="row">

            <?php while ($blog_res = mysqli_fetch_array($blog_query)) {

                   $blog_res['blogDate'];

                   $date = new DateTime($blog_res['blogDate']);

                   $day = $date->format('d');

                   $month = $date->format('M');

                   $Year = $date->format('Y'); ?>

                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 wow zoomIn" data-wow-delay=".2s">

                    <article class="post clearfix">

                        

                        <div class="featured-post">

                            <img src="<?= getImage($blog_res['catImage'], 400, 400, $blog_res['catName'], "/uploaded-files/blog/images/"); ?>" alt="<?php echo $blog_res['blogDname'];?>" title="<?php echo $blog_res['blogDname'];?>">

                         

                        </div>

                        <div class="content-post">

                            <h3 class="title-post"><a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="<?php echo $blog_res['blogDname'];?>"><?php echo $blog_res['blogDname'];?></a></h3>



                            <div class="entry-post">

                                <p><?=html_entity_decode(substr($blog_res['shortdesc'],0,120));?>...</p>

                                <a class="read_more" href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="Read More"><span>Read More</span> </a>

                            </div>

                        </div>

                    </article>

                </div>

                <?php } ?>



               

            </div>

        </div>



        </div>

        </div>

    </section>



    <!-- <?php include "app_testimonials.php"; ?>

    <?php include "app_clients.php"; ?>

    <?php include "app_faq.php"; ?> -->



    <?php include "app_footer.php"; ?>

    <?php include "app_bottom.php"; ?>

</body>



</html>