<?php

function paytmForm($order_res) {

  header("Pragma: no-cache");
  header("Cache-Control: no-cache");
  header("Expires: 0");

  $checkSum = "";
  $paramList = array();

  $ORDER_ID = $order_res['order_id'];  
  $CUST_ID = $order_res['customers_id'];
  $INDUSTRY_TYPE_ID = 'Retail';
  $CHANNEL_ID = 'WEB';
  $TXN_AMOUNT = $order_res['total_amount']-$order_res['coupon_discount_amount']+$order_res['vat_amount'];

// Create an array having all required parameters for creating checksum.
  $paramList["MID"] = PAYTM_MERCHANT_MID;
  $paramList["ORDER_ID"] = $ORDER_ID;
  $paramList["CUST_ID"] = $CUST_ID;
  // $paramList["CUST_ID"] = 2;
  $paramList["INDUSTRY_TYPE_ID"] = $INDUSTRY_TYPE_ID;
  $paramList["CHANNEL_ID"] = $CHANNEL_ID;
  $paramList["TXN_AMOUNT"] = round($TXN_AMOUNT);
  $paramList["WEBSITE"] = PAYTM_MERCHANT_WEBSITE;
  $paramList['CALLBACK_URL'] = site_url() . 'payment/order_success/'.$ORDER_ID;
//Here checksum string will return by getChecksumFromArray() function.
  $checkSum = getChecksumFromArray($paramList, PAYTM_MERCHANT_KEY);
  ?>
  <html>
    <head>
      <title>Merchant Check Out Page</title>
    </head>
    <body>
    <center><h1>Please do not refresh this page...</h1></center>
    <form method="post" action="<?php echo PAYTM_TXN_URL ?>" name="f1">
      <table border="1">
        <tbody>
          <?php
          foreach ($paramList as $name => $value) {
            echo '<input type="hidden" name="' . $name . '" value="' . $value . '">';
          }
          ?>
        <input type="hidden" name="CHECKSUMHASH" value="<?php echo $checkSum ?>">
        </tbody>
      </table>
      <script type="text/javascript">
        document.f1.submit();
      </script>
    </form>
  </body>
  </html>
  <?php
}
?>



