


(function ($) {
    // Sticky Header
    $(window).on('scroll', function () {
        $('.menubar').toggleClass('stricky-fixed', $(this).scrollTop() > 100);
        // $('#web-pulse-scroll-up').fadeToggle($(this).scrollTop() > 100);
    });

    // Mobile Navigation
    if ($(".navigation").length) {
        $(".navigation .navbar button").on("click", function () {
            $(".navigation .menu").slideToggle();
            $(this).toggleClass('open');
            return false;
        });

        $(".navigation .cs-submenu > a").append(
            '<button class="dropdown-expander" title="dropdown"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z"/></svg></button>'
        );

        if ($(window).width() < 1023) {
            $(".navigation .menu").on("click", ".dropdown-expander", function () {
                $(this).closest("li").children(".cs-dropdown").slideToggle();
                $(this).toggleClass("rotated");
                return false;
            });

            $(document).on("click", function (e) {
                if (!$(e.target).closest('.navigation .navbar button').length) {
                    $('.navigation .menu').slideUp();
                    $(".navigation .navbar button").removeClass('open');
                }
            });
        }
    }

    // Common SVG arrows
    const navSVG = [
        '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg>',
        '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg>'
    ];

    // Owl helper
    const initOwl = (sel, opt) => $(sel).owlCarousel($.extend({
        loop: true, margin: 0, navSpeed: 500,
        navText: navSVG, responsiveClass: true
    }, opt));

    // Sliders
    initOwl("#slider", { nav: true, autoplay: true, dots: false, animateOut: "fadeOut", items: 1, responsive: {0:{nav:false},600:{nav:false}} });
    initOwl("#featuredProducts", { margin: 20, nav: true, items: 3, dots: false, responsive: {0:{items:1},600:{items:1},1024:{items:3}} });
    initOwl("#testimonials", { margin: 15, autoplay: true, dots: true, items: 2, responsive: {0:{items:1},600:{items:1},1024:{items:2}} });
    initOwl("#clients", { margin: 15, autoplay: true, dots: true, items: 5, responsive: {0:{items:2},600:{items:2},1024:{items:5}} });

    // Scroll Top
//    $('#web-pulse-scroll-up').on('click', () => $("html, body").animate({scrollTop: 0}, 600));

    // Gallery thumbs
    $('#thumbs img').on('click', function () {
        $('#largeImage').attr('src', $(this).attr('src').replace('thumb', 'large'));
        $("#thumbs img").removeClass("active");
        $(this).addClass("active");
    });

    // WOW init
    //new WOW({ animateClass: 'animated', offset: 100, mobile: false }).init();

})(jQuery);



