<?php 
include_once("include/main.inc.php");
$hover = 'photo gallery';
$page_metatitle = "Photo Gallery | Skylight Glass Manufacturers in Lahore, Pakistan - Syed Engineering";

$page_metakey = "Skylight Glass, Skylight Glass Manufacturers, Skylight Glass Manufacturers in Lahore, Skylight Glass Manufacturers in Pakistan";

$page_metadesc = "Syed Engineering leading Skylight Glass Manufacturers in Lahore, Pakistan, Since 2016. Committed to quality, trust, and excellence across every step of your journey with us. Get latest factory price for Skylight Glass. ✓Fast Delivery ✓Good Price";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
 
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>


    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/gallery-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Photo Gallery - <?=$admin_res['companyName'];?></h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Photo Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <?php
$limit = 12;
?>
<div class="gallery_page">
    <div class="container">
        <h2 class="title_2">A Closer Look at Our Work
</h2>
     <div class="clearfix"></div>
          <p class="w-75 mx-auto text-center pt-0 d-flow-root">
Our photo gallery showcases the quality, precision, and creativity that define every project we deliver. From innovative structures to robust engineering solutions, these images reflect our commitment to excellence and attention to detail. Browse through to see how we transform ideas into reality with expertise and dedication.
            </p>
        <div class="clearfix"></div>
        <div class="row g-3 row-cols-1 row-cols-md-2 row-cols-lg-3" id="gallery-container">
            <?php 
            $certificate_sql= mysqli_query($GLOBALS['dbconn'], "SELECT * FROM gallery_tbl ORDER BY id DESC LIMIT $limit");
            while($catlog_stand= mysqli_fetch_assoc($certificate_sql)) { ?>
                <div class="col">
                    <div class="gallery-bx">
                        <a data-fancybox="" href="<?=site_url;?>/uploaded-files/gallery/<?=$catlog_stand['gallery_image'];?>" title="<?= $catlog_stand['gallery_title']; ?>" class="img">
                            <img src="<?=site_url;?>/uploaded-files/gallery/<?=$catlog_stand['gallery_image'];?>" alt="<?= $catlog_stand['gallery_title']; ?>" title="<?= $catlog_stand['gallery_title']; ?>">
                        </a>
                        <div class="tx-bx">
                            <div class="tt"><?= $catlog_stand['gallery_title']; ?></div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

        <div class="text-center mt-4">
            <button class="btn btn-primary" id="loadMore">View More</button>
            <button class="btn btn-secondary d-none" id="viewLess">View Less</button>
        </div>
    </div>
</div>

<script>
let offset = 12;
let perPage = 12;

document.getElementById("loadMore").addEventListener("click", function () {
    fetch("load-more-gallery.php?offset=" + offset)
        .then(response => response.text())
        .then(data => {
            document.getElementById("gallery-container").insertAdjacentHTML("beforeend", data);
            offset += perPage;

            // Show View Less Button
            document.getElementById("viewLess").classList.remove("d-none");
        });
});

document.getElementById("viewLess").addEventListener("click", function () {
    fetch("load-more-gallery.php?offset=0&limit=" + perPage)
        .then(response => response.text())
        .then(data => {
            document.getElementById("gallery-container").innerHTML = data;
            offset = perPage;

            // Hide View Less button
            document.getElementById("viewLess").classList.add("d-none");
        });
});
</script>


    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>