<?php
include_once("../include/main.inc.php");
check_session('MyCpanel', 'index.php');
$title = "Admin Login Panel";
admin_header();
$cat_count = get_category_count();
$enquiry_count = get_enquiry_count();
$location_count = get_location_count();
$coupan_count = get_coupan_count();
$blog_count = get_blog_count();
$order_count = get_order_count();
?>
<div class="content-wrapper">
  <div class="page-header">
    <h3 class="page-title">
      <span><?=ucfirst($_SESSION['companyName']); ?></span> Admin Panel
    </h3>
  </div>
  <div class="row grid-margin">
    <div class="col-12">
      <div class="card card-statistics">
        <div class="card-body">
          <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
            <div class="statistics-item">
              <p>
                Manage Category
              </p>
              <h2><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-card-list" viewBox="0 0 16 16">
                  <path d="M14.5 3a.5.5 0 0 1 .5.5v9a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5h13zm-13-1A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5v-9A1.5 1.5 0 0 0 14.5 2h-13z" />
                  <path d="M5 8a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 5 8zm0-2.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm0 5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-1-5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0zM4 8a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0zm0 2.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0z" />
                </svg> <?= $cat_count ?></h2>
            </div>
            <div class="statistics-item">
              <p> Manage Location
              </p>
              <h2> <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pin-map" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M3.1 11.2a.5.5 0 0 1 .4-.2H6a.5.5 0 0 1 0 1H3.75L1.5 15h13l-2.25-3H10a.5.5 0 0 1 0-1h2.5a.5.5 0 0 1 .4.2l3 4a.5.5 0 0 1-.4.8H.5a.5.5 0 0 1-.4-.8l3-4z" />
                  <path fill-rule="evenodd" d="M8 1a3 3 0 1 0 0 6 3 3 0 0 0 0-6zM4 4a4 4 0 1 1 4.5 3.969V13.5a.5.5 0 0 1-1 0V7.97A4 4 0 0 1 4 3.999z" />
                </svg> <?= $location_count ?></h2>
            </div>
            <div class="statistics-item">
              <p>
                Manage Enquiry
              </p>
              <h2><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-card-checklist" viewBox="0 0 16 16">
                  <path d="M14.5 3a.5.5 0 0 1 .5.5v9a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5h13zm-13-1A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5v-9A1.5 1.5 0 0 0 14.5 2h-13z" />
                  <path d="M7 5.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5zm-1.496-.854a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 1 1 .708-.708l.146.147 1.146-1.147a.5.5 0 0 1 .708 0zM7 9.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5zm-1.496-.854a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 0 1 .708-.708l.146.147 1.146-1.147a.5.5 0 0 1 .708 0z" />
                </svg> <?= $enquiry_count ?></h2>
            </div>
            <div class="statistics-item">
              <p>
                Manage Coupon
              </p>
              <h2><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmark-check" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                  <path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.777.416L8 13.101l-5.223 2.815A.5.5 0 0 1 2 15.5V2zm2-1a1 1 0 0 0-1 1v12.566l4.723-2.482a.5.5 0 0 1 .554 0L13 14.566V2a1 1 0 0 0-1-1H4z" />
                </svg> <?= $coupan_count ?></h2>
            </div>
            <div class="statistics-item">
              <p>
                Manage Orders
              </p>
              <h2><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-basket" viewBox="0 0 16 16">
                  <path d="M5.757 1.071a.5.5 0 0 1 .172.686L3.383 6h9.234L10.07 1.757a.5.5 0 1 1 .858-.514L13.783 6H15a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1v4.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 13.5V9a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h1.217L5.07 1.243a.5.5 0 0 1 .686-.172zM2 9v4.5A1.5 1.5 0 0 0 3.5 15h9a1.5 1.5 0 0 0 1.5-1.5V9H2zM1 7v1h14V7H1zm3 3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 4 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 6 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 8 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 1 .5-.5zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 1 .5-.5z" />
                </svg> <?= $order_count ?></h2>
            </div>
            <div class="statistics-item">
              <p>
                Manage Blog
              </p>
              <h2><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chat-left-text" viewBox="0 0 16 16">
                  <path d="M14 1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H4.414A2 2 0 0 0 3 11.586l-2 2V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12.793a.5.5 0 0 0 .854.353l2.853-2.853A1 1 0 0 1 4.414 12H14a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z" />
                  <path d="M3 3.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zM3 6a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9A.5.5 0 0 1 3 6zm0 2.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z" />
                </svg> <?= $blog_count ?></h2>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    
   
 <?php 
      $today = date('Y-m-d');
      $query = mysqli_query($dbconn,"SELECT * FROM tbl_enquiry order by en_id desc limit 5");
      if(mysqli_num_rows($query) > 0){$i=1;?>

    <div class="col-md-12 grid-margin stretch-card">
      <div class="card">
        <div class="card-body">
          <h4 class="card-title">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-calendar-check" viewBox="0 0 16 16">
              <path d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
              <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
            </svg>
            Enquiry Data
          </h4>
          <div class="table-responsive">
            <table id="order-listing" class="table table-bordered table-hover">
            <thead>
                <tr>
                  <th>S.No.</th>
                  <th>Enquiry Details</th>
                  <th>Sender Details</th>
                  <th>Actions</th>
                </tr>  
              </thead>
              <tbody>
                <?php while($enquiry = mysqli_fetch_array($query)){
                    if($enquiry['en_zcode']!=''){  
                      $mobileNumbers= '+'.$enquiry[en_zcode].' - '.$enquiry[en_mobile];
                     }else{ 
                      $mobileNumbers=$enquiry['en_mobile'];
                     }
                  ?>
                  <tr>
                    <td><?= $i++ ?></td>
                    <td>
                      Name: <b><?=$enquiry['en_name'];?></b> <br /> 
                      <?php if($enquiry['en_email']!=''){ ?>      
                      Email: <b><?=$enquiry['en_email'];?></b>  <br />
                      <?php } ?>
                      Mobile: <b><?=$mobileNumbers;?></b>  <br />
                      <?php if($enquiry['en_country_name']!=''){ ?>      
                      Country: <b><?=$enquiry['en_country_name'];?></b><br /> 
                        <?php } ?>
                        <?php if ($enquiry['en_country'] != '') { ?>
                          Location: <b><?=$enquiry['en_country']; ?></b> <br />
                          <?php } ?>
                    </td>
                    <td>
                      Sender Ip Address: <b><?=$enquiry['en_ip'];?></b>  <br />   
                      Message: <b><?=$enquiry['en_comment'];?></b>  <br /> 
                      URl: <b><?=$enquiry['en_url'];?></b>  
                    </td>
                    <td>
                      <?php if ($enquiry['en_mobile'] != ''){?>
                          <a href="tel:<?= $enquiry['en_mobile'] ?>" title="Call Now"><i class="fa fa-phone call-to-action"></i></a>&nbsp;
<!--                          <a href="https://wa.me/91<?= $enquiry['en_mobile'] ?>" title="Whatsapp"><i class="fa fa-whatsapp call-to-action"></i></a>-->
                      <?php } ?>
                       <?php if ($enquiry['en_email'] != ''){?>
                          <a href="mailto:<?= $enquiry['en_email'] ?>" title="Mail Now"><i class="fa fa-envelope-o call-to-action"></i></a>&nbsp;
                      <?php } ?>
                    </td>
                </tr> 
                <?php }?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
<?php } ?>
  </div>

</div>
<!-- content-wrapper ends -->

<?php
admin_footer();
                       
?>