<?php 
include_once("include/main.inc.php"); 
$hover='blog';
$blog_query = mysqli_query($GLOBALS['dbconn'], "select * from blog_tbl ORDER BY catID DESC");
$page_metatitle="Blogs- ".COMPANY_NAME;
$page_metakey="Blogs- ".COMPANY_NAME;
$page_metadesc="Blogs- ".COMPANY_NAME;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/blog-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Our Blog <?=COMPANY_NAME;?></h1>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Our Blog</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <section class="blog_page">
        <div class="container">
            <h2 class="title_2">Our Blog</h2>
            <div class="clearfix"></div>
            <div class="row">
                <?php
             while($blog_res = mysqli_fetch_assoc($blog_query)){
              
                $date = new DateTime($blog_res['blogDate']);
                $day = $date->format('d');
                $month = $date->format('M');
                $year = $date->format('Y'); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-12 col-12">
                    <div class="blogBox">
                        <a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm"
                            title="<?php echo $blog_res['blogDname'];?>">
                            <div class="image">
                                <img src="<?= getImage($blog_res['catImage'], 361, 361, $blog_res['catName'], "/uploaded-files/blog/images/"); ?>"
                                    alt="<?php echo $blog_res['blogDname'];?>"
                                    title="<?php echo $blog_res['blogDname'];?>">
                            </div>
                        </a>
                        <div class="blogDescribe">
                            <!--<abbr class="blogDate"><?=$day;?> <?=$month;?>, <?=$year;?></abbr>-->
                            <h3><a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm"
                                    title="<?php echo $blog_res['blogDname'];?>"><?php echo $blog_res['blogDname'];?></a>
                            </h3>
                            <a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm"
                                title="Read More" class="readMore">Read More <svg xmlns="http://www.w3.org/2000/svg"
                                    width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                    </path>
                                </svg></a>
                        </div>
                    </div>
                </div>
                <?php } ?>





            </div>

        </div>
    
    </section>

    <?php include "app_faq.php"; ?>
    <?php include "app_clients.php"; ?>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>