<?php
include_once("include/main.inc.php");
$page_metatitle = "Diet Chart For Kidney Patients - ".COMPANY_NAME;
$page_metakey = "Diet Chart For Kidney Patients - ".COMPANY_NAME;
$page_metadesc = "Diet Chart For Kidney Patients - ".COMPANY_NAME;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>


<body>
    <?php include "app_header.php"; ?>
    <div class="bread-cum-sec">
        <img src="<?=site_url;?>/designer/images/kidney-chart-banner.jpg" alt="Diet Chart For Kidney Patients" title="Diet Chart For Kidney Patients" class="w-100">
    </div>
    <div class="diet-chart">
        <div class="container">
            <div class="text-box">
                <div class="ttitle">Diet Chart For Kidney Patients !</div>
                <p>When your kidneys are not working as well as they should, waste and fluid build up in your body. Over time, the waste and extra fluid can cause heart, bone and other health problems. A kidney-friendly meal plan limits how much of certain minerals and fluid you eat and drink. This can help keep the waste and fluid from building up and causing problems.</p>
                <p>How strict your meal plan should be depends on your stage of kidney disease. In the early stages of kidney disease, you may have little or no limits on what you eat and drink. As your kidney disease gets worse, your doctor may recommend that you limit:</p>
                <ul>
                    <li>Potassium</li>
                    <li>Phosphorus</li>
                    <li>Fluids</li>
                </ul>
                <p>It is commonly recommended that all people with kidney disease restrict the following nutrients:</p>
                <p><strong>Sodium:</strong> It is found in many foods and a major component of table salt. Damaged kidneys can’t filter out excess sodium, causing its blood levels to rise. It’s often recommended to limit sodium to less than 2,000 mg per day.</p>
                <p><strong>Potassium:</strong> Plays many critical roles in the body, but those with kidney disease need to limit potassium to avoid dangerously high blood levels. It’s usually recommended to limit potassium to less than 2,000 mg per day.</p>
                <p><strong>Phosphorus:</strong> Damaged kidneys can’t remove excess phosphorus, a mineral in many foods. High levels can cause damage to the body, so dietary phosphorus is restricted to less than 800–1,000 mg per day in most patients.</p>
                <div class="mtitle">Sodium:</div>
                <p>Sodium (salt) is a mineral found in almost all foods. Too much sodium can make you thirsty, which can lead to swelling and raise your blood pressure. This can damage your kidneys more and make your heart work harder.</p>
                <p>One of the best things that you can do to stay healthy is to limit how much sodium you eat. To limit sodium in your meal plan:</p>
                <p>Do not add salt to your food when cooking or eating. Try cooking with fresh herbs, lemon juice or other salt-free spices.</p>
                <p>Choose fresh or frozen vegetables instead of canned vegetables. If you do use canned vegetables, drain and rinse them to remove extra salt before cooking or eating them.</p>
                <p>Avoid processed meats like ham, bacon, sausage and lunch meats.</p>
                <p>Munch on fresh fruits and vegetables rather than crackers or other salty snacks.</p>
                <p>Avoid canned soups and frozen dinners that are high in sodium. Avoid pickled foods, like olives and pickles. Limit high-sodium condiments like soy sauce, BBQ sauce and ketchup.</p>
                <p>Important! Be careful with salt substitutes and “reduced sodium” foods. Many salt substitutes are high in potassium. Too much potassium can be dangerous if you have kidney disease. Work with your dietitian to find foods that are low in sodium and potassium.</p>
                <div class="mtitle">Portions:</div>
                <p>Choosing healthy foods is a great start, but eating too much of anything, even healthy foods, can be a problem. The other part of a healthy diet is portion control, or watching how much you eat.</p>
                <p>To help control your portions:</p>
                <p>Check the nutrition facts label on a food to learn the serving size and how much of each nutrient is in one serving. Many packages have more than one serving. For example, a 20-ounce bottle of soda is really two-and-a-half servings. Many fresh foods, such as fruits and vegetables, do not come with nutrition facts labels. Ask your dietitian for a list of nutrition facts for fresh foods and tips for how to measure the right portions.</p>
                <p>Eat slowly, and stop eating when you are not hungry any more. It takes about 20 minutes for your stomach to tell your brain that you are full. If you eat too quickly, you may eat more than you need.</p>
                <p>Do not eat directly from the package the food came in. Instead, take out one serving of food and put the bag or box away.</p>
                <div class="mtitle">Potassium</div>
                <p>Potassium is a mineral found in almost all foods. Your body needs some potassium to make your muscles work, but too much potassium can be dangerous. When your kidneys are not working well, your potassium level may be too high or too low. Having too much or too little potassium can cause muscle cramps, problems with the way your heart beats and muscle weakness.</p>
                <p>If you have kidney disease, you may need to limit how much potassium you take in. Ask your doctor or dietitian if you need to limit potassium.</p>
                <p>Use the list below to learn which foods are low or high in potassium. Your dietitian can also help you learn how to safely eat small amounts of your favorite foods that are high in potassium.</p>
                <div class="mtitle">Eat this (lower-potassium foods)</div>
                <p>Apples, cranberries, grapes, pineapples and strawberries</p>
                <p>Cauliflower, onions, peppers, radishes, summer squash, lettuce</p>
                <p>Pita, tortillas and white breads</p>
                <p>Beef and chicken, white rice</p>
                <div class="mtitle">AVOID (higher-potassium foods)</div>
                <p>Avocados, bananas, melons, oranges, prunes and raisins</p>
                <p>Artichokes, winter squash, plantains, spinach, potatoes and tomatoes</p>
                <p>Bran products and granola</p>
                <p>Beans (baked, black, pinto, etc.), brown or wild rice</p>
                <div class="mtitle">Lower-protein foods:</div>
                <ul>
                    <li>Bread</li>
                    <li>Fruits</li>
                    <li>Vegetables</li>
                    <li>Pasta and rice</li>
                    <li>Higher-protein foods</li>
                    <li>Red meat</li>
                    <li>Poultry</li>
                    <li>Fish and Eggs</li>
                </ul>
                <div class="mtitle">Carbohydrates</div>
                <p>Carbohydrates (“carbs”) are the easiest kind of energy for your body to use. Healthy sources of carbohydrates include fruits and vegetables. Unhealthy sources of carbohydrates include sugar, honey, hard candies, soft drinks and other sugary drinks.</p>
                <p>Some carbohydrates are high in potassium and phosphorus, which you may need to limit depending on your stage of kidney disease. We'll talk about this in more detail a little later. You may also need to watch your carbohydrates carefully if you have diabetes.</p>
                <div class="mtitle">Fat</div>
                <p>You need some fat in your meal plan to stay healthy. Fat gives you energy and helps you use some of the vitamins in your food. But too much fat can lead to weight gain and heart disease. Try to limit fat in your meal plan, and choose healthier fats when you can.</p>
                <div class="mtitle">Healthier fat or “good” fat is called unsaturated fat. Examples of unsaturated fat include:</div>
                <ul>
                    <li>Olive oil</li>
                    <li>Peanut oil</li>
                    <li>Corn oil</li>
                </ul>
                <p>Unsaturated fat can help reduce cholesterol. If you need to gain weight, try to eat more unsaturated fat. If you need to lose weight, limit the unsaturated fat in your meal plan. As always, moderation is the key. Too much “good” fat can also cause problems.</p>
                <div class="mtitle">Saturated fat, also known as “bad” fat, can raise your cholesterol level and raise your risk for heart disease. Examples of saturated fats include:</div>
                <ul>
                    <li>Butter</li>
                    <li>Lard</li>
                    <li>Shortening</li>
                    <li>Meats</li>
                </ul>
                <p>Limit these in your meal plan. Choose healthier, unsaturated fat instead. Trimming the fat from meat and removing the skin from chicken or turkey can also help limit saturated fat. You should also avoid trans fat. This kind of fat makes your "bad" (LDL) cholesterol higher and your "good" (HDL) cholesterol lower. When this happens, you are more likely to get heart disease, which can cause kidney damage.</p>
                <div class="ttitle">Food and drinks to be avoided by kidney patients:</div>
                <ul>
                    <li>Dark-Colored Colas(All form carbonated colas) and Alcochol</li>
                    <li>Avocados</li>
                    <li>Canned Foods such as soups, vegetables and beans</li>
                    <li>Whole-Wheat Bread</li>
                    <li>Brown Rice</li>
                    <li>Bananas</li>
                    <li>Oranges and Orange Juice</li>
                    <li>Red Meat</li>
                    <li>Processed Meats</li>
                    <li>Pickles, Processed Olives and Relish</li>
                    <li>Apricots</li>
                    <li>Potatoes and Sweet Potatoes</li>
                    <li>Tomatoes</li>
                    <li>Packaged, Instant and Pre-Made Meals</li>
                    <li>Swiss Chard, Spinach and Beet Greens</li>
                    <li>Dates, Raisins and Prunes</li>
                    <li>Pretzels, Chips and Crackers</li>
                    <li>Frozen pizza, microwaveable meals and instant noodles</li>
                    <li>Limit intake of Diary products as they contain high potassium</li>
                    <li>Salt intake</li>
                </ul>
                <div class="mtitle">Best foods for people with kidney problems:</div>
                <p><strong>Cauliflower: </strong> Cauliflower is a nutritious vegetable that is high in many nutrients, including vitamin C, vitamin K and the B vitamin folate. One cup (124 grams) of cooked cauliflower contains:</p>
                <ul>
                    <li>Sodium: 19 mg</li>
                    <li>Potassium: 176 mg</li>
                    <li>Phosphorus: 40 mg</li>
                </ul>
                <p><strong>Blueberries:</strong> Blueberries are packed with nutrients and one of the best sources of antioxidants</p>
                <p>One cup (148 grams) of fresh blueberries contains:</p>
                <ul>
                    <li>Sodium: 1.5 mg</li>
                    <li>Potassium: 114 mg</li>
                    <li>Phosphorus: 18 mg</li>
                </ul>
                <p><strong>Sea Bass: </strong> Sea bass is a high-quality protein that contains incredibly healthy fats called omega-3</p>
                <p>Three ounces (85 grams) of cooked sea bass contain:</p>
                <ul>
                    <li>Sodium: 74 mg</li>
                    <li>Potassium: 279 mg</li>
                    <li>Phosphorus: 211 mg</li>
                </ul>
                <p><strong>Red Grapes: </strong> Red grapes are high in vitamin C and contain antioxidants called flavonoids, which have been shown to reduce inflammation.</p>
                <p>These sweet fruits are kidney-friendly, with a half cup (75 grams) containing</p>
                <ul>
                    <li>Sodium: 1.5 mg</li>
                    <li>Potassium: 144 mg</li>
                    <li>Phosphorus: 15 mg</li>
                </ul>
                <p><strong>Egg Whites</strong>Egg white provide a high-quality, kidney-friendly source of protein.</p>
                <p>Two large egg whites (66 grams) contain:</p>
                <ul>
                    <li>Sodium: 110 mg</li>
                    <li>Potassium: 108 mg</li>
                    <li>Phosphorus: 10 mg</li>
                </ul>
                <p><strong>Garlic:</strong> Garlic provides a delicious alternative to salt, adding flavor to dishes while providing nutritional benefits. It’s a good source of manganese, vitamin C and vitamin B6 and contains sulfur compounds that have anti-inflammatory properties.</p>
                <p>Three cloves (9 grams) of garlic contain:</p>
                <ul>
                    <li>Sodium: 1.5 mg</li>
                    <li>Potassium: 36 mg</li>
                    <li>Phosphorus: 14 mg</li>
                </ul>
                <p><strong>Buckwheat: </strong> Buckwheat is highly nutritious, providing a good amount of B vitamins, magnesium, iron and fiber.</p>
                <p>A half cup (84 grams) of cooked buckwheat contains (32):</p>
                <ul>
                    <li>Sodium: 3.5 mg</li>
                    <li>Potassium: 74 mg</li>
                    <li>Phosphorus: 59 mg</li>
                </ul>
                <p><strong>Olive Oil: </strong> Olive oil is a healthy source of fat and phosphorus-free, making it a great option for people with kidney disease.</p>
                <p>One ounce (28 grams) of olive oil contains:</p>
                <ul>
                    <li>Sodium: 0.6 mg</li>
                    <li>Potassium: 0.3 mg</li>
                    <li>Phosphorus: 0 mg</li>
                </ul>
                <p><strong>Bulgur: </strong> Bulgur is an ancient grain that makes a terrific, kidney-friendly alternative to other whole grains that are high in phosphorus and potassium.</p>
                <p>A half-cup (91-gram) serving of bulgur contains:</p>
                <ul>
                    <li>Sodium: 4.5 mg</li>
                    <li>Potassium: 62 mg</li>
                    <li>Phosphorus: 36 mg</li>
                </ul>
                <p><strong>Cabbage: </strong> Cabbage belongs to the cruciferous vegetable family and is loaded with vitamins, minerals and powerful plant compounds.</p>
                <p>It’s low in potassium, phosphorus and sodium with one cup (70 grams) of shredded cabbage containing:</p>
                <ul>
                    <li>Sodium: 13 mg</li>
                    <li>Potassium: 119 mg</li>
                    <li>Phosphorus: 18 mg</li>
                </ul>
                <p><strong>Bell Peppers: </strong> Bell peppers contain an impressive amount of nutrients but are low in potassium, unlike many other vegetables.</p>
                <p>One small red pepper (74 grams) contains:</p>
                <ul>
                    <li>Sodium: 3 mg</li>
                    <li>Potassium: 156 mg</li>
                    <li>Phosphorus: 19 mg</li>
                </ul>
                <p><strong>Onions:</strong> Onions are excellent for providing sodium-free flavor to renal-diet dishes.</p>
                <p>Reducing salt can be difficult for many patients, making finding flavorful salt alternatives a must.</p>
                <p>One small onion (70 grams) contains:</p>
                <ul>
                    <li>Sodium: 3 mg</li>
                    <li>Potassium: 102 mg</li>
                    <li>Phosphorus: 20 mg</li>
                </ul>
                <p><strong>Arugula(Green): </strong> Arugula is a nutrient-dense green that is low in potassium, making it a good choice for kidney-friendly salads and side dishes.</p>
                <p>One cup (20 grams) of raw arugula contains:</p>
                <ul>
                    <li>Sodium: 6 mg</li>
                    <li>Potassium: 74 mg</li>
                    <li>Phosphorus: 10 mg</li>
                </ul>
                <p><strong>Macadamia Nuts: </strong> Macadamia nuts are a delicious option for people with kidney problems. They are much lower in phosphorus than popular nuts like peanuts and almonds.</p>
                <p>One ounce (28 grams) of macadamia nuts contains:</p>
                <ul>
                    <li>Sodium: 1.4 mg</li>
                    <li>Potassium: 103 mg</li>
                    <li>Phosphorus: 53 mg</li>
                </ul>
                <p><strong>Radish: </strong> Radishes are crunchy vegetables that make a healthy addition to a renal diet.</p>
                <p>A half cup (58 grams) of sliced radishes contains:</p>
                <ul>
                    <li>Sodium: 23 mg</li>
                    <li>Potassium: 135 mg</li>
                    <li>Phosphorus: 12 mg</li>
                </ul>
                <p><strong>Turnips: </strong> Turnips are kidney-friendly and make an excellent replacement for vegetables that are higher in potassium like potatoes and winter squash.</p>
                <p>They can be roasted or boiled and mashed for a healthy side dish that works well for a renal diet.</p>
                <p>A half cup (78 grams) of cooked turnips contains:</p>
                <ul>
                    <li>Sodium: 12.5 mg</li>
                    <li>Potassium: 138 mg</li>
                    <li>Phosphorus: 20 mg</li>
                </ul>
                <p><strong>Pineapple:</strong> Pineapple makes a sweet, low-potassium alternative for those with kidneys problems.</p>
                <p>Plus, pineapple is rich in fiber, B vitamins, manganese and bromelain, an enzyme that helps reduce inflammation.</p>
                <p>One cup (165 grams) of pineapple chunks contains:</p>
                <ul>
                    <li>Sodium: 2 mg</li>
                    <li>Potassium: 180 mg</li>
                    <li>Phosphorus: 13 mg</li>
                </ul>
                <p><strong>Cranberries: </strong> Cranberries benefit both the urinary tract and kidneys.</p>
                <p>These tiny, tart fruits contain phytonutrients called A-type proanthocyanidins, which prevent bacteria from sticking to the lining of the urinary tract and bladder, thus preventing infection.</p>
                <p>Cranberries can be eaten dried, cooked, fresh or as a juice. They are very low in potassium, phosphorus and sodium.</p>
                <p>One cup (100 grams) of fresh cranberries contains:</p>
                <ul>
                    <li>Sodium: 2 mg</li>
                    <li>Potassium: 85 mg</li>
                    <li>Phosphorus: 13 mg</li>
                </ul>
                <p><strong>Shiitake Mushrooms: </strong> Shiitake mushrooms are a savory ingredient that can be used as a plant-based meat substitute for those on a renal diet who need to limit protein.</p>
                <p>They are an excellent source of B vitamins, copper, manganese and selenium.</p>
                <p>One cup (145 grams) of cooked shiitake mushroom contains:</p>
                <ul>
                    <li>Sodium: 6 mg</li>
                    <li>Potassium: 170 mg</li>
                    <li>Phosphorus: 42 mg</li>
                </ul>
            </div>
        </div>
    </div>

    <?php include "app_faqs.php"; ?>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>


</body>

</html>