<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>

    </title>
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <link rel="publisher" href="" />
    <link rel="canonical" href="index.php" />
    <?php include 'app_top.php'; ?>

</head>

<body>
    <?php include 'app_header.php'; ?>
    <div class="breadcum-sec bg-white">
        <div class="container-fluid px-md-5">
            <ul>
                <li><a href="" title="Home">Home</a></li>
                <li><a href=""> Price Calculators</a></li>
                <li>Home Interior Price Calculator</li>
            </ul>
        </div>
    </div>
    <div class="section bg-light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10 col-12">
                    <div class="step-page">
                        <div class="step-indicator">
                            <div class="st step-1 active">
                                BHK Type
                            </div>
                            <div class="st step-2">
                                Rooms to design
                            </div>
                            <div class="st step-3">
                                Package
                            </div>
                            <div class="st step-4">
                                Get Quote
                            </div>
                        </div>
                        <form action="">
                            <div class="step-content">
                                <div class="stepbox active">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Select your <span> BHK type</span></div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="bhk" id="bhk1">
                                            <label class="form-check-label" for="bhk1">1 BHK</label>
                                        </div>
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="bhk" id="bhk2">
                                            <label class="form-check-label" for="bhk2">2 BHK</label>
                                            <span class="drop"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-down" viewBox="0 0 16 16">
                                                    <path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708" />
                                                </svg></span>
                                            <div class="sub-options">
                                                <div class="radio-group">
                                                    <input type="radio" class="form-check-input" id="2bhk-small" name="2bhk" checked>
                                                    <label for="2bhk-small">Small<small>Below 800 sq ft</small></label>
                                                    <input type="radio" class="form-check-input" id="2bhk-large" name="2bhk">
                                                    <label for="2bhk-large">Large<small>Above 800 sq ft</small></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="bhk" id="bhk3">
                                            <label class="form-check-label" for="bhk3">3 BHK</label>
                                            <span class="drop"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-down" viewBox="0 0 16 16">
                                                    <path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708" />
                                                </svg></span>
                                            <div class="sub-options">
                                                <div class="radio-group">
                                                    <input type="radio" class="form-check-input" id="3bhk-Small" name="3bhk" checked>
                                                    <label for="3bhk-Small">Small<small>Below 1200 sq ft</small></label>
                                                    <input type="radio" class="form-check-input" id="3bhk-Large" name="3bhk">
                                                    <label for="3bhk-Large">Large<small>Above 1200 sq ft</small></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="bhk" id="bhk4">
                                            <label class="form-check-label" for="bhk4">4 BHK</label>
                                            <span class="drop"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-down" viewBox="0 0 16 16">
                                                    <path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708" />
                                                </svg></span>
                                            <div class="sub-options">
                                                <div class="radio-group">
                                                    <input type="radio" class="form-check-input" id="4bhk-standard" name="4bhk" checked>
                                                    <label for="4bhk-standard">Small<small>Below 1800 sq ft</small></label>
                                                    <input type="radio" class="form-check-input" id="4bhk-luxury" name="4bhk">
                                                    <label for="4bhk-luxury">Large<small>Above 1800 sq ft</small></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="bhk-option form-check">
                                            <input class="form-check-input" type="radio" name="bhk" id="bhk5">
                                            <label class="form-check-label" for="bhk5">5 BHK+</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5"><span>Select the rooms </span> you’d like us to design</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="room-list">
                                            <div class="room-item" data-room="Living Room">
                                                <div class="room-name">Living Room</div>
                                                <div class="counter-controls">
                                                    <button type="button" onclick="decrement(this)">−</button>
                                                    <span>0</span>
                                                    <button type="button" onclick="increment(this)">+</button>
                                                </div>
                                            </div>
                                            <div class="room-item" data-room="Kitchen">
                                                <div class="room-name">Kitchen</div>
                                                <div class="counter-controls">
                                                    <button type="button" onclick="decrement(this)">−</button>
                                                    <span>0</span>
                                                    <button type="button" onclick="increment(this)">+</button>
                                                </div>
                                            </div>
                                            <div class="room-item" data-room="Bedroom">
                                                <div class="room-name">Bedroom</div>
                                                <div class="counter-controls">
                                                    <button type="button" onclick="decrement(this)">−</button>
                                                    <span>0</span>
                                                    <button type="button" onclick="increment(this)">+</button>
                                                </div>
                                            </div>
                                            <div class="room-item" data-room="Bathroom">
                                                <div class="room-name">Bathroom</div>
                                                <div class="counter-controls">
                                                    <button type="button" onclick="decrement(this)">−</button>
                                                    <span>0</span>
                                                    <button type="button" onclick="increment(this)">+</button>
                                                </div>
                                            </div>
                                            <div class="room-item" data-room="Dining">
                                                <div class="room-name">Dining</div>
                                                <div class="counter-controls">
                                                    <button type="button" onclick="decrement(this)">−</button>
                                                    <span>0</span>
                                                    <button type="button" onclick="increment(this)">+</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5"><span>Pick your </span>package</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="package-options">
                                            <label class="package">
                                                <div class="package-header">
                                                    <input type="radio" name="package" value="essentials" >
                                                    <span class="package-title">Essentials (₹₹)</span>
                                                </div>
                                                <div class="package-description">
                                                    A range of essential home interior solutions that’s perfect for all your needs.
                                                </div>
                                                <img src="designer/images/package/Essentials.jpg" alt="Essentials">
                                                <ul>
                                                    <li>Affordable pricing</li>
                                                    <li>Convenient designs</li>
                                                    <li>Basic accessories</li>
                                                </ul>
                                            </label>
                                            <label class="package">
                                                <div class="package-header">
                                                    <input type="radio" name="package" value="premium">
                                                    <span class="package-title">Premium (₹₹₹)</span>
                                                </div>
                                                <div class="package-description">
                                                    Superior home interior solutions that will take your interiors to the next level.
                                                </div>
                                                <img src="designer/images/package/Premium.jpg" alt="Premium">
                                                <ul>
                                                    <li>Mid-range pricing</li>
                                                    <li>Premium designs</li>
                                                    <li>Wide range of accessories</li>
                                                </ul>
                                            </label>
                                            <label class="package">
                                                <div class="package-header">
                                                    <input type="radio" name="package" value="Luxe">
                                                    <span class="package-title">Luxe (₹₹₹₹)</span>
                                                </div>
                                                <div class="package-description">
                                                    High-end interior solutions for the ultimate home interior experience you deserve.
                                                </div>
                                                <img src="designer/images/package/luxe.jpg" alt="Luxe">
                                                <ul>
                                                    <li>Elite pricing</li>
                                                    <li>Lavish designs</li>
                                                    <li>Extensive range of accessories</li>
                                                </ul>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Your estimate is almost ready</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="form-group">
                                            <input type="text" name="name" class="form-control" onkeyup="validateOnlyTextField(this)" placeholder="Full Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="email" name="email" class="form-control" placeholder="Email id">
                                        </div>
                                        <div class="form-group">
                                            <input type="hidden" name="countryName" class="countryName" value="">
                                            <input type="hidden" name="code" class="code" value="">
                                            <input class="form-control telePhone" type="tel" name="mobile" value="" maxlength="10" minlength="10" onkeyup="this.value=this.value.replace(/[^0-9]/g,'')" placeholder="Mobile Number*" required>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="location" class="form-control" placeholder="Your Location">
                                        </div>
                                        <div class="form-group mb-0">
                                            <div class="g-recaptcha" data-sitekey="6Ld_T_sdAAAAAJYYygzCQ9I068mGeRCu_Boz7ecO"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="step-footer">
                            <button class="back" id="backBtn" onclick="prevStep()" disabled>Back</button>
                            <div class="pagination" id="pagination-text">
                                1 / 4
                            </div>
                            <button class="next" id="nextBtn" onclick="nextStep()">Next</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app_footer.php'; ?>
    <?php include 'app_bottom.php'; ?>
    <script>
        let currentStep = 1;
        const totalSteps = 4;

        function updateStepView() {
            const element = document.querySelector("header");
            element.scrollIntoView();

            document.querySelectorAll('.step-indicator .st').forEach((el, idx) => {
                el.classList.remove('active', 'done');
                if (idx + 1 < currentStep) {
                    el.classList.add('done');
                } else if (idx + 1 === currentStep) {
                    el.classList.add('active');
                }
            });
            document.querySelectorAll('.stepbox').forEach((box, idx) => {
                box.classList.toggle('active', idx + 1 === currentStep);
            });
            document.getElementById('pagination-text').textContent = `${currentStep} / ${totalSteps}`;
            document.getElementById('backBtn').disabled = currentStep === 1;
            document.getElementById('nextBtn').innerHTML = currentStep === totalSteps ? "Get My Estimate" : "Next";
        }

        function nextStep() {
            if (currentStep < totalSteps) {
                currentStep++;
                updateStepView();
            }
        }

        function prevStep() {
            if (currentStep > 1) {
                currentStep--;
                updateStepView();
            }
        }

        const bhkOptions = document.querySelectorAll(".bhk-option");

        bhkOptions.forEach(option => {
            option.addEventListener("click", () => {
                bhkOptions.forEach(opt => opt.classList.remove("active"));
                option.classList.add("active");
            });
        });

        function increment(button) {
            const span = button.parentNode.querySelector('span');
            span.textContent = parseInt(span.textContent) + 1;
        }

        function decrement(button) {
            const span = button.parentNode.querySelector('span');
            const current = parseInt(span.textContent);
            if (current > 0) {
                span.textContent = current - 1;
            }
        }

        const packages = document.querySelectorAll('.package');

        packages.forEach(pkg => {
            pkg.addEventListener('click', () => {
                packages.forEach(p => p.classList.remove('selected'));
                pkg.classList.add('selected');
                pkg.querySelector('input[type="radio"]').checked = true;
            });
        });
    </script>
</body>

</html>