<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <link rel="publisher" href="" />
    <link rel="canonical" href="index.php" />
    <?php include 'app_top.php'; ?>
    <style>
        .step-indicator::before {
            width: 83%;
        }
    </style>
</head>

<body>
    <?php include 'app_header.php'; ?>
    <div class="breadcum-sec bg-white">
        <div class="container-fluid px-md-5">
            <ul>
                <li><a href="" title="Home">Home</a></li>
                <li><a href=""> Price Calculators</a></li>
                <li>Wardrobe Price Calculator</li>
            </ul>
        </div>
    </div>
    <div class="section bg-light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10 col-12">
                    <div class="step-page">
                        <div class="step-indicator">
                            <div class="st active">Length</div>
                            <div class="st">Type</div>
                            <div class="st">Finish</div>
                            <div class="st">Material</div>
                            <div class="st">Accessories</div>
                            <div class="st">Get Quote</div>
                        </div>
                        <form action="">
                            <div class="step-content">
                                <div class="stepbox active">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">What is the height of <span>your wardrobe?</span></div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="height-ft" id="height-ft1">
                                            <label class="form-check-label" for="height-ft1">4 ft</label>
                                        </div>
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="height-ft" id="height-ft2">
                                            <label class="form-check-label" for="height-ft2">6 ft</label>
                                        </div>
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="height-ft" id="height-ft6">
                                            <label class="form-check-label" for="height-ft6">7 ft</label>
                                        </div>
                                        <div class="bhk-option form-check mb-3">
                                            <input class="form-check-input" type="radio" name="height-ft" id="height-ft9">
                                            <label class="form-check-label" for="height-ft9">9 ft</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Select the type of wardrobe</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="package-options">
                                            <label class="package wardrobe">
                                                <div class="package-header">
                                                    <input type="radio" name="wardrobe" value="Sliding">
                                                    <span class="package-title">Swing</span>
                                                </div>
                                                <div class="package-description">Movable doors that slide horizontally along a metal rail and save floor space.</div>
                                                <img src="designer/images/package/sliding.jpg" alt="Sliding">
                                                <div class="package-description mb-0">Make a style statement even in a compact space.</div>
                                            </label>
                                            <label class="package wardrobe">
                                                <div class="package-header">
                                                    <input type="radio" name="wardrobe" value="Swing">
                                                    <span class="package-title">Swing</span>
                                                </div>
                                                <div class="package-description">Movable doors that swing out to open, giving better visibility and storage space.</div>
                                                <img src="designer/images/package/swing.jpg" alt="Sliding">
                                                <div class="package-description mb-0">A cost-effective option that never goes out of style.</div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Select your preferred finish</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="package-options">
                                            <label class="package finish">
                                                <div class="package-header">
                                                    <input type="radio" name="finish" value="laminate">
                                                    <span class="package-title">Standard - Laminate</span>
                                                </div>
                                                <img src="designer/images/package/laminate.jpg" alt="laminate">
                                                <div class="package-description mb-2"><strong>Price:</strong> ₹₹</div>
                                                <div class="package-description mb-0"><strong>Pro Tip:</strong> Looking for a seamless finish that sits well with every interior? This one's for you.</div>
                                            </label>
                                            <label class="package finish">
                                                <div class="package-header">
                                                    <input type="radio" name="finish" value="Membrane">
                                                    <span class="package-title">Premium - Membrane</span>
                                                </div>
                                                <img src="designer/images/package/membrane.jpg" alt="Membrane">
                                                <div class="package-description mb-2"><strong>Price:</strong> ₹₹₹</div>
                                                <div class="package-description mb-0"><strong>Pro Tip:</strong> Get a magazine-like look that requires low maintenance.</div>
                                            </label>
                                            <label class="package finish">
                                                <div class="package-header">
                                                    <input type="radio" name="finish" value="Membrane">
                                                    <span class="package-title">Luxe - Acrylic</span>
                                                </div>
                                                <img src="designer/images/package/acrylic.jpg" alt="Membrane">
                                                <div class="package-description mb-2"><strong>Price:</strong> ₹₹₹₹</div>
                                                <div class="package-description mb-0"><strong>Pro Tip:</strong> Adds a touch of luxury to your modular wardrobe.</div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Select your preferred core material</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="package-options">
                                            <label class="package material">
                                                <div class="package-header">
                                                    <input type="radio" name="material" value="MDF">
                                                    <span class="package-title">MDF</span>
                                                </div>
                                                <div class="package-description mb-2">Seamless, free of knots, and has high resistance to wear & tear.</div>
                                                <img src="designer/images/package/acrylic.jpg" alt="MDF">
                                                <div class="package-description mb-2"><strong>Price:</strong> ₹₹</div>
                                                <div class="package-description mb-0"><strong>Pro Tip:</strong> An ideal choice for the cabinets owing to its smooth surface.</div>
                                            </label>
                                            <label class="package material">
                                                <div class="package-header">
                                                    <input type="radio" name="material" value="HDF">
                                                    <span class="package-title">HDF/HMR</span>
                                                </div>
                                                <div class="package-description mb-2">Sturdy and highly dense along with a solid screw-holding capacity.</div>
                                                <img src="designer/images/package/acrylic.jpg" alt="HDF">
                                                <div class="package-description mb-2"><strong>Price:</strong> ₹₹</div>
                                                <div class="package-description mb-0"><strong>Pro Tip:</strong> A good option that comes with a high load-bearing capacity.</div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox ">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Add your preferred accessories (optional)</div>
                                    </div>
                                    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-3 justify-content-center">
                                        <div class="col">
                                            <label class="kitchen-layout accessories">
                                                <input type="checkbox" class="form-check-input" name="Loft" value="Loft">
                                                <img src="designer/images/package/loft.jpg" alt="" class="p-0">
                                                <div class="tt">Loft</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout accessories">
                                                <input type="checkbox" class="form-check-input" name="Drawer" value="Drawer">
                                                <img src="designer/images/package/Single-Full-size-Drawer.jpg" alt="" class="p-0">
                                                <div class="tt">Single Full-size Drawer</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout accessories">
                                                <input type="checkbox" class="form-check-input" name="Half-drawer" value="Half-drawer">
                                                <img src="designer/images/package/1-half-drawer.jpg" alt="" class="p-0">
                                                <div class="tt">1 half-drawer</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout accessories">
                                                <input type="checkbox" class="form-check-input" name="2Half-drawer" value="2Half-drawer">
                                                <img src="designer/images/package/2-half-drawers.jpg" alt="" class="p-0">
                                                <div class="tt">2 half-drawer</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout accessories">
                                                <input type="checkbox" class="form-check-input" name="Wicker" value="Wicker">
                                                <img src="designer/images/package/Wicker-Pull-Out.jpg" alt="" class="p-0">
                                                <div class="tt">Wicker Pull Out</div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Your estimate is almost ready</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="form-group">
                                            <input type="text" name="name" class="form-control" onkeyup="validateOnlyTextField(this)" placeholder="Full Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="email" name="email" class="form-control" placeholder="Email id">
                                        </div>
                                        <div class="form-group">
                                            <input type="hidden" name="countryName" class="countryName" value="">
                                            <input type="hidden" name="code" class="code" value="">
                                            <input class="form-control telePhone" type="tel" name="mobile" value="" maxlength="10" minlength="10" onkeyup="this.value=this.value.replace(/[^0-9]/g,'')" placeholder="Mobile Number*" required>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="location" class="form-control" placeholder="Your Location">
                                        </div>
                                        <div class="form-group mb-0">
                                            <div class="g-recaptcha" data-sitekey="6Ld_T_sdAAAAAJYYygzCQ9I068mGeRCu_Boz7ecO"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="step-footer">
                            <button class="back" id="backBtn" onclick="prevStep()" disabled>Back</button>
                            <div class="pagination" id="pagination-text">
                                1 / 6
                            </div>
                            <button class="next" id="nextBtn" onclick="nextStep()">Next</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app_footer.php'; ?>
    <?php include 'app_bottom.php'; ?>
    <script>
        let currentStep = 1;
        const totalSteps = 6;

        function updateStepView() {
            const element = document.querySelector("header");
            element.scrollIntoView();

            document.querySelectorAll('.step-indicator .st').forEach((el, idx) => {
                el.classList.remove('active', 'done');
                if (idx + 1 < currentStep) {
                    el.classList.add('done');
                } else if (idx + 1 === currentStep) {
                    el.classList.add('active');
                }
            });
            document.querySelectorAll('.stepbox').forEach((box, idx) => {
                box.classList.toggle('active', idx + 1 === currentStep);
            });
            document.getElementById('pagination-text').textContent = `${currentStep} / ${totalSteps}`;
            document.getElementById('backBtn').disabled = currentStep === 1;
            document.getElementById('nextBtn').innerHTML = currentStep === totalSteps ? "Get My Estimate" : "Next";
        }

        function nextStep() {
            if (currentStep < totalSteps) {
                currentStep++;
                updateStepView();
            }
        }

        function prevStep() {
            if (currentStep > 1) {
                currentStep--;
                updateStepView();
            }
        }

        const bhkOptions = document.querySelectorAll(".bhk-option");
        bhkOptions.forEach(option => {
            option.addEventListener("click", () => {
                bhkOptions.forEach(opt => opt.classList.remove("active"));
                option.classList.add("active");
            });
        });

        function makeSelectableGroup(selector, activeClass = 'selected') {
            const items = document.querySelectorAll(selector);
            items.forEach(item => {
                item.addEventListener('click', (e) => {
                    if (e.target.tagName === 'INPUT') return;
                    items.forEach(i => i.classList.remove(activeClass));
                    item.classList.add(activeClass);

                    const radio = item.querySelector('input[type="radio"]');
                    if (radio) radio.checked = true;
                });
            });
        }
        makeSelectableGroup('.wardrobe');
        makeSelectableGroup('.finish');
        makeSelectableGroup('.material');

        function makeSelectableToggle(params, activeClass = 'selected') {
            const items = document.querySelectorAll(params);
            items.forEach(item => {
                item.addEventListener('click', (e) => {
                    if (e.target.tagName === 'INPUT') return;
                    item.classList.toggle(activeClass);
                });
            });
        }

        makeSelectableToggle(".accessories")
    </script>
</body>

</html>