<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>

    </title>
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <link rel="publisher" href="" />
    <link rel="canonical" href="index.php" />
    <?php include 'app_top.php'; ?>

</head>

<body>
    <?php include 'app_header.php'; ?>
    <div class="breadcum-sec bg-white">
        <div class="container-fluid px-md-5">
            <ul>
                <li><a href="" title="Home">Home</a></li>
                <li><a href=""> Price Calculators</a></li>
                <li>Modular kitchen price Calculator</li>
            </ul>
        </div>
    </div>
    <div class="section bg-light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10 col-12">
                    <div class="step-page">
                        <div class="step-indicator">
                            <div class="st active">
                                Kitchen Layout
                            </div>
                            <div class="st">
                                Measurements
                            </div>
                            <div class="st">
                                Package
                            </div>
                            <div class="st">
                                Get Quote
                            </div>
                        </div>
                        <form action="">
                            <div class="step-content">
                                <div class="stepbox active">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Select the layout of <span>your kitchen</span></div>
                                    </div>
                                    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 g-3">
                                        <div class="col">
                                            <label class="kitchen-layout" data-layout="L-shaped">
                                                <input type="radio" class="form-check-input" name="kitchen" value="L-shaped">
                                                <img src="designer/images/kitchen/l-shaped.png" alt="">
                                                <div class="tt">L-shaped</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout" data-layout="Straight">
                                                <input type="radio" class="form-check-input" name="kitchen" value="Straight">
                                                <img src="designer/images/kitchen/straight.png" alt="">
                                                <div class="tt">Straight</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout" data-layout="U-shaped">
                                                <input type="radio" class="form-check-input" name="kitchen" value="U-shaped">
                                                <img src="designer/images/kitchen/u-shaped.png" alt="">
                                                <div class="tt">U-shaped</div>
                                            </label>
                                        </div>
                                        <div class="col">
                                            <label class="kitchen-layout" data-layout="Parallel">
                                                <input type="radio" class="form-check-input" name="kitchen" value="Parallel">
                                                <img src="designer/images/kitchen/parallel.png" alt="">
                                                <div class="tt">Parallel</div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox ">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Now review the measurements for accuracy</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div id="messurement">
                                            <img src="designer/images/kitchen/l-shaped.webp" alt="">
                                            <div class="form-group field field1">
                                                <label>A</label>
                                                <select name="" id="" class="form-select">
                                                    <option>3</option>
                                                    <option>4</option>
                                                    <option>5</option>
                                                    <option>6</option>
                                                    <option>7</option>
                                                    <option>8</option>
                                                    <option>9</option>
                                                    <option>10</option>
                                                    <option>11</option>
                                                    <option>12</option>
                                                    <option>13</option>
                                                </select> ft.
                                            </div>
                                            <div class="form-group field field2">
                                                <label>B</label>
                                                <select name="" id="" class="form-select">
                                                    <option>3</option>
                                                    <option>4</option>
                                                    <option>5</option>
                                                    <option>6</option>
                                                    <option>7</option>
                                                    <option>8</option>
                                                    <option>9</option>
                                                    <option>10</option>
                                                    <option>11</option>
                                                    <option>12</option>
                                                    <option>13</option>
                                                </select> ft.
                                            </div>
                                            <div class="form-group field field3">
                                                <label>C</label>
                                                <select name="" id="" class="form-select">
                                                    <option>3</option>
                                                    <option>4</option>
                                                    <option>5</option>
                                                    <option>6</option>
                                                    <option>7</option>
                                                    <option>8</option>
                                                    <option>9</option>
                                                    <option>10</option>
                                                    <option>11</option>
                                                    <option>12</option>
                                                    <option>13</option>
                                                </select> ft.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5"><span>Pick your </span>package</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="package-options">
                                            <label class="package">
                                                <div class="package-header">
                                                    <input type="radio" name="package" value="essentials">
                                                    <span class="package-title">Essentials (₹₹)</span>
                                                </div>
                                                <div class="package-description">
                                                    A range of essential home interior solutions that’s perfect for all your needs.
                                                </div>
                                                <img src="designer/images/package/Essentials.jpg" alt="Essentials">
                                                <ul>
                                                    <li>Affordable pricing</li>
                                                    <li>Convenient designs</li>
                                                    <li>Basic accessories</li>
                                                </ul>
                                            </label>
                                            <label class="package">
                                                <div class="package-header">
                                                    <input type="radio" name="package" value="premium">
                                                    <span class="package-title">Premium (₹₹₹)</span>
                                                </div>
                                                <div class="package-description">
                                                    Superior home interior solutions that will take your interiors to the next level.
                                                </div>
                                                <img src="designer/images/package/Premium.jpg" alt="Premium">
                                                <ul>
                                                    <li>Mid-range pricing</li>
                                                    <li>Premium designs</li>
                                                    <li>Wide range of accessories</li>
                                                </ul>
                                            </label>
                                            <label class="package">
                                                <div class="package-header">
                                                    <input type="radio" name="package" value="Luxe">
                                                    <span class="package-title">Luxe (₹₹₹₹)</span>
                                                </div>
                                                <div class="package-description">
                                                    High-end interior solutions for the ultimate home interior experience you deserve.
                                                </div>
                                                <img src="designer/images/package/luxe.jpg" alt="Luxe">
                                                <ul>
                                                    <li>Elite pricing</li>
                                                    <li>Lavish designs</li>
                                                    <li>Extensive range of accessories</li>
                                                </ul>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="stepbox">
                                    <div class="head-sec mb-4">
                                        <div class="tt fs-5">Your estimate is almost ready</div>
                                    </div>
                                    <div class="stepbox-content">
                                        <div class="form-group">
                                            <input type="text" name="name" class="form-control" onkeyup="validateOnlyTextField(this)" placeholder="Full Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="email" name="email" class="form-control" placeholder="Email id">
                                        </div>
                                        <div class="form-group">
                                            <input type="hidden" name="countryName" class="countryName" value="">
                                            <input type="hidden" name="code" class="code" value="">
                                            <input class="form-control telePhone" type="tel" name="mobile" value="" maxlength="10" minlength="10" onkeyup="this.value=this.value.replace(/[^0-9]/g,'')" placeholder="Mobile Number*" required>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="location" class="form-control" placeholder="Your Location">
                                        </div>
                                        <div class="form-group mb-0">
                                            <div class="g-recaptcha" data-sitekey="6Ld_T_sdAAAAAJYYygzCQ9I068mGeRCu_Boz7ecO"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="step-footer">
                            <button class="back" id="backBtn" onclick="prevStep()" disabled>Back</button>
                            <div class="pagination" id="pagination-text">
                                1 / 4
                            </div>
                            <button class="next" id="nextBtn" onclick="nextStep()">Next</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app_footer.php'; ?>
    <?php include 'app_bottom.php'; ?>
    <script>
        let currentStep = 1;
        const totalSteps = 4;

        function updateStepView() {
            const element = document.querySelector("header");
            element.scrollIntoView();

            document.querySelectorAll('.step-indicator .st').forEach((el, idx) => {
                el.classList.remove('active', 'done');
                if (idx + 1 < currentStep) {
                    el.classList.add('done');
                } else if (idx + 1 === currentStep) {
                    el.classList.add('active');
                }
            });
            document.querySelectorAll('.stepbox').forEach((box, idx) => {
                box.classList.toggle('active', idx + 1 === currentStep);
            });
            document.getElementById('pagination-text').textContent = `${currentStep} / ${totalSteps}`;
            document.getElementById('backBtn').disabled = currentStep === 1;
            document.getElementById('nextBtn').innerHTML = currentStep === totalSteps ? "Get My Estimate" : "Next";
        }

        function nextStep() {
            if (currentStep < totalSteps) {
                currentStep++;
                updateStepView();
            }
        }

        function prevStep() {
            if (currentStep > 1) {
                currentStep--;
                updateStepView();
            }
        }

        const packages = document.querySelectorAll('.package');

        packages.forEach(pkg => {
            pkg.addEventListener('click', (e) => {
                if (e.target.tagName === 'INPUT') return;
                packages.forEach(p => p.classList.remove('selected'));
                pkg.classList.add('selected');
                pkg.querySelector('input[type="radio"]').checked = true;
            });
        });

        const kitchen = document.querySelectorAll('.kitchen-layout');

        kitchen.forEach(item => {
            item.addEventListener('click', (e) => {
                if (e.target.tagName === 'INPUT') return;
                kitchen.forEach(k => k.classList.remove('selected'));
                item.classList.add('selected');
                item.querySelector('input[type="radio"]').checked = true;
                updateMeasurements(item.dataset.layout);
            });
        });

        function updateMeasurements(layout) {
            const messurement = document.getElementById('messurement');
            const img = messurement.querySelector('img');
            const fields = [...messurement.querySelectorAll('.field')];
            const imageMap = {
                "L-shaped": "designer/images/kitchen/l-shaped.webp",
                "Straight": "designer/images/kitchen/straight.webp",
                "U-shaped": "designer/images/kitchen/u-shaped.webp",
                "Parallel": "designer/images/kitchen/parallel.webp"
            };
            const hideMap = {
                "L-shaped": [2],
                "Straight": [1, 2],
                "Parallel": [2]
            };
            fields.forEach(f => {
                f.style.display = "flex";
                f.querySelector('.form-select').disabled = false;
            });
            img.src = imageMap[layout] || "";
            (hideMap[layout] || []).forEach(i => {
                fields[i].style.display = "none";
                fields[i].querySelector('.form-select').disabled = true;
            });
        }
    </script>
</body>

</html>