<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once ("../include/main.inc.php");
check_session('MyCpanel', 'index.php');
################ Paging Starts From Here ##################
@extract($_REQUEST);
$start = (intval($start) < 0 or $start == "") ? 0 : $start;
$pagesize = isset($pagesize)?$pagesize:100;

$heading = "Update Products";
$record_type = "Products";
$script_name = "products.php";
$table_name = "tbl_products";
####################################################


$attribute_tbl = mysqli_query($dbconn, "SELECT * FROM tbl_attributes WHERE status=1");
$attributes_array = $attributes = [];
while($atrb = mysqli_fetch_array($attribute_tbl)){
    $attributes[$atrb['attributes_id']] = $atrb;
    $attributes_array[$atrb['parent_id']][] = $atrb['attributes_id'];
}


$qry = mysqli_fetch_array(db_query("SELECT * FROM $table_name WHERE product_id=".$_REQUEST['pid']));
if(!$qry){
    header('Location: products.php');
    exit();
}

admin_header("");
?>
<style>
     #productImage{
        display: flex;
     }
    #productImage img{
        max-width: 150px;
        max-height: 90px;
        border: 1px solid #ccc;
        margin: 2px;
    }
    a.remove-height {
        color: #fff;
        background: red;
        padding: 5px;
        border-radius: 27px;
        display: inline-block;
        width: 30px;
        height: 30px;
        text-align: center;
        font-weight: 900;
        font-size: 20px;
    }
    .col-1.high-sn {
        font-size: 23px;
        text-align: end;
    }
</style>
<table width="99%" border="0" align="center" cellpadding="0" cellspacing="0" valign="top">
    <tr>
        <td align="left" width="50%" class="myTitle">
            <?= $heading; ?>
        </td>
        <td align="right">
            <table width="98%" border="0" align="center" cellpadding="0" cellspacing="0" valign="top">
                <tr>
                    <td align="right">
                        <a href="<?= SITE_ADMIN_URL."/products.php"?>" class="button add-category-btn text-white">Back</button>
                    </td>
                </tr>
            </table>
        </td>
    </tr>

</table>
<hr size="2" width="99%" color="#DA251C">

    <form action="<?= SITE_ADMIN_URL.'/form_page.php' ?>" class="form_submit" type="post" enctype="multipart/form-data">
        <div class="modal-body">
            
            <div class="row">
                <div class="col-3">
                    <div class="form-group">
                        <label>Select Brand<sup class="text-danger">*</sup></label>
                        <select class="form-control form-control-lg" name="brand">
                            <option value="">Select brand</option>
                            <?php 
                                $brands = mysqli_query($dbconn, "SELECT brand_id, brand_name FROM tbl_brands WHERE brand_status=1");
                                while($brd = mysqli_fetch_assoc($brands)){
                            ?>
                            <option value="<?= $brd['brand_id']; ?>" <?= ($qry['brand_id'] == $brd['brand_id'])?'selected':''; ?>><?= $brd['brand_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>



                <div class="col-9">
                    <div class="form-group">
                        <label>Heading<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="prd_name" placeholder="Enter product heading" value="<?= $qry['product_name'] ?>">
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label>Sub heading<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="sub_heading" placeholder="Enter product sub heading" value="<?= $qry['sub_heading'] ?>">
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label>Product url<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="product_url" placeholder="Enter product url" value="<?= $qry['product_url'] ?>">
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label>Highlighted points <sup class="text-danger">*</sup></label>
                        <div id="heighlites">
                            <?php $hln = 1; foreach(explode('|', $qry['highlite_points']) as $hl){ ?>
                            <div class="row">
                                <div class="col-1 high-sn"><?= $hln++?>.</div>
                                <div class="col-10">
                                    <input type="text" name="heighlite[]" placeholder="Enter heighlites" class="form-control form-control -sm" value="<?= $hl; ?>">
                                </div>
                                <div class="col-1">
                                    <a class="remove-height" onclick="RemoveHighlites(this)" href="#"><i class="fa fa-times"></i></a>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <div class="mt-1 text-dark">To add more field <a href="#" id="addHfield">Click Here</a></div>
                    </div>
                </div>
                <div class="col-4">
                    <div class="form-group">
                        <label>Product MRP<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="mrp" placeholder="Enter MRP" value="<?= $qry['mrp'] ?>">
                    </div>
                </div>
                <div class="col-4">
                    <div class="form-group">
                        <label>Price<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="price" placeholder="Enter price" value="<?= $qry['product_price'] ?>">
                    </div>
                </div>
                <div class="col-4">
                    <div class="form-group">
                        <label>Discount (%)<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="discount" placeholder="Enter Discount" value="<?= $qry['discount'] ?>">
                    </div>
                </div>
                
                <div class="col-4">
                    <div class="form-group">
                        <label>Quantity<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="qty" placeholder="Enter quantity" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')" value="<?= $qry['product_quantity'] ?>">
                    </div>
                </div>
                
                <div class="col-4">
                    <div class="form-group">
                        <label>Condition<sup class="text-danger">*</sup></label>
                        <input type="text" class="form-control" name="condition" placeholder="Enter condition" value="<?= $qry['product_condition'] ?>">
                    </div>
                </div>

                <div class="col-4">
                    <div class="form-group">
                        <label>Status<sup class="text-danger">*</sup></label>
                        <select class="form-control" name="status">
                            <option value="1">Active</option>
                            <option value="0" <?= ($qry['product_status'] == 0)?'selected':''; ?>>In-Active</option>
                        </select>
                    </div>
                </div>



                <div class="col-12">
                    <div class="form-group">
                        <label>Short Description<sup class="text-danger">*</sup></label>
                        <textarea class="form-control" name="short_desc" placeholder="Enter short description"><?= $qry['product_short_details'] ?></textarea>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label>Full Description<sup class="text-danger">*</sup></label>
                        <textarea id="full_desc" name="full_desc" class="form-control" placeholder="Enter full description"><?= $qry['product_full_details'] ?></textarea>                              
                    </div>
                </div>
                
                <div class="col-4">
                    <div class="form-group mb-0" style="height:58px;">
                        <label>Products images<sup class="text-danger">*</sup></label>
                        <input type="file" id="prevMulti" name="prdimgs[]" multiple onChange="prevMultople(this)">
                    </div>
                </div>
                <div class="col-12 mb-4">
                    <sub class="text-danger">** Image size should be 300*300px, Upload multiple images in one upload</sub>
                </div>
                
                <div class="col-12" id="productImage">
                    
                    <?php 
                        $prd_img = mysqli_query($dbconn, "SELECT * FROM tbl_product_images WHERE product_id=".$_REQUEST['pid']);
                        while($pim = mysqli_fetch_array($prd_img)){
                            $filenm = SITE_DIR_PATH.'/uploaded-files/products/'.$pim['image_path'];
                            $dimens = GetImageSize($filenm);
                            if ($dimens[0] > 130) {
                                $dimens[0] = $dimens[0] + 50;
                                $dimens[1] = $dimens[1] + 80;
                            } else {
                                $dimens[0] = 200;
                                $dimens[1] = 200;
                            }


                            echo '<div>
                                <a href="javascript:void(0);" onClick="openwin(`'.SITE_ADMIN_URL.'/popup_new.php?img=products/'.$pim['image_path'].'`, '.$dimens[0].', '.$dimens[1].')" class="linkgray fontbold">
                                <img src="'.site_url.'/uploaded-files/products/'.$pim['image_path'].'">
                            </a>';
                            echo '<p class="text-center"><a class="deleteImg" href="'.SITE_ADMIN_URL.'/form_page.php?remove_imageId='.$pim['image_id'].'" title="Remove Image"><i class="fa fa-trash"></i></a></p></div>';
                        }
                    ?>
                </div>
            </div>
            <div class="form-group">
                <div>
                    <input type="hidden" name="attr_mainid">
                </div>
                <h4>Select Attributes</h4>
                <?php 
                    $product_atrribute = mysqli_query($dbconn, "SELECT attribute_id FROM tbl_product_attributes WHERE product_id=".$_REQUEST['pid']);
                    $pa_array = [];
                    while($ex_atr = mysqli_fetch_array($product_atrribute)){
                        $pa_array[] = $ex_atr['attribute_id'];
                    }
                    foreach($attributes_array[0] as $atr){
                ?>
                <div class="border-bottom mb-2">
                    <label><?= $attributes[$atr]['attributes_name']; ?></label>
                    <div class="ml-3">
                        <?php foreach($attributes_array[$atr] as $subatr){ ?>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" name="attrbid[]" type="checkbox" id="atrinpt_<?= $subatr;?>" value="<?= $subatr;?>" <?= in_array($subatr, $pa_array)?'checked':'';  in_ar ?>>
                            <label class="form-check-label" for="atrinpt_<?= $subatr;?>"><?= $attributes[$subatr]['attributes_name']; ?></label>
                        </div>
                        <?php } ?>
                        
                    </div>
                </div>
                <?php } ?>
            </div>
            
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">Save changes</button>
            <input type="hidden" name="update_product" value="<?= $qry['product_id'] ?>">
            <a href="<?= SITE_ADMIN_URL."/products.php"?>" class="btn btn-secondary text-white" data-dismiss="modal">Close</a>
        </div>
    </form>


<script src="jquery.min.js"></script>

<?php admin_footer(); ?>
<script>
    function RemoveHighlites(elm){
        $(elm).closest('.row').remove();
        let sn = 1;
        $('#heighlites .high-sn').each(function(){
            $(this).text(sn++ +'.');
        });
    }

    $(document).ready(function(){

        $('#addHfield').click(function(e){
            e.preventDefault();
            let sn = 1;
           
            let html = '<div class="row mt-1"><div class="col-1 high-sn"></div><div class="col-10"><input type="text" name="heighlite[]" placeholder="Enter heighlites" class="form-control form-control -sm"></div><div class="col-1"><a class="remove-height" onclick="RemoveHighlites(this)" href="#"><i class="fa fa-times"></i></a></div></div>';
            $('#heighlites').append(html);
            $('#heighlites .high-sn').each(function(){
                $(this).text(sn++ +'.');
            });

        });


        $('.deleteImg').click(function(e){
            e.preventDefault();
            if(confirm('Are you sure to delete this image?') == true){
                let elm = $(this);
                $.ajax({
                    url: elm.attr('href'),
                    type: 'get',
                    success: function(r){
                        elm.parent().parent().remove();
                    }
                });
            }
        });



        $("#prevMulti").on("change", function(e) {
            //$("#productImage").empty();//you can remove this code if you want previous user input
            for(let i=0;i<this.files.length;++i){
                let filereader = new FileReader();
                let $img=jQuery.parseHTML("<img src=''>");
                filereader.onload = function(){
                    $img[0].src=this.result;
                };
                filereader.readAsDataURL(this.files[i]);
                $("#productImage").append($img);
            }
        });

        $('input[name=price]').keyup(function(){
            let mrp = parseInt($('input[name=mrp]').val());
            let price = parseInt($('input[name=price]').val());
            let discount = 0;
            if(price > 0){
                let diff = mrp-price;
                if(diff > 0){
                    discount = ((diff*100)/mrp).toFixed(2);
                }else{
                    discount = 0;
                }
                $('input[name=discount]').val(discount);
            }            
        });

        $('input[name=discount]').keyup(function(){
            let mrp = parseInt($('input[name=mrp]').val());
            let discount = parseFloat($('input[name=discount]').val()).toFixed(2);
            let price = 0;
            if(discount > 0){
                let price = ((mrp*discount)/100);
                $('input[name=price]').val((mrp-price).toFixed(2));
            }            
        });

    });

    var editor = CKEDITOR.replace( 'full_desc' );
    editor.on( 'change', function( evt ) {
        $('#full_desc').val(evt.editor.getData());
    });
</script>