<?php
include_once("include/main.inc.php");
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
require 'razorpay/vendor/autoload.php';

use Razorpay\Api\Api;

$paymentId = $_POST['razorpay_payment_id'];
$orderId   = $_POST['razorpay_order_id'];
$signature = $_POST['razorpay_signature'];
// Fetch full payment details
$api = new Api(RZP_KEY_ID, RZP_SECRET_ID);

$attributes = [
    'razorpay_order_id'   => $orderId,
    'razorpay_payment_id'=> $paymentId,
    'razorpay_signature' => $signature
];
// $payment = $api->payment->fetch($paymentId);

// Print everything
// echo "<pre>";
// print_r($payment->toArray());
// echo "</pre>";
// exit;
try {
    $api->utility->verifyPaymentSignature($attributes);
    $payment = $api->payment->fetch($paymentId)->toArray();

    // Extract useful fields safely
    $status  = $payment['status'];               // captured
    $method  = $payment['method'];               // card / upi
    $bank    = $payment['bank'] ?? null;
    $vpa     = $payment['vpa'] ?? null;
    $last4   = $payment['card']['last4'] ?? null;
    $email   = $payment['email'] ?? null;
    $contact = $payment['contact'] ?? null;
    $receivedAmount = $payment['amount'];
    $receivedAmountRs = $receivedAmount / 100;
    // Save complete response (recommended)
    $fullResponse = json_encode($payment);

    // ✅ UPDATE ORDER TABLE
    $stmt = $dbconn->prepare("
        UPDATE orders_tbl SET
            transaction_id = ?,
            payment_status = ?,
             received_amount = ?,
            payment_method = ?,
            bank = ?,
            vpa = ?,
            card_last4 = ?,
            razorpay_response = ?,
            paid_at = NOW()
        WHERE razorpay_order_id = ?
    ");

    $stmt->bind_param("sssssssss",$paymentId,$status,$receivedAmountRs,$method,$bank,$vpa,$last4,$fullResponse,$orderId);

    $stmt->execute();
    // 2️⃣ CLEAR CART & ORDER SESSION

    $numcount_res=mysqli_fetch_assoc(mysqli_query($GLOBALS['dbconn'],"Select * from orders_tbl Where razorpay_order_id='$orderId'"));
    $product_sql=mysqli_query($GLOBALS['dbconn'],"Select * from order_details Where order_id='".$numcount_res['order_id']."'");
    $itemRows = '';
    $grandTotal = 0;

        while($item=mysqli_fetch_assoc($product_sql)) {
            $itemName  = htmlspecialchars($item['product_name']);
            $qty       = $item['qty'];
            $price     = $item['item_price'];
            $total     = $qty * $price;
            $grandTotal += $total;

            $itemRows .= '
                <tr>
                    <td>' . $itemName . '</td>
                    <td>' . $qty . '</td>
                    <td>₹' . $total . '</td>
                </tr>
            ';
        }
    $isCOD = ($numcount_res['payment_mode'] === 'COD'); // adjust as per your logic

    $advancePercent = 3;
    $advanceAmount = round(($grandTotal * $advancePercent) / 100, 2);
    $balanceCOD = $grandTotal - $advanceAmount;
    $invoiceName=$numcount_res['invoice_no'];
    $userID=$numcount_res['user_id'];
    $customer_res= mysqli_fetch_assoc(mysqli_query($GLOBALS["dbconn"],"Select user_id,user_name,user_email,user_mobile from user_tbl where user_id='$userID'"));
      $to = $admin_res['email'];

        $to2 = $admin_res['cc'];

       $to3 = 'webpulseindia@gmail.com'; 

    
      $subject="Your SK Infosolutions order confirmation $invoiceName";
      $htmlContent = '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333333; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; border: 1px solid #eeeeee; }
        .header { background-color: #ffffff; padding: 20px; text-align: center; border-bottom: 3px solid #00AEEF; }
        .logo { max-width: 180px; }
        .content { padding: 30px; }
        .order-summary { background-color: #f9f9f9; padding: 20px; border-radius: 8px; margin-top: 20px; }
        .button { display: inline-block; padding: 12px 25px; background-color: #00AEEF; color: #ffffff !important; text-decoration: none; border-radius: 5px; font-weight: bold; margin-top: 20px; }
        .footer { background-color: #f1f1f1; padding: 20px; text-align: center; font-size: 12px; color: #777777; }
        .status-badge { color: #ED1C24; font-weight: bold; }
        .item-table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        .item-table th { text-align: left; border-bottom: 1px solid #ddd; padding: 10px 0; }
        .item-table td { padding: 10px 0; border-bottom: 1px solid #eee; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="https://www.selold.com/uploaded-files/logo/logo.png" alt="SK Infosolutions" class="logo">
        </div>

        <div class="content">
            <h2>Order Confirmed!</h2>
            <p>Hi ' . $numcount_res['name'] . ',</p>
            <p>We have successfully received your order. Our team is currently reviewing the details and will proceed with the next steps shortly.</p>
            
            <div class="order-summary">
                <strong>Order ID:</strong> ' . $invoiceName . '<br>
                <strong>Order Date:</strong> ' . date('F d, Y') . '<br>
                <strong>Order Status:</strong> <span class="status-badge">Processing</span>
            </div>
            ' . ($isCOD ? '
            <div class="order-summary" style="margin-top:15px;">
                <strong>Payment Method:</strong> Cash on Delivery (COD)<br>
                <strong>Advance Paid (3%):</strong> ₹' . number_format($advanceAmount, 2) . '<br>
                <strong>Payable on Delivery:</strong> ₹' . number_format($balanceCOD, 2) . '
            </div>

            <p style="font-size:14px; color:#555;">
                <em>
                As per our COD policy, a 3% advance payment has been collected online to confirm your order.
                The remaining amount is payable in cash at the time of delivery.
                </em>
            </p>
            ' : '') . '
            <table class="item-table">
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Qty</th>
                        <th>Price</th>
                    </tr>
                </thead>
                <tbody>
                    ' . $itemRows . '
                </tbody>
              <tfoot>
                <tr>
                    <td colspan="2" style="text-align:right;"><strong>Order Total:</strong></td>
                    <td><strong>₹' . number_format($grandTotal, 2) . '</strong></td>
                </tr>

                ' . ($isCOD ? '
                <tr>
                    <td colspan="2" style="text-align:right;">Advance Paid (3%):</td>
                    <td>₹' . number_format($advanceAmount, 2) . '</td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align:right;"><strong>Pay on Delivery:</strong></td>
                    <td><strong>₹' . number_format($balanceCOD, 2) . '</strong></td>
                </tr>
                ' : '') . '
            </tfoot>

            </table>

            <center>
                <a href="https://www.selold.com/account/orders" class="btn button">View My Order</a>
            </center>
        </div>

        <div class="footer">
            <p><strong>SK Infosolutions</strong><br>
            Buy | Sell | Repair Old Gadgets</p>
            <p>Visit us: <a href="https://www.selold.com/">www.selold.com</a></p>
            <p>&copy; ' . date('Y') . ' SK Infosolutions. All rights reserved.</p>
        </div>
    </div>
</body>
</html>';
  if($to!='')

         {

         smtp_mailer($to, $email, $name, $subject, $htmlContent);

         }

         if($to2!='')

         {

         smtp_mailer($to2, $email, $name, $subject, $htmlContent);

         }

     smtp_mailer($to3, $email, $name, $subject, $htmlContent);
smtp_mailer($customer_res['user_email'], $email, $name, $subject, $htmlContent); //email for customer
    unset($_SESSION['cart']);
    unset($_SESSION['local_order_id']);
    unset($_SESSION['razorpay_order_id']);
    unset($_SESSION['order_amount']);
    echo json_encode([
        'status' => 'success',
        'order_no' => $orderId
       
    ]);

} catch (Exception $e) {
    // ❌ PAYMENT FAILED
     $stmt = $dbconn->prepare("UPDATE orders_tbl SET payment_status = 'failed' WHERE razorpay_order_id = ? ");
    $stmt->bind_param("s", $orderId);
    $stmt->execute();

   echo json_encode([
    'status' => 'failed',
    'order_no' => $orderNo,
    'error' => 'verification_failed'
]);
}
?>