<?php
$id = base64_decode($_GET['id']);
echo $id;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmed | SK Infosolutions</title>
    <style>
        :root {
            --primary-blue: #00AEEF; /* Matches the 'SEL' blue */
            --accent-red: #ED1C24;   /* Matches the red dot */
            --text-dark: #1A1A1A;
            --bg-light: #f9f9f9;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-light);
            color: var(--text-dark);
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .thank-you-card {
            background: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            max-width: 600px;
            width: 90%;
            text-align: center;
        }

        .logo {
            max-width: 200px;
            margin-bottom: 20px;
        }

        .success-icon {
            width: 80px;
            height: 80px;
            background: #e6f7ff;
            color: var(--primary-blue);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            margin: 0 auto 20px;
        }

        h1 {
            color: var(--text-dark);
            margin-bottom: 10px;
            font-size: 28px;
        }

        p {
            color: #666;
            line-height: 1.6;
        }

        .order-box {
            background: #fdfdfd;
            border: 1px dashed #ddd;
            padding: 20px;
            border-radius: 8px;
            margin: 25px 0;
            text-align: left;
        }

        .order-id {
            color: var(--primary-blue);
            font-weight: bold;
        }

        .btn-container {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 30px;
        }

        .btn {
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 6px;
            font-weight: 600;
            transition: 0.3s;
        }

        .btn-primary {
            background-color: var(--primary-blue);
            color: white;
        }

        .btn-primary:hover {
            background-color: #008cc0;
        }

        .btn-outline {
            border: 2px solid #ddd;
            color: #555;
        }

        .btn-outline:hover {
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }

        .footer-note {
            font-size: 14px;
            margin-top: 30px;
            border-top: 1px solid #eee;
            padding-top: 20px;
        }

        .red-dot {
            color: var(--accent-red);
        }
    </style>
</head>
<body>

    <div class="thank-you-card">
        <img src="https://www.selold.com/uploaded-files/logo/logo.png" alt="SK Infosolutions Logo" class="logo">
        
        <div class="success-icon">✓</div>
        
        <h1>Order Placed Successfully<span class="red-dot">!</span></h1>
        <p>Thank you for choosing <strong>SK Infosolutions</strong>. Your gadgets are in good hands. We have sent a confirmation email to your registered address.</p>

        <div class="order-box">
            <strong>Order ID:</strong> <span class="order-id">#SK-992834</span><br>
            <strong>Estimated Delivery:</strong> 3-5 Business Days<br>
            <strong>Status:</strong> Processing
        </div>

        <div class="btn-container">
            <a href="https://www.selold.com/" class="btn btn-primary">Continue Shopping</a>
            <a href="#" class="btn btn-outline">Track Order</a>
        </div>

        <div class="footer-note">
            <p>Questions? Contact us at <a href="mailto:support@selold.com" style="color: var(--primary-blue);">support@selold.com</a></p>
            <p><small>&copy; 2025 SK Infosolutions | www.selold.com</small></p>
        </div>
    </div>

</body>
</html>