<?php 
include_once("include/main.inc.php"); 
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Shipping Policy</title>
    <meta name="keywords" content="" />
    <meta name="description" content="" />
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>
    <section class="heading_banner">
        <div class="container">
            <h1 class="cat_title">Shipping Policy</h1>
            <div class="clearfix"></div>
            <div class="inner_breadcrumb">
                <ul class="breadcrumb">
                    <li><a href="index.php" title="Home">Home</a></li>
                    <li class="active">Shipping Policy</li>
                </ul>
            </div>
        </div>
    </section>


    <section class="about_page terms-conditions">
        <div class="container">
           
        <h2>Shipping Policy – Selold.com</h2>

<p>At <strong>Selold.com</strong>, we aim to deliver high-quality refurbished laptops and electronics safely, quickly, and reliably across India. Please read our shipping policy carefully to understand how orders are processed and delivered.</p>

<h3>1. Shipping Locations</h3>
<p>We currently ship across India, including major cities, towns, and select rural areas. Delivery availability may vary depending on courier service coverage.</p>

<h3>2. Order Processing Time</h3>
<ul>
  <li>All orders are processed within <strong>1–2 business days</strong> after payment confirmation.</li>
  <li>Orders placed on Sundays or public holidays will be processed on the next working day.</li>
  <li>Each refurbished laptop undergoes quality checks and secure packaging before dispatch.</li>
</ul>

<h3>3. Estimated Delivery Time</h3>
<ul>
  <li><strong>Metro Cities:</strong> 3–6 business days</li>
  <li><strong>Non-Metro Cities &amp; Towns:</strong> 4–7 business days</li>
  <li><strong>Remote Locations:</strong> 5–8 business days</li>
</ul>
<p>Delivery timelines are approximate and may vary due to courier delays, weather conditions, or unforeseen circumstances.</p>

<h3>4. Shipping Charges</h3>
<ul>
  <li><strong>Free Shipping</strong> on prepaid orders and promotional offers.</li>
  <li>In case of <strong>Cash on Delivery (COD)</strong>, a booking amount may be required in advance as a booking confirmation.</li>
  <li>Standard shipping charges (if applicable) will be clearly mentioned at checkout before payment.</li>
</ul>

<h3>5. Courier Partners</h3>
<p>We work with trusted logistics partners to ensure safe and timely delivery of your order. Tracking details will be shared via SMS or email once the order is dispatched.</p>

<h3>6. Order Tracking</h3>
<p>Once your order is shipped, you will receive:</p>
<ul>
  <li>A tracking ID</li>
  <li>Courier partner details</li>
</ul>
<p>You can track your shipment online until delivery.</p>

<h3>7. For Any Shipping-Related Queries</h3>
<p>Feel free to contact us:</p>
<ul>
  <li><strong>Website:</strong> <a href="https://www.selold.com" target="_blank">https://www.selold.com</a></li>
  <li><strong>Email:</strong> <a href="mailto:info@selold.com">info@selold.com</a></li>
  <li><strong>Phone:</strong> <a href="tel:9205237575">9205237575</a></li>
</ul>

        </div>
    </section>

    <!-- <?php include 'app_clients.php'; ?> -->
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>