<?php
include_once("include/main.inc.php");
if (isset($_GET['ref'])) {
    $_SESSION['account_referral_url'] = $_GET['ref'];
}
$page_metatitle = "Register - " . $admin_res['companyName'];
$page_metakey = "Register - " . $admin_res['companyName'];
$page_metadesc = "Register - " . $admin_res['companyName'];
if (isset($_SESSION['USER_LOGIN']) && $_SESSION['USER_LOGIN'] == 'yes') {
    header('Location: '.site_url.'/my-account.htm');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>

    <div class="inner_breadcrumb2 inner_breadcrumb bg2">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                <li class="active">Register</li>
            </ul>
        </div>
    </div>

    <div class="loginPage">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="loginPanel">
                        <div class="text-center">
                            <h2>Create Your Profile</h2>
                            <p>Sign up to experience our services.</p>
                        </div>
                        <form id="register_form" name="register_form" method="POST">
                            <div id="register_response"></div>
                            <div class="form-group">
                                <label>Name<span>*</span></label>
                                <input class="form-control" name="user_name" onkeyup="validateOnlyTextField(this)" type="text" required="required" value="">
                            </div>

                            <div class="form-group">
                                <label>Email ID <span>*</span></label>
                                <input class="form-control" name="user_email" type="email" required="" value="">
                            </div>

                            <div class="form-group">
                                <label>Mobile Number<span>*</span></label>
                                <input class="form-control telePhone" type="tel" name="user_mobile" minlength="10" maxlength="10" onkeyup="this.value=this.value.replace(/[^0-9]/g,'')">
                                <input type="hidden" name="countryName" class="countryName" value="India">
                                <input type="hidden" name="code" class="code" value="91">
                            </div>

                            <div class="form-group">
                                <label>Password <span>*</span></label>
                                <input class="form-control" name="password" type="password" required="" value="">
                            </div>

                            <div class="form-group">
                                <label>Confirm Password<span>*</span></label>
                                <input class="form-control" name="cpassword" type="password" required="required">
                            </div>

                            <div class="form-group">
                                <label><input type="checkbox" name="terms" id="terms" checked="" required> I agree to the <a class="terms_conditions" href="#" target="_blank">Terms and Conditions</a>
                                </label>
                            </div>

                            <button type="submit" name="register_submit" class="moreBtn">Create Account</button>

                            <div class="loginBottom">
                                <span>You Already have an account<a href="login.php"><strong>Login Here</strong></a></span>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
    <script>
//register form
 $(document).ready(function () {
    $("#register_form").validate({
        rules: {
            user_name: "required",
            user_email: {
                required: true
            },
            password: {
                required: true,
                minlength: 6
            },
            cpassword: {
                required: true,
                minlength: 6
            },
            user_mobile: {
                required: true,
                number: true,
                minlength: 10,
                maxlength: 12
            },
            terms: {          // ✅ checkbox rule
                required: true
            }
        },
        messages: {
            user_name: "Please enter your name",
            user_email: {
                required: "Please enter your email address"
            },
            password: {
                required: "Please enter password",
                minlength: "Your Password must be 6 Character Long"
            },
            cpassword: {
                required: "Please enter confirm password",
                minlength: "Your Confirm Password must be 6 Character Long"
            },
            user_mobile: {
                required: "Please enter your mobile no.",
                number: "Mobile No. contains only numbers",
                minlength: "Your Mobile No. must be 10 digits long",
                maxlength: "Your Mobile No. must be 10 - 12 digits long"
            },
            terms: {          // ✅ checkbox message
                required: "Please agree to the Terms & Conditions"
            }
        },

        // ✅ Proper error placement for checkbox
        errorPlacement: function (error, element) {
            if (element.attr("type") === "checkbox") {
                error.insertAfter(element.closest('label'));
            } else {
                error.insertAfter(element);
            }
        },

        submitHandler: function (form) {
            $.ajax({
                url: '<?= site_url; ?>/ajax_register.php',
                type: 'POST',
                data: $('#register_form').serialize(),
                dataType: 'json',
                success: function (result) {
                    if (result.status === true) {
                        $('#register_response')
                            .text(result.message_response)
                            .css('color', 'green');
                        $('#register_form')[0].reset();
                        if (result.redirect_url != '') {
                            window.location.href = result.redirect_url;
                        }
                    } else {
                        $('#register_response')
                            .text(result.message_response)
                            .css('color', 'red');
                        // if (result.redirect_url !== '') {
                        //     window.location.href = result.redirect_url;
                        // }
                    }
                }
            });
        }
    });
});

        </script>
</body>

</html>