<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Product Detail</title>
    <meta name="keywords" content="" />
    <meta name="description" content="" />
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php
        if(isset($ca_nam1)){
            include "app_header_sub.php"; 
        } else{
            include "app_header.php"; 
        }
    ?>
    <div class="inner_breadcrumb2 inner_breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                <?php if ($brdc2) { ?>
                    <li>
                        <a href="<?= site_url; ?>/<?= getValidFileName($brdc2['catName']); ?>.htm" title="<?= $brdc2['catName']; ?> "><?= $brdc2['displayName']; ?></a>
                    </li>
                <?php } ?>
                <?php if ($brdc1) { ?>
                    <li>
                        <a href="<?= site_url; ?>/<?= getValidFileName($brdc1['catName']); ?>.htm" title="<?= $brdc1['catName']; ?>"><?= $brdc1['displayName']; ?></a>
                    </li>
                <?php } ?>
                <?php if ($brdc) { ?>
                    <li>
                        <a href="<?= site_url; ?>/<?= getValidFileName($brdc['catName']); ?>.htm" title="<?= $brdc['catName']; ?> "><?= $brdc['displayName']; ?></a>
                    </li>
                <?php } ?>
                <li class="active"><?= $product['product_title']; ?></li>
            </ul>
        </div>
    </div>

    <section class="product_listing">
        <div class="container">
            <div class="row">
                <div class="col-md-5 col-12">
                    <div class="app-figure" id="zoom-fig">
                        <div class="details_zoom">
                            <div class="row">
                                <?php
                                $image_path = explode(',', $product['product_image']);
                                ?>
                                <div class="col-md-10 col-12 order-md-2">
                                    <a id="Zoom-1" class="MagicZoom" title="" href="<?= site_url . '/uploaded-files/product-images/' . $image_path[0]; ?>" data-options="zoomWidth:500px; zoomHeight:500px">
                                        <span class="fl-stock bg-success"><?= ($product['quantity'] > 0) ? 'In stock' : 'Out of stock'; ?></span>
                                        <img src="<?= site_url . '/uploaded-files/product-images/' . $image_path[0]; ?>" alt="" />
                                    </a>
                                </div>
                                <div class="col-md-2 col-12 order-md-1 pt-3 pt-md-0 pe-md-0">
                                    <div class="selectors d-flex d-md-block gap-1">
                                        <?php
                                        $sn=1;
                                        foreach ($image_path as $img) {
                                            $img_thumb = getImage($img, 70, 70, $sub_res['catName'].$sn, "/uploaded-files/product-images/");
                                        ?>
                                            <a data-zoom-id="Zoom-1" href="<?= site_url . '/uploaded-files/product-images/' . $img; ?>" data-image="<?= $img; ?>?scale.height=400" class="<?= ($image_path[0] == $img) ? 'mz-thumb-selected' : ''; ?>">
                                                <img srcset="<?= $img_thumb ?>?scale.width=112 2x" src="<?= $img_thumb; ?>?scale.width=56" />
                                            </a>
                                        <?php $sn++;} ?>
                                        <!-- <a data-zoom-id="Zoom-1" href="designer/images/buy-laptop/acer.png" data-image="designer/images/buy-laptop/acer.png?scale.height=400">
                                            <img srcset="designer/images/buy-laptop/acer.png?scale.width=112 2x" src="designer/images/buy-laptop/acer.png?scale.width=56" />
                                        </a>
                                        <a data-zoom-id="Zoom-1" href="designer/images/buy-laptop/dell.png" data-image="designer/images/buy-laptop/dell.png?scale.height=400">
                                            <img srcset="designer/images/buy-laptop/dell.png?scale.width=112 2x" src="designer/images/buy-laptop/dell.png?scale.width=56" />
                                        </a>
                                        <a data-zoom-id="Zoom-1" href="designer/images/buy-laptop/acer.png" data-image="designer/images/buy-laptop/acer.png?scale.height=400">
                                            <img srcset="designer/images/buy-laptop/acer.png?scale.width=112 2x" src="designer/images/buy-laptop/acer.png?scale.width=56" />
                                        </a> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-7 col-12">
                    <div class="product_details">
                        <form action="">
                            <h1 class="protitle"><?= $product['product_title'] ?></h1>
                            <div class="sub-tt"><?= $product['product_specfi'] ?></div>
                            <div class="price mb-2 fs-5">
                                <span class="old_price"><i class="fa fa-inr"></i> <?= $product['mrp'] * 1; ?></span>
                                <i class="fa fa-inr"></i><?= $product['product_price'] * 1; ?>
                                <?php if ($product['discount'] > 0) { ?><div class="off_label"><?= $product['discount'] * 1; ?>% off</div><?php } ?>
                            </div>


                            <?php
                            $attribute_tbl = mysqli_query($dbconn, "SELECT * FROM tbl_attributes WHERE status=1");
                            $attributes_array = $attributes = $brands_array = [];
                            while ($atrb = mysqli_fetch_array($attribute_tbl)) {
                                $attributes[$atrb['attributes_id']] = $atrb;
                                $attributes_array[$atrb['parent_id']][] = $atrb['attributes_id'];
                            }


                            $prdatr = [];
                            if (!empty($product['attributes_id'])) {
                                foreach (explode(',', $product['attributes_id']) as $atr) {
                                    $prdatr[$attributes[$atr]['parent_id']][] = $attributes[$atr]['attributes_name'];
                                }
                            }
                            ?>

                            <ul class="_1xgFaf">
                                <?php 
                                    foreach ($prdatr as $at_key => $at_v) { 
                                        if(isset($attributes[$at_key])){
                                ?>
                                    <li class="rgWa7D">
                                        <b><?= $attributes[$at_key]['attributes_name']; ?></b>:
                                        <?php foreach ($at_v as $single_atrb) {
                                            echo $single_atrb;
                                        } ?>
                                    </li>
                                <?php }} ?>
                            </ul>

                            <div class="tt">Condition:</div>
                            <ul class="con-items">
                                <li class="con-item active"><?= $product['product_condition'] ?></li>
                            </ul>
                            <?php $product['product_keyfeatures'] ?>
                            <ul class="con-li">
                                <li>No functional defects</li>
                                <li>Minor scratches & dents on body</li>
                                <li>With compatible charger</li>
                            </ul>

                            <?php
                            $prd_info = '';
                            foreach ($prdatr as $at_key => $at_v) {
                                $prd_info .= '<li>' . $attributes[$at_key]['attributes_name'] . ': ';
                            ?>
                                <!-- <div class="tt"><?= $attributes[$at_key]['attributes_name']; ?>: </div>
                            <ul class="con-items">
                                <?php
                                foreach ($at_v as $single_atrb) {
                                    $prd_info .= $single_atrb;
                                    echo '<li class="con-item">' . $single_atrb . '</li>';
                                }
                                $prd_info .= '</li>';
                                ?>
                            </ul> -->
                            <?php } ?>
                            <!-- <div class="tt">Storage:</div>
                            <ul class="con-items">
                                <li class="con-item active">8 GB / 128 GB SSD</li>
                                <li class="con-item">16 GB / 512 GB SSD</li>
                            </ul>
                            <div class="tt">Operating System:</div>
                            <ul class="con-items">
                                <li class="con-item active">Windows</li>
                            </ul> -->



                            <div class="btn-grp ">
                                <a class="moreBtn" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#productID" title="Enquire Now" data-title="<?= $product['product_title'] ?>" data-info="<?= $prd_info; ?>" data-img="<?= site_url . '/uploaded-files/product-images/' . $image_path[0]; ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414.05 3.555ZM0 4.697v7.104l5.803-3.558L0 4.697ZM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586l-1.239-.757Zm3.436-.586L16 11.801V4.697l-5.803 3.546Z"></path>
                                    </svg> Enquire Now
                                </a>

                                <a class="w-btn" href="#whatsapp" data-bs-toggle="modal" title="Whatsapp Now"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z">
                                    </path>
                                </svg></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="product_overview mt-4">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">Product Details</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab" tabindex="0">
                        <div class="bx-title">Overview</div>
                        <p><?= $product['product_specfi'] ?></p>
                        <div class="bx-title">Quick Details</div>
                        <div class="quick_details">
                            <?php $product['product_otherdetails'] ?>
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <dl class="dl-horizontal">
                                        <dt>Processor:</dt>
                                        <dd>Intel® Core™ i5</dd>
                                        <dt>Operating System:</dt>
                                        <dd>Windows 10</dd>
                                        <dt>Display:</dt>
                                        <dd>13" display with large screen-to-body ratio</dd>
                                        <dt>Memory:</dt>
                                        <dd>8 GB RAM</dd>
                                    </dl>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <dl class="dl-horizontal">
                                        <dt>Storage:</dt>
                                        <dd>128GB M.2 PCIe</dd>
                                        <dt>Battery:</dt>
                                        <dd>5.3 hours, 38Whr (MM18)</dd>
                                        <dt>Weight:</dt>
                                        <dd>1.7kg / 3.74lbs</dd>
                                        <dt>Color / Finish:</dt>
                                        <dd>Space Grey, with in-mould rolling finish</dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="homeFeture pt-0">
        <div class="container">
            <div class="row">
                <div class="shop-sec">
                    <div class="shop-title mb-4">
                        <div class="tt-bx text-start">
                            <h4 class="tt">Top <span> Selling laptops</span></h4>
                            <p class="m-0 text-start">Upgrade affordably with our quality refurbished laptops. Explore options now!</p>
                        </div>
                    </div>
                    <div class="owl-carousel featuredProducts ">
                        <?php
                        $allbrand = mysqli_query($GLOBALS['dbconn'], "select product_name, product_title, product_image from product_tbl where product_status=1 and product_id!=".$product['product_id']);
                        while ($ab = mysqli_fetch_array($allbrand)) {
                            $ab_img = explode(',', $ab['product_image']);
                            $ab_thumb = getImage($ab_img[0], 182, 182, $ab['product_title'], "/uploaded-files/product-images/");
                        ?>
                        <div class="productBox">
                            <div class="productImg">
                                <a href="<?=site_url;?>/<?=getValidFileName($ab['product_name']);?>.htm">
                                    <img src="<?= $ab_thumb?>" alt="<?= $ab['product_title']; ?>" title="<?= $ab['product_title']; ?>">
                                </a>
                            </div>
                            <div class="productContent">
                                <div class="title"><?= $ab['product_title']; ?></div>
                            </div>
                        </div>
                        <?php } ?>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php 
         $catid = explode(',', $product['product_cat']);
         $inset = '';
         foreach($catid as $cid){
             $inset .= "FIND_IN_SET('".$cid."', product_cat) OR ";
         }
         
         $samebrand = mysqli_query($GLOBALS['dbconn'], "select product_name, product_title, product_image from product_tbl where (".rtrim($inset, 'OR ').") and product_status=1 and product_id!=".$product['product_id']);

         if(mysqli_num_rows($samebrand) > 0){

    ?>

    <div class="homeFeture pt-0">
        <div class="container">
            <div class="row">
                <div class="shop-sec">
                    <div class="shop-title mb-4">
                        <div class="tt-bx text-start">
                            <h4 class="tt">Top <span> Selling  <?= $brdc['displayName']; ?> Laptops</span></h4>
                            <p class="m-0 text-start">Upgrade affordably with our quality refurbished laptops. Explore options now!</p>
                        </div>
                    </div>
                    <div class="owl-carousel featuredProducts ">
                        <?php
                       
                        while ($ab = mysqli_fetch_array($samebrand)) {
                            $ab_img = explode(',', $ab['product_image']);
                            $ab_thumb = getImage($ab_img[0], 182, 182, $ab['product_title'], "/uploaded-files/product-images/");
                        ?>
                        <div class="productBox">
                            <div class="productImg">
                                <a href="<?=site_url;?>/<?=getValidFileName($ab['product_name']);?>.htm">
                                    <img src="<?= $ab_thumb?>" alt="<?= $ab['product_title']; ?>" title="<?= $ab['product_title']; ?>">
                                </a>
                            </div>
                            <div class="productContent">
                                <div class="title"><?= $ab['product_title']; ?></div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <div class="homeFeture pt-0">
        <div class="container">
            <div class="row">
                <div class="shop-sec">
                    <div class="shop-title mb-4">
                        <div class="tt-bx text-start">
                            <h5 class="tt">Top <span> Selling Brands</span></h5>
                            <p class="m-0 text-start">Upgrade affordably with our quality refurbished laptops. Explore options now!</p>
                        </div>
                    </div>

                    <div id="featuredProducts2" class="owl-carousel featuredProducts ">
                        <?php
                        $relBrand = mysqli_query($GLOBALS['dbconn'], "select catImage, catName, displayName, catDesc, catID, catDesc1,catBanner, parentID,homeTitle,catHomeImage from category_tbl where parentID=1 and status='Y' order by catOrder ASC");
                        while ($sub_res = mysqli_fetch_array($relBrand)) {
                            $file_ext = explode('.', $sub_res['catImage']);
                            $file_extention = $file_ext['1'];

                            if ($sub_res['catHomeImage'] != '') {
                                $img_link = getImage($sub_res['catHomeImage'], 300, 300, $sub_res['catName'], "/uploaded-files/category/images/");
                            } elseif ($sub_res['catImage'] != '') {
                                if ($file_extention == 'PNG' || $file_extention == 'png') {
                                    $img_link = site_url . '/uploaded-files/category/images/' . $sub_res['catImage'];
                                } else {
                                    $img_link = getImage($sub_res['catImage'], 300, 300, $sub_res['catName'], "/uploaded-files/category/images/");
                                }
                            } else {
                                $img_link = getImage("noimage.jpg", 300, 300, "noimages", "/uploaded-files/category/images/");
                            }
                            $headingTitle = ($sub_res['homeTitle'] != '') ? $sub_res['homeTitle'] : $sub_res['catName'];
                        ?>
                            <div class="productBox">
                                <a href="<?= site_url; ?>/<?= getValidFileName($sub_res['catName']); ?>.htm" title="<?= $sub_res['displayName']; ?>  in <?= $admin_res['targetlocation']; ?>">
                                    <div class="productImg">
                                        <img src="<?= $img_link; ?>" alt="<?= $sub_res['catName']; ?>  in <?= $admin_res['targetlocation']; ?>" title="<?= $sub_res['catName']; ?>  in <?= $admin_res['targetlocation']; ?>">
                                    </div>
                                    <div class="productContent">
                                        <div class="title"><?= $sub_res['displayName']; ?></div>
                                    </div>
                                </a>
                            </div>
                        <?php } ?>
                        <!-- <div class="pro-bx">
                            <div class="pro-img">
                                <a href="">
                                    <img src="designer/images/buy-laptop/asus.png" alt="">
                                </a>
                            </div>
                            <div class="pro-des">
                                <div class="title">Asus laptops</div>
                            </div>
                        </div>
                        <div class="pro-bx">
                            <div class="pro-img">
                                <a href="">
                                    <img src="designer/images/buy-laptop/dell.png" alt="">
                                </a>
                            </div>
                            <div class="pro-des">
                                <div class="title">Dell laptops</div>
                            </div>
                        </div>
                        <div class="pro-bx">
                            <div class="pro-img">
                                <a href="">
                                    <img src="designer/images/buy-laptop/hp.png" alt="">
                                </a>
                            </div>
                            <div class="pro-des">
                                <div class="title">HP laptops</div>
                            </div>
                        </div>
                        <div class="pro-bx">
                            <div class="pro-img">
                                <a href="">
                                    <img src="designer/images/buy-laptop/lenovo.png" alt="">
                                </a>
                            </div>
                            <div class="pro-des">
                                <div class="title">Lenovo laptops</div>
                            </div>
                        </div>
                        <div class="pro-bx">
                            <div class="pro-img">
                                <a href="">
                                    <img src="designer/images/buy-laptop/mac-book.png" alt="">
                                </a>
                            </div>
                            <div class="pro-des">
                                <div class="title">Apple Macbook</div>
                            </div>
                        </div>
                        <div class="pro-bx">
                            <div class="pro-img">
                                <a href="">
                                    <img src="designer/images/buy-laptop/mac.png" alt="">
                                </a>
                            </div>
                            <div class="pro-des">
                                <div class="title">iMac</div>
                            </div>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

<script>
    $(document).ready(function() {
        $('.moreBtn').click(function() {
            $('#productID .pro-modal .tt').text($(this).data('title'));
            $('#productID .pro-modal ul.con-li').html($(this).data('info'));
            $('#productID .pro-modal .img-bx img').prop('src', $(this).data('img'));
        });
    });
</script>

</html>