<?php
$page_metatitle = $product['product_title'] . ' in Delhi';
$page_metadesc = $product['product_title'] . ' in Delhi';
$page_metakey = $product['product_title'] . ' in Delhi';
$image_path = explode(',', $product['product_image']);
?>
<?php
$in_cart = false;
if (isset($_SESSION['cart'][$product['product_id']])) {
    $in_cart = true;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="stylesheet" href="https://www.selold.com/designer/css/magiczoomplus.css">
    <script src="https://www.selold.com/designer/js/magiczoomplus.js"></script>
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>




    <div class="inner_breadcrumb2 inner_breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                <?php if ($brdc2) { ?>
                    <li>
                        <a href="<?= site_url; ?>/<?= getValidFileName($brdc2['catName']); ?>.htm"
                            title="<?= $brdc2['catName']; ?> "><?= $brdc2['displayName']; ?></a>
                    </li>
                <?php } ?>
                <?php if ($brdc1) { ?>
                    <li>
                        <a href="<?= site_url; ?>/<?= getValidFileName($brdc1['catName']); ?>.htm"
                            title="<?= $brdc1['catName']; ?>"><?= $brdc1['displayName']; ?></a>
                    </li>
                <?php } ?>
                <?php if ($brdc) { ?>
                    <li>
                        <a href="<?= site_url; ?>/<?= getValidFileName($brdc['catName']); ?>.htm"
                            title="<?= $brdc['catName']; ?> "><?= $brdc['displayName']; ?></a>
                    </li>
                <?php } ?>
                <li class="active"><?= $product['product_title']; ?></li>
            </ul>
        </div>
    </div>

    <div class="product_listing">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="app-figure" id="zoom-fig">
                        <div class="details_zoom">
                            <div class="row">
                                <div class="col-md-10 col-12 order-md-2">
                                    <a id="Zoom-1" class="MagicZoom"
                                        href="<?= getImage($image_path[0], 500, 500, $product['product_title'] . $product['product_id'], '/uploaded-files/product-images/'); ?>"
                                        title="<?= $product['product_title'] ?> in Delhi"
                                        data-options="zoomWidth:500px; zoomHeight:500px">
                                        <?php if ($product['is_available'] == 1 && $product['quantity'] > 0) {  ?>
                                            <span class="fl-stock bg-success">In stock</span>
                                        <?php } else { ?>
                                            <span class="fl-stock bg-danger">Out of stock</span>
                                        <?php } ?>
                                        <img src="<?= getImage($image_path[0], 500, 500, $product['product_title'] . $product['product_id'], '/uploaded-files/product-images/'); ?>" fetchpriority="high" alt="<?= $product['product_title'] ?> in Delhi" title="<?= $product['product_title'] ?> in Delhi">

                                    </a>
                                </div>
                                <div class="col-md-2 col-12 order-md-1 pt-3 pt-md-0 pe-md-0">
                                    <div class="selectors d-flex d-md-block gap-1">
                                        <?php
                                        $sn = 1;
                                        foreach ($image_path as $img) {

                                        ?>
                                            <a data-zoom-id="Zoom-1" href="javascript:void(0);"
                                                data-image="<?= getImage($img, 500, 500, $product['product_title'] . $sn . $product['product_id'], "/uploaded-files/product-images/"); ?>"
                                                class="mz-thumb-selected">
                                                <img srcset="<?= getImage($img, 500, 500, $product['product_title'] . $sn . $product['product_id'], "/uploaded-files/product-images/"); ?>"
                                                    src="<?= getImage($img, 70, 70, $product['product_title'] . $sn . $product['product_id'], "/uploaded-files/product-images/"); ?>" loading="lazy" alt="<?= $product['product_title'] ?> in Delhi">
                                            </a>
                                        <?php $sn++;
                                        } ?>

                               <?php if($product['product_video']!=''){ ?>
                                        <a class="mz-thumb youtube" data-fancybox="" href="https://www.youtube.com/watch?v=<?=$product['product_video'];?>">
                                            <img src="https://img.youtube.com/vi/<?=$product['product_video'];?>/hqdefault.jpg" alt="<?=$product['product_title'];?>" title="<?=$product['product_title'];?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="playBtn" viewBox="0 0 16 16">
                                                <path d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z">
                                                </path>
                                            </svg>
                                        </a>
                                        <?php } ?>

                                        <!-- <a class="mz-thumb youtube" data-fancybox="" href="https://www.youtube.com/watch?v=mcigSu-AvbA">
                                            <img src="https://img.youtube.com/vi/mcigSu-AvbA/hqdefault.jpg" alt="Video">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="playBtn" viewBox="0 0 16 16">
                                                <path d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z">
                                                </path>
                                            </svg>
                                        </a> -->

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="product_details">
                        <form action="">
                            <h1 class="protitle"><?= $product['product_title'] ?> in Delhi</h1>
                            <div class="sub-tt"><?= $product['product_specfi'] ?></div>
                            <div class="price mb-2 fs-5">
                                <?php if ($product['mrp'] != $product['product_price']) { ?>
                                    <span class="old_price"><i class="fa fa-inr"></i> <?= $product['mrp'] * 1; ?></span>
                                <?php } ?>
                                <i class="fa fa-inr"></i><?= $product['product_price'] * 1; ?>
                                <?php if ($product['discount'] > 0) { ?> <div class="off_label">
                                        <?= $product['discount'] * 1; ?>% off</div> <?php } ?>
                            </div>
                            <?php
                            $attribute_tbl = mysqli_query($dbconn, "SELECT * FROM tbl_attributes WHERE status=1");
                            $attributes_array = $attributes = $brands_array = [];
                            while ($atrb = mysqli_fetch_array($attribute_tbl)) {
                                $attributes[$atrb['attributes_id']] = $atrb;
                                $attributes_array[$atrb['parent_id']][] = $atrb['attributes_id'];
                            }


                            $prdatr = [];
                            if (!empty($product['attributes_id'])) {
                                foreach (explode(',', $product['attributes_id']) as $atr) {
                                    $prdatr[$attributes[$atr]['parent_id']][] = $attributes[$atr]['attributes_name'];
                                }
                            }
                            ?>

                            <ul class="_1xgFaf">
                                <?php
                                foreach ($prdatr as $at_key => $at_v) {
                                    if (isset($attributes[$at_key])) {
                                ?>
                                        <li class="rgWa7D">
                                            <b><?= $attributes[$at_key]['attributes_name']; ?></b>:
                                            <?php foreach ($at_v as $single_atrb) {
                                                echo $single_atrb;
                                            } ?>
                                        </li>
                                <?php }
                                } ?>
                            </ul>
                            <div class="tt">Condition:</div>
                            <ul class="con-items">
                                <li class="con-item active"><?= $product['product_condition'] ?></li>
                            </ul>
                            <ul class="con-li">
                                <li>All QC Passed</li>
                                <li>Good Physical Condition</li>
                                <li>With Original Charger</li>
                            </ul>


                            <div class="btn-grp ">

                                <?php if ($product['is_available'] == 1) {
                                    if ($product['quantity'] > 0) {
                                ?>
                                        <a class="step_login_btn" href="javascript:void(0)"
                                            onclick="manage_cart('<?= $product['product_id']; ?>','add')"
                                            id="<?= $product['product_id']; ?>addcart" style="<?= $in_cart ? 'display:none;' : '' ?>" title="Add to Cart">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                                class="bi bi-cart3" viewBox="0 0 16 16">
                                                <path
                                                    d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .49.598l-1 5a.5.5 0 0 1-.465.401l-9.397.472L4.415 11H13a.5.5 0 0 1 0 1H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5M3.102 4l.84 4.479 9.144-.459L13.89 4zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4m7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4m-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2m7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2" />
                                            </svg> Add to Cart</a>
                                <?php }
                                } ?>
                                <a class="step_login_btn" href="<?= site_url; ?>/cart.htm"
                                    id="<?= $product['product_id']; ?>viewcart" title="View Cart" style="<?= $in_cart ? '' : 'display:none;' ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-cart3" viewBox="0 0 16 16">
                                        <path
                                            d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .49.598l-1 5a.5.5 0 0 1-.465.401l-9.397.472L4.415 11H13a.5.5 0 0 1 0 1H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5M3.102 4l.84 4.479 9.144-.459L13.89 4zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4m7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4m-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2m7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2" />
                                    </svg> View Cart</a>

                                <a class="moreBtn addWishlist" href="javascript:void(0);"
                                    data-product="<?= $product['product_id']; ?>" title="Add to Wishlist">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-heart" viewBox="0 0 16 16">
                                        <path
                                            d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143q.09.083.176.171a3 3 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15" />
                                    </svg> Add to Wishlist</a>
                                <div id="wish_msg_<?= $product['product_id']; ?>" style="color:green; font-size:13px; display:none;"></div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
            <div class="product_overview mt-4">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                            data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane"
                            aria-selected="true">Product Details</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab"
                        tabindex="0">
                        <div class="bx-title">Overview</div>
                        <p><?= $product['product_specfi'] ?></p>
                        <?php if (!empty($product['product_otherdetails'])) { ?>
                            <div class="bx-title">Quick Details</div>
                            <?php echo $product['product_otherdetails'] ?>
                            <!-- <div class="quick_details">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <dl class="dl-horizontal">
                                        <dt>Processor:</dt>
                                        <dd>Intel® Core™ i5</dd>
                                        <dt>Operating System:</dt>
                                        <dd>Windows 10</dd>
                                        <dt>Display:</dt>
                                        <dd>13" display with large screen-to-body ratio</dd>
                                        <dt>Memory:</dt>
                                        <dd>8 GB RAM</dd>
                                    </dl>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <dl class="dl-horizontal">
                                        <dt>Storage:</dt>
                                        <dd>128GB M.2 PCIe</dd>
                                        <dt>Battery:</dt>
                                        <dd>5.3 hours, 38Whr (MM18)</dd>
                                        <dt>Weight:</dt>
                                        <dd>1.7kg / 3.74lbs</dd>
                                        <dt>Color / Finish:</dt>
                                        <dd>Space Grey, with in-mould rolling finish</dd>
                                    </dl>
                                </div>
                            </div>
                        </div> -->
                        <?php } ?>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <div class="homeFeture pt-0">
        <div class="container">
            <div class="row">
                <div class="shop-sec">
                    <div class="shop-title mb-4">
                        <div class="tt-bx text-start">
                            <h4 class="tt">Top <span> Selling Brands</span></h4>
                            <p class="m-0 text-start">Upgrade affordably with our quality refurbished laptops. Explore
                                options now!</p>
                        </div>
                    </div>

                    <div id="featuredProducts2" class="owl-carousel featuredProducts ">
                        <?php
                        $relBrand = mysqli_query($GLOBALS['dbconn'], "select catImage, catName, displayName, catDesc, catID, catDesc1,catBanner, parentID,homeTitle,catHomeImage from category_tbl where parentID=1 and status='Y' order by catOrder ASC");
                        while ($sub_res = mysqli_fetch_array($relBrand)) {
                            $file_ext = explode('.', $sub_res['catImage']);
                            $file_extention = $file_ext['1'];

                            if ($sub_res['catHomeImage'] != '') {
                                $img_link = getImage($sub_res['catHomeImage'], 300, 300, $sub_res['catName'], "/uploaded-files/category/images/");
                            } elseif ($sub_res['catImage'] != '') {
                                if ($file_extention == 'PNG' || $file_extention == 'png') {
                                    $img_link = site_url . '/uploaded-files/category/images/' . $sub_res['catImage'];
                                } else {
                                    $img_link = getImage($sub_res['catImage'], 300, 300, $sub_res['catName'], "/uploaded-files/category/images/");
                                }
                            } else {
                                $img_link = getImage("noimage.jpg", 300, 300, "noimages", "/uploaded-files/category/images/");
                            }
                            $headingTitle = ($sub_res['homeTitle'] != '') ? $sub_res['homeTitle'] : $sub_res['catName'];
                        ?>
                            <div class="productBox">
                                <a href="<?= site_url; ?>/<?= getValidFileName($sub_res['catName']); ?>.htm"
                                    title="<?= $sub_res['displayName']; ?>  in <?= $admin_res['targetlocation']; ?>">
                                    <div class="productImg">
                                        <img src="<?= $img_link; ?>"
                                            alt="<?= $sub_res['catName']; ?>  in <?= $admin_res['targetlocation']; ?>"
                                            title="<?= $sub_res['catName']; ?>  in <?= $admin_res['targetlocation']; ?>">
                                    </div>
                                    <div class="productContent">
                                        <div class="title"><?= $sub_res['displayName']; ?></div>
                                    </div>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
    <script>
        $(document).on("click", ".addWishlist", function() {
            var pid = $(this).data("product");
            $.ajax({
                url: "<?= site_url; ?>/ajax_wishlist.php",
                type: "POST",
                data: {
                    product_id: pid
                },
                success: function(resp) {
                    resp = resp.trim(); // remove any extra spaces/newlines

                    if (resp == "login") {
                        if (confirm("You need to login first to add to Wishlist.")) {
                            window.location.href = "<?= site_url; ?>/login.htm?return_url=" + encodeURIComponent(window.location.href);
                        }
                    } else if (resp == "added") {
                        $("#wish_msg_" + pid).html("✔ Added to Wishlist").fadeIn().delay(5000).fadeOut();
                    } else if (resp == "exists") {
                        $("#wish_msg_" + pid).html("✔ Already in Wishlist").fadeIn().delay(5000).fadeOut();
                    } else if (resp == "error") {
                        alert("Something went wrong! Please try again.");
                    } else if (resp == "invalid") {
                        alert("Invalid product.");
                    }
                },
                error: function() {
                    alert("AJAX error! Please try again.");
                }
            });
        });
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const selectors = document.querySelectorAll(".selectors a");
            const maxVisible = 6;

            if (selectors.length > maxVisible) {
                // Hide the extra selectors
                selectors.forEach((item, index) => {
                    if (index >= maxVisible) {
                        item.style.display = "none";
                    }
                });

                // Calculate remaining
                let remaining = selectors.length - maxVisible;

                // Create show-more button
                let btn = document.createElement("div");
                btn.className = "show-more-btn";
                btn.textContent = `+${remaining}`;

                // Append button
                document.querySelector(".selectors").appendChild(btn);

                // On click -> MagicZoom Expand
                btn.addEventListener("click", function() {
                    // Trigger MagicZoom expand
                    MagicZoom.expand('Zoom-1');
                });
            }
        });
    </script>





</body>

</html>