<?php include_once("include/main.inc.php"); 
include "dashboard_query.php";


$user_id = isset($_SESSION['USER_ID']) ? intval($_SESSION['USER_ID']) : 0;

// Fetch wishlist items for this user
$wishlist_qry = mysqli_query($dbconn, "
    SELECT w.*, p.product_title, p.product_price, p.product_specfi, p.mrp, p.discount, p.product_image 
    FROM wps_wishlists w
    JOIN product_tbl p ON p.product_id = w.products_Id
    WHERE w.customer_id = '$user_id'
    ORDER BY w.wishlists_date_added DESC
");

$wishlist_count = mysqli_num_rows($wishlist_qry);

// --- Handle Wishlist Remove AJAX Request ---
if(isset($_POST['remove']) && isset($_POST['wish_id'])){
    $user_id = isset($_SESSION['USER_ID']) ? intval($_SESSION['USER_ID']) : 0;
    if($user_id <= 0){
        echo "login";
        exit;
    }

    $wish_id = intval($_POST['wish_id']);
    $del = mysqli_query($dbconn, "DELETE FROM wps_wishlists WHERE id='$wish_id' AND customer_id='$user_id'");
    echo ($del) ? "removed" : "error";
    exit;
}



?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>My Wishlist</title>
    <meta name="keywords" content="" />
    <meta name="description" content="" />
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>

    <div class="wishlist_page">
        <div class="container">
            <div class="row">
                <?php include "app_d_sidebar.php"; ?>

                <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-12">
                    <div class="right_side">
                        <h1 class="bx-title">My Wishlist (<?php echo $wishlist_count; ?>)</h1>
                        <div class="wps_right wishlist">
                              <?php if($wishlist_count > 0): ?>
                                <?php while($item = mysqli_fetch_assoc($wishlist_qry)): 
                                    $images = explode(',', $item['product_image']);
                                    $main_img = !empty($images[0]) ? $images[0] : 'noimage.jpg';


                                       // Calculate discount
if ($item['mrp'] != $item['product_price']) { 
    if($item['discount'] == '0'){
        $discount_percent = (($item['mrp'] - $item['product_price']) / $item['mrp']) * 100; 
        $discount_percent = round($discount_percent);
    } else {
        $discount_percent = $item['discount'] * 1;
    }
} else {
    $discount_percent = 0;
}

                                ?>
                            <!--- Start Here-->
                            <div class="order_item">
                                <div class="wishlist_body">
                                    <div class="row">
                                        <div class="col-lg-8 col-md-8 col-sm-8">
                                            <div class="row">
                                                <div class="col-lg-3 col-md-3 col-sm-3">
                                                    <a href="javascript:void()"><img src="<?= site_url; ?>/uploaded-files/product-images/<?php echo $main_img; ?>"></a>
                                                </div>
                                                <div class="col-lg-8 col-md-8 col-sm-8">
                                                    <div class="wishlist_info">
                                                        <a href="javascript:void(0);"><?php echo $item['product_title']; ?></a>
                                                        <p><?= $item['product_specfi'] ?></p>
                                                        <div class="price">
                                                            <span class="offerPrice">₹ <?= $item['product_price']; ?></span>
                                                             <?php if($discount_percent > 0){ ?>
                                                            <span class="mrpPrice">₹<?= $item['mrp']; ?></span>
                                                            <span class="offPercentage"><?= $discount_percent ?>off</span>
                                                              <?php } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4">
                                            <a class="add_to_cart" href="cart.php" title="Buy Now"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                                    <path d="M9 5.5a.5.5 0 0 0-1 0V7H6.5a.5.5 0 0 0 0 1H8v1.5a.5.5 0 0 0 1 0V8h1.5a.5.5 0 0 0 0-1H9V5.5z" />
                                                    <path d="M.5 1a.5.5 0 0 0 0 1h1.11l.401 1.607 1.498 7.985A.5.5 0 0 0 4 12h1a2 2 0 1 0 0 4 2 2 0 0 0 0-4h7a2 2 0 1 0 0 4 2 2 0 0 0 0-4h1a.5.5 0 0 0 .491-.408l1.5-8A.5.5 0 0 0 14.5 3H2.89l-.405-1.621A.5.5 0 0 0 2 1H.5zm3.915 10L3.102 4h10.796l-1.313 7h-8.17zM6 14a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm7 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0z" />
                                                </svg> Buy Now</a>
                                            <a class="remove removeWish" data-id="<?= $item['id']; ?>" href="javascript:void(0);" title="Remove"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                                    <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z" />
                                                    <path fill-rule="evenodd" d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z" />
                                                </svg> Remove</a>
                                        </div>
                                    </div>
                                </div>

                            </div>
<?php endwhile; ?>
                            <?php else: ?>
                                <p>Your wishlist is empty.</p>
                            <?php endif; ?>
                           

                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>



    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
<script>
$(".removeWish").click(function(){
    let wid = $(this).data("id");
    let row = $(this).closest(".order_item");

    $.ajax({
        type: "POST",
        url: "",
        data: { remove: 1, wish_id: wid },
        success: function(res){
            console.log("Response:", res);
            if(res.trim() == "removed"){
                row.fadeOut(300, function(){
                    $(this).remove();
                    location.reload();
                });
            } 
        }
    });
});

</script>


</body>

</html>