<?php
include_once("include/main.inc.php");
$page_metatitle="Login - ".$admin_res['companyName'];
$page_metakey="Login - ".$admin_res['companyName'];
$page_metadesc="Login - ".$admin_res['companyName'];
if(isset($_SESSION['USER_LOGIN']) && $_SESSION['USER_LOGIN'] == 'yes') {
    if(isset($_GET['return_url']) && $_GET['return_url']!='') {
        header("Location: ".$_GET['return_url']);
        exit;
    } else {
        header("Location: ".site_url."/my-account.htm");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>

    <div class="inner_breadcrumb2 inner_breadcrumb bg2">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                <li class="active">Login</li>
            </ul>
        </div>
    </div>

    <div class="loginPage">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4">
                    <div class="loginPanel">
                        <div class="text-center">
                            <h2>Login to Your Account</h2>
                            <p>Access your dashboard by signing in below.</p>
                        </div>
                        <form id="login_form" name="login_form" method="POST">
                            <div id="login_response"></div>
                            <div class="form-group">
                                <label>Email ID <span>*</span></label>
                                <input class="form-control" name="login_email" type="email" required="" value="">

                            </div>

                            <div class="form-group">
                                <label>Password <span>*</span></label>
                                <input class="form-control" name="password" type="password" required="">
                            </div>
                            <div class="loginBottom mb-3">
                                <a class="forgetText" href="<?=site_url;?>/forget-password.htm" title="Forgot Password">Forgot Password
                                    ?</a>
                            </div>
                            <button type="submit" name="login_submit" class="moreBtn">Sign In</button>

                            <div class="loginBottom">
                                <a href="<?=site_url;?>/register.htm">New to SEL-OLD? <strong>Create an
                                        account</strong></a>
                            </div>
                         <input type="hidden" name="return_url" value="<?=isset($_GET['return_url']) ? $_GET['return_url'] : '';?>">

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
    <script>
    //login form
    $(document).ready(function() {
        $("#login_form").validate({
            rules: {
                login_email: {
                    required: true,
                },
                password: {
                    required: true,
                }
            },
            messages: {
                login_email: {
                    required: "Please enter your email address"
                },
                password: {
                    required: "Please enter password",
                }
            },
            submitHandler: function(form) {
                $.ajax({
                    url: '<?= site_url; ?>/ajax_login.php',
                    type: 'POST',
                    data: $('#login_form').serialize(),
                    dataType: 'json',
                    success: function(result) {
                        if (result.status == true) {
                            // alert('success');
                            $('#login_response').text(result.message_response).css(
                                'color',
                                'green');
                            $('#login_form')[0].reset();
                        
                            if (result.redirect_url != '') {
                                // alert(result.redirect_url);
                                 window.location.href = result.redirect_url;
                            }
                        } else {
                            // alert('Not success');
                            $('#login_response').text(result.message_response).css(
                                'color',
                                'red');
                            // if (result.redirect_url!='') {
                            // window.open(result.redirect_url);
                            // }
                        }
                    }
                });
            }
        });
    });
    </script>
</body>

</html>