<?php
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

include_once("include/main.inc.php");
date_default_timezone_set('Asia/Kolkata');
$name = $admin_res['companyName'];

####################  SEND OTP  ####################
if(isset($_POST['otp_submit'])){
    $email = $_POST['email'];
    $sanitized_emailid =  mysqli_real_escape_string($GLOBALS['dbconn'], $email); 
    $name="Selold";

    if($email != ''){
        $check_sql=mysqli_query($dbconn,"SELECT user_id FROM user_tbl WHERE user_email='$sanitized_emailid'");
        if(mysqli_num_rows($check_sql)>0){

            $otp = rand(1000, 9999);
            $expiry = date("Y-m-d H:i:s", strtotime('+10 minutes'));
            mysqli_query($GLOBALS['dbconn'],"UPDATE user_tbl SET otp='$otp', otp_expiry='$expiry' WHERE user_email='$email'");

            $subject = 'Your OTP for Password Reset - '.site_url;
            $message = "<p>Your OTP for password reset is: <strong>$otp</strong>. It is valid for 10 minutes.</p>";

            if (smtp_mailer($email, $email, $name, $subject, $message)) {
                $resp = [
                    'status' => true,
                    'message_response' => 'OTP sent successfully. Please verify below.',
                    'show_otp' => true,
                    'email' => $email
                ];
            } else {
                $resp = ['status' => false, 'message_response' => 'Failed to send OTP.'];
            }

        } else {
            $resp = ['status' => false, 'message_response' => 'Email not found.'];
        }
    } else {
        $resp = ['status' => false, 'message_response' => 'Email field is mandatory.'];
    }
    echo json_encode($resp);
    exit;
}

#################### VERIFY OTP ####################
if(isset($_POST['verify_otp'])){
    $email = $_POST['verify_email'];
    $otp_val = $_POST['otp_box'];

    $check=mysqli_query($dbconn,"SELECT otp,otp_expiry FROM user_tbl WHERE user_email='$email'");
    $res=mysqli_fetch_array($check);

    if($res && $res['otp']==$otp_val && $res['otp_expiry'] >= date("Y-m-d H:i:s")){
        $resp=['status'=>true,'message_response'=>'OTP Verified. Reset Password below.','show_reset'=>true,'email'=>$email];
    } else {
        $resp=['status'=>false,'message_response'=>'Invalid or expired OTP.'];
    }
    echo json_encode($resp);
    exit;
}

#################### RESET PASSWORD ####################
if(isset($_POST['reset_pass'])){
    $email=$_POST['reset_email'];

    // FIXED LINE BELOW ONLY (no other change)
    $new = $_POST['new_password'];

    mysqli_query($dbconn,"UPDATE user_tbl SET password='$new', otp=NULL, otp_expiry=NULL WHERE user_email='$email'");
    // $resp=['status'=>true,'message_response'=>'Password Reset Successfully! Please login.'];
    $resp=['status'=>true,'message_response'=>'Password Reset Successfully! Please login.','redirect_url'=>site_url.'/login.htm'];
    echo json_encode($resp);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<?php include "app_top.php"; ?>
</head>

<body>
<?php include "app_header.php"; ?>

<section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/about-banner.jpg)">
<div class="container">
    <div class="row">
        <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
            <h1 class="cat_title">Forget Password</h1>
            <div class="clearfix"></div>
        </div>
    </div>
</div>
</section>

<div class="inner_breadcrumb hidden_xs">
<div class="container">
    <div class="row">
        <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <ul class="breadcrumb">
                <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                <li class="active">Forget Password</li>
            </ul>
        </div>
    </div>
</div>
</div>

<div class="login-page py-5" style="background: #f5f5f5;">
<div class="container">
    <div class="login-form">
        <div class="login-title">Create New Password</div>
        <div class="form-bx">

            <!-- EMAIL FORM -->
            <form id="forget_form" name="forget_form" method="post">
                <div id="forget_response"></div>
                <div class="form-group">
                    <label>Email Address</label>
                    <div class="input-group">
                        <div class="input-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                class="bi bi-envelope" viewBox="0 0 16 16">
                                <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 
                                2.383-4.708 2.825L15 11.105V5.383Zm-.034 
                                6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 
                                3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 
                                11.105l4.708-2.897L1 5.383v5.722Z"></path>
                            </svg>
                        </div>
                        <input type="email" name="email" class="form-control" placeholder="Enter Your Registered Email">
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" name="otp_submit" class="addToBtn w-100">Send OTP</button>
                </div>
            </form>

            <!-- OTP FORM -->
           <div id="otp_section" style="display:none; margin-top:20px;">
    <form id="otp_form">
        <input type="hidden" name="verify_email" id="verify_email">
        <label>Enter OTP</label>
        <input type="text" name="otp_box" class="form-control" maxlength="4" required>
        <button type="submit" name="verify_otp" class="addToBtn w-100 mt-2">Verify OTP</button>

        <!-- RESEND OTP BUTTON -->
        <button type="button" id="resend_btn" class="addToBtn w-100 mt-2" style="background:#ff9800;">
            Resend OTP
        </button>
    </form>
</div>

            <!-- RESET PASSWORD FORM -->
            <div id="reset_section" style="display:none; margin-top:20px;">
                <form id="reset_form">
                    <input type="hidden" name="reset_email" id="reset_email">
                    <label>New Password</label>
                    <input type="password" name="new_password" class="form-control" required>
                    <button type="submit" name="reset_pass" class="addToBtn w-100 mt-2">Reset Password</button>
                </form>
            </div>

        </div>

        <p class="shift">Don't have an account?
            <a href="<?=site_url;?>/register.htm">Register</a>
        </p>
    </div>
</div>
</div>

<?php include "app_footer.php"; ?>
<?php include "app_bottom.php"; ?>

<script>
$(document).ready(function() {

    // SEND OTP
    $("#forget_form").validate({
        rules:{ email:{ required:true } },
        messages:{ email:{ required:"Please enter your email address" } },
        submitHandler: function(form) {
            $.ajax({
                url:'forget_passwords.php',
                type:'POST',
                data:$('#forget_form').serialize(),
                dataType:'json',
                success:function(result){

                    if(result.status){
                        // Move message text inside OTP section area
                        $("#otp_section").prepend(
                            '<div class="alert alert-success text-center">'+result.message_response+'</div>'
                        );
                    } else {
                        $("#forget_response").html(
                            '<div class="alert alert-danger text-center">'+result.message_response+'</div>'
                        );
                    }

                    if(result.status && result.show_otp){
                        $("#verify_email").val(result.email);
                        $("#forget_form").hide();
                        $("#otp_section").show();
                        $("#reset_section").hide();
                    }
                }
            });
        }
    });


    // VERIFY OTP
    $("#otp_form").on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url:'forget_passwords.php',
            type:'POST',
            data:$("#otp_form").serialize()+"&verify_otp=1",
            dataType:'json',
            success:function(result){

                if(result.status){
                    // Move OTP verified message INSIDE reset section
                    $("#reset_section").prepend(
                        '<div class="alert alert-success text-center">'+result.message_response+'</div>'
                    );
                } else {
                    $("#otp_section").prepend(
                        '<div class="alert alert-danger text-center">'+result.message_response+'</div>'
                    );
                }

                if(result.status && result.show_reset){
                    $("#reset_email").val(result.email);
                    $("#otp_section").hide();
                    $("#reset_section").show();
                }
            }
        });
    });


$("#resend_btn").on('click', function(){

    let email = $("#verify_email").val();

    $.ajax({
        url:'forget_passwords.php',
        type:'POST',
        data:{ email: email, otp_submit: 1 },
        dataType:'json',
        success:function(result){

            $(".alert").remove(); // remove old alerts

            if(result.status){
                $("#otp_section").prepend(
                    '<div class="alert alert-warning text-center" style="color:#000;font-weight:bold;">OTP Resent Successfully!</div>'
                );
            } else {
                $("#otp_section").prepend(
                    '<div class="alert alert-danger text-center">'+result.message_response+'</div>'
                );
            }
        }
    });
});


    // RESET PASSWORD
   $("#reset_form").on('submit', function(e){
    e.preventDefault();
    $.ajax({
        url:'forget_passwords.php',
        type:'POST',
        data:$("#reset_form").serialize()+"&reset_pass=1",
        dataType:'json',
        success:function(result){

            $("#forget_response").html(
                '<div class="alert alert-success text-center">'+result.message_response+'</div>'
            );

            $("#otp_section").hide();
            $("#reset_section").hide();
            $("#forget_form").show();

            if(result.redirect_url){
                setTimeout(function(){
                    window.location.href = result.redirect_url;
                }, 2000); // 2 sec delay
            }
        }
    });
});

});
</script>



</body>
</html>
