<?php include_once("include/main.inc.php"); 
include "dashboard_query.php";

$user_id = $_SESSION['USER_ID'] ?? 0;  
$err = "";
$success = "";

if(isset($_POST['submit'])){
    
    $current = mysqli_real_escape_string($dbconn, $_POST['crpass']);
    $newpass = mysqli_real_escape_string($dbconn, $_POST['newpass']);
    $confpass = mysqli_real_escape_string($dbconn, $_POST['confpass']);

    // 1. Get stored password
  $res = mysqli_query($dbconn, "SELECT password FROM user_tbl WHERE user_id='$user_id'");
$row = mysqli_fetch_assoc($res);
$db_pass = $row['password'];

// 2. Verify current password (plain text)
if($current !== $db_pass){
    $err = "Current password is incorrect!";
}
// 5. Check not same as current
elseif($newpass == $db_pass){
    $err = "New password cannot be same as current!";
}
else {
    // 6. UPDATE PASSWORD AS PLAIN TEXT
    mysqli_query($dbconn, "UPDATE user_tbl SET password='$newpass' WHERE user_id='$user_id'");
    $success = "Password updated successfully!";
}
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Change Password</title>
    <meta name="keywords" content="" />
    <meta name="description" content="" />
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>

    <section class="my_account_page">
        <div class="container">
            <div class="row">
                <?php include "app_d_sidebar.php"; ?>

                <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-12">
                    <div class="right_side">
                        <h1 class="bx-title">Change Password</h1>
                        <?php if(!empty($err)){ echo "<p style='color:red;'>$err</p>"; } ?>
<?php if(!empty($success)){ echo "<p style='color:green;'>$success</p>"; } ?>
                        <div class="wps_right">
                            <p><strong>Your new password must:</strong></p>
                            <ul>
                                <li>Be at least 4 characters in length</li>
                                <li>Not be same as your current password</li>
                                <li>Not contain common passwords.</li>
                            </ul>
                            <div class="row" id="passwords">
                                <form method="post">
                                    <div class="col-lg-6 col-md-6 col-sm-6">
                                        <div class="form-group">
                                            <label class="input_label">
                                                <input class="form-control" name="crpass" type="text" placeholder="Type Current Password *" value="" required>
                                            </label>
                                            <div id="err_crpass" style="color:red;"></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6">
                                        <div class="form-group">
                                            <label class="input_label">
                                                <input class="form-control" name="newpass"  id="newpass" type="text" placeholder="Type New Password *" value="" required>
                                            </label>
                                            <div id="err_newpass" style="color:red;"></div>
                                        </div>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6">
                                        <div class="form-group">
                                            <label class="input_label">
                                                <input class="form-control" name="confpass" type="text" placeholder="Retype New Password *" value="" required>
                                            </label>
                                            <div id="err_confpass" style="color:red;"></div>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12">
                                        <div class="form-group">
                                            <button class="moreBtn" type="submit" name="submit">Change Password</button>
                                        </div>
                                    </div>

                                </form>
                            </div>

                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>


    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>

<script>
$(document).ready(function() {

    // Apply validation to the form
    $("form").validate({
        rules: {
            crpass: { required: true },
            newpass: { required: true, minlength: 4 },
            confpass: { required: true, equalTo: "#newpass" }
        },
        messages: {
            crpass: "Please enter your current password",
            newpass: {
                required: "Please enter a new password",
                minlength: "New password must be at least 4 characters"
            },
            confpass: {
                required: "Please retype your new password",
                equalTo: "Passwords do not match"
            }
        },
        errorPlacement: function(error, element) {
            // Map each input to its custom div
            if(element.attr("name") == "crpass"){
                error.appendTo("#err_crpass");
            } else if(element.attr("name") == "newpass"){
                error.appendTo("#err_newpass");
            } else if(element.attr("name") == "confpass"){
                error.appendTo("#err_confpass");
            } else {
                error.insertAfter(element);
            }
        }
    });

});
</script>

</body>

</html>