<?php
include_once ("../include/main.inc.php");
check_session('MyCpanel', 'index.php');
$title = "Admin Login Panel";
admin_header();

$cat_count = get_category_count();
$enquiry_count = get_enquiry_count();
$location_count = get_location_count();
$blog_count = get_blog_count();
?>

<div class="row dash-stats">
  <div class="col-lg-3 col-sm-6">
    <a style="text-decoration: none;" href="<?= SITE_ADMIN_URL; ?>/manage_categories.php">
      <div class="tb-iconbox tb-style4 tb-color1">
        <div class="tb-icon tb-flex">
          <i class="fa fa-users"></i>
        </div>
        <div class="tb-iconbox-text">
          <h3 class="tb-iconbox-heading"><?= $cat_count ?></h3>
          <div class="tb-iconbox-sub-heading">Total Categories</div>
        </div>
      </div>
    </a>
  </div>
  <div class="col-lg-3 col-sm-6">
    <a style="text-decoration: none;" href="<?= SITE_ADMIN_URL; ?>/manage_buy_enquiry.php">
      <div class="tb-iconbox tb-style4 tb-color1">
        <div class="tb-icon tb-flex">
          <i class="fa fa-question-circle"></i>
        </div>
        <div class="tb-iconbox-text">
          <h3 class="tb-iconbox-heading"><?= $enquiry_count ?></h3>
          <div class="tb-iconbox-sub-heading">Total Enquiries</div>
        </div>
      </div>
    </a>
  </div>
  <div class="col-lg-3 col-sm-6">
    <a style="text-decoration: none;" href="<?= SITE_ADMIN_URL; ?>/manage_blog.php">
      <div class="tb-iconbox tb-style4 tb-color1">
        <div class="tb-icon tb-flex">
          <i class="fa fa-newspaper-o"></i>
        </div>
        <div class="tb-iconbox-text">
          <h3 class="tb-iconbox-heading"><?= $blog_count ?></h3>
          <div class="tb-iconbox-sub-heading">Total Blogs</div>
        </div>
      </div>
    </a>
  </div>
  <div class="col-lg-3 col-sm-6">
    <a style="text-decoration: none;" href="<?= SITE_ADMIN_URL; ?>/manage_locations.php">
      <div class="tb-iconbox tb-style4 tb-color1">
        <div class="tb-icon tb-flex">
          <i class="fa fa-map-marker"></i>
        </div>
        <div class="tb-iconbox-text">
          <h3 class="tb-iconbox-heading"><?= $location_count ?></h3>
          <div class="tb-iconbox-sub-heading">Total Locations</div>
        </div>
      </div>
    </a>
  </div>
</div>
<?php
$today = date('Y-m-d');
$query = mysqli_query($dbconn, "SELECT * FROM tbl_enquiry  order by enq_id desc limit 5");
if (mysqli_num_rows($query) > 0) {
  $i = 1; ?>
  <div class="col-lg-12">
    <div class="text-center">
      <span class="heading">Latest Enquiry</span> <span class="pull-right"><a
          href="<?= SITE_ADMIN_URL; ?>/manage_buy_enquiry.php">View All</a></span>
    </div>
    <style>
   .table tr td{
    vertical-align: top !important;
   }
</style>
    <div class="table-responsive">

      <table class="table table-striped">

        <thead>
          <tr>
            <td width="5%" height="20" align="left"><strong>S.No.</strong></td>
            <td width="10%" align="left"><strong>Sender Detail </strong></td>
            <td width="10%" align="center"><strong>Enquiry Details</strong></td>
            <td width="30%" align="center"><strong>System Details</strong></td>
          </tr>
        </thead>
        <tbody>
          <?php while ($arr = mysqli_fetch_array($query)) { ?>
            <tr>
              <td><?= $i++ ?></td>
              <td class="text-left">
                  Date: <b><?= date('d M Y, h:ia', strtotime($arr['create_date'])); ?> </b><br /> 
                  Name: <b><?=$arr['name']; ?></b> <br /> 
                  Mobile: <b><?=$arr['mobile']; ?></b><br>
                  Email: <b><?=$arr['email']; ?></b> <?php if($arr['verified'] == 1){?><i class="fa fa-check-circle text-success" title="Verified"></i><?php } ?> <br />
                  <b><?=$arr['location']; ?> <?=$arr['pincode']; ?></b> <br /> 
              </td>
              <td class="text-left">
                  Enquiry for: <b><?=$arr['enquiry_type']; ?></b> <br /> 
                  Message: <?= $arr['comment']; ?><br />
                
              </td>
              <td class="text-left">
                URl: <b><a href="<?=$arr['uri_page']; ?>" target="_blank"><?=$arr['uri_page']; ?></a></b>  <br />             
                Ip Address: <b><?=$arr['ip_address']; ?></b>  <br /> 
                Platform: <b><?= $arr['platform']; ?></b>  <br /> 
                Browser: <b><?= $arr['browser']; ?></b>  <br /> 
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
<?php }
?>

<?php admin_footer(); ?>