<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once ("../include/main.inc.php");
check_session('MyCpanel', 'index.php');
################ Paging Starts From Here ##################
@extract($_REQUEST);
$start = (intval($start) < 0 or $start == "") ? 0 : $start;
$pagesize = isset($pagesize)?$pagesize:100;

$heading = "Add New Products";
$record_type = "Products";
$script_name = "products.php";
$table_name = "tbl_products";
####################################################


$attribute_tbl = mysqli_query($dbconn, "SELECT * FROM tbl_attributes WHERE status=1");
$attributes_array = $attributes = [];
while($atrb = mysqli_fetch_array($attribute_tbl)){
    $attributes[$atrb['attributes_id']] = $atrb;
    $attributes_array[$atrb['parent_id']][] = $atrb['attributes_id'];
}

admin_header("");
?>
<style>
     #productImage{
        display: flex;
     }
    #productImage img{
        width: 150px;
        max-height: 90px;
        border: 1px solid #ccc;
        margin: 2px;
    }
    a.remove-height {
        color: #fff;
        background: red;
        padding: 5px;
        border-radius: 27px;
        display: inline-block;
        width: 30px;
        height: 30px;
        text-align: center;
        font-weight: 900;
        font-size: 20px;
    }
    .col-1.high-sn {
        font-size: 23px;
        text-align: end;
    }
</style>
<table width="99%" border="0" align="center" cellpadding="0" cellspacing="0" valign="top">
    <tr>
        <td align="left" width="50%" class="myTitle">
            <?= $heading; ?>
        </td>
        <td align="right">
            <table width="98%" border="0" align="center" cellpadding="0" cellspacing="0" valign="top">
                <tr>
                    <td align="right">
                        <a href="<?= SITE_ADMIN_URL."/products.php"?>" class="button add-category-btn text-white">Back</button>
                    </td>
                </tr>
            </table>
        </td>
    </tr>

</table>
<hr size="2" width="99%" color="#DA251C">

<form action="<?= SITE_ADMIN_URL.'/form_page.php' ?>" class="form_submit" type="post" enctype="multipart/form-data">
    <div class="modal-body">
        
        <div class="row">
            <div class="col-3">
                <div class="form-group">
                    <label>Select Brand<sup class="text-danger">*</sup></label>
                    <select class="form-control form-control-lg" name="brand">
                        <option value="">Select brand</option>
                        <?php 
                            $brands = mysqli_query($dbconn, "SELECT brand_id, brand_name FROM tbl_brands WHERE brand_status=1");
                            while($brd = mysqli_fetch_assoc($brands)){
                        ?>
                        <option value="<?= $brd['brand_id']; ?>"><?= $brd['brand_name']; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="col-9">
                <div class="form-group">
                    <label>Heading<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="prd_name" placeholder="Enter product heading">
                </div>
            </div>
            <div class="col-12">
                <div class="form-group">
                    <label>Sub heading<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="sub_heading" placeholder="Enter product sub heading">
                </div>
            </div>
            <div class="col-12">
                <div class="form-group">
                    <label>Product url<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="product_url" placeholder="Enter product url">
                </div>
            </div>
            <div class="col-12">
                <div class="form-group">
                    <label>Highlighted points <sup class="text-danger">*</sup></label>
                    <div id="heighlites">
                        <div class="row">
                            <div class="col-1 high-sn">1.</div>
                            <div class="col-10">
                                <input type="text" name="heighlite[]" placeholder="Enter heighlites" class="form-control form-control -sm">
                            </div>
                            <div class="col-1">
                                <a class="remove-height" onclick="RemoveHighlites(this)" href="#"><i class="fa fa-times"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="mt-1 text-dark">To add more field <a href="#" id="addHfield">Click Here</a></div>
                </div>
            </div>
            <div class="col-4">
                <div class="form-group">
                    <label>Product MRP<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="mrp" placeholder="Enter MRP" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')">
                </div>
            </div>
            <div class="col-4">
                <div class="form-group">
                    <label>Price<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="price" placeholder="Enter price">
                </div>
            </div>
            <div class="col-4">
                <div class="form-group">
                    <label>Discount (%)<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="discount" placeholder="Enter Discount">
                </div>
            </div>
            
            <div class="col-4">
                <div class="form-group">
                    <label>Quantity<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="qty" placeholder="Enter quantity" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')">
                </div>
            </div>
            
            <div class="col-4">
                <div class="form-group">
                    <label>Condition<sup class="text-danger">*</sup></label>
                    <input type="text" class="form-control" name="condition" placeholder="Enter condition">
                </div>
            </div>

            <div class="col-4">
                <div class="form-group">
                    <label>Status<sup class="text-danger">*</sup></label>
                    <select class="form-control" name="status">
                        <option value="1">Active</option>
                        <option value="0">In-Active</option>
                    </select>
                </div>
            </div>
            
            <div class="col-12">
                <div class="form-group">
                    <label>Short Description<sup class="text-danger">*</sup></label>
                    <textarea class="form-control" name="short_desc" placeholder="Enter short description"></textarea>
                </div>
            </div>
            <div class="col-12">
                <div class="form-group">
                    <label>Full Description<sup class="text-danger">*</sup></label>
                    <textarea id="full_desc" name="full_desc" class="form-control" placeholder="Enter full description"></textarea>                              
                </div>
            </div>
            
            <div class="col-4">
                <div class="form-group">
                    <label>Products images<sup class="text-danger">*</sup></label>
                    <input type="file" id="prevMulti" name="prdimgs[]" multiple onChange="prevMultople(this)">
                    <div><sub class="text-danger">Upload multiple images in one upload</sub></div>
                </div>
            </div>

            <div class="col-12" id="productImage"></div>
        </div>
        <div class="form-group">
            <div>
                <input type="hidden" name="attr_mainid">
            </div>
            <h4>Select Attributes</h4>
            <?php 
                foreach($attributes_array[0] as $atr){
            ?>
            <div class="border-bottom mb-2">
                <label><?= $attributes[$atr]['attributes_name']; ?></label>
                <div class="ml-3">
                    <?php foreach($attributes_array[$atr] as $subatr){ ?>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" name="attrbid[]" type="checkbox" id="atrinpt_<?= $subatr;?>" value="<?= $subatr;?>">
                        <label class="form-check-label" for="atrinpt_<?= $subatr;?>"><?= $attributes[$subatr]['attributes_name']; ?></label>
                    </div>
                    <?php } ?>
                    
                </div>
            </div>
            <?php } ?>
        </div>
        
    </div>
    <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Save changes</button>
        <input type="hidden" name="add_product" value="add_product">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
    </div>
</form>


<script src="jquery.min.js"></script>

<?php admin_footer(); ?>
<script>
    function RemoveHighlites(elm){
        $(elm).closest('.row').remove();
        let sn = 1;
        $('#heighlites .high-sn').each(function(){
            $(this).text(sn++ +'.');
        });
    }
    $(document).ready(function(){
        $('#addHfield').click(function(e){
            e.preventDefault();
            let sn = 1;
           
            let html = '<div class="row mt-1"><div class="col-1 high-sn"></div><div class="col-10"><input type="text" name="heighlite[]" placeholder="Enter heighlites" class="form-control form-control -sm"></div><div class="col-1"><a class="remove-height" onclick="RemoveHighlites(this)" href="#"><i class="fa fa-times"></i></a></div></div>';
            $('#heighlites').append(html);
            $('#heighlites .high-sn').each(function(){
                $(this).text(sn++ +'.');
            });

        });
       

        $("#prevMulti").on("change", function(e) {
            $("#productImage").empty();//you can remove this code if you want previous user input
            for(let i=0;i<this.files.length;++i){
                let filereader = new FileReader();
                let $img=jQuery.parseHTML("<img src=''>");
                filereader.onload = function(){
                    $img[0].src=this.result;
                };
                filereader.readAsDataURL(this.files[i]);
                $("#productImage").append($img);
            }
        });


        $('input[name=price]').keyup(function(){
            let mrp = parseInt($('input[name=mrp]').val());
            let price = parseInt($('input[name=price]').val());
            let discount = 0;
            if(price > 0){
                let diff = mrp-price;
                if(diff > 0){
                    discount = ((diff*100)/mrp).toFixed(2);
                }else{
                    discount = 0;
                }
                $('input[name=discount]').val(discount);
            }            
        });

        $('input[name=discount]').keyup(function(){
            let mrp = parseInt($('input[name=mrp]').val());
            let discount = parseFloat($('input[name=discount]').val());
            let price = 0;
            if(discount > 0){
                let price = ((mrp*discount)/100).toFixed(2);
                $('input[name=price]').val(mrp-price);
            }            
        });

    });
    var editor = CKEDITOR.replace( 'full_desc' );

// The "change" event is fired whenever a change is made in the editor.
        editor.on( 'change', function( evt ) {
            // getData() returns CKEditor's HTML content.
            $('#full_desc').val(evt.editor.getData());
            // console.log( 'Total bytes: ' + evt.editor.getData() );
        });
</script> 