<?php include_once("include/main.inc.php"); ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Shopping Cart</title>
    <meta name="keywords" content="" />
    <meta name="description" content="" />
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>
    <section class="inner_breadcrumb2 inner_breadcrumb">
        <div class="container ">
                <ul class="breadcrumb">
                    <li><a href="index.php" title="Home">Home</a></li>
                    <li class="active">Shopping Cart</li>
                </ul>
        </div>
    </section>

    <section class="cart_page">
        <div class="container">
            <div class="row">
                <div class="col-lg-9 col-md-9 col-sm-8 col-12">
                    <div class="cart_left">
                        <h1 class="bx-title">Shopping Cart</h1>

                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Hey!</strong> Your shopping cart contains: 1 Product
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <div style="overflow-x: auto;">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th class="text-start">Unit Price </th>
                                        <th class="text-center">QTY</th>
                                        <th class="text-center">Total</th>
                                        <th class="text-center">Remove</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td data-label="PRODUCT">
                                            <div class="cart_image">
                                                <a href="javascript:void()"><img src="designer/images/buy-laptop/Lenovo-V15.jpg"></a>
                                            </div>
                                            <div class="cart_info">
                                                <a href="javascript:void()">Lenovo V15 Series (13'' Intel Core i5)- Refurbished</a>
                                                <p>In Warranty, Good, 8 GB / 128 GB SSD, Windows 11, Space Gray</p>
                                            </div>
                                        </td>
                                        <td class="text-center" data-label="UNIT PRICE">
                                            <div class="price">
                                                <div class="cart_off_label">20%off</div>
                                                <span class="old_price"><i class="fa fa-inr"></i> 40,000</span>
                                                <i class="fa fa-inr"></i> 32,000
                                            </div>
                                        </td>

                                        <td class="text-center" data-label="QTY">
                                            <div class="details_qty mb-0">
                                                <input type="button" value="-" class="minus" />
                                                <input type="text" name="qty" id="qty" value="1" class="qty" maxlength="10">
                                                <input type="button" value="+" class="plus" />
                                            </div>
                                        </td>
                                        <td class="text-center" data-label="TOTAL">
                                            <div class="price">
                                                <i class="fa fa-inr"></i> 32,000
                                            </div>
                                        </td>
                                        <td class="text-center" data-label="REMOVE">
                                            <a class="cart_remove" href="javascript:void()" title="remove"><i class="fa fa-remove"></i></a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <a class="shopping_btn" href="listing.php" title="Continue Shopping"><i class="fa fa-angle-left"></i> Continue Shopping</a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-4 col-12">
                    <div class="cart_right_title">Price Details</div>
                    <div class="cart_right">
                        <table class="table table-totals">
                            <tbody>
                                <tr>
                                    <td>Price (2 item)</td>
                                    <td><i class="fa fa-inr"></i> 9600</td>
                                </tr>
                                <tr>
                                    <td>Discount Price</td>
                                    <td>- <i class="fa fa-inr"></i> 200</td>
                                </tr>
                                <tr>
                                    <td>Delivery Charges</td>
                                    <td class="free">Free</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td>Amount Payable</td>
                                    <td>
                                        <div class="payable"><i class="fa fa-inr"></i> 9400</div>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                        <a class="order_btn" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#productID" title="Order Now">Order Now</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>