<?php
    include_once ("include/main.inc.php");
    date_default_timezone_set('Asia/Kolkata');
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    if(isset($_POST['lp_switch']) && isset($_POST['lp_processer'])){
        $error = array('success' => false, 'error_type' => 'before');
        $in = $_POST;
        // print_r($in);
        if(empty($in['name'])){$error['message']['name'] = '<span class="frmErr">Enter name</span>';}
        if(empty($in['email']) || !filter_var($in['email'], FILTER_VALIDATE_EMAIL)){$error['message']['email'] = '<span class="frmErr">Enter valid email address</span>';}
        if(empty($in['mobile'])){$error['message']['mobile'] = '<span class="frmErr">Enter mobile number</span>';}
        if(empty($in['g-recaptcha-response'])){$error['message']['g-recaptcha-response'] = '<span class="frmErr">Please check recaptcha</span>';}
        if(!isset($error['message'])){

            $secret = secret_key;
            $data = array('secret' => $secret, 'response' => $_POST['g-recaptcha-response']);
            $verify = curl_init();
            curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
            curl_setopt($verify, CURLOPT_POST, true);
            curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($verify); //var_dump($response);
            $response = json_decode($response);
            if ($response->success) {
                $otp = rand(1000, 9999);
                $systm_details = '';
                $systm_details .= 'Plateform: '.$_SERVER['HTTP_SEC_CH_UA_PLATFORM'];
                $systm_details .= 'Mobile: '.$_SERVER['HTTP_SEC_CH_UA_MOBILE'];
                $systm_details .= 'Browser: '.$_SERVER['HTTP_SEC_CH_UA'];
                $data = array(
                    'name' => $in['name'],
                    'mobile' => $in['mobile'],
                    'email' => $in['email'],
                    'comment' => '',
                    'enquiry_type' => 'SELL',
                    'enquiry_details' => $in['lp_details'],
                    'product_name' => $in['lp_catName'],
                    'pincode' => '',
                    'location' => '',
                    'create_date' => date('Y-m-d H:i:s'),
                    'uri_page' => $_SERVER['HTTP_REFERER'],
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'platform' => trim($_SERVER['HTTP_SEC_CH_UA_PLATFORM'], '"'),
                    'browser' => str_replace('"', '', explode(',', $_SERVER['HTTP_SEC_CH_UA'])[1]),
                    'status' => 0,
                    'countryName' => $in['countryName'],
                    'countryCode' => $in['code'],
                    'otp' =>  $otp,
                    'verified' => 0
                );
                $sql = insertintable('tbl_enquiry', $data);
                if($sql){
                    
                    if(in_array($in['lp_catId'], [12,39,13])){
                        $price = price_calculate_apple($in);
           
                    }else{
                        $price = price_calculate($in);
                    }
                    $_SESSION['inqId'] = $sql;
                    $_SESSION['otp'] = $otp;
                    $_SESSION['catName'] = $in['lp_catName'];
                    $_SESSION['calcPrice'] = $price;
                    $_SESSION['sellDetail'] = $data['enquiry_details'];
                    // send_otp($in['name'], $in['email'], $otp);
                    sendOTP1($in['mobile'], $otp);
                    send_sell_enquiry($data, $admin_res);
                    $error['success'] = true;
                    // $error['price'] = $price;
                    // $error['d'] = $otp;
                    //$error['rlink'] = site_url."/final-price/".str_replace(' ', '-', strtolower($in['lp_catName'])).'.htm';

                }
            }else{
                $error['message']['g-recaptcha-response'] = '<span class="frmErr">Robot verification failed, please try again.</span>';
            }
            
        }

        echo json_encode($error);
    }

    if(isset($_POST['enqOtp'])){
        $error = array('success' => false, 'error_type' => 'before');
        $in = $_POST;
        if(empty($in['enqOtp']) || $in['enqOtp'] != $_SESSION['otp']){$error['message']['enqOtp'] = '<span class="frmErr">Enter valid OTP</span>';}
       
        if(!isset($error['message'])){
            $data = array(
                'verified' => 1,
                'enquiry_details' => $_SESSION['sellDetail'].'<p>Calculated Price: '.$_SESSION['calcPrice'].'</p>'
            );
            $sql = updateintable('tbl_enquiry', $data, ['enq_id', $_SESSION['inqId']]);
            if($sql){
                $error['success'] = true;
                $error['rlink'] = site_url."/final-price/".str_replace(' ', '-', strtolower($_SESSION['catName'])).'.htm';
                unset($_SESSION['otp']);
                unset($_SESSION['inqId']);
                unset($_SESSION['catName']);
            }
            
        }

        echo json_encode($error);
    }


    if(isset($_POST['pincodeFinder'])){

        $error = array('success' => false);
        $in = $_POST;
        if(empty($in['pincode']) || !ctype_digit($in['pincode'])){$error['msg'] = 'Enter valid pincode';}
       
        if(!isset($error['msg'])){
            $url = 'https://api.postalpincode.in/pincode/'.$in['pincode'];
            $resp = json_decode(file_get_contents($url))[0];

            if($resp->Status == 'Success'){
                $state = $resp->PostOffice[0];
                $error['html'] = 'State: '. $state->State.', District: '. $state->District;
                $error['success'] = true;
            }else{
                $error['msg'] = 'This Pincode not found please try another pincode.';
            }

           // $location = $resp->PostOffice[0];

            
            
            
        }

        echo json_encode($error);
    }


    function price_calculate($in){
        $whr = '';
        if($in['lp_switch'] == 'Yes'){$whr .= $in['lp_processer'].",";}
        $whr .= "'".$in['lp_ram']."',";
        $whr .= "'".$in['lp_hdd']."',";
        $whr .= "'".$in['lp_screentype']."',";
        $whr .= "'".$in['lp_screensize']."',";
        $whr .= "'".$in['lp_screensize']."',";
        if($in['lp_graphics'] == 1){$whr .= "'".$in['lp_grephicscard']."',";}

        $price = mysqli_fetch_assoc(mysqli_query($GLOBALS['dbconn'], "SELECT SUM(price) AS price FROM selling_perameters_price WHERE sp_id IN (".rtrim($whr, ',').") AND catId=".$in['lp_catId']));

        $finaprice = $calprice = $price['price'];

        $data = array(
            '1' => 5,
            '2' => 10,
            '3' => 5,
            '4' => 5,
            '5' => 10,
            '6' => 10,
            '7' => 5,
            '8' => 10,
            '9' => 5,
            '10' => 50,
            '11' => 10,
            '12' => 5
        );
        foreach(explode(',', $in['lp_function']) as $f){
            if(isset($data[$f])){
                $finaprice -=  $calprice*($data[$f]/100);
            }
        }

        if($in['lp_physicalCondition'] == 1){$finaprice +=  $calprice*(5/100);}
        if($in['lp_physicalCondition'] == 3){$finaprice -=  $calprice*(15/100);}
        if($in['lp_physicalCondition'] == 4){$finaprice -=  $calprice*(50/100);}
        if($in['lp_deviceAge'] == 5){$finaprice +=  $calprice*(12/100);}
        if($in['lp_deviceAge'] == 6){$finaprice +=  $calprice*(10/100);}
        if($in['lp_deviceAge'] == 7){$finaprice +=  $calprice*(5/100);}
        if($in['lp_deviceAge'] == 9){$finaprice +=  $calprice*(2/100);}
        if($in['lp_screenCondition'] == 11){$finaprice -=  $calprice*(10/100);}
        if($in['lp_screenCondition'] == 12){$finaprice -=  $calprice*(20/100);}
        return ($finaprice <100)?100:$finaprice;
    }

    function price_calculate_apple($in){
        $whr = '';
        if(!empty($in['lp_graphics'])){$whr .= " AND model_year=".$in['lp_graphics']; }
        if(!empty($in['lp_processer'])){$whr .= " AND processor='".$in['lp_processer']."'"; }
        if(!empty($in['lp_ram'])){$whr .= " AND ram='".rtrim($in['lp_ram'], 'GB')."'"; }
        if(!empty($in['lp_hdd'])){$whr .= " AND hard_disk='".trim($in['lp_hdd'])."'"; }
        if(!empty($in['screen'])){$whr .= " AND screen_size='".$in['screen']."'"; }
        if(!empty($in['lp_screentype'])){$whr .= " AND screen_qlty='".$in['lp_screentype']."'"; }
        $price = mysqli_fetch_assoc(mysqli_query($GLOBALS['dbconn'], "SELECT sell_price FROM selling_price_apple WHERE catId=".$in['lp_catId'].$whr));
        $finaprice = $calprice = $price['sell_price'];
        

        $data = array(
            '1' => 5,
            '2' => 10,
            '3' => 5,
            '4' => 5,
            '5' => 10,
            '6' => 10,
            '7' => 5,
            '8' => 10,
            '9' => 5,
            '10' => 50,
            '11' => 10,
            '12' => 5
        );
        foreach(explode(',', $in['lp_function']) as $f){
            if(isset($data[$f])){
                $finaprice -=  $calprice*($data[$f]/100);
            }
        }

        if($in['lp_physicalCondition'] == 1){$finaprice +=  $calprice*(5/100);}
        if($in['lp_physicalCondition'] == 3){$finaprice -=  $calprice*(15/100);}
        if($in['lp_physicalCondition'] == 4){$finaprice -=  $calprice*(50/100);}
        if($in['lp_deviceAge'] == 5){$finaprice +=  $calprice*(12/100);}
        if($in['lp_deviceAge'] == 6){$finaprice +=  $calprice*(10/100);}
        if($in['lp_deviceAge'] == 7){$finaprice +=  $calprice*(5/100);}
        if($in['lp_deviceAge'] == 9){$finaprice -=  $calprice*(2/100);}
        if($in['lp_screenCondition'] == 11){$finaprice -=  $calprice*(25/100);}
        if($in['lp_screenCondition'] == 12){$finaprice -=  $calprice*(50/100);}
        return ($finaprice <100)?100:$finaprice;
        // return "SELECT sell_price FROM selling_price_apple WHERE catId=".$in['lp_catId'].$whr;
    }
    function sendOTP1($mobile, $otp) {
        $secret = 'AtPcCQHeqSYpsEZdIz0l'; 
        $sender = 'SKINFS';
        $message = "Dear User, Welcome to selold.com. Please share this OTP $otp for displaying the price S.K. INFOSOLUTIONS";
        $tempid = '1707172231647364413';
        
        // URL encode the message
        $message = urlencode($message);
      
        $url = "https://sms.staticking.com/index.php/smsapi/httpapi/?secret=$secret&sender=$sender&tempid=$tempid&receiver=$mobile&route=TA&msgtype=1&sms=$message";
      
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = curl_exec($ch);
      
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
      
        curl_close($ch);
      
        return $response;
      }
    function send_otp($name, $to, $otp){
        $email = 'server@selold.com';
        $subject = 'Verification Code: selold.com';
        $msg = '<div style="margin: 0 25%; border: 1px solid #e3e3e3;">
        <div style="background-color: #fff;text-align: center; padding: 5px; border-bottom:1px solid #ccc">
           <img style="height: 50px;" src="'.site_url.'/uploaded-files/logo//logo.png" alt="Sel old">
        </div>
        <div style="padding: 45px 30px 45px; text-align: center; background: #fff;">
           <div style="width: 100%; margin: 0 auto; ">
                <p style="margin-top: 20px; text-align: start; ">Hey '. $name .',</p>
                <p style="text-align: start; ">Here is th OTP to confirm your request.</p>
                <p style="text-align: start; "> OTP is valid for <b style="color: #1f1f1f">5 minutes</b>. Do not share this code with others.</p>
                <p style="text-align: start; ">Your Verification Code is :</p>
                <p style="margin: 15px 0; font-size: 35px; font-weight: 600; letter-spacing: 4px;">'.$otp.'</p> 
                <p style="text-align: start; ">If you have any concerns, please reach out to our support team.</p> 
                <p style="text-align: start; margin: 55px 0 0; ">Best Regards,</p>
                <p style="text-align: start; margin: 0px 0 50px; ">SEL OLD</p> 
           </div>
        </div>
        <div style="text-align: center; color: #8c8c8c; padding-bottom: 45px;">
           <p>Need help? Ask at <a href="mailto:support@selold.com" style="color: #499fb6; text-decoration: none">support@selold.com</a> or visit our <a href="https://www.selold.com/" style="color: #499fb6; text-decoration: none">www.selold.com</a></p>
           <p style="margin: 0 0 4px; font-weight: 600;"SK Infosolutions</p>
           <p style="margin: 0 0 4px; font-size: 11px;">E-15/91, 3rd Floor, Sector-8 Rohini, Delhi 110085, India</p>
           <p style="margin: 0; font-size: 11px;">Copyright © 2024 SK Infosolutions. All rights reserved.</p>
        </div>
     </div>';
     
        smtp_mailer($to,$email,'SEL OLD',$subject,$msg);
    }



    if(isset($_POST['loadProduct'])){
        $error = array('success' => false);
        $in = $_POST;
        if(empty($in['start']) || !ctype_digit($in['start'])){$error['msg'] = 'invalid start';}
        if(empty($in['whr'])){$error['msg'] = 'invalid start';}
       
        if(!isset($error['msg'])){
            
            $target_location = $in['loadProduct'];
            $filter_atr = [];
            $attribute_tbl = mysqli_query($dbconn, "SELECT * FROM tbl_attributes WHERE status=1");
            $attributes_array = $attributes = $brands_array = [];
            while ($atrb = mysqli_fetch_array($attribute_tbl)) {
                $attributes[$atrb['attributes_id']] = $atrb;
                $attributes_array[$atrb['parent_id']][] = $atrb['attributes_id'];
            }
            
            $products = mysqli_query($GLOBALS['dbconn'], "SELECT * FROM product_tbl WHERE quantity>0 AND product_status=1 " . $in['whr'] . " order by product_id desc limit ".$in['start'].", 5");
            while ($prd = mysqli_fetch_assoc($products)) {
                $image_path = explode(',', $prd['product_image']);
                $img_thumb = getImage($image_path[0], 270, 270, $prd['product_title'], "/uploaded-files/product-images/");
                ?>
                <div class="pr-li mb-2">
                    <div class="row g-0 align-items-stretch">
                        <div class="col-md-4 col-12 g_col">
                            <div class="img_bx">
                                <a href="<?=site_url;?>/<?=getValidFileName($prd['product_name']);?>.htm" title="Buy Old <?= $prd['product_title']; ?> in <?= $target_location ?>">
                                <img src="<?= $img_thumb; ?>"
                                    alt="<?= $prd['product_title']; ?>" title="Buy Old <?= $prd['product_title']; ?> in <?= $target_location ?>">
                                </a>
                                    <?php if($prd['quantity'] < 10){ ?>
                                    <div class="stock-badge">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clock-history" viewBox="0 0 16 16">
                                            <path d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022zm2.004.45a7 7 0 0 0-.985-.299l.219-.976q.576.129 1.126.342zm1.37.71a7 7 0 0 0-.439-.27l.493-.87a8 8 0 0 1 .979.654l-.615.789a7 7 0 0 0-.418-.302zm1.834 1.79a7 7 0 0 0-.653-.796l.724-.69q.406.429.747.91zm.744 1.352a7 7 0 0 0-.214-.468l.893-.45a8 8 0 0 1 .45 1.088l-.95.313a7 7 0 0 0-.179-.483m.53 2.507a7 7 0 0 0-.1-1.025l.985-.17q.1.58.116 1.17zm-.131 1.538q.05-.254.081-.51l.993.123a8 8 0 0 1-.23 1.155l-.964-.267q.069-.247.12-.501m-.952 2.379q.276-.436.486-.908l.914.405q-.24.54-.555 1.038zm-.964 1.205q.183-.183.35-.378l.758.653a8 8 0 0 1-.401.432z"></path>
                                            <path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0z"></path>
                                            <path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5"></path>
                                        </svg>
                                    
                                        <span>Only <?= $prd['quantity']; ?> Left</span>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-8 col-12 g_col">
                            <div class="tx-bx product_details">
                                <div class="sub-tt text-dark mb-1 fs-5">
                                    <a href="<?=site_url;?>/<?=getValidFileName($prd['product_name']);?>.htm" title="Buy Old <?= $prd['product_title']; ?> in <?= $target_location ?>">
                                        <?= $prd['product_title']; ?>
                                    </a>
                                </div>
                                <div class="star mb-2">
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star-half-o"></i>
                                </div>
                                <div class="price mb-2">
                                    <span class="old_price"><i class="fa fa-inr"></i>
                                        <?= $prd['mrp'] * 1; ?></span>
                                    <i class="fa fa-inr"></i><?= $prd['product_price'] * 1; ?>
                                    <?php if ($prd['discount'] > 0) { ?>
                                        <div class="off_label "><?= $prd['discount'] * 1; ?>% off</div>
                                    <?php } ?>
                                </div>
                                <ul class="_1xgFaf">
                                    <?php
                                    if (!empty($prd['attributes_id'])) {
                                        $prdatr = [];
                                        foreach (explode(',', $prd['attributes_id']) as $atr) {
                                            $filter_atr[$attributes[$atr]['parent_id']][] = $atr;
                                            $prdatr[$attributes[$atr]['parent_id']][] = $attributes[$atr]['attributes_name'];
                                        }

                                        if (!empty($prdatr)) {
                                            foreach ($prdatr as $at_key => $at_v) {
                                                if(isset($attributes[$at_key])){
                                                    echo '<li class="rgWa7D"><b>';
                                                    echo $attributes[$at_key]['attributes_name'] . '</b>: ';
                                                    foreach ($at_v as $single_atrb) {
                                                        echo $single_atrb . ' ';
                                                    }
                                                    echo '</li>';
                                                }
                                            }
                                        }
                                    }
                                    ?>
                                    <!---- <li class="rgWa7D">Intel Core i5 Processor </li>
                                        <li class="rgWa7D">16 GB RAM</li>
                                        <li class="rgWa7D">Windows 11 Operating System</li>
                                        <li class="rgWa7D">128 GB SSD</li> -->
                                </ul>
                                <a href="<?=site_url;?>/<?=getValidFileName($prd['product_name']);?>.htm" title="Buy Old <?= $prd['product_title']; ?> in <?= $target_location ?>" class="moreBtn">View More 
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right-short" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8"></path>
                                    </svg></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } 

           
        }

    }



    if(isset($_POST['getHdd'])){
        $in = $_POST;
        $whr = '';
        if(isset($in['modelYear'])){$whr .= " AND model_year=".$in['modelYear']; }
        if(isset($in['processor'])){$whr .= " AND processor='".$in['processor']."'"; }
        if(isset($in['ram']) && !empty($in['ram'])){$whr .= " AND ram='".rtrim($in['ram'], 'GB')."'"; }
        if(isset($in['hdd']) && !empty($in['hdd'])){$whr .= " AND hard_disk='".$in['hdd']."'"; }
        if(isset($in['screen']) && !empty($in['screen'])){$whr .= " AND screen_size='".$in['screen']."'"; }
        $parts = mysqli_query($dbconn, "SELECT * FROM selling_price_apple WHERE `status`=1 AND catId=".$in['catId'].$whr);
        $data = $hdd = $ram = $processor = $screen = $screen_type = [];

        while($prt = mysqli_fetch_assoc($parts)){
            if(!empty($prt['processor'])){$processor[] = $prt['processor'];}
            if(!empty($prt['ram'])){$ram[] = $prt['ram'];}
            if(!empty($prt['hard_disk'])){$hdd[] = $prt['hard_disk'];}
            if(!empty($prt['screen_size'])){$screen[] = $prt['screen_size'];}
            if(!empty($prt['screen_qlty'])){$screen_type[] = $prt['screen_qlty'];}
        }
        if(!empty($processor)){
            $data['processor'] = '<option value="">Select Processor</option>';
            foreach(array_unique($processor) as $i){$data['processor'] .= '<option value="'.$i.'">'.$i.'</option>';}
        }
        if(!empty($ram)){
            $data['ram'] = '<option value="">Select Ram</option>';
            foreach(array_unique($ram) as $i){$data['ram'] .= '<option value="'.$i.' GB" data-id="'.$i.'">'.$i.' GB</option>';}
        }
        if(!empty($hdd)){
            $data['hdd'] = '<option value="">Select Hard disk</option>';
            foreach(array_unique($hdd) as $i){$data['hdd'] .= '<option value="'.$i.'">'.$i.'</option>';}
        }
        if(!empty($screen)){
            $data['screen'] = '<option value="">Select Screen</option>';
            foreach(array_unique($screen) as $i){$data['screen'] .= '<option value='.$i.'" data-id="'.$i.'">'.$i.'"</option>';}
        }
        if(!empty($screen_type)){
            $data['screen_type'] = '<option value="">Select Screen Type</option>';
            foreach(array_unique($screen_type) as $i){$data['screen_type'] .= '<option value="'.$i.'">'.$i.'</option>';}
        }
        
        echo json_encode($data);
    }


    function send_sell_enquiry($in, $admin_res){
        $email = 'server@selold.com';
        $subject = 'Enquiry from : selold.com';
        $to = $admin_res['email'];
        $htmlContent = '<table border="0" width="100%">
            <tbody>
              <tr>
                <td colspan="2"><strong>Dear Admin</strong></td></tr>
                <tr><td colspan="2">Enquiry Received with following info: </td></tr>
                <tr><td colspan="2">&nbsp;</td></tr>
                <tr><td width="26%"><strong>Post URL: </strong></td><td><span style="margin-top: 15px;">'.$in['uri_page'].'</span></td></tr>
                <tr><td width="26%"><strong>Name: </strong></td><td><span style="margin-top: 15px;">' . $in['name'] . '</span></td></tr>
                <tr><td width="26%"><strong>Email Id: </strong></td><td><span style="margin-top: 15px;">' . $in['email'] . '</span></td></tr>
                <tr><td width="26%"><strong>Mobile: </strong></td><td><span style="margin-top: 15px;">' . $in['mobile'] . '</span></td></tr>
                <tr><td><strong>Country: </strong></td><td><span style="margin-top: 15px;">' . $in['countryName'] . '</span></td></tr>
                <tr><td width="26%"><strong>Code: </strong></td><td><span style="margin-top: 15px;">' .  $in['countryCode']  . '</span></td></tr>
                <tr><td><strong>Calculated Price: </strong></td><td>'.$_SESSION['calcPrice'].'</td></tr>
                <tr><td><strong>Product: </strong></td><td>'.$in['product_name'].'</td></tr>
                <tr><td><strong>Inquiry Details: </strong></td><td> </td></tr>
                <tr><td><strong> </strong></td><td><span style="margin-top: 15px;">' . $in['enquiry_details'] . '</span></td></tr>
              </tbody></table>';
     
            $to = $admin_res['email'];
            $to2 = $admin_res['cc'];
            
            $to3 = 'webpulseindia@gmail.com'; 
          
            $email = 'server@selold.com';
            $name = 'SEL OLD';
            // $headers = 'From: '.'Webpulseindia.com'.' enquiry@webpulseindia.com' . "\r\n" .
            // 'Reply-To:  '.$name.'<'.$email.'>' . "\r\n" .
            // 'X-Mailer: PHP/' . phpversion();
            // @mail($to,$subject,$htmlContent,$headers);
            // @mail($to2,$subject,$htmlContent,$headers);
            // @mail($to3,$subject,$htmlContent,$headers);
            if ($to != '') {
                smtp_mailer($to, $email, $name, $subject, $htmlContent);
            }
            if ($to2 != '') {
                smtp_mailer($to2, $email, $name, $subject, $htmlContent);
            }
            smtp_mailer($to3, $email, $name, $subject, $htmlContent);
    }


    if(isset($_POST['corporateEnqury'])){
        $error = array('success' => false, 'error_type' => 'before');
        $in = $_POST;
        if(empty($in['qty'])){$error['message']['qty'] = '<span class="frmErr text-danger">Enter quantity</span>';}
        if(empty($in['name'])){$error['message']['name'] = '<span class="frmErr text-danger">Enter name</span>';}
        if(empty($in['org_name'])){$error['message']['org_name'] = '<span class="frmErr text-danger">Enter organization name</span>';}
        if(empty($in['email']) || !filter_var($in['email'], FILTER_VALIDATE_EMAIL)){$error['message']['email'] = '<span class="frmErr">Enter valid email address</span>';}
        if(empty($in['mobile'])){$error['message']['mobile'] = '<span class="frmErr text-danger">Enter mobile number</span>';}
        if(empty($in['g-recaptcha-response'])){$error['message']['corporateEnqury'] = '<span class="frmErr text-danger">Please check recaptcha</span>';}
        if(!isset($error['message'])){

            $secret = secret_key;
            $data = array('secret' => $secret, 'response' => $_POST['g-recaptcha-response']);
            $verify = curl_init();
            curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
            curl_setopt($verify, CURLOPT_POST, true);
            curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($verify); //var_dump($response);
            $response = json_decode($response);
            if ($response->success) {
                $otp = rand(1000, 9999);
                $systm_details = '';
                $systm_details .= 'Plateform: '.$_SERVER['HTTP_SEC_CH_UA_PLATFORM'];
                $systm_details .= 'Mobile: '.$_SERVER['HTTP_SEC_CH_UA_MOBILE'];
                $systm_details .= 'Browser: '.$_SERVER['HTTP_SEC_CH_UA'];
                $data = array(
                    'name' => $in['name'].' ('.$in['org_name'].')',
                    'mobile' => $in['mobile'],
                    'email' => $in['email'],
                    'comment' => $in['message'],
                    'enquiry_type' => 'OTHER',
                    'enquiry_details' => 'Corporate Enquiry for '.$in['enqtype'].' Laptops, Quantity: '.$in['qty'],
                    'product_name' => '',
                    'pincode' => $in['pincode'],
                    'location' => $in['location'],
                    'create_date' => date('Y-m-d H:i:s'),
                    'uri_page' => $_SERVER['HTTP_REFERER'],
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'platform' => trim($_SERVER['HTTP_SEC_CH_UA_PLATFORM'], '"'),
                    'browser' => str_replace('"', '', explode(',', $_SERVER['HTTP_SEC_CH_UA'])[1]),
                    'status' => 0,
                    'countryName' => $in['countryName'],
                    'countryCode' => $in['code'],
                    'otp' =>  $otp,
                    'verified' => 0
                );
                $sql = insertintable('tbl_enquiry', $data);
                if($sql){
                    send_corporate_enquiry($data, $admin_res);
                    $error['success'] = true;
                }
            }else{
                $error['message']['g-recaptcha-response'] = '<span class="frmErr">Robot verification failed, please try again.</span>';
            }            
        }
        echo json_encode($error);
    }

    function send_corporate_enquiry($in, $admin_res){
        $email = 'server@selold.com';
        $subject = 'Corporate Enquiry from : selold.com';
        $to = $admin_res['email'];
        $htmlContent = '<table border="0" width="100%">
            <tbody>
              <tr>
                <td colspan="2"><strong>Dear Admin</strong></td></tr>
                <tr><td colspan="2">Enquiry Received with following info: </td></tr>
                <tr><td colspan="2">&nbsp;</td></tr>
                <tr><td width="26%"><strong>Post URL: </strong></td><td><span style="margin-top: 15px;">'.$in['uri_page'].'</span></td></tr>
                <tr><td width="26%"><strong>Name: </strong></td><td><span style="margin-top: 15px;">' . $in['name'] . '</span></td></tr>
                <tr><td width="26%"><strong>Email Id: </strong></td><td><span style="margin-top: 15px;">' . $in['email'] . '</span></td></tr>
                <tr><td width="26%"><strong>Mobile: </strong></td><td><span style="margin-top: 15px;">' . $in['mobile'] . '</span></td></tr>
                <tr><td><strong>Country: </strong></td><td><span style="margin-top: 15px;">' . $in['countryName'] . '</span></td></tr>
                <tr><td width="26%"><strong>Code: </strong></td><td><span style="margin-top: 15px;">' .  $in['countryCode']  . '</span></td></tr>
                <tr><td><strong>Enquiry Type: </strong></td><td>'.$in['enquiry_details'] .'</td></tr>
                <tr><td><strong>Comment: </strong></td><td><span style="margin-top: 15px;">' . $in['comment'] . '</span></td></tr>
              </tbody></table>';

        $to = $admin_res['email'];
        $to2 = $admin_res['cc'];
        $to3 = 'webpulseindia@gmail.com';
       
        $email = 'server@selold.com';
        $name = 'SEL OLD';
        // $headers = 'From: '.'Webpulseindia.com'.' enquiry@webpulseindia.com' . "\r\n" .
        // 'Reply-To:  '.$name.'<'.$email.'>' . "\r\n" .
        // 'X-Mailer: PHP/' . phpversion();
        // @mail($to,$subject,$htmlContent,$headers);
        // @mail($to2,$subject,$htmlContent,$headers);
        // @mail($to3,$subject,$htmlContent,$headers);
        if ($to != '') {
            smtp_mailer($to, $email, $name, $subject, $htmlContent);
        }
        if ($to2 != '') {
            smtp_mailer($to2, $email, $name, $subject, $htmlContent);
        }
        smtp_mailer($to3, $email, $name, $subject, $htmlContent);
     
    }

?>