function stickyHeader() {
  if ($(".menubar").length) {
    var strickyScrollPos = 100;
    if ($(window).scrollTop() > strickyScrollPos) {
      $(".menubar").addClass("stricky-fixed");
    } else if ($(this).scrollTop() <= strickyScrollPos) {
      $(".menubar").removeClass("stricky-fixed");
    }
  }
}

jQuery(window).on("scroll", function () {
  (function ($) {
    stickyHeader();
  })(jQuery);
});

if ($(".navigation").length) {
  $(".navigation .navbar button").on("click", function () {
    $(".navigation .menu").slideToggle();
    $(this).toggleClass("open");
    return false;
  });
  $(".navigation .cs-submenu")
    .children("a")
    .append(function () {
      return '<button class="dropdown-expander"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z"/></svg></button>';
    });
}

if (document.documentElement.clientWidth < 1023) {
  $(".navigation .menu .dropdown-expander").on("click", function () {
    $(this).parent().parent().children(".cs-dropdown").slideToggle();
    console.log($(this).parents("li"));
    console.log(
      $(this).parents().children(".dropdown-expander").toggleClass("rotated")
    );
    return false;
  });
  $(document).click(function (e) {
    if (!$(e.target).closest(".navigation .navbar button").length) {
      $(".navigation .menu").stop(true).slideUp();
      $(".navigation .navbar button").removeClass("open");
    }
  });
}

var swiper = new Swiper(".homeSlider", {
  pagination: ".swiper-pagination",
  slidesPerView: "auto",
  paginationClickable: true,
  loop: true,
  autoplay: {
    delay: 7000,
  },
  effect: "fade",
  spaceBetween: 0,
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
  breakpoints: {
    1920: {
      slidesPerView: 1
    },
    1028: {
      slidesPerView: 1
    },
    480: {
      slidesPerView: 1
    },
    0: {
      slidesPerView: 1
    }
  }

});

var imageCarousel = $(".image-carousel");
imageCarousel.owlCarousel({
  center: true,
  margin: 20,
  navSpeed: 500,
  nav: true,
  navText: ['<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg>', '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg>'],
  autoplay: true,
  loop: true,
  dots: false,
  items: 1,
  responsiveClass: true,
  responsive: {
    1200: {
      items: 3
    },
    768: {
      items: 2
    },
    480: {
      items: 1
    }
  }
});


var videoGallery = $(".video-gallery");
videoGallery.owlCarousel({
  center: true,
  margin: 10,
  navSpeed: 500,
  nav: true,
  navText: ['<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg>', '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg>'],
  autoplay: true,
  loop: true,
  dots: false,
  items: 1,
  responsiveClass: true,
  responsive: {
    1200: {
      items: 5
    },
    768: {
      items: 4
    },
    480: {
      items: 2
    }
  }
});

var products = $("#products");
products.owlCarousel({
  loop: false,
  rewind: true,
  margin: 10,
  navSpeed: 500,
  nav: true,
  navText: ['<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg>', '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg>'],
  autoplay: true,
  dots: true,
  items: 4,
  responsiveClass: true,
  responsive: {
    0: {
      items: 1
    },
    600: {
      items: 1,
    },
    810: {
      items: 2
    },
    1024: {
      items: 3
    },
    1100: {
      items: 4
    }
  }
});

var testimonials = $("#testimonials");
testimonials.owlCarousel({
  loop: true,
  margin: 15,
  navSpeed: 500,
  nav: false,
  navText: ['<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg>', '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg>'],
  autoplay: true,
  dots: true,
  items: 3,
  center: true,
  responsiveClass: true,
  responsive: {
    0: {
      items: 1
    },
    600: {
      items: 1,
    },
    1024: {
      items: 3
    },
    1100: {
      items: 3
    }
  }
});

wow = new WOW({
  animateClass: 'animated',
  offset: 100,
  mobile: false
});
wow.init()

$(window).on('scroll', function () {
  if ($(this).scrollTop() > 100) {
    $("#scrollUp").fadeIn();
  } else {
    $("#scrollUp").fadeOut();
  }
});
$("#scrollUp").on('click', function () {
  $("html, body").animate({
    scrollTop: 0
  }, 600);
  return false;
});

$('#thumbs img').click(function () {
  $('#largeImage').attr('src', $(this).attr('src').replace('thumb', 'large'));
  if ($(this).hasClass("active")) {
    $("#thumbs img").removeClass("active");
  } else {
    $("#thumbs img").removeClass("active");
    $(this).addClass("active");
  }
});
$(".telePhone").intlTelInput({
  preferredCountries: ["in", "us"],
  initialCountry: "in",
  separateDialCode: true,
});


document.addEventListener('DOMContentLoaded', () => {
  const titleCache = new Map();
  const initializeYouTubePlayers = () => {
    document.querySelectorAll('.youtube-player').forEach(player => {
      const videoId = player.dataset.id;
      if (!videoId) return;

      const thumbnail = createThumbnail(videoId);
      player.appendChild(thumbnail);

      if (titleCache.has(videoId)) {
        updateThumbnail(thumbnail, titleCache.get(videoId));
      } else {
        fetchVideoTitle(videoId)
          .then(title => {
            titleCache.set(videoId, title);
            updateThumbnail(thumbnail, title);
          })
          .catch(() => updateThumbnail(thumbnail, 'YouTube Video'));
      }
    });
  };
  const createThumbnail = (videoId) => {
    const container = document.createElement('div');
    container.className = 'youtube-thumbnail';
    container.innerHTML = `
<img loading="lazy" src="https://i.ytimg.com/vi/${videoId}/sddefault.jpg" alt="Loading video...">
<span></span>
<a href="https://www.youtube.com/watch?v=${videoId}" class="play" data-fancybox="video" aria-label="Play video"></a>`;
    return container;
  };

  const fetchVideoTitle = async (videoId) => {
    const res = await fetch(`https://www.youtube.com/oembed?url=https://www.youtube.com/watch?v=${videoId}&format=json`);
    if (!res.ok) throw new Error('Failed to fetch video title');
    const data = await res.json();
    return data.title;
  };

  const updateThumbnail = (thumbnail, title) => {
    const img = thumbnail.querySelector('img');
    const a = thumbnail.querySelector('a');
    img.alt = img.title = title;
    a.title = title;
    thumbnail.querySelector('span').textContent = title;
  };

  initializeYouTubePlayers();
});