<?php
$gallery_video = mysqli_query($GLOBALS['dbconn'], "SELECT slink_title, slink_url, id FROM video_tbl ORDER BY id ASC limit 6");
if (mysqli_num_rows($gallery_video) > 0):
?>

<div class="shortSection">
    <div class="container">
        <div class="title">Watch Our Latest YouTube Short!</div>
        <div class="clearfix"></div>
        <div class="row g-2 mb-2">
            <?php
            while ($video_res = mysqli_fetch_assoc($gallery_video)):
                $videoId = $video_res['slink_url'];
                $videoTitle = $video_res['slink_title'];
            ?>
            <!-- <div class="col-lg-2 col-md-6 col-12 mb-4">
                    <div class="vid-bx">
                        <iframe width="165" height="300"
                                src="https://www.youtube.com/embed/<?php echo htmlspecialchars($videoId); ?>?autoplay=1&mute=1&loop=1&playlist=<?php echo htmlspecialchars($videoId); ?>"
                                loading="lazy" title="<?php echo htmlspecialchars($videoTitle); ?>" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen>
                        </iframe>



                    </div>
                </div> -->
            <div class="col-lg-2 col-md-6 col-12 mb-4">
                <div class="vid-bx video-thumbnail" data-video-id="<?= htmlspecialchars($video_res['slink_url']); ?>">
                    <img src="https://img.youtube.com/vi/<?= htmlspecialchars($video_res['slink_url']); ?>/hqdefault.jpg"
                        alt="<?= htmlspecialchars($video_res['slink_title']); ?>" title="<?= htmlspecialchars($video_res['slink_title']); ?>" width="480" height="360">
                    <div class="play-button text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" viewBox="0 0 16 16">
                                                                <path d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z">
                                                                </path>
                                                            </svg>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
        <div class="text-center">
            <a href="https://www.youtube.com/@VARDHMANMACHINERYINDIA/shorts" target="_blank" class="read_more_btn"
                title="Watch More Short videos">Watch More Short videos</a>
        </div>
    </div>
</div>
<script>
    document.querySelectorAll('.video-thumbnail').forEach(function(el) {
    el.addEventListener('click', function() {
        const videoId = el.getAttribute('data-video-id');
        const iframe = document.createElement('iframe');
        iframe.setAttribute('src', `https://www.youtube.com/embed/${videoId}?autoplay=1&mute=1`);
        iframe.setAttribute('allow', 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture');
        iframe.setAttribute('allowfullscreen', '');
        iframe.setAttribute('loading', 'lazy');
        iframe.style.width = "100%";
        iframe.style.height = "300px";
        el.innerHTML = "";
        el.appendChild(iframe);
    });
});
</script>
<?php
else:
    echo "No videos found.";
endif;
?>

 