<?php 
include_once("include/main.inc.php"); 
$page_metatitle = "Market Area | IFR Coveralls Manufacturers in Delhi, India - ".$admin_res['companyName'];
$page_metakey = "IFR Coveralls, IFR Coveralls Manufacturers, IFR Coveralls Manufacturers in Delhi, IFR Coveralls Manufacturers in India";
$page_metadesc = COMPANY . " leading IFR Coveralls Manufacturers in Delhi, India, Since 2009. Committed to quality, trust, and excellence across every step of your journey with us. Get latest factory price for IFR Coveralls. ✓Fast Delivery ✓Good Price ";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>
<body>

<?php include "app_header.php"; ?>

<section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/market-banner.jpg)">
    <div class="container">
        <div class="row">
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                <h1 class="cat_title">Market Area - <?=$admin_res['companyName'];?></h1>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>
</section>

<div class="inner_breadcrumb hidden_xs">
    <div class="container">
        <div class="row">
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <ul class="breadcrumb">
                    <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                    <li class="active">Market Area</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<section class="sitemap_page">
    <div class="container">
        <div class="wps_right market_area">
            <?php 
            $sql_loc = mysqli_query($GLOBALS['dbconn'], "SELECT locationID, locationName, loc_url FROM location_tbl WHERE parentID='0' AND status='Y' ORDER BY locationName ASC");
            if(mysqli_num_rows($sql_loc) > 0){
                
            ?>

            <h2 class="mt25">Countries</h2>
                <?php }else{ ?>
                    <h2 class="mt25">Market Area</h2>
                    <?php } ?>
                <ul class="market-list">
                    <?php
                    while($res_loc = mysqli_fetch_array($sql_loc)) { 
                        $loc_url = $res_loc['loc_url'] ?: $res_loc['locationName'];
                        $locationID = $res_loc['locationID'];
                        ?>
                        <li><a href="<?=site_url;?>/<?php echo getValidFileName($loc_url); ?>/" title="<?php echo $res_loc['locationName'];?>"><?php echo $res_loc['locationName'];?></a></li>
                    <?php } ?>
                </ul>

              <?php
// Re-loop countries for states
mysqli_data_seek($sql_loc, 0);
while($res_loc = mysqli_fetch_array($sql_loc)) {
    $locationID = $res_loc['locationID'];
    $sql_states = mysqli_query($GLOBALS['dbconn'], "SELECT locationID, locationName, loc_url FROM location_tbl WHERE parentID='$locationID' AND status='Y' ORDER BY locationName ASC");
    if(mysqli_num_rows($sql_states) > 0){
        ?>
        <h3 class="mt25">Locations of <?php echo $res_loc['locationName']; ?></h3>
        <ul class="market-list">
        <?php
        while($res_state = mysqli_fetch_array($sql_states)) {
            $loc_url = $res_state['loc_url'] ?: $res_state['locationName'];
            ?>
            <li><a href="<?=site_url;?>/<?php echo getValidFileName($loc_url); ?>/" title="<?php echo $res_state['locationName'];?>"><?php echo $res_state['locationName'];?></a></li>
        <?php } ?>
        </ul>
        <?php
                    // Nested cities under each state
                    mysqli_data_seek($sql_states, 0);
                    while($res_state = mysqli_fetch_array($sql_states)) {
                        $stateID = $res_state['locationID'];
                        $sql_cities = mysqli_query($GLOBALS['dbconn'], "SELECT locationID, locationName, loc_url FROM location_tbl WHERE parentID='$stateID' AND status='Y' ORDER BY locationName ASC");
                        if(mysqli_num_rows($sql_cities) > 0){
                            ?>
                            <h3 class="mt25">Cities of <?php echo $res_state['locationName']; ?></h3>
                            <ul class="market-list">
                                <?php
                                while($res_city = mysqli_fetch_array($sql_cities)) {
                                    $loc_url = $res_city['loc_url'] ?: $res_city['locationName'];
                                    ?>
                                    <li><a href="<?=site_url;?>/<?php echo getValidFileName($loc_url); ?>/" title="<?php echo $res_city['locationName'];?>"><?php echo $res_city['locationName'];?></a></li>
                                <?php } ?>
                            </ul>
                            <?php
                        }
                    }
                }
            }
            ?>
        </div>
    </div>
</section>

<?php include "app_footer.php";?>
<?php include "app_bottom.php";?>
</body>
</html>