<div class="corporate-video1 py-5 bg-light-light">
    <div class="container-fluid px-4">
        <div class="title1 text-center fs-30">Follow Us On</div>
        <div class="border-bottom border-3 w-100px border-primary mx-auto pt-1"></div>
        <p class="fs-18 mt-4 text-center">Connect with us on social media to stay updated on the latest advancements and
            insights in rehabilitation and healthcare. Follow us for informative posts, engaging videos, and community
            highlights that inspire and educate. Join our growing network of professionals and enthusiasts dedicated to
            improving patient care. Together, let’s make a positive impact!</p>

        <div class="d-flex align-items-center justify-content-center">
            <?php if($admin_res['facebook_link']){ ?>
            <span class="sbi_follow_btn facebook rounded">
                <a href="<?=$admin_res['facebook_link'];?>" target="_blank" rel="nofollow noopener" title="Facebook">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#fff" viewBox="0 0 24 24">
                        <path
                            d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z">
                        </path>
                    </svg>
                    <span>Facebook</span>
                </a>
            </span>

            <?php } if($admin_res['instagram_link']){ ?>
            <span class="sbi_follow_btn instagram rounded">
                <a href="<?=$admin_res['instagram_link'];?>" target="_blank" rel="nofollow noopener" title="Instagram">
                    <svg class="svg-inline--fa fa-instagram fa-w-14" aria-hidden="true" data-fa-processed=""
                        aria-label="Instagram" data-prefix="fab" data-icon="instagram" role="img" viewBox="0 0 448 512">
                        <path fill="currentColor"
                            d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z">
                        </path>
                    </svg>
                    <span>Instagram</span>
                </a>
            </span>

            <?php } if($admin_res['youtube_link']){ ?>
            <span class="sbi_follow_btn youtube rounded">
                <a href="<?=$admin_res['youtube_link'];?>" target="_blank" rel="nofollow noopener" title="Youtube">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#fff" viewBox="0 0 24 24">
                        <path
                            d="M4.652 0h1.44l.988 3.702.916-3.702h1.454l-1.665 5.505v3.757h-1.431v-3.757l-1.702-5.505zm6.594 2.373c-1.119 0-1.861.74-1.861 1.835v3.349c0 1.204.629 1.831 1.861 1.831 1.022 0 1.826-.683 1.826-1.831v-3.349c0-1.069-.797-1.835-1.826-1.835zm.531 5.127c0 .372-.19.646-.532.646-.351 0-.554-.287-.554-.646v-3.179c0-.374.172-.651.529-.651.39 0 .557.269.557.651v3.179zm4.729-5.07v5.186c-.155.194-.5.512-.747.512-.271 0-.338-.186-.338-.46v-5.238h-1.27v5.71c0 .675.206 1.22.887 1.22.384 0 .918-.2 1.468-.853v.754h1.27v-6.831h-1.27zm2.203 13.858c-.448 0-.541.315-.541.763v.659h1.069v-.66c.001-.44-.092-.762-.528-.762zm-4.703.04c-.084.043-.167.109-.25.198v4.055c.099.106.194.182.287.229.197.1.485.107.619-.067.07-.092.105-.241.105-.449v-3.359c0-.22-.043-.386-.129-.5-.147-.193-.42-.214-.632-.107zm4.827-5.195c-2.604-.177-11.066-.177-13.666 0-2.814.192-3.146 1.892-3.167 6.367.021 4.467.35 6.175 3.167 6.367 2.6.177 11.062.177 13.666 0 2.814-.192 3.146-1.893 3.167-6.367-.021-4.467-.35-6.175-3.167-6.367zm-12.324 10.686h-1.363v-7.54h-1.41v-1.28h4.182v1.28h-1.41v7.54zm4.846 0h-1.21v-.718c-.223.265-.455.467-.696.605-.652.374-1.547.365-1.547-.955v-5.438h1.209v4.988c0 .262.063.438.322.438.236 0 .564-.303.711-.487v-4.939h1.21v6.506zm4.657-1.348c0 .805-.301 1.431-1.106 1.431-.443 0-.812-.162-1.149-.583v.5h-1.221v-8.82h1.221v2.84c.273-.333.644-.608 1.076-.608.886 0 1.18.749 1.18 1.631v3.609zm4.471-1.752h-2.314v1.228c0 .488.042.91.528.91.511 0 .541-.344.541-.91v-.452h1.245v.489c0 1.253-.538 2.013-1.813 2.013-1.155 0-1.746-.842-1.746-2.013v-2.921c0-1.129.746-1.914 1.837-1.914 1.161 0 1.721.738 1.721 1.914v1.656z">
                        </path>
                    </svg>
                    <span> Youtube</span>
                </a>
            </span>

            <?php } if($admin_res['twitter_link']){ ?>
            <span class="sbi_follow_btn twitter rounded">
                <a href="<?=$admin_res['twitter_link'];?>" target="_blank" rel="nofollow noopener" title="Twitter">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16px" height="16px" fill="#fff">
                        <path
                            d="M 2.296875 2 C 2.052875 2 1.9117344 2.2756094 2.0527344 2.4746094 L 6.4882812 8.7050781 L 2.0136719 14 L 3.3457031 14 L 7.09375 9.5527344 L 9.9609375 13.580078 C 10.148938 13.844078 10.452391 14 10.775391 14 L 13.703125 14 C 13.947125 14 14.088266 13.724391 13.947266 13.525391 L 9.2753906 6.9628906 L 13.457031 2 L 12.154297 2 L 8.6738281 6.1191406 L 6.0390625 2.4199219 C 5.8510625 2.1559219 5.5476094 2 5.2246094 2 L 2.296875 2 z M 3.6542969 3 L 5.2246094 3 L 12.345703 13 L 10.775391 13 L 3.6542969 3 z">
                        </path>
                    </svg>
                    <span>Twitter</span>
                </a>
            </span>

            <?php } if($admin_res['linked_link']){ ?>
            <span class="sbi_follow_btn linkedin rounded">
                <a href="<?=$admin_res['linked_link'];?>" target="_blank" rel="nofollow noopener" title="linkedin">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#fff" viewBox="0 0 16 16">
                        <path
                            d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854V1.146zm4.943 12.248V6.169H2.542v7.225h2.401zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248-.822 0-1.359.54-1.359 1.248 0 .694.521 1.248 1.327 1.248h.016zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016a5.54 5.54 0 0 1 .016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225h2.4z">
                        </path>
                    </svg>
                    <span>linkedin</span>
                </a>
            </span>
            <?php }  ?>
        </div>


    </div>
</div>
<footer class="footer pt-5 ">
    <div class="container-fluid px-4">
        <div class="row">
            <div class="col-lg-3 col-md-12">
                <div class="footer-heading ">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 64 64"
                                stroke-width="3" stroke="#fff" fill="none">
                                <path
                                    d="M38,55.53l17.24-47A.13.13,0,0,0,55,8.39l-46.18,25a.13.13,0,0,0,.05.24l23,2.68a.11.11,0,0,1,.11.09l5.7,19.14A.13.13,0,0,0,38,55.53Z" />
                            </svg>
                        </div>
                        <div class="text-start w-75 ms-3">
                            <div class="foot_head text-white fs-25 fw-bold border-dashed-bottom mb-2">Address</div>
                            <p class="fs-15 text-white br-tag pe-lg-0 mb-2"><?=$admin_res['address'];?>
                            </p>
                            <ul class="footer-links m-0 p-0">
                                <li>
                                    <a href="<?=site_url;?>/sitemap.htm" title="Sitemap" class="text-white1">Sitemap</a>
                                </li>
                                <li>
                                    <a href="<?=site_url;?>/market-area.htm" title="Market Area"
                                        class="text-white1">Market Area</a>
                                </li>
                            </ul>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-12">
                <div class="footer-heading ">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" fill="#fff"
                                class="bi bi-link-45deg" viewBox="0 0 16 16">
                                <path
                                    d="M4.715 6.542 3.343 7.914a3 3 0 1 0 4.243 4.243l1.828-1.829A3 3 0 0 0 8.586 5.5L8 6.086a1 1 0 0 0-.154.199 2 2 0 0 1 .861 3.337L6.88 11.45a2 2 0 1 1-2.83-2.83l.793-.792a4 4 0 0 1-.128-1.287z" />
                                <path
                                    d="M6.586 4.672A3 3 0 0 0 7.414 9.5l.775-.776a2 2 0 0 1-.896-3.346L9.12 3.55a2 2 0 1 1 2.83 2.83l-.793.792c.112.42.155.855.128 1.287l1.372-1.372a3 3 0 1 0-4.243-4.243z" />
                            </svg>
                        </div>
                        <div class="text-start w-75 ms-3">
                            <div class="foot_head text-white fs-25 fw-bold border-dashed-bottom mb-2">Important links
                            </div>
                            <ul class="footer-links m-0 p-0">
                                <li><a href="<?= site_url; ?>/about-us.htm" class="text-white1" title="About Us">About
                                        Us</a></li>
                                <li><a href="<?= site_url; ?>/certificate.htm" class="text-white1"
                                        title="Certificates">Certificates</a></li>
                                <li><a href="<?= site_url; ?>/uploaded-files/pdf/Dzire-Brouchure.pdf"
                                        class="text-white1" title="Brochure" target="_blank">Brochure</a></li>
                                <li><a href="<?= site_url; ?>/uploaded-files/pdf/Dzire-Rehab-Brochure.pdf"
                                        class="text-white1" title="Catalog" target="_blank">Catalog</a></li>
                                <li><a href="<?= site_url; ?>/blog.htm" title="Blogs" class="text-white1">Blogs</a></li>
                                <li><a href="<?= site_url; ?>/contact-us.htm" title="Contact Us"
                                        class="text-white1">Contact Us</a></li>
                            </ul>





                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-12">
                <div class="footer-heading ">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                                fill="none">
                                <path
                                    d="M14.05 6C15.0268 6.19057 15.9244 6.66826 16.6281 7.37194C17.3318 8.07561 17.8095 8.97326 18 9.95M14.05 2C16.0793 2.22544 17.9716 3.13417 19.4163 4.57701C20.8609 6.01984 21.7721 7.91101 22 9.94M18.5 21C9.93959 21 3 14.0604 3 5.5C3 5.11378 3.01413 4.73086 3.04189 4.35173C3.07375 3.91662 3.08968 3.69907 3.2037 3.50103C3.29814 3.33701 3.4655 3.18146 3.63598 3.09925C3.84181 3 4.08188 3 4.56201 3H7.37932C7.78308 3 7.98496 3 8.15802 3.06645C8.31089 3.12515 8.44701 3.22049 8.55442 3.3441C8.67601 3.48403 8.745 3.67376 8.88299 4.05321L10.0491 7.26005C10.2096 7.70153 10.2899 7.92227 10.2763 8.1317C10.2643 8.31637 10.2012 8.49408 10.0942 8.64506C9.97286 8.81628 9.77145 8.93713 9.36863 9.17882L8 10C9.2019 12.6489 11.3501 14.7999 14 16L14.8212 14.6314C15.0629 14.2285 15.1837 14.0271 15.3549 13.9058C15.5059 13.7988 15.6836 13.7357 15.8683 13.7237C16.0777 13.7101 16.2985 13.7904 16.74 13.9509L19.9468 15.117C20.3262 15.255 20.516 15.324 20.6559 15.4456C20.7795 15.553 20.8749 15.6891 20.9335 15.842C21 16.015 21 16.2169 21 16.6207V19.438C21 19.9181 21 20.1582 20.9007 20.364C20.8185 20.5345 20.663 20.7019 20.499 20.7963C20.3009 20.9103 20.0834 20.9262 19.6483 20.9581C19.2691 20.9859 18.8862 21 18.5 21Z"
                                    stroke="#fff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                        <div class="text-start w-60 ms-3">
                            <div class="foot_head text-white fs-25 fw-bold border-dashed-bottom mb-2">Phone</div>
                            <a class="fs-15 text-white pe-lg-5" href="tel:<?= $admin_res['mobile']; ?>" title="Call us">
                                <?= $admin_res['mobile']; ?></a>
                        </div>
                    </div>
                </div>
                <div class="footer-heading mt-3 ">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                width="50px" height="50px" viewBox="0 0 64 64" aria-hidden="true" role="img"
                                class="iconify iconify--emojione-monotone" preserveAspectRatio="xMidYMid meet">
                                <path
                                    d="M50.332 22.833l1.264-1.254l.984.976l2.976-2.952a1.495 1.495 0 0 0 0-2.125l-2.679-2.656a1.522 1.522 0 0 0-2.141 0l-2.977 2.952l.984.976l-1.264 1.253a23.992 23.992 0 0 0-14.053-5.576v-1.182c2.488-.631 4.332-2.864 4.332-5.53C37.76 4.558 35.181 2 32 2c-3.182 0-5.761 2.558-5.761 5.714c0 2.667 1.843 4.898 4.332 5.53v1.182a23.99 23.99 0 0 0-14.053 5.577l-1.264-1.254l.982-.976l-2.976-2.952a1.523 1.523 0 0 0-2.141 0l-2.678 2.656a1.494 1.494 0 0 0 0 2.125l2.977 2.954l.983-.977l1.263 1.254C10.134 26.98 8 32.337 8 38.19C8 51.342 18.746 62 32 62s24-10.658 24-23.81c0-5.853-2.135-11.211-5.668-15.357M29.586 6.712v4.294a4.054 4.054 0 0 1-1.701-3.292c0-2.254 1.843-4.081 4.115-4.081c2.271 0 4.113 1.827 4.113 4.081c0 1.357-.674 2.55-1.701 3.292l.001-4.294c0-1.455-4.826-1.455-4.827 0M32 58.826c-11.487 0-20.8-9.238-20.8-20.636c0-11.396 9.313-20.634 20.8-20.634c11.486 0 20.799 9.239 20.799 20.634c0 11.398-9.313 20.636-20.799 20.636"
                                    fill="#fff" />
                                <path
                                    d="M32 19.143v1.588h-.677v5.372H32v9.4c-1.496 0-2.709 1.202-2.709 2.687s1.213 2.688 2.709 2.688c.316 0 .617-.064.9-.164l10.122 8.307l-.001-.002l2.619 2.575c3.437-3.441 5.559-8.177 5.559-13.404c0-10.518-8.596-19.047-19.199-19.047m13.553 29.685l-10.848-10.66a2.666 2.666 0 0 0-.785-1.871V21.153c2.189.241 4.256.894 6.123 1.873l-1.185 2.035l1.172.671l1.185-2.032a17.332 17.332 0 0 1 5.39 5.35l-2.047 1.173l.677 1.163l2.045-1.169a16.927 16.927 0 0 1 1.969 7.306h-5.064v1.34h5.067a16.927 16.927 0 0 1-1.962 7.313l-2.055-1.178l-.677 1.163l2.051 1.176c-.328.51-.672 1.012-1.056 1.491"
                                    fill="#fff" />
                                <path d="M31.323 50.279h1.353v5.372h-1.353z" fill="#fff" />
                                <path d="M14.399 37.521h5.416v1.34h-5.416z" fill="#fff" />
                                <path d="M22.613 23.406l1.354 2.325l1.173-.671l-1.354-2.325z" fill="#fff" />
                                <path d="M19.441 30.222l-2.345-1.343l-.677 1.164l2.345 1.344z" fill="#fff" />
                                <path d="M16.419 46.34l.677 1.164l2.345-1.345l-.677-1.163z" fill="#fff" />
                                <path d="M22.612 52.977l1.173.671l1.354-2.327l-1.172-.672z" fill="#fff" />
                                <path d="M38.859 51.321l1.354 2.327l1.174-.671l-1.356-2.328z" fill="#fff" />
                            </svg>
                        </div>
                        <div class="text-start w-75 ms-3">
                            <div class="foot_head text-white fs-25 fw-bold border-dashed-bottom mb-2">Time</div>
                            <p class="fs-15 text-white pe-lg-5"> 10:00 am to 7:00 pm</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="footer-heading ">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                width="50px" height="50px" viewBox="0 0 32 32" version="1.1">
                                <g id="icomoon-ignore">
                                </g>
                                <path
                                    d="M29.229 13.342l-11.595-11.595c-0.436-0.436-1.016-0.677-1.633-0.677s-1.197 0.24-1.633 0.677l-2.528 2.528h-3.835v3.834l-5.332 5.331v17.491h26.656v-17.489l-0.099-0.099zM28.125 13.747l-4.129 4.129v-8.257l4.129 4.129zM15.121 2.5c0.47-0.47 1.289-0.47 1.759 0l1.774 1.774h-5.307l1.774-1.774zM19.719 5.34l3.211 3.212v10.39l-2.469 2.469-2.829-2.829c-0.436-0.436-1.016-0.677-1.633-0.677s-1.197 0.241-1.633 0.677l-2.871 2.87-2.426-2.426v-13.685h10.649zM4.38 13.24l3.624-3.624v8.343l-4.172-4.172 0.548-0.548zM3.738 16.058v-0.856l7.003 7.003-0.079 0.080-0.001-0.001-6.923 6.923v-13.149zM4.589 29.864l0.573-0.573h0.002l9.957-9.956c0.47-0.47 1.289-0.47 1.759 0l10.531 10.529h-22.822zM28.262 15.36v13.848l-7.046-7.043 7.046-7.046v0.242z"
                                    fill="#fff">
                                </path>
                                <path d="M12.268 8.539h7.464v1.066h-7.464v-1.066z" fill="#fff">
                                </path>
                                <path d="M12.268 14.937h7.464v1.066h-7.464v-1.066z" fill="#fff">
                                </path>
                                <path d="M12.268 11.738h5.331v1.066h-5.331v-1.066z" fill="#fff">
                                </path>
                            </svg>
                        </div>
                        <div class="text-start w-50 ms-3">
                            <div class="foot_head text-white fs-25 fw-bold border-dashed-bottom mb-2">E – mail</div>
                            <span class="fs-15 text-white pe-lg-5" title="E-mail Us">
                                info@dziresurgicalindia.in</span>
                        </div>
                    </div>
                </div>
                <div class="footer-heading mt-3">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 -3 157 157"
                                fill="none">
                                <g clip-path="url(#clip0)">
                                    <path
                                        d="M111.855 80.0366C116.105 79.8137 120.107 79.0917 123.996 79.489C141.568 81.2841 154.692 94.7186 156.477 112.327C158.084 128.174 150.202 141.213 135.381 146.976C124.339 151.27 113.201 151.95 102.071 147.243C94.338 143.972 88.3304 138.836 84.8939 130.993C84.7223 130.604 84.4802 130.241 84.2233 129.78C80.9673 129.955 77.7761 130.134 74.5843 130.298C57.0052 131.194 39.4284 132.145 21.8451 132.941C17.0971 133.156 12.3297 132.925 7.5681 132.829C6.46398 132.799 5.36921 132.617 4.31477 132.288C1.19736 131.327 0.161726 129.17 1.25502 126.123C5.94932 112.821 13.1719 100.555 22.524 90.0026C33.9347 77.1708 47.8576 69.0784 65.1166 67.3066C76.9243 66.0947 88.2637 68.0797 99.165 72.6856C101.533 73.6078 103.842 74.6758 106.079 75.8838C108.077 77.1637 110.005 78.5499 111.855 80.0366ZM103.099 84.6534C93.8979 80.5175 85.002 77.1073 75.1494 76.6524C61.4419 76.0192 49.0383 79.4715 38.2031 87.9236C26.5587 97.0069 18.0285 108.674 11.1315 121.617C10.8329 122.281 10.5793 122.964 10.3723 123.662C16.6278 124.229 78.94 119.974 82.8756 118.721C82.9733 118.26 83.1196 117.733 83.1921 117.198C84.1579 110.606 86.3335 104.25 89.6082 98.4495C90.7073 96.5332 92.0763 94.7853 93.6732 93.2598C96.5712 90.4057 99.675 87.7564 103.1 84.6534H103.099ZM118.466 138.891C123.795 138.857 129.057 137.678 133.893 135.432C137.563 133.798 140.638 131.066 142.692 127.609C147.451 119.564 146.535 106.553 140.513 99.4009C135.716 93.7024 129.72 89.7661 122.156 89.1426C113.381 88.42 105.924 91.5281 100.856 98.8027C95.7789 106.09 94.5549 114.526 95.4876 123.249C95.922 126.818 97.7008 130.086 100.46 132.387C105.594 136.957 111.695 138.853 118.467 138.891H118.466Z"
                                        fill="#fff" />
                                    <path
                                        d="M67.2042 59.5951C59.6796 59.286 52.3087 57.7227 45.8299 53.1201C38.5115 47.9213 32.7337 38.2483 37.27 26.1696C38.4131 23.0565 39.962 20.1084 41.8762 17.4013C44.4933 13.8236 47.3818 10.453 50.5164 7.31989C57.572 0.191128 69.6122 -1.57614 78.1152 3.64665C89.2675 10.4948 95.7483 20.7795 97.0222 33.7597C97.7789 41.4639 94.3521 48.029 88.2377 52.9277C82.1725 57.7863 75.0353 59.4221 67.2042 59.5951ZM66.1951 49.7722C70.9029 49.6536 75.4793 49.0888 79.5806 46.5606C85.1604 43.122 87.413 37.4636 85.7378 31.1443C84.4309 26.2047 81.7433 22.0557 78.2873 18.3908C74.8443 14.7396 70.8162 12.273 65.575 12.1142C59.8045 11.9393 55.4372 15.0403 51.4175 18.4181C48.4722 20.893 46.6876 24.4827 45.4862 28.2473C42.8219 36.5951 45.7367 43.3844 53.6597 47.1711C57.6342 49.0744 61.8869 49.5914 66.1951 49.7716V49.7722Z"
                                        fill="#fff" />
                                    <path
                                        d="M124.785 118.038C124.785 121.184 124.835 123.73 124.762 126.273C124.746 127.377 124.569 128.472 124.238 129.525C124.03 130.227 123.596 130.84 123.004 131.271C122.413 131.702 121.696 131.926 120.964 131.909C120.232 131.951 119.508 131.742 118.91 131.318C118.312 130.893 117.876 130.277 117.674 129.571C117.337 128.295 117.166 126.981 117.166 125.662C117.09 123.253 117.144 120.839 117.144 118.065C114.201 118.065 111.457 118.139 108.721 118.038C106.955 117.997 105.198 117.782 103.475 117.395C102.717 117.225 102.039 116.805 101.549 116.202C101.06 115.6 100.786 114.85 100.774 114.073C100.761 113.296 101.01 112.538 101.48 111.919C101.951 111.301 102.615 110.86 103.367 110.665C104.748 110.287 106.172 110.085 107.604 110.064C110.673 109.978 113.747 110.037 116.94 110.037C116.94 106.91 116.926 104.168 116.947 101.428C116.898 100.437 116.959 99.4433 117.128 98.4654C117.452 97.0876 118.263 96.0383 119.866 96.0221C120.542 95.9729 121.213 96.1679 121.758 96.571C122.304 96.9748 122.687 97.5607 122.838 98.2223C123.255 100.054 123.551 101.912 123.724 103.784C123.953 105.737 124.071 107.702 124.241 109.739C126.174 109.739 127.813 109.786 129.448 109.726C131.329 109.658 133.206 109.405 135.085 109.394C138.087 109.376 139.98 110.825 140.146 113.097C140.3 115.225 138.749 116.966 135.965 117.425C133.776 117.737 131.572 117.937 129.362 118.023C127.951 118.108 126.53 118.038 124.785 118.038Z"
                                        fill="#fff" />
                                </g>
                                <defs>
                                    <clipPath id="clip0">
                                        <rect width="156" height="151" fill="white" transform="translate(0.777344)" />
                                    </clipPath>
                                </defs>
                            </svg>
                        </div>
                        <div class="text-start w-50 ms-3">
                            <div class="foot_head text-white fs-25 fw-bold border-dashed-bottom mb-2 ">Apply for Job
                            </div>
                            <a href="<?=site_url;?>/career.htm" title="Careers" class="fs-15 text-white pe-lg-5">
                                Careers</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 mt-3">

                <!-- <hr class="bg-white"> -->
                <div class="text-center w-100">
                    <div class="foot_head text-white fs-25 fw-bold border-dashed-bottoms mb-1 text-center"> All Products
                    </div>
                    <ul class="footer-links m-0 p-0 d-flex1 ">

                    <?php $sql=mysqli_query($GLOBALS['dbconn'],"select displayName, catName, catID, parentID from category_tbl where parentID='0'  && status='Y' order by catOrder");
                                while($res=mysqli_fetch_array($sql)){
                                 $catID=$res['catID'];
                                $sql_sub=mysqli_query($GLOBALS['dbconn'],"select displayName, catName, catID, parentID from category_tbl where parentID='$catID' && status='Y' order by catOrder");
                                $num11 = mysqli_num_rows($sql_sub);
                                ?>
                                <?php while($sub_res=mysqli_fetch_array($sql_sub)){  ?>


                        <li class="">

                           <a href="<?= site_url; ?>/<?=getValidFileName($ca_nam1);?>/<?= getValidFileName($sub_res['catName']); ?>.htm" title="<?php echo $sub_res['displayName']; ?>">
                                <span class="menu-item-text"><?php echo $sub_res['displayName']; ?></span>

                            </a>

                        </li>
                         <?php } } ?>
                        <!-- <li class="">

                            <a href="https://www.rehabilitationproduct.com/rehabilitation-belts.htm"
                                title="Rehabilitation Belts">
                                <span class="menu-item-text">Rehabilitation Belts</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/ankle-braces.htm" title="Ankle Braces">
                                <span class="menu-item-text">Ankle Braces</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/back-support-belts.htm"
                                title="Back Support Belts">
                                <span class="menu-item-text">Back Support Belts</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/elbow-support.htm" title="Elbow Support">
                                <span class="menu-item-text">Elbow Support</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/knee-braces.htm" title="Knee Braces">
                                <span class="menu-item-text">Knee Braces</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/neck-support.htm" title="Neck Support">
                                <span class="menu-item-text">Neck Support</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/wheelchair.htm" title="Wheelchair">
                                <span class="menu-item-text">Wheelchair</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/adult-diaper.htm" title="Adult Diaper">
                                <span class="menu-item-text">Adult Diaper</span>

                            </a>

                        </li>
                        <li class="">

                            <a href="https://www.rehabilitationproduct.com/health-care-equipment.htm"
                                title="Health Care Equipment">
                                <span class="menu-item-text">Health Care Equipment</span>

                            </a>

                        </li> -->


                    </ul>





                </div>
                <hr class="bg-white">

            </div>
        </div>
        <!-- <p class="text-center fs-18 text-white mb-0 py-4 mt-4">&copy; 2024 Dzire Rehabilitation. All Rights Reserved
        </p> -->
        <div class="row align-items-center">
            <div class="col-md-12 col-lg-4">
                <p class="fs-18 text-white mb-0 py-3 mt-0 mb-2">&copy; 2025 Dzire Rehabilitation. All Rights
                    Reserved
                </p>
            </div>
            <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12 text-end">
                <p class="text-white mb-0  fs-18 text-white mb-0 py-3 mt-0 mb-2"> Crafted with
                    <svg class="mx-1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        viewBox="0 0 16 16">
                        <path fill-rule="evenodd"
                            d="M8 1.314C12.438-3.248 23.534 4.735 8 15-7.534 4.736 3.562-3.248 8 1.314z"></path>
                    </svg> by Webpulse - <a class="text-white fs-18" href="https://www.webpulseindia.com/web-designing"
                        target="_blank" title="Web Designing">Web Designing,</a> <a class="fs-18 text-white"
                        href="https://www.webpulseindia.com/digital-marketing" target="_blank"
                        title="Digital Marketing">Digital Marketing &amp;</a>&nbsp; <a class="fs-18 text-white"
                        href="https://www.brandempower.org" target="_blank" title="Branding Company"> Branding Company
                    </a>
                </p>
            </div>
        </div>
    </div>
</footer>
<div data-bs-toggle="modal" data-bs-target="#myModal" class="send_enquiry svgs" title="Get a Quote"><svg
        xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
        <path
            d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414.05 3.555ZM0 4.697v7.104l5.803-3.558L0 4.697ZM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586l-1.239-.757Zm3.436-.586L16 11.801V4.697l-5.803 3.546Z">
        </path>
    </svg><span>Get a Quote</span></div>
<div class="whatapp_btn svgs" data-bs-toggle="modal" data-bs-target="#whatsapp" title="Whatsapp Now"><svg
        xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
        <path
            d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z">
        </path>
    </svg>
</div>
<a class="whatapp_btn2 svgs" href="tel:+91-8799460165" title="Call Us">
    <svg class="" fill="#ffffff" width="24px" height="24px" viewBox="0 0 32 32" version="1.1"
        xmlns="http://www.w3.org/2000/svg">
        <title>Call Us</title>
        <path
            d="M19.373 11.831c-0.138-0.154-0.337-0.25-0.559-0.25-0.414 0-0.75 0.336-0.75 0.75 0 0.195 0.074 0.373 0.197 0.506l-0-0.001c0.819 0.92 1.32 2.139 1.32 3.476 0 1.602-0.719 3.035-1.852 3.996l-0.008 0.006c-0.136 0.136-0.22 0.324-0.22 0.531 0 0.415 0.336 0.751 0.751 0.751 0.207 0 0.395-0.084 0.531-0.22v0c1.396-1.251 2.27-3.060 2.27-5.072 0-1.717-0.636-3.285-1.685-4.481l0.007 0.008zM22.428 8.776c-0.138-0.152-0.336-0.247-0.557-0.247-0.414 0-0.75 0.336-0.75 0.75 0 0.194 0.073 0.37 0.194 0.503l-0.001-0.001c1.445 1.629 2.328 3.786 2.328 6.149 0 2.819-1.256 5.345-3.24 7.047l-0.012 0.010c-0.136 0.136-0.22 0.324-0.22 0.531 0 0.415 0.336 0.751 0.751 0.751 0.207 0 0.395-0.084 0.531-0.22v0c2.244-2.002 3.65-4.901 3.65-8.129 0-2.741-1.014-5.245-2.686-7.158l0.011 0.013zM25.273 5.524c-0.137-0.146-0.331-0.236-0.546-0.236-0.414 0-0.75 0.336-0.75 0.75 0 0.198 0.077 0.378 0.202 0.512l-0-0c2.215 2.36 3.575 5.544 3.575 9.046 0 3.986-1.763 7.561-4.551 9.986l-0.016 0.014c-0.136 0.136-0.22 0.324-0.22 0.531 0 0.415 0.336 0.751 0.751 0.751 0.207 0 0.395-0.084 0.531-0.22v0c10.635-10.637 1.121-21.030 1.023-21.134zM12.378 11.725c0 0 0 0 0 0 0.248 0 0.469-0.121 0.605-0.307l0.001-0.002 4.282-5.897c0.090-0.122 0.143-0.275 0.143-0.44 0-0.064-0.008-0.127-0.023-0.187l0.001 0.005c-0.141-0.532-0.367-0.997-0.664-1.407l0.008 0.012c-0.178-0.272-0.374-0.509-0.593-0.723l-0.001-0.001-0.004-0.004c-0.952-0.94-2.261-1.52-3.706-1.52-1.446 0-2.757 0.582-3.71 1.524l0-0c-3.379 3.386-5.468 8.060-5.468 13.222s2.089 9.836 5.469 13.222l-0-0c0.943 0.942 2.245 1.525 3.683 1.525 0.006 0 0.012 0 0.018-0h-0.001c0.003 0 0.007 0 0.010 0 1.445 0 2.754-0.581 3.706-1.522l-0.001 0c0.211-0.203 0.399-0.427 0.56-0.671l0.009-0.015c0.301-0.408 0.536-0.886 0.676-1.404l0.007-0.030c0.014-0.055 0.022-0.117 0.022-0.182 0-0.166-0.054-0.319-0.145-0.443l0.001 0.002-4.282-5.899c-0.138-0.188-0.358-0.309-0.606-0.309v0c-0.798 0.001-1.553 0.187-2.224 0.517l0.030-0.013c-0.599-1.412-0.948-3.055-0.948-4.779s0.348-3.367 0.979-4.862l-0.031 0.082c0.641 0.317 1.396 0.502 2.194 0.504h0.001zM9.652 9.428c-0.216 0.057-0.39 0.202-0.485 0.393l-0.002 0.004c-0.902 1.802-1.43 3.927-1.43 6.174s0.528 4.372 1.467 6.256l-0.037-0.081c0.097 0.195 0.271 0.34 0.481 0.397l0.005 0.001c0.055 0.014 0.118 0.022 0.183 0.022 0.162 0 0.313-0.050 0.438-0.135l-0.003 0.002c0.489-0.351 1.081-0.589 1.723-0.664l0.017-0.002 3.818 5.26c-0.108 0.249-0.232 0.464-0.377 0.662l0.007-0.009c-0.113 0.17-0.237 0.317-0.375 0.45l-0.001 0.001c-0.681 0.674-1.618 1.091-2.652 1.091s-1.969-0.416-2.65-1.089l0 0c-3.108-3.114-5.030-7.413-5.030-12.161s1.922-9.047 5.030-12.161l-0 0c0.673-0.671 1.601-1.086 2.626-1.086 0.005 0 0.010 0 0.014 0h-0.001c0.002 0 0.004 0 0.006 0 1.034 0 1.972 0.415 2.655 1.088l-0-0c0.15 0.146 0.284 0.308 0.399 0.483l0.007 0.011c0.129 0.177 0.244 0.378 0.335 0.592l0.008 0.020-3.818 5.259c-0.659-0.076-1.251-0.315-1.75-0.674l0.011 0.008c-0.12-0.085-0.268-0.136-0.429-0.136-0.067 0-0.132 0.009-0.194 0.025l0.005-0.001z">
        </path>
    </svg>
</a>