<?php 
include_once("include/main.inc.php");
$page_metatitle = 'Career - '.$admin_res['companyName'];
$page_metakey = 'Career - '.$admin_res['companyName'];
$page_metadesc = 'Career - '.$admin_res['companyName'];

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include "app_top.php"; ?>

   
</head>

<body>
    <?php include "app_header.php"; ?>
    <div class="webpulse-main-wrapper">
        <div class="small-banner py-4 heading_banner position-relative">
            <div class="text-center position-relative z-index-9">
                <h1 class="cat_title">Career</h1>
                <div class="clearfix"></div>
                <!-- <div class="cat_title2">We Are Available For You</div> -->
            </div>
        </div>
        <nav aria-label="breadcrumb" class="py-0 position-relative z-index-9 bg-light-light border-bottom">
            <div class="container-fluid px-4 py-2">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?=site_url;?>" title="Home" class="text-dark">Home</a></li>
                    <li class="breadcrumb-item active text-orange" aria-current="page">Career</li>
                </ol>
            </div>
        </nav>
        <section class="contact-form-area carrer-form py-5">
            <div class="container-fluid px-4">
                <div class="base-header2 mb-3">
                    <h2 class="text-center lsp-5 lh-base text-uppercase fs-30 text-black fw-bold lsp-5px pb-0">
                        <small class="d-block fs-13 pb-2 fw-normal">Form </small>
                        Career
                    </h2>
                    <p class="text-center w-75 mx-auto">We recently helped a small business grow from break-even to over
                        $1m profit in less than 2 years.
                        Please find below contact details and contact us today!
                    </p>
                </div>
                <div class="row">
                    <div class="col-md-12 col-lg-8">

                        <div class="div-tab-dps div-tabs-para sections pb-4 pb-lg-5">
                            <form
                                class="default-form-area py-4 p-md-4  mt-1 rounded-3 shadow text-center  border-bottom border-3 border-dark-blue bg-white" id="multiStepForm" method="post" enctype="multipart/form-data" action="<?= site_url; ?>/ajax-career-form.php">
                                <div id="career_response"></div>
                                <ul class="p-0 m-0 list-group text-center  text-muted">
                                    <li id="step1" class="col-tabs-1 tabs-dps-tab active list-group-item bg-white border-0">
                                        <div class="base-header2">
                                            <h3
                                                class="text-center lsp-5 lh-base text-uppercase fs-20 text-dark-blue fw-bold lsp-5px pb-0 mb-0">
                                                <small class="d-block fs-13 pb-0 fw-normal text-black">Presentation
                                                </small>
                                                Personal info
                                            </h3>
                                            <p class="text-center">Please provide your personal information, including contact details and relevant experience, to help us assess your application.</p>
                                        </div>
                                        <div class="mb-3">
                                            <input type="text"
                                                class="form-control rounded-pill border border-gray fs-13 lsp-5 py-2"
                                                id="name" name="name" onkeyup="validateOnlyTextField(this)" placeholder="Enter Your Full Name" required="">
                                        </div>
                                        <div class="mb-3">
                                            <input type="email"
                                                class="form-control rounded-pill border border-gray fs-13 lsp-5 py-2"
                                                id="email" name="email" placeholder="Email Address" required="">
                                        </div>
                                        <div class="mb-3">
                                            <input type="tel"
                                                class="form-control rounded-pill border border-gray fs-13 lsp-5 py-2"
                                                id="mobile" name="mobile"  onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                                                minlength="10" maxlength="10" placeholder="Phone Number" required="">
                                        </div>
                                        <div class="d-flex">
                                            <label
                                                class="form-check-label fs-13 lsp-5 px-2 text-muted fw-bold">Gender</label>
                                            <div class="form-check form-check-inline fs-13 px-2">
                                                <input class="form-check-input mx-2" type="radio" name="gender"
                                                    id="gander1" value="male">
                                                <label for="gander1" class="form-check-label text-muted">Male</label>
                                            </div>
                                            <div class="form-check form-check-inline fs-13 px-2">
                                                <input class="form-check-input mx-2" type="radio" name="gender"
                                                    id="gander2" value="female">
                                                <label for="gander2" class="form-check-label text-muted">Female</label>
                                            </div>
                                        </div>
                                        <div class="mb-3 fs-13 text-start">
                                            <label for="formFile" class="px-2 text-muted">Upload Resume <small><small>(File accepted: .jpg, .jpeg, .pdf, .doc/docx - Max file size: 10MB)</small>
                                            </small></label>
                                        </div>
                                        <input class="form-control rounded-pill border border-gray fs-13 lsp-5 p-2"
                                            type="file" id="formFile" name="formFile" required="">
                                        <div class="d-flex justify-content-center mt-3">
                                            <button type="button"
                                                class="button-col-tabs-1 thm-btn style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize next-btn">Next</button>
                                        </div>
                                    </li>
                                    <li id="step2" class="col-tabs-2 tabs-dps-tab list-group-item bg-white border-0">
                                        <div class="base-header2">
                                            <h3
                                                class="text-center lsp-5 lh-base text-uppercase fs-20 text-dark-blue fw-bold lsp-5px pb-0 mb-0">
                                                <small class="d-block fs-13 pb-0 fw-normal text-black">Work Availability
                                                </small>
                                                Personal info
                                            </h3>
                                            <p class="text-center">We would love to hear from you. Drop your query and
                                                we will get back to you.
                                            </p>
                                        </div>
                                        <div
                                            class="mb-3  text-muted d-block justify-content-between align-items-center">
                                            <div
                                                class="form-check fs-13 text-start d-flex justify-content-start mb-3 border w-100 mx-1  align-items-center rounded-pill p-2">
                                                <input class="form-check-input ms-0 mt-0" type="radio" name="work"
                                                    id="work1" value="Full Time">
                                                <label class="form-check-label ms-2 lsp-5" for="work1">
                                                    Full Time
                                                </label>
                                            </div>
                                            <div
                                                class="form-check fs-13 text-start  d-flex justify-content-start mb-3 w-100 mx-1  align-items-center border rounded-pill p-2">
                                                <input class="form-check-input  ms-0 mt-0" type="radio" name="work"
                                                    id="work2" value="Part Time">
                                                <label class="form-check-label ms-2" for="work2">
                                                    Part Time
                                                </label>
                                            </div>
                                            <div
                                                class="form-check fs-13 text-start  d-flex justify-content-start mb-3 w-100 mx-1  align-items-center border rounded-pill p-2">
                                                <input class="form-check-input  ms-0 mt-0" type="radio" name="work"
                                                    id="work3" value="Freelance">
                                                <label class="form-check-label ms-2 lsp-5" for="work3">
                                                    Freelance
                                                </label>
                                            </div>
                                            <div
                                                class="form-check fs-13 text-start  d-flex justify-content-start mb-3 w-100 mx-1  align-items-center border rounded-pill p-2">
                                                <input class="form-check-input  ms-0 mt-0" type="radio" name="work"
                                                    id="work4" value="Contract Availability">
                                                <label class="form-check-label ms-2 lsp-5" for="work4">
                                                    Contract availability
                                                </label>
                                            </div>
                                        </div>
                                        <div class="mb-3 fs-13">
                                            <p class="text-center text-muted lsp-5">* Start branch radio based </p>
                                        </div>
                                        <div class="d-flex justify-content-center">
                                            <button type="button"
                                                class=" button-col-tabs-01 thm-btn style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize prev-btn">Prev</button>
                                            <button type="button"
                                                class=" button-col-tabs-2 thm-btn ms-3 style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize next-btn">Next</button>
                                        </div>
                                    </li>
                                    <li class="col-tabs-3 tabs-dps-tab list-group-item bg-white border-0">
                                        <div class="base-header2 mb-3">
                                            <div class="base-header2">
                                                <h3
                                                    class="text-center lsp-5 lh-base text-uppercase fs-20 text-dark-blue fw-bold lsp-5px pb-0 mb-0">
                                                    <small class="d-block fs-13 pb-0 fw-normal text-black">Work
                                                        Availability </small>
                                                    Additional info about "Full Time" availability
                                                </h3>
                                                <p class="text-center">We would love to hear from you. Drop your query
                                                    and we will get back to you.
                                                </p>
                                            </div>
                                        </div>
                                        <div class="mb-3 fs-13">
                                            <label class="mb-2 text-muted">Minimum Salary?</label>

                                            <select
                                                class="form-select text-muted fs-13 form-control rounded-pill border border-gray fs-13 lsp-5 py-2"
                                                aria-label="Default select example" name="salary">
                                                <option value="">Choose a range</option>
                                                <option value="<10k">&lt;10k</option>
                                                <option value="10-15k">10-15k</option>
                                                <option value="15-20k">15-20k</option>
                                                <option value="20-25k">20-25k</option>
                                                <option value="25-30k">25-30k</option>
                                                <option value="30-35k">30-35k</option>
                                                <option value="35-40k">35-40k</option>
                                                <option value="45-50k">45-50k</option>
                                                <option value=">50k">&gt;50k</option>
                                            </select>
                                        </div>
                                        <div class="mb-3">
                                            <label class="fs-13 mb-2 text-muted">Availability?</label>

                                            <select
                                                class="form-select fs-13 form-control text-muted rounded-pill border border-gray fs-13 lsp-5 py-2"
                                                aria-label="Default select example" name="availability">
                                                <option value="">Choose your availability</option>
                                                <option value="I can start immediately">I can start immediately</option>
                                                <option value="I need to give 2 or 4 weeks notice">I need to give 2–4
                                                    weeks notice</option>
                                                <option value="I am passively browsing">I am passively browsing</option>
                                                <option value="I will be available in a couple months">I will be
                                                    available in a couple months</option>
                                                <option value="I am not sure">I am not sure</option>
                                            </select>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-center">
                                            <label class="form-check-label mb-2 text-muted fs-13 me-3">Are you willing
                                                to work remotely?</label>
                                            <div class="form-check text-muted form-check-inline fs-13">
                                                <input class="form-check-input" type="radio" name="remote" id="remote1"
                                                    value="yes">
                                                <label class="form-check-label">Yes</label>
                                            </div>
                                            <div class="form-check text-muted form-check-inline fs-13">
                                                <input class="form-check-input" type="radio" name="remote" id="remote2"
                                                    value="no">
                                                <label class="form-check-label">No</label>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-center">
                                            <button type="button"
                                                class="button-col-tabs-02 thm-btn style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize prev-btn">Prev</button>
                                            <button type="button"
                                                class="button-col-tabs-3 thm-btn ms-3 style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize next-btn">Next</button>
                                        </div>
                                    </li>
                                    <li class="col-tabs-4 tabs-dps-tab list-group-item bg-white border-0">
                                        <div class="mb-3">
                                            <h3 class="fs-20 text-muted">Thank you for your time</h3>
                                        </div>
                                        <div
                                            class="form-check mb-3 fs-13 d-flex justify-content-center align-items-center">
                                            <input class="form-check-input text-muted" type="checkbox" name="term" id="gridCheck" value="Accepted">
                                            <label class="form-check-label mx-2 text-muted" for="gridCheck">
                                                Please accept your term and condition.
                                            </label>
                                        </div>
                                        <div class="d-flex justify-content-center">
                                            <button type="button"
                                                class="button-col-tabs-03 button-col-tabs-2 thm-btn style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize prev-btn">Prev</button>
                                            <button type="submit" name="career-submit"
                                                class="thm-btn ms-3 style-2 bg-sky px-4 py-2 fs-13 m-0 text-white text-center rounded-pill border-0 lsp-5 text-capitalize">Submit</button>
                                        </div>
                                    </li>
                                </ul>
                            </form>
                        </div>

                    </div>
                    <div class="col-md-12 col-lg-4 ">
                        <div
                            class="form-right-box text-center  bg-white p-3 pb-4 mb-0 mb-lg-5 rounded-3 shadow text-center  border-bottom border-3 border-dark-blue">
                            <div class="img-box mt-0">
                                <img src="<?=site_url;?>/designer/images/careers-page-101-featured-1.webp" alt="Career Form - <?=$admin_res['companyName'];?>" title="Career Form - <?=$admin_res['companyName'];?>"
                                    class="w-100   border-skype p-1 shadow rounded ">
                            </div>
                            <div class="base-header2 mt-4 d-block">
                                <h4
                                    class="text-center lsp-5 lh-base text-uppercase fs-13 text-black fw-bold lsp-5px pb-0 mt-2 mb-0">
                                    Career Opportunities
                                    <small class="d-block fs-13 pb-2 fw-normal text-dark-blue  fs-18"> We are
                                        Hiring</small>
                                </h4>
                            </div>
                            <p>We are hiring! Join our team of dedicated professionals committed to innovation and excellence in healthcare. Apply now and make an impact!</p>
                            <div class="border-top"></div>
                            <ul class="social w-100 mb-1 float-none pt-3 m-0 p-0">
                            <?php if($admin_res['facebook']!=''){ ?>
                                <li class="facebook">
                                    <a href="<?=$admin_res['facebook'];?>" target="_blank" title="Facebook"><svg xmlns="http://www.w3.org/2000/svg"
                                            width="16" height="16" fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z">
                                            </path>
                                        </svg></a>
                                </li>
                                <?php } if($admin_res['twitter']!=''){ ?>
                                <li class="twitter"><a href="<?=$admin_res['twitter'];?>" target="_blank" title="Twitter">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16"
                                            width="16px" height="16px">
                                            <path
                                                d="M 2.296875 2 C 2.052875 2 1.9117344 2.2756094 2.0527344 2.4746094 L 6.4882812 8.7050781 L 2.0136719 14 L 3.3457031 14 L 7.09375 9.5527344 L 9.9609375 13.580078 C 10.148938 13.844078 10.452391 14 10.775391 14 L 13.703125 14 C 13.947125 14 14.088266 13.724391 13.947266 13.525391 L 9.2753906 6.9628906 L 13.457031 2 L 12.154297 2 L 8.6738281 6.1191406 L 6.0390625 2.4199219 C 5.8510625 2.1559219 5.5476094 2 5.2246094 2 L 2.296875 2 z M 3.6542969 3 L 5.2246094 3 L 12.345703 13 L 10.775391 13 L 3.6542969 3 z">
                                            </path>
                                        </svg>
                                    </a></li>
                                    <?php } if($admin_res['youtube']!=''){ ?>
                                <li class="youtube"><a href="<?=$admin_res['youtube'];?>" target="_blank" title="Youtube"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M4.652 0h1.44l.988 3.702.916-3.702h1.454l-1.665 5.505v3.757h-1.431v-3.757l-1.702-5.505zm6.594 2.373c-1.119 0-1.861.74-1.861 1.835v3.349c0 1.204.629 1.831 1.861 1.831 1.022 0 1.826-.683 1.826-1.831v-3.349c0-1.069-.797-1.835-1.826-1.835zm.531 5.127c0 .372-.19.646-.532.646-.351 0-.554-.287-.554-.646v-3.179c0-.374.172-.651.529-.651.39 0 .557.269.557.651v3.179zm4.729-5.07v5.186c-.155.194-.5.512-.747.512-.271 0-.338-.186-.338-.46v-5.238h-1.27v5.71c0 .675.206 1.22.887 1.22.384 0 .918-.2 1.468-.853v.754h1.27v-6.831h-1.27zm2.203 13.858c-.448 0-.541.315-.541.763v.659h1.069v-.66c.001-.44-.092-.762-.528-.762zm-4.703.04c-.084.043-.167.109-.25.198v4.055c.099.106.194.182.287.229.197.1.485.107.619-.067.07-.092.105-.241.105-.449v-3.359c0-.22-.043-.386-.129-.5-.147-.193-.42-.214-.632-.107zm4.827-5.195c-2.604-.177-11.066-.177-13.666 0-2.814.192-3.146 1.892-3.167 6.367.021 4.467.35 6.175 3.167 6.367 2.6.177 11.062.177 13.666 0 2.814-.192 3.146-1.893 3.167-6.367-.021-4.467-.35-6.175-3.167-6.367zm-12.324 10.686h-1.363v-7.54h-1.41v-1.28h4.182v1.28h-1.41v7.54zm4.846 0h-1.21v-.718c-.223.265-.455.467-.696.605-.652.374-1.547.365-1.547-.955v-5.438h1.209v4.988c0 .262.063.438.322.438.236 0 .564-.303.711-.487v-4.939h1.21v6.506zm4.657-1.348c0 .805-.301 1.431-1.106 1.431-.443 0-.812-.162-1.149-.583v.5h-1.221v-8.82h1.221v2.84c.273-.333.644-.608 1.076-.608.886 0 1.18.749 1.18 1.631v3.609zm4.471-1.752h-2.314v1.228c0 .488.042.91.528.91.511 0 .541-.344.541-.91v-.452h1.245v.489c0 1.253-.538 2.013-1.813 2.013-1.155 0-1.746-.842-1.746-2.013v-2.921c0-1.129.746-1.914 1.837-1.914 1.161 0 1.721.738 1.721 1.914v1.656z">
                                            </path>
                                        </svg>
                                    </a>
                                </li>
                                <?php } if($admin_res['instagram']!=''){ ?>
                                <li class="instagram"><a href="<?=$admin_res['instagram'];?>" target="_blank" title="Instagram"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" viewBox="0 0 16 16">
                                            <path
                                                d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.917 3.917 0 0 0-1.417.923A3.927 3.927 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.916 3.916 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.926 3.926 0 0 0-.923-1.417A3.911 3.911 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0h.003zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599.28.28.453.546.598.92.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.47 2.47 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.478 2.478 0 0 1-.92-.598 2.48 2.48 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233 0-2.136.008-2.388.046-3.231.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92.28-.28.546-.453.92-.598.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045v.002zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92zm-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217zm0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334z">
                                            </path>
                                        </svg></a></li>
                                        <?php } ?>
                            </ul>

                        </div>
                    </div>
                </div>
            </div>
        </section>




    </div>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
    <script>
    // $(document).on('click', '.button-col-tabs-1', function() {
    //     $('.tabs-dps-tab').removeClass('active');
    //     $('.col-tabs-2').addClass('active');
    // })
    // $(document).on('click', '.button-col-tabs-01', function() {
    //     $('.tabs-dps-tab').removeClass('active');
    //     $('.col-tabs-1').addClass('active');
    // })
    // $(document).on('click', '.button-col-tabs-02', function() {
    //     $('.tabs-dps-tab').removeClass('active');
    //     $('.col-tabs-2').addClass('active');
    // })
    // $(document).on('click', '.button-col-tabs-2', function() {
    //     $('.tabs-dps-tab').removeClass('active');
    //     $('.col-tabs-3').addClass('active');
    // })
    // $(document).on('click', '.button-col-tabs-03', function() {
    //     $('.tabs-dps-tab').removeClass('active');
    //     $('.col-tabs-3').addClass('active');
    // })
    // $(document).on('click', '.button-col-tabs-3', function() {
    //     $('.tabs-dps-tab').removeClass('active');
    //     $('.col-tabs-4').addClass('active');
    // })
   
$(document).ready(function () {
    let currentStep = 1; 
    const totalSteps = $("ul.list-group > li").length; 

    // Initialize jQuery Validation
    $("#multiStepForm").validate({
        rules: {
            name: "required",
            email: {
                required: true,
                email: true,
            },
            mobile: {
                required: true,
                number: true,
                minlength: 10,
                maxlength: 10,
            },
            gender: {
                required: true,
            },
          
          
        },
        messages: {
            name: "Please enter your full name",
            email: {
                required: "Please enter your email address",
                email: "Enter a valid email address",
            },
            mobile: {
                required: "Please enter your mobile number",
                number: "Only numbers are allowed",
                minlength: "Mobile number must be 10 digits",
                maxlength: "Mobile number must be 10 digits",
            },
            gender: "Please select your gender",
           
            
        },
       
    });

  
    function showStep(step) {
    console.log(`Showing step: ${step}`);
    // $('.list-group-item').hide();
    // $(`#step${step}`).show();
        $('.tabs-dps-tab').removeClass('active');
    $(`.col-tabs-${step}`).addClass('active');
}

    
    function validateCurrentStep() {
        let valid = true;

       
        $(`#step${currentStep} :input[name]`).each(function () {
        if (!$(this).valid()) {
            valid = false;
        }
    });

        return valid; // Return true only if all fields in the current step are valid
    }

    // Show the initial step
    showStep(currentStep);

    // Handle "Next" button click
    $(".next-btn").on("click", function () {
       
       
        if (validateCurrentStep()) {
           
            if (currentStep < totalSteps) {
                console.log('here');
                console.log(validateCurrentStep());
                currentStep++;
                showStep(currentStep);
            }
        }
    });

    // Handle "Prev" button click
    $(".prev-btn").on("click", function () {
        if (currentStep > 1) {
            currentStep--;
            showStep(currentStep);
        }
    });

    // Handle form submission
    $("#multiStepForm").on("submit", function (e) {
    e.preventDefault();
    if (validateCurrentStep()) {
        var formData = new FormData(this); // Simplify FormData creation
        for (var pair of formData.entries()) {
            console.log(pair[0] + ': ' + pair[1]); // Debug form data
        }
        $.ajax({
            url: $(this).attr("action"), // Use form's action attribute
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    $("#career_response").text(response.message_response).css("color", "green");
                    $("#multiStepForm")[0].reset();
                } else {
                    $("#career_response").text(response.message_response).css("color", "red");
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error: ", error);
            },
        });
    }
});
});
        </script>
</body>

</html>