<?php

include_once("include/main.inc.php");

$hover = 'blogs';

$blog_query = mysqli_query(
    $GLOBALS['dbconn'], 
    "SELECT catImage, catName, blogDname, catDesc, blog_written 
     FROM blog_tbl 
     ORDER BY en_date DESC"
);

$page_metatitle = "Top Vastu Consultant in Mumbai – Expert Blogs, Tips & Remedies | Dr. Riddhe Sshilpi";

$page_metakey = "Top Vastu Consultant, Vastu Tips, Vastu Remedies, Vastu for Home, Vastu Blog Mumbai, Vastu Shastra Expert Mumbai, Best Vastu Consultant, Vastu for Office, Vastu Guidance, Vastu Consultancy Services";

$page_metadesc = "Discover expert Vastu tips, home remedies, and guidance from Dr. Riddhe Sshilpi – a Top Vastu consultant in Mumbai. Explore insightful blogs to bring harmony and positivity to your space.";

$blog_query1 = mysqli_query($GLOBALS['dbconn'], "select catImage,catName,blogDname,catDesc,blog_written from blog_tbl ORDER BY en_date DESC");

?>
<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include 'app_header.php'; ?>

    <div class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/blog-banner.webp)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Our Blogs</h1>
                    <div class="clearfix"></div>
                    <!-- <div class="cat_title2">We Are Available For You</div> -->
                </div>
            </div>
        </div>
    </div>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Our Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="blog_page">
        <div class="container">
            <div class="row">
                <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-12">
                    <div class="blog_left">
                        <h2 class="left_title1">Our Blogs</h2>
                        <div class="clearfix"></div>

                        <div class="row">

                            <?php

                            while ($blog_res = mysqli_fetch_assoc($blog_query)) {



                                if ($blog_res['catImage'] != '') {

                                    $blog_img =  getImage($blog_res['catImage'], 375, 375, $blog_res['catName'], "/uploaded-files/blog/images/");
                                } else {

                                    $blog_img = NO_IMG_URL;
                                }

                                $blog_shortdesc = str_ireplace('{companyName}', $admin_res['companyName'], $blog_res['catDesc']);

                            ?>
                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                    <div class="blog-item">
                                        <div class="blog__img">
                                            <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>">
                                                <img src="<?= $blog_img; ?>" alt="<?= $blog_res['blogDname']; ?>" title="<?= $blog_res['blogDname']; ?>">
                                            </a>
                                        </div>
                                        <div class="blog__content">
                                            <h3 class="blog__title"><a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>"><?= $blog_res['blogDname']; ?></a></h3>
                                            <p class="blog__desc"><?= html_entity_decode(substr($blog_shortdesc, 0, 200)); ?>...
                                            </p>
                                            <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" class="read_more_btn">Read More</a>
                                        </div>
                                    </div>
                                </div>

                            <?php } ?>


                        </div>
                    </div>
                </div>

                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12">
                    <div class="left_sidebar">
                        <div class="left_title1">Popular Post</div>

                        <?php

                        while ($blog_res1 = mysqli_fetch_assoc($blog_query1)) {



                            if ($blog_res1['catImage'] != '') {

                                $blog_img =  getImage($blog_res1['catImage'], 375, 375, $blog_res1['catName'], "/uploaded-files/blog/images/");
                            } else {

                                $blog_img = NO_IMG_URL;
                            }

                            $blog_shortdesc = str_ireplace('{companyName}', $admin_res['companyName'], $blog_res1['catDesc']);

                        ?>
                            <div class="right_news">
                                <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res1['catName']); ?>.htm" title="<?= $blog_res1['blogDname']; ?>">
                                    <div class="image">
                                        <img src="<?= $blog_img; ?>" alt="<?= $blog_res1['blogDname']; ?>" title="<?= $blog_res1['blogDname']; ?>">
                                    </div>
                                </a>
                                <h4 class="title_h4"><a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res1['catName']); ?>.htm" title="<?= $blog_res1['blogDname']; ?>"><?= $blog_res1['blogDname']; ?></a></h4>
                            </div>

                        <?php } ?>


                    </div>

                </div>
            </div>
        </div>
    </div>
    <?php include 'award_video.php'; ?>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>