<?php

class Pages extends Public_Controller {

  public function __construct() {

    parent::__construct();
    $this->load->helper(array('file'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }

  public function aboutus() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_page='about' and status='1' and CURDATE() between banner_start_date and banner_end_date")->row_array();
    $data['latestnews1'] = $this->db->query("SELECT * FROM wps_news WHERE status='1' order by news_id desc limit 1")->row_array();
    $data['latestnews2'] = $this->db->query("SELECT * FROM wps_news WHERE status='1' order by news_id desc limit 3 offset 1")->result_array();
    $this->load->view('pages/about', $data);
  }


  
  public function sitemap() {
    $this->load->view('pages/sitemap');
  }

  

  public function contactus() {
     
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    //trace($_SERVER['HTTP_REFERER']);

    $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|alpha');
    $this->form_validation->set_rules('location', 'Location', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
    $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|alpha');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required');
     $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');


    if ($this->form_validation->run() == TRUE) {
        if($this->input->post()){
   // trace($_POST);exit();
}
      $post_data = http_build_query(
            array(
                'secret' => CAPTCHA_SECRET,
                'response' => $_POST['g-recaptcha-response'],
                'remoteip' => $_SERVER['REMOTE_ADDR'],
            )
      );
      $opts = array('http' => array(
              'method' => 'POST',
              'header' => 'Content-type: application/x-www-form-urlencoded',
              'content' => $post_data,
          ),
      );
      $context = stream_context_create($opts);
      $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
      $capcha_result = json_decode($response);
      if (!$capcha_result->success) {
        //throw new Exception('Gah! CAPTCHA verification failed. Please try again', 1);
        $msg = "CAPTCHA verification failed!";
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', $msg);
        $friendly_url = $this->uri->uri_string;
        $condition = array('friendly_url' => $friendly_url, 'status' => '1');
        $content = $this->pages_model->get_cms_page($condition);
        $data['content'] = $content;
        $data['title'] = "Contact Us";
        $this->load->view('contactus', $data);
      } else {

      $posted_data = array(
          'type' => '1',
          'first_name' => $this->input->post('first_name'),
          'location' => $this->input->post('location'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'message' => $this->input->post('message'),
          'purpose' => $this->input->post('purpose'),
          'receive_date' => $this->config->item('config.date.time')
      );
      $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

      //Mail
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('first_name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{user_name}', $name, $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone'), $body);
      $body = str_replace('{location}', $this->input->post('location'), $body);
      $body = str_replace('{comments}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', SITENAME, $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
      if($this->admin_info->website_mode=='Live'){
          $mail_conf = array(
              'subject' => "Enquiry from Printmytape.in",
              'to_email' => $adminRes->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
          $mail_conf = array(
              'subject' => "Enquiry from Printmytape.in",
              'to_email' => $adminRes->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }else{
          $mail_conf = array(
            'subject' => "Webpulseindia.com - Enquiry from Printmytape.in",
            'to_email' => $adminRes->admin_email,
            'from_email' => $this->input->post('email'),
            'from_name' => $name,
            'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }

      $msg = "Thank you for inquiring. We will connect with you soon";
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $msg);
      redirect(base_url('contact-us'));
    }
  }

    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '14');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['title'] = "Contact Us";
    $this->load->view('contactus', $data);
  }


  public function whatsappenq() {
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    $this->form_validation->set_rules('wname', 'Name', 'trim|required');
    $this->form_validation->set_rules('wmobile', 'Mobile Number', 'trim|required|max_length[10]|min_length[10]|numeric');
    $url=$_SERVER['HTTP_REFERER'];

      if ($this->form_validation->run() == TRUE) {  
      $posted_data = array (
        'type' => '3',
        'first_name' => $this->input->post('wname'),
        'mobile_number' => $this->input->post('wmobile'),
        'message' => 'Whatsapp Enquiry',
        'post_url' => $url,
        'receive_date' => $this->config->item('config.date.time')
      );
      $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, false);
        $name=$this->input->post('wname');
        $subject = "WebpulseIndia.com - Whatsapp Enquiry from ".$this->config->item('site_name');
        $content = get_content('wps_auto_respond_mails', '15');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{name}', $this->input->post('wname'), $body);
        $body = str_replace('{phone}', $this->input->post('wmobile'), $body);
        $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
        $body = str_replace('{admin_email}', $adminRes->admin_email, $body);
        $body = str_replace('{post_url}', $url, $body);
          $mail_conf = array(
              'subject' => "Webpulseindia.com - Whatsapp Enquiry from ".$this->config->item('site_name'),
              'to_email' => $adminRes->admin_email,
              'from_email' => $adminRes->admin_email,
              'from_name' => $name,
                'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
          $mail_conf1 = array(
              'subject' => "Webpulseindia.com - Whatsapp Enquiry from ".$this->config->item('site_name'),
              'to_email' => 'webpulseindia@gmail.com',
              'from_email' => $adminRes->admin_email,
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf1);
     $res = 'success';     
    }else {
        $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>';
    }
    echo $res;
    exit;
  }

  public function marketarea() {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list WHERE status ='1'")->result_array();

    $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();

    $this->load->view('marketarea', $data);
  }

  
}

/* End of file pages.php */