<?php

class Gallery extends Public_Controller {

  public function __construct() { 
    parent::__construct();
    //$this->load->helper(array('gallery/gallery'));
    $this->load->model(array('gallery/gallery_model', 'gallery_category/gallery_category_model'));
  }

 public function index() {
    if (!isset($this->meta_info['entity_id'])) {
      redirect(base_url(''));
    }
    $gallery_id = (int) $this->meta_info['entity_id'];
    $data['category'] =$this->db->query("SELECT * FROM wps_gallery_category WHERE status = '1' and category_id='$gallery_id'")->row_array();
    $data['gallery_list'] =  $this->db->query("SELECT * FROM wps_gallery WHERE status = '1' and gallery_parent_id='$gallery_id' ORDER BY gallery_id")->result_array();
    $data['banner']=$this->db->query("select * from wps_banners where banner_position='Gallery Banner' and status='1'")->row_array();
    $this->load->view('gallery/view_gallery', $data);
  }

  public function galleries() {
      $data['galDetail'] = $this->db->query("SELECT * FROM wps_cms_pages WHERE status = '1' and page_id='30'")->row_array();
      
      $gal_cat= $this->db->query("SELECT * from wps_gallery_category where status='1' and parent_id='0'")->result_array();
      $data['gallery_category'] = $gal_cat;

      //$photo_gallery= $this->db->query("SELECT * from wps_gallery where status='1' and gallery_parent_id='1'")->result_array();
      $photo_gallery= $this->db->query("SELECT * from wps_gallery where gallery_parent_id='2' and status='1' ")->result_array();
      $data['photo_gallery'] = $photo_gallery;
      $data['banner']=$this->db->query("select * from wps_banners where banner_position='Photo Gallery Banner' and status='1'")->row_array();
    
      $this->load->view('gallery/view_photos', $data);
  }

  public function haffle_studio() {
    
      
      $gal_cat= $this->db->query("SELECT * from wps_gallery_category where status='1' and parent_id='0'")->result_array();
      $data['gallery_category'] = $gal_cat;

      $photo_gallery= $this->db->query("SELECT * from wps_haffle where status='1' and type_id=1")->result_array();
      $data['photo_gallery'] = $photo_gallery;
       $data['banner']=$this->db->query("select * from wps_banners where banner_position='Achievements Banner' and status='1'")->row_array();
    
      $this->load->view('gallery/haffle_studio', $data);
  }

  public function gallery_listing($cid) {
    $ord = "ORDER BY gallery_name ASC";
    $data['active_page'] = 'Gallery Listing';
    $data['page_title'] = "Gallery";
    $data['heading_title'] = 'Gallery Lists';
    $data['unq_section'] = "Gallery";

    if ($cid > 0) {
      $ord = "ORDER BY gallery_name DESC";
      $qry = $this->db->query("select * from wps_gallery where gallery_id ='" . $cid . "'")->row();
      $data['active_page'] = $qry->gallery_name;
    }

    $record_per_page = (int) $this->input->post('per_page');
    if (array_key_exists('entity_id', $this->meta_info) && $this->meta_info['entity_id'] > 0) {
      $parent_segment = (int) $this->meta_info['entity_id'];
    } else {
      $parent_segment = (int) $this->uri->segment(3);
    }
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';
    $base_url = ( $parent_segment > 0 ) ? "gallery/gallery_listing/$parent_id/pg/" : "gallery/gallery_listing/pg/";
    
    //category
    $condtion_array_gallery = array(
        'field' => "*,( SELECT COUNT(gallery_id) FROM wps_gallery AS b
        WHERE b.parent_id=a.gallery_id ) AS total_subcategories",
        'condition' => "AND parent_id = '0' AND status='1' ",
        //'limit' => $config['per_page'],
        //'offset' => $offset,
        'debug' => FALSE
    );
    $res_gallery = $this->gallery_model->getgallery($condtion_array_gallery);
    $data['gallery'] = $res_gallery;
    //end here
    
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(gallery_id) FROM wps_gallery AS b
        WHERE b.parent_id=a.gallery_id ) AS total_subcategories",
        'condition' => ($parent_id > 0)?"AND parent_id = '$parent_id' AND status='1'":"AND parent_id != '0' AND status='1'",
        'limit' => $config['per_page'],
        'offset' => $offset,
        'debug' => FALSE
    );
    $res_array = $this->gallery_model->getgallery($condtion_array);
    
    $data['total_rows'] = $config['total_rows'] = $this->gallery_model->total_rec_found;
    $data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);
    $data['res'] = $res_array;
    //trace($res_array);
    $this->load->view('gallery/view_gallery', $data);
  }

  
  public function getGalleryDetails(){
    $galleryId = $this->input->get_post('galleryId');
    $cparam = array('gallery_id' => $galleryId, "status" => 1);
    $comm = $this->gallery_model->get_gallery_comment(FALSE, FALSE, $cparam);
    $imageName = $this->input->get_post('galleryImg');
    $gimage = get_image('gallery',$imageName, '', '', 'R');
    $viewText = '';
    $viewText .= '
          <div class="user-info">
            <div class="col-lg-8 col-md-6 col-sm-6 col-xs-12 pleft pright popimg">
              <img src="'.$gimage.'" class="responsive-img"/>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 comb commentBox">
              <div class="comch">'.count($comm).' Comments</div>
              <textarea  name="comment" type="text" class="comcomment" id="comment" value="" placeholder="Add a comment..."  /></textarea>
              <input type="hidden" name="gallery_id" id="gallery_id" value="'.$galleryId.'" />
              <button class="compbt" id="postComment">POST</button>
              <div class="popcom">';
              foreach($comm as $comment){
                $viewText .= '<div class="com1">
                  <strong>'.$comment['mem_name'].'</strong> <span class="gr1">'.getDateFormat($comment['post_date'],3).'</span><br />
                <p>'.$comment['comment'].'</p>    
                <br />
                </div>';
              }
              $viewText .= '<div class="glin1"></div>                
              </div>
              <div class="bsocial mobpb" style="margin-top:8px; margin-bottom:8px;">
                <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5a40d07cdf99e7aa"></script>
                <div class="addthis_inline_share_toolbox_z8un"></div>
              </div>
            </div>              
          </div>
          <div class="clear"></div>';
    echo $viewText;
    
  }

   public function video_gallery() { 
     $data['galDetail'] = $this->db->query("SELECT * FROM wps_cms_pages WHERE status = '1' and page_id='30'")->row_array();
        $res=$this->db->query("SELECT * FROM wps_gallery WHERE status = '1' and type_id=2 order by gallery_id")->result_array();
        $data['res']=$res;
        $data['heading_title']='Video Gallery';
        $data['banner']=$this->db->query("select * from wps_banners where banner_position='Achievements Banner' and status='1'")->row_array();
        $this->load->view('gallery/view_video_gallery',$data);
   }

}