<?php
class Printed_color2 extends Admin_Controller
{
	public function __construct()
	{		
		parent::__construct(); 			

		$this->load->model(array('color_model'));
	}

	public  function index()
	{
		 $pagesize  =  (int) $this->input->get_post('pagesize');
	     $config['limit'] =  ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
		 $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
		 $base_url =  current_url_query_string(array('filter'=>'result'),array('per_page'));
		 $parent_id  =   (int) $this->uri->segment(4,0);
		 $keyword = trim($this->input->get_post('keyword',TRUE));
		 $keyword = $this->db->escape_str($keyword);
	     $condtion = " ";
		 $condtion_array = array(
		                'field' =>"*",
						 'index'=>'p2color_id',
						 'condition'=>$condtion,
						 'limit'=>$config['limit'],
						  'offset'=>$offset	,
						  'debug'=>FALSE
						 );	
		$res_array  =  $this->color_model->getp2colors($condtion_array);
		$config['total_rows']	=  $this->color_model->total_rec_found;
		$data['page_links']     =  dashboard_pagination($base_url,$config['total_rows'],$config['limit'],$offset);	
		$data['headingTitle']  =  'Printing Colors 2';
		$data['res']            =  $res_array; 
		$data['parent_id']      =  $parent_id; 	
		if( $this->input->post('action')!='')
		{			
			$this->update_status('wps_printing_color2','p2color_id');
		}
		if( $this->input->post('update_order')!='')
		{			
			$this->update_displayOrder('wps_printing_color2','sort_order','p2color_id');
		}
		//echo "<pre>";print_r($data);
		$this->load->view('pcolor2/view_color_list',$data);

	}	

	public function add()
	{
		 $data['headingTitle'] = 'Add Printing Color 1';
		 $this->form_validation->set_rules('p2color_name','Printing Color Name',"trim|required|max_length[32]|unique[wps_printing_color2.p2color_name='".$this->db->escape_str($this->input->post('p2color_name'))."' AND status!='2']");
		$this->form_validation->set_rules('p2color_code','Printing Color Code',"trim|required|max_length[50]");
		if($this->form_validation->run()===TRUE)
		{
			    $posted_data = array(
					'p2color_name'=>$this->input->post('p2color_name'),
					'p2color_code'=>$this->input->post('p2color_code'),
					'p2color_type'=>$this->input->post('p2color_type'),
					'p2color_date_added'=>$this->config->item('config.date.time')
				 );
		    $this->color_model->safe_insert('wps_printing_color2',$posted_data,FALSE);	
			$this->session->set_userdata(array('msg_type'=>'success'));
			$this->session->set_flashdata('success',lang('success'));
			redirect('wps-admin/printed_color2', '');
		}
		$this->load->view('pcolor2/view_color_add',$data);
	}

	public function edit()
	{
		$p2colorId = (int) $this->uri->segment(4);
		$rowdata=$this->color_model->get_p2color_by_id($p2colorId);
		$data['headingTitle'] = 'Printing Color 1';
		if( !is_array($rowdata) )
		{
			$this->session->set_flashdata('message', lang('idmissing'));
			redirect('wps-admin/printed_color2', ''); 	
		}
		$p2colorId = $rowdata['p2color_id'];	
			$this->form_validation->set_rules('p2color_name','Printing Color Name',"trim|required|max_length[32]|unique[wps_printing_color2.p2color_name='".$this->db->escape_str($this->input->post('p2color_name'))."' AND status!='2' AND p2color_id!='".$rowdata['p2color_id']."']");
			$this->form_validation->set_rules('p2color_code','Printing Color Code',"trim|required|max_length[50]");
			if($this->form_validation->run()==TRUE)
			{	

				$posted_data = array(
					'p2color_name'=>$this->input->post('p2color_name'),
					'p2color_code'=>$this->input->post('p2color_code'),
					'p2color_type'=>$this->input->post('p2color_type'),
					'pcolor_date_updated'=>$this->config->item('config.date.time')
				 );

			 	$where = "p2color_id = '".$p2colorId."'"; 			
				$this->color_model->safe_update('wps_printing_color2',$posted_data,$where,FALSE);
				$this->session->set_userdata(array('msg_type'=>'success'));	
				$this->session->set_flashdata('success',lang('successupdate'));	

				redirect('wps-admin/printed_color2'.'/'.query_string(), ''); 
			}		
		$data['edit_result']=$rowdata;	
		$this->load->view('pcolor2/view_color_edit',$data);	
	}

}



// End of controller
