<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Webpulse Group - Products</title>
    <meta name="keywords" content="Webpulse Group - Home" />
    <meta name="description" content="Webpulse Group - Home" />
    <?php include 'components/top_header.php';?>
</head>

<body>
    <div class="webpulse-main-wrapper">
        <!-- Header -->
        <?php include 'components/header.php';?>



        <!-- Heading Banner -->
        <section class="heading_banner" style="background-image: url(designer/images/contact/contact.jpg)">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <div class="cat_title">Contact Us</div>
                        <div class="clearfix"></div>
                        <div class="cat_title2">We Are Available For You</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Breadcrumb -->
        <section class="inner_breadcrumb hidden-xs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <ul class="breadcrumb">
                            <li><a href="index.html" title="Home">Home</a></li>
                            <li class="active">Contact Us</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>


        <!-- Home About -->
        <section class="contact_page">
            <div class="container">
            <div class="contact_form_grid1">
                <div class="row">

                        <div class="col-lg-5 contact_details">
                            <h4 class="title-head">Contact Information</h4>
                            <p>Write to us or call us, get quick response powered by our advanced coustomer support team
                                .</p>
                            <ul class="address_list">
                                <li> <span class="fa fa-map-marker"></span> 71/7A, 2nd Floor,
                                        Rama Road Industrial Area,
                                        New Delhi-110015, (India)</li>
                                <li><a href="javascript:void()"><span class="fa fa-phone"></span> Call: +91-11-47015888,
                                        +91-99112-44888</a></li>
                                <li><a href="javascript:void()"><span class="fa fa-whatsapp"></span> Fax:
                                        +91-99112-44888</a></li>
                                <li><a href="javascript:void()"><span class="fa fa-globe"></span>
                                        www.yourwebsite.com</a></li>
                            </ul>
                            <h4 class="title-head">Get in Touch</h4>
                            <ul class="social_list">
                                <li><a href="javascript:void()"><i class="fa fa-facebook"></i></a></li>
                                <li><a href="javascript:void()"><i class="fa fa-twitter"></i></a></li>
                                <li><a href="javascript:void()"><i class="fa fa-google"></i></a></li>
                                <li><a href="javascript:void()"><i class="fa fa-linkedin"></i></a></li>
                            </ul>
                        </div>
                        <div class="col-lg-7 form_grid">
                            <h4 class="title-head">We want to hear form you!</h4>
                            <form role="form" name="contact-form" method="post" id="contact_form">
                                <script src="https://www.google.com/recaptcha/api.js" async defer></script>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input tabindex="1" class="form-control" type="text" name="name"
                                                placeholder="Your Name*" value="" onkeyup="validateOnlyTextField(this)" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input tabindex="2" class="form-control" type="email" name="email"
                                                placeholder="Your Email ID*" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input tabindex="3" class="form-control" type="text" name="phone"
                                                placeholder="Your Phone No*" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input tabindex="4" class="form-control" type="text" name="location"
                                                placeholder="Your Location*" id="autocomplete" onFocus="geolocate()"
                                                required>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <textarea tabindex="5" class="form-control" rows="5"
                                                placeholder="Your Comments Here*" required name="message"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group" style="margin-bottom: 0;">
                                            <div tabindex="6" class="g-recaptcha"
                                                data-sitekey="6LeIanwUAAAAAFmGKxHc8HDyiVvsJdvRc01uSMVD"></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <button tabindex="7" class="modal_btn" type="submit" name="submit"
                                                value="Submit" data-submit="...Sending">Submit</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>



                </div>
            </div>
        </section>


        <iframe class="contact_map"
            src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d112032.51155929791!2d77.15094!3d28.65924!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x11551dbc1a6316e9!2sWebpulse+Solution+(P)+Limited+-+Rated+%231+Web+Designing+Company+in+India!5e0!3m2!1sen!2sus!4v1554719807863!5m2!1sen!2sus"
            allowfullscreen></iframe>


            <?php include 'components/testimonial.php';?>

<!-- Home Clients -->
<section class="webpulse_home_clients">
   <div class="container">
       <div class="sec-title centered wow fadeInUp animated animated" data-wow-delay=".1s">
           <h4 class="title-head text-dark">Our Clients</h4>
           <div class="separator"></div>
       </div>
       <div class="clearfix"></div>
       <?php include 'components/clients.php';?>
   </div>
</section>


        <!-- Footer -->
        <?php include 'components/footer.php';?>
    </div>
    <?php include 'components/bottom_footer.php';?>
    <script>
    jQuery(document).ready(function($) {
        $("#contact_form").validate({
            rules: {
                name: "required",
                message: "required",
                location: "required",
                email: {
                    required: true,
                    email: true
                },
                phone: {
                    required: true,
                    number: true,
                    minlength: 10,
                }
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter message",
                email: {
                    required: "Please enter your email address"
                },
                location: "Please enter your location",
                phone: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                    minlength: "Your Mobile No. must be at least 10 characters long",
                }
            },
        })
    });
    </script>
</body>

</html>