<?php
$current_page = "Contact";
include_once ("include/main.inc.php");
$getAdminDetails = getAdminDetails($res);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Contact Us - <?= COMPANY_NAME; ?></title>
    <meta name="description" content="Contact Us -<?= COMPANY_NAME; ?>">
    <meta name="keywords" content="Contact Us -<?= COMPANY_NAME; ?>">

    <?php include 'components/top_header.php'; ?>
</head>

<body>
    <div class="webpulse-main-wrapper">
        <!-- Header -->
        <?php include 'components/header.php'; ?>
        <div class="heading_banner"
            style="background-image: url(<?= SITE_URL_PATH; ?>/designer/images/contact/contact.jpg)">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <h1 class="cat_title">Prime Machinery</h1>
                        <div class="clearfix"></div>

                    </div>
                </div>
            </div>
        </div>
        <div class="inner_breadcrumb hidden-xs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <ul class="breadcrumb">
                            <li><a href="<?= SITE_URL_PATH; ?>" title="Home">Home</a></li>
                            <li class="active">Contact Us</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>


        <!-- Home About -->
        <section class="contact_page">
            <div class="container">
                <div class="contact_form_grid1">
                    <div class="row">

                        <div class="col-lg-5 contact_details">
                            <h2 class="title-head">Contact Information</h2>
                            <p>Write to us or call us, get quick response powered by our advanced customer support team
                                .</p>
                            <ul class="address_list">

                                <li><span class="fa fa-map-marker"></span>
                                    GSTIN - 09BJCPG3423K1ZB<br><?= $getAdminDetails['address']; ?></li>

                                <!-- <li> <span class="fa fa-map-marker"></span> 71/7A, 2nd Floor,
                                        Rama Road Industrial Area,
                                        New Delhi-110015, (India)</li>-->
                                <li><a href="tel:<?= $getAdminDetails['mobile']; ?>"><span class="fa fa-phone"></span>
                                        Call: <?= $getAdminDetails['mobile']; ?></a>, <a
                                        href="tel:<?= $getAdminDetails['phone']; ?>"><?= $getAdminDetails['phone']; ?></a>
                                </li>

                                <!--<li><a href="javascript:void()"><span class="fa fa-whatsapp"></span> Fax:
                                        +91-99112-44888</a></li>-->
                                <h3 class="title-head">Delhi Office Contact Details</h3>
                                <li><span class="fa fa-map-marker"></span> <?= $getAdminDetails['address2']; ?></a></li>
                                <li><a href="tel:9667916222"><span class="fa fa-phone"></span> Call: +91-
                                        9667916222</a>, <a href="tel:9667925333">+91- 9667925333</a></li>

                                <!--<h3 class="title-head">Lucknow Office Contact Details</h3>-->
                                <!-- <li><span class="fa fa-map-marker"></span>GSTIN - 09BJCPG3423K1ZB<br> <?= $getAdminDetails['address3']; ?></a></li>-->
                                <!-- <li><a href="tel:9667916222"><span class="fa fa-phone"></span> Call: +91- 9667925888</a></a></li>-->
                            </ul>
                            <h3 class="title-head">Get in Touch</h3>
                            <ul class="social_list">
                                <li><a href="https://www.facebook.com/primemachineryofficial/"><i
                                            class="fa fa-facebook"></i></a></li>
                                <li><a href="https://www.instagram.com/primemachinery/"><i
                                            class="fa fa-instagram"></i></a></li>

                                <li><a href="https://www.youtube.com/channel/UC8thTrZeb_powEiiipRycSw"><i
                                            class="fa fa-youtube-play"></i></a></li>
                            </ul>
                        </div>
                        <div class="col-lg-7 form_grid">
                            <h3 class="title-head">We want to hear from you!</h3>
                            <form name="contact-form" method="post" id="contact_form">
                                <span class="text-danger error_message"></span>
                                <span class="text-success success_message"></span>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input placeholder="Full Name *" class="form-control" type="text"
                                                tabindex="1" name="names" onkeyup="validateOnlyTextField(this)"
                                                required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input placeholder="Email ID *" class="form-control" type="email"
                                                tabindex="2" name="emails" required="">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input type="hidden" class="countryName countryName" name="countryName"
                                                value="">
                                                <input type="hidden" name="code" class="code" value="">
                                            <input class="form-control telePhone mobile" value="" type="tel"
                                                name="mobiles" placeholder="Mobile Number*"
                                                onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                                                minlength="10" maxlength="10" required="" autocomplete="off"
                                                style="padding-left: 84px;">
                                        </div>
                                        <!-- <div class="form-group">
                                            <input placeholder="Phone Number *" class="form-control" type="tel" maxlength="10"  onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"
oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" tabindex="3" name="mobiles"  required="">
                                        </div> -->
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <input placeholder="Location*" class="form-control" type="text" tabindex="4"
                                                name="locations" required="" pattern="[a-z A-Z]+">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <textarea placeholder="Type your Message Here...." class="form-control"
                                                required="" tabindex="5"
                                                name="messages"><?php echo !empty($message) ? $message : ''; ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group" style="margin-bottom: 0;">
                                            <div tabindex="6" class="g-recaptcha" data-sitekey="<?= site_key; ?>"></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <button tabindex="7" class="modal_btn" type="submit" name="submit-side"
                                                value="Submit" data-submit="...Sending">Submit</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>

                </div>
            </div>
        </section>

        <iframe class="contact_map"
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3560.5922742226644!2d80.81338521477947!3d26.82110818316718!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x399bffd624979c47%3A0xddd7355d3fe71e8a!2sGupta%20Enterprises!5e0!3m2!1sen!2sin!4v1651495464334!5m2!1sen!2sin"
            allowfullscreen=""></iframe>

        <!-- Footer -->
        <?php include 'components/footer.php'; ?>
    </div>
    <?php include 'components/bottom_footer.php'; ?>
    <script>
        jQuery(document).ready(function ($) {
            $("#contact_form").validate({
                rules: {
                    names: "required",
                    messages: {
                        required: true,

                    },
                    locations: {
                        required: true,

                    },
                    emails: {
                        required: true,

                    },
                    mobiles: {
                        required: true,
                        number: true,
                        minlength: 10,
                        maxlength: 10,
                    }
                },
                messages: {
                    names: "Please enter your name",
                    messages: "Please enter message",
                    emails: {
                        required: "Please enter your email address"
                    },
                    locations: "Please enter your location",
                    mobiles: {
                        required: "Please enter your mobile no.",
                        number: "Mobile No. contains only numbers",
                        minlength: "Your Mobile No. must be at least 10 characters long",
                    }
                },
            })
        });
    </script>
    <script>
        $(document).ready(function () {
            $('#contact_form').submit(function (e) {
                e.preventDefault();
                $.ajax({
                    'url': '<?= SITE_URL_PATH; ?>/ajax_save_contact.php',
                    'type': 'POST',
                    'dataType': 'json',
                    'data': $(this).serialize(),
                    'success': function (result) {
                        if (result.status == false) {
                            $('.success_message').text('');
                            $('.error_message').text(result.message_response)
                        } else {
                            $('.error_message').text('');
                            $('.success_message').text(result.message_response);
                            $('#contact_form').trigger("reset");
                        }
                    }
                });
            });
        });
    </script>
</body>

</html>